/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.core;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionProviderForwarder
implements ISelectionProvider {
    protected ISelectionProvider provider;
    protected Class<?> forwardType;

    public SelectionProviderForwarder(ISelectionProvider provider, Class<?> forwardType) {
        this.provider = provider;
        this.forwardType = forwardType;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.provider.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        ISelection selection = this.provider.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IAdaptable adaptable;
            Object value;
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object element = sel.getFirstElement();
            if (this.forwardType.isInstance(element)) {
                return selection;
            }
            if (element instanceof IAdaptable && (value = (adaptable = (IAdaptable)element).getAdapter(this.forwardType)) != null) {
                return new StructuredSelection(value);
            }
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.provider.addSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.provider.setSelection(selection);
    }
}

