/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class JGrassRegion {
    public static final String BLACKBOARD_KEY = "eu.hydrologis.jgrass.libs.region";
    public static final String BLANK_REGION = "proj:           0\nzone:           0\nnorth:          1\nsouth:          0\nwest:           0\neast:           1\nrows:           1\ncols:           1\ne-w resol:      1\nn-s resol:      1";
    private int proj = 0;
    private int zone = 0;
    private double north = Double.NaN;
    private double south = Double.NaN;
    private double west = Double.NaN;
    private double east = Double.NaN;
    private double ns_res = Double.NaN;
    private double we_res = Double.NaN;
    private int rows = 0;
    private int cols = 0;
    private LinkedHashMap<String, String> additionalGrassEntries = null;

    public JGrassRegion(String regionFilePath) throws IOException {
        this.readRegionFromFile(regionFilePath, this);
    }

    public JGrassRegion(double west, double east, double south, double north, int rows, int cols) {
        this.west = west;
        this.east = east;
        this.south = south;
        this.north = north;
        this.rows = rows;
        this.cols = cols;
        this.fixResolution();
    }

    public JGrassRegion(double west, double east, double south, double north, double weres, double nsres) {
        this.west = west;
        this.east = east;
        this.south = south;
        this.north = north;
        this.we_res = weres;
        this.ns_res = nsres;
        this.fixRowsAndCols();
        this.fixResolution();
    }

    public JGrassRegion(JGrassRegion region) {
        this.west = region.getWest();
        this.east = region.getEast();
        this.south = region.getSouth();
        this.north = region.getNorth();
        this.rows = region.getRows();
        this.cols = region.getCols();
        this.fixResolution();
    }

    public JGrassRegion(Envelope2D envelope2D) {
        this.west = envelope2D.getMinX();
        this.east = envelope2D.getMaxX();
        this.south = envelope2D.getMinY();
        this.north = envelope2D.getMaxY();
        this.we_res = envelope2D.getHeight();
        this.ns_res = envelope2D.getWidth();
        this.fixRowsAndCols();
        this.fixResolution();
    }

    public JGrassRegion(String west, String east, String south, String north, String ewres, String nsres) {
        double[] nsew = this.nsewStringsToNumbers(north, south, east, west);
        double[] xyRes = this.xyResStringToNumbers(ewres, nsres);
        double no = nsew[0];
        double so = nsew[1];
        double ea = nsew[2];
        double we = nsew[3];
        double xres = xyRes[0];
        double yres = xyRes[1];
        JGrassRegion tmp = new JGrassRegion(we, ea, so, no, xres, yres);
        this.setExtent(tmp);
    }

    public JGrassRegion(String west, String east, String south, String north, int rows, int cols) {
        double[] nsew = this.nsewStringsToNumbers(north, south, east, west);
        double no = nsew[0];
        double so = nsew[1];
        double ea = nsew[2];
        double we = nsew[3];
        JGrassRegion tmp = new JGrassRegion(we, ea, so, no, rows, cols);
        this.setExtent(tmp);
    }

    public void setExtent(JGrassRegion region) {
        this.west = region.getWest();
        this.east = region.getEast();
        this.south = region.getSouth();
        this.north = region.getNorth();
        this.rows = region.getRows();
        this.cols = region.getCols();
        this.fixResolution();
        this.fixRowsAndCols();
    }

    public Envelope getEnvelope() {
        return new Envelope(new Coordinate(this.west, this.north), new Coordinate(this.east, this.south));
    }

    public Rectangle2D.Double getRectangle() {
        return new Rectangle2D.Double(this.west, this.south, this.east - this.west, this.north - this.south);
    }

    public String toString() {
        return "region:\nwest=" + this.west + "\neast=" + this.east + "\nsouth=" + this.south + "\nnorth=" + this.north + "\nwe_res=" + this.we_res + "\nns_res=" + this.ns_res + "\nrows=" + this.rows + "\ncols=" + this.cols;
    }

    public JGrassRegion reproject(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws Exception {
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)lenient);
        Envelope envelope = this.getEnvelope();
        Envelope targetEnvelope = JTS.transform(envelope, transform);
        return new JGrassRegion(targetEnvelope.getMinX(), targetEnvelope.getMaxX(), targetEnvelope.getMinY(), targetEnvelope.getMaxY(), this.getRows(), this.getCols());
    }

    private void fixResolution() {
        this.we_res = (this.east - this.west) / (double)this.cols;
        this.ns_res = (this.north - this.south) / (double)this.rows;
    }

    private void fixRowsAndCols() {
        this.rows = (int)Math.round((this.north - this.south) / this.ns_res);
        if (this.rows < 1) {
            this.rows = 1;
        }
        this.cols = (int)Math.round((this.east - this.west) / this.we_res);
        if (this.cols < 1) {
            this.cols = 1;
        }
    }

    public static Coordinate snapToNextHigherInRegionResolution(double x, double y, JGrassRegion region) {
        double minx = region.getRectangle().getBounds2D().getMinX();
        double ewres = region.getWEResolution();
        double xsnap = minx + Math.ceil((x - minx) / ewres) * ewres;
        double miny = region.getRectangle().getBounds2D().getMinY();
        double nsres = region.getNSResolution();
        double ysnap = miny + Math.ceil((y - miny) / nsres) * nsres;
        return new Coordinate(xsnap, ysnap);
    }

    public static JGrassRegion getActiveRegionFromMapset(String mapsetPath) throws IOException {
        File windFile = new File(mapsetPath + File.separator + "WIND");
        if (!windFile.exists()) {
            return null;
        }
        return new JGrassRegion(windFile.getAbsolutePath());
    }

    public static void writeWINDToMapset(String mapsetPath, JGrassRegion activeRegion) throws IOException {
        JGrassRegion.writeRegionToFile(mapsetPath + File.separator + "WIND", activeRegion);
    }

    public static void writeDEFAULTWINDToLocation(String locationPath, JGrassRegion region) throws IOException {
        JGrassRegion.writeRegionToFile(locationPath + File.separator + "PERMANENT" + File.separator + "DEFAULT_WIND", region);
    }

    public static JGrassRegion adaptActiveRegionToEnvelope(Envelope sourceEnvelope, JGrassRegion sourceRegion) {
        Coordinate eastNorth = JGrassRegion.snapToNextHigherInRegionResolution(sourceEnvelope.getMaxX(), sourceEnvelope.getMaxY(), sourceRegion);
        Coordinate westsouth = JGrassRegion.snapToNextHigherInRegionResolution(sourceEnvelope.getMinX() - sourceRegion.getWEResolution(), sourceEnvelope.getMinY() - sourceRegion.getNSResolution(), sourceRegion);
        JGrassRegion newRegion = new JGrassRegion(westsouth.x, eastNorth.x, westsouth.y, eastNorth.y, sourceRegion.getWEResolution(), sourceRegion.getNSResolution());
        return newRegion;
    }

    public List<JGrassRegion> toSubRegions(int subregionsNum) {
        int tmpR = this.getRows();
        int tmpC = this.getCols();
        double tmpWest = this.getWest();
        double tmpSouth = this.getSouth();
        double tmpWERes = this.getWEResolution();
        double tmpNSRes = this.getNSResolution();
        if (subregionsNum > tmpR || subregionsNum > tmpC) {
            throw new IllegalArgumentException("The number of subregions has to be smaller than the number of rows and columns.");
        }
        int subregRows = (int)Math.floor((double)tmpR / (double)subregionsNum);
        int subregCols = (int)Math.floor((double)tmpC / (double)subregionsNum);
        ArrayList<JGrassRegion> regions = new ArrayList<JGrassRegion>();
        double runningEasting = tmpWest;
        double runningNorthing = tmpSouth;
        for (int i = 0; i < subregionsNum; ++i) {
            double n = runningNorthing + (double)subregRows * tmpNSRes;
            double s = runningNorthing;
            for (int j = 0; j < subregionsNum; ++j) {
                JGrassRegion r;
                double w = runningEasting;
                double e = runningEasting + (double)subregCols * tmpWERes;
                if (e > this.getEast()) {
                    e = this.getEast();
                }
                if (n > this.getNorth()) {
                    n = this.getNorth();
                }
                if ((r = new JGrassRegion(w, e, s, n, tmpWERes, tmpNSRes)).getWEResolution() == 0.0 || r.getNSResolution() == 0.0) continue;
                regions.add(r);
                runningEasting = e;
            }
            runningEasting = tmpWest;
            runningNorthing = n;
        }
        return regions;
    }

    private void readRegionFromFile(String filePath, JGrassRegion region) throws IOException {
        String line;
        BufferedReader windReader = new BufferedReader(new FileReader(filePath));
        LinkedHashMap<String, String> store = new LinkedHashMap<String, String>();
        while ((line = windReader.readLine()) != null) {
            if (line.matches(".*reclass.*")) {
                String mapLine = windReader.readLine();
                String mapsetLine = windReader.readLine();
                if (mapLine == null || mapsetLine == null) {
                    throw new IOException("Wrong reclass file format");
                }
                String mapName = mapLine.trim().split(":")[1].trim();
                String mapsetName = mapsetLine.trim().split(":")[1].trim();
                File f = new File(filePath).getParentFile().getParentFile().getParentFile();
                File reclassMap = new File(f, mapsetName + "/" + "cellhd" + "/" + mapName);
                if (!reclassMap.exists()) {
                    throw new IOException("The reclass cellhead file doesn't seem to exist. Unable to read the file region.");
                }
                windReader.close();
                windReader = new BufferedReader(new FileReader(reclassMap));
                line = windReader.readLine();
            }
            if (line == null) {
                throw new IOException("Wrong reclass file format");
            }
            String[] lineSplit = line.split(":", 2);
            if (lineSplit.length != 2) continue;
            String key = lineSplit[0].trim();
            String value = lineSplit[1].trim();
            if (key.indexOf("res") != -1 && key.indexOf("resol") == -1 || key.indexOf("res3") != -1) {
                if (key.startsWith("compressed")) continue;
                store.put(key.replaceAll("res", "resol"), value);
                continue;
            }
            store.put(key, value);
        }
        try {
            region.setProj(Integer.parseInt((String)store.get("proj")));
            region.setZone(Integer.parseInt((String)store.get("zone")));
            store.remove("proj");
            store.remove("zone");
        }
        catch (Exception e) {
            // empty catch block
        }
        String tmpNorth = (String)store.get("north");
        String tmpSouth = (String)store.get("south");
        String tmpEast = (String)store.get("east");
        String tmpWest = (String)store.get("west");
        double[] nsew = this.nsewStringsToNumbers(tmpNorth, tmpSouth, tmpEast, tmpWest);
        region.setNorth(nsew[0]);
        region.setSouth(nsew[1]);
        region.setEast(nsew[2]);
        region.setWest(nsew[3]);
        store.remove("north");
        store.remove("south");
        store.remove("east");
        store.remove("west");
        if (!store.containsKey("e-w resol") && !store.containsKey("n-s resol")) {
            region.setCols(Integer.parseInt((String)store.get("cols")));
            region.setRows(Integer.parseInt((String)store.get("rows")));
            store.remove("cols");
            store.remove("rows");
            region.fixResolution();
        } else {
            double[] xyRes = this.xyResStringToNumbers((String)store.get("e-w resol"), (String)store.get("n-s resol"));
            region.setWEResolution(xyRes[0]);
            region.setNSResolution(xyRes[1]);
            store.remove("e-w resol");
            store.remove("n-s resol");
            region.fixRowsAndCols();
        }
        region.setAdditionalGrassEntries(store);
        windReader.close();
        windReader = null;
        store = null;
    }

    private double degreeToNumber(String value) {
        double number = -1.0;
        String[] valueSplit = value.trim().split(":");
        if (valueSplit.length == 3) {
            double deg = Double.parseDouble(valueSplit[0]);
            double min = Double.parseDouble(valueSplit[1]);
            double sec = Double.parseDouble(valueSplit[2]);
            number = deg + min / 60.0 + sec / 60.0 / 60.0;
        } else if (valueSplit.length == 2) {
            double deg = Double.parseDouble(valueSplit[0]);
            double min = Double.parseDouble(valueSplit[1]);
            number = deg + min / 60.0;
        } else if (valueSplit.length == 1) {
            number = Double.parseDouble(valueSplit[0]);
        }
        return number;
    }

    private double[] xyResStringToNumbers(String ewres, String nsres) {
        double xres = -1.0;
        double yres = -1.0;
        xres = ewres.indexOf(58) != -1 ? this.degreeToNumber(ewres) : Double.parseDouble(ewres);
        yres = nsres.indexOf(58) != -1 ? this.degreeToNumber(nsres) : Double.parseDouble(nsres);
        return new double[]{xres, yres};
    }

    private double[] nsewStringsToNumbers(String north, String south, String east, String west) {
        double no = -1.0;
        double so = -1.0;
        double ea = -1.0;
        double we = -1.0;
        if (north.indexOf("N") != -1 || north.indexOf("n") != -1) {
            north = north.substring(0, north.length() - 1);
            no = this.degreeToNumber(north);
        } else if (north.indexOf("S") != -1 || north.indexOf("s") != -1) {
            north = north.substring(0, north.length() - 1);
            no = -this.degreeToNumber(north);
        } else {
            no = Double.parseDouble(north);
        }
        if (south.indexOf("N") != -1 || south.indexOf("n") != -1) {
            south = south.substring(0, south.length() - 1);
            so = this.degreeToNumber(south);
        } else if (south.indexOf("S") != -1 || south.indexOf("s") != -1) {
            south = south.substring(0, south.length() - 1);
            so = -this.degreeToNumber(south);
        } else {
            so = Double.parseDouble(south);
        }
        if (west.indexOf("E") != -1 || west.indexOf("e") != -1) {
            west = west.substring(0, west.length() - 1);
            we = this.degreeToNumber(west);
        } else if (west.indexOf("W") != -1 || west.indexOf("w") != -1) {
            west = west.substring(0, west.length() - 1);
            we = -this.degreeToNumber(west);
        } else {
            we = Double.parseDouble(west);
        }
        if (east.indexOf("E") != -1 || east.indexOf("e") != -1) {
            east = east.substring(0, east.length() - 1);
            ea = this.degreeToNumber(east);
        } else if (east.indexOf("W") != -1 || east.indexOf("w") != -1) {
            east = east.substring(0, east.length() - 1);
            ea = -this.degreeToNumber(east);
        } else {
            ea = Double.parseDouble(east);
        }
        return new double[]{no, so, ea, we};
    }

    private static void writeRegionToFile(String regionFilePath, JGrassRegion region) throws IOException {
        String line;
        File file = new File(regionFilePath);
        if (!file.exists()) {
            String nameLower = file.getName().toLowerCase();
            String nameUpper = file.getName().toUpperCase();
            String baseDir = file.getParent();
            File tmpFile = null;
            tmpFile = new File(baseDir + File.separator + nameLower);
            if (tmpFile.exists()) {
                file = tmpFile;
            } else {
                tmpFile = new File(baseDir + File.separator + nameUpper);
                if (tmpFile.exists()) {
                    file = tmpFile;
                } else {
                    BufferedWriter out = new BufferedWriter(new FileWriter(file));
                    out.write(BLANK_REGION);
                    out.close();
                }
            }
        }
        BufferedReader windReader = new BufferedReader(new FileReader(file));
        LinkedHashMap<String, String> store = new LinkedHashMap<String, String>();
        while ((line = windReader.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line, ":");
            if (tok.countTokens() != 2) continue;
            String key = tok.nextToken().trim();
            String value = tok.nextToken().trim();
            if (key.indexOf("res") != -1 && key.indexOf("resol") == -1 || key.indexOf("res3") != -1) {
                store.put(key.replaceAll("res", "resol"), value);
                continue;
            }
            store.put(key, value);
        }
        store.put("north", new Double(region.getNorth()).toString());
        store.put("south", new Double(region.getSouth()).toString());
        store.put("east", new Double(region.getEast()).toString());
        store.put("west", new Double(region.getWest()).toString());
        store.put("n-s resol", new Double(region.getNSResolution()).toString());
        store.put("e-w resol", new Double(region.getWEResolution()).toString());
        store.put("cols", new Integer(region.getCols()).toString());
        store.put("rows", new Integer(region.getRows()).toString());
        windReader.close();
        windReader = null;
        StringBuffer data = new StringBuffer(512);
        Set entrySet = store.entrySet();
        for (Map.Entry entry : entrySet) {
            data.append((String)entry.getKey() + ":   " + (String)entry.getValue() + "\n");
        }
        BufferedWriter windWriter = new BufferedWriter(new FileWriter(file));
        windWriter.write(data.toString());
        windWriter.flush();
        windWriter.close();
        windWriter = null;
    }

    public int getProj() {
        return this.proj;
    }

    public void setProj(int proj) {
        this.proj = proj;
    }

    public int getZone() {
        return this.zone;
    }

    public void setZone(int zone) {
        this.zone = zone;
    }

    public double getNorth() {
        return this.north;
    }

    public void setNorth(double north) {
        this.north = north;
    }

    public double getSouth() {
        return this.south;
    }

    public void setSouth(double south) {
        this.south = south;
    }

    public double getWest() {
        return this.west;
    }

    public void setWest(double west) {
        this.west = west;
    }

    public double getEast() {
        return this.east;
    }

    public void setEast(double east) {
        this.east = east;
    }

    public double getNSResolution() {
        return this.ns_res;
    }

    public void setNSResolution(double ns_res) {
        this.ns_res = ns_res;
        this.fixRowsAndCols();
        this.fixResolution();
    }

    public double getWEResolution() {
        return this.we_res;
    }

    public void setWEResolution(double we_res) {
        this.we_res = we_res;
        this.fixRowsAndCols();
        this.fixResolution();
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
        this.fixResolution();
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
        this.fixResolution();
    }

    public LinkedHashMap<String, String> getAdditionalGrassEntries() {
        return this.additionalGrassEntries;
    }

    public void setAdditionalGrassEntries(LinkedHashMap<String, String> additionalGrassEntries) {
        this.additionalGrassEntries = additionalGrassEntries;
    }
}

