/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandSelectDescriptor;
import org.geotools.coverage.Category;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.image.jai.Registry;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.CoverageUtilities;
import org.geotools.process.raster.RasterProcess;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.util.logging.Logging;
import org.jaitools.media.jai.rangelookup.RangeLookupDescriptor;
import org.jaitools.media.jai.rangelookup.RangeLookupRIF;
import org.jaitools.media.jai.rangelookup.RangeLookupTable;
import org.jaitools.numeric.Range;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Reclassify", description="Reclassifies a continous raster into integer values defined by a set of ranges")
public class RangeLookupProcess
implements RasterProcess {
    private static final double DEFAULT_NODATA = 0.0;
    private static final Logger LOGGER = Logging.getLogger(RangeLookupProcess.class);

    @DescribeResult(name="reclassified", description="The reclassified raster")
    public GridCoverage2D execute(@DescribeParameter(name="coverage", description="Input raster") GridCoverage2D coverage, @DescribeParameter(name="band", description="Source band to use for classification (default is 0)", min=0) Integer classificationBand, @DescribeParameter(name="ranges", description="Specifier for a value range in the format ( START ; END ).  START and END values are optional. [ and ] can also be used as brackets, to indicate inclusion of the relevant range endpoint.", collectionType=Range.class) List<Range> classificationRanges, @DescribeParameter(name="outputPixelValues", description="Value to be assigned to corresponding range", min=0) int[] outputPixelValues, @DescribeParameter(name="noData", description="Value to be assigned to pixels outside any range (defaults to 0)", min=0) Double noData, ProgressListener listener) throws ProcessException {
        RangeLookupTable lookupTable;
        int ranges;
        if (coverage == null) {
            throw new ProcessException(org.geotools.renderer.i18n.Errors.format((int)143, (Object)"coverage"));
        }
        if (classificationRanges == null) {
            throw new ProcessException(org.geotools.renderer.i18n.Errors.format((int)143, (Object)"classificationRanges"));
        }
        double nd = 0.0;
        if (noData != null) {
            nd = noData;
        }
        if (outputPixelValues != null && outputPixelValues.length > 0 && (ranges = classificationRanges.size()) != outputPixelValues.length) {
            throw new ProcessException(org.geotools.renderer.i18n.Errors.format((int)91, (Object)"outputPixelValues"));
        }
        RenderedImage sourceImage = coverage.getRenderedImage();
        if (classificationBand != null) {
            int band = classificationBand;
            int numbands = sourceImage.getSampleModel().getNumBands();
            if (band < 0 || numbands <= band) {
                throw new ProcessException(org.geotools.renderer.i18n.Errors.format((int)58, (Object)"band", (Object)band));
            }
            if (band == 0 && numbands > 0 || band > 0) {
                sourceImage = BandSelectDescriptor.create((RenderedImage)sourceImage, (int[])new int[]{band}, null);
            }
        }
        int size = classificationRanges.size();
        switch (ColorUtilities.getTransferType((int)size)) {
            case 0: {
                lookupTable = CoverageUtilities.getRangeLookupTable(classificationRanges, outputPixelValues, (byte)nd);
                break;
            }
            case 1: {
                lookupTable = CoverageUtilities.getRangeLookupTable(classificationRanges, outputPixelValues, (short)nd);
                break;
            }
            case 3: {
                lookupTable = CoverageUtilities.getRangeLookupTable(classificationRanges, outputPixelValues, nd);
                break;
            }
            default: {
                throw new IllegalArgumentException(Errors.format((int)58, (Object)"classification ranges size", (Object)size));
            }
        }
        ParameterBlockJAI pb = new ParameterBlockJAI("RangeLookup");
        pb.setSource("source0", (Object)sourceImage);
        pb.setParameter("table", (Object)lookupTable);
        RenderedOp indexedClassification = JAI.create((String)"RangeLookup", (ParameterBlock)pb);
        GridSampleDimension outSampleDimension = new GridSampleDimension((CharSequence)"classification", new Category[]{Category.NODATA}, null).geophysics(true);
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D output = factory.create((CharSequence)"reclassified", (RenderedImage)indexedClassification, coverage.getGridGeometry(), new GridSampleDimension[]{outSampleDimension}, new GridCoverage[]{coverage}, (Map)new HashMap<String, Double>(){
            {
                this.put("GC_NODATA", 0.0);
            }
        });
        return output;
    }

    public GridCoverage2D execute(GridCoverage2D coverage, Integer classificationBand, List<Range> classificationRanges, ProgressListener listener) throws ProcessException {
        return this.execute(coverage, classificationBand, classificationRanges, null, 0.0, listener);
    }

    static {
        Registry.registerRIF((JAI)JAI.getDefaultInstance(), (OperationDescriptor)new RangeLookupDescriptor(), (RenderedImageFactory)new RangeLookupRIF(), (String)"org.jaitools.media.jai");
    }
}

