/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.List;
import javax.media.jai.ROI;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.process.ProcessException;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.Utilities;
import org.jaitools.imageutils.ROIGeometry;
import org.jaitools.media.jai.rangelookup.RangeLookupTable;
import org.jaitools.numeric.Range;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CoverageUtilities {
    private CoverageUtilities() {
    }

    public static ROI prepareROI(Geometry roi, AffineTransform mt2d) throws ProcessException {
        Geometry rasterSpaceGeometry;
        try {
            rasterSpaceGeometry = JTS.transform(roi, (MathTransform)new AffineTransform2D(mt2d.createInverse()));
        }
        catch (MismatchedDimensionException e) {
            throw new ProcessException(e);
        }
        catch (TransformException e) {
            throw new ProcessException(e);
        }
        catch (NoninvertibleTransformException e) {
            throw new ProcessException(e);
        }
        Geometry simplifiedGeometry = DouglasPeuckerSimplifier.simplify(rasterSpaceGeometry, 1.0);
        return new ROIGeometry(simplifiedGeometry);
    }

    public static SimpleFeatureType createFeatureType(GridCoverage2D gc2d, Class<? extends Geometry> geometryClass) {
        Utilities.ensureNonNull((String)"gc2d", (Object)gc2d);
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName(gc2d.getName().toString());
        ftBuilder.setNamespaceURI("http://www.geotools.org/");
        ftBuilder.setCRS(gc2d.getCoordinateReferenceSystem2D());
        ftBuilder.setDefaultGeometry("the_geom");
        ftBuilder.add("the_geom", geometryClass);
        if (!geometryClass.equals(Point.class)) {
            ftBuilder.add("value", Double.class);
        } else {
            GridSampleDimension[] sampleDimensions;
            for (GridSampleDimension sd : sampleDimensions = gc2d.getSampleDimensions()) {
                Class bandClass;
                SampleDimensionType sdType = sd.getSampleDimensionType();
                int dataBuffType = TypeMap.getDataBufferType((SampleDimensionType)sdType);
                switch (dataBuffType) {
                    case 0: {
                        bandClass = Byte.class;
                        break;
                    }
                    case 5: {
                        bandClass = Double.class;
                        break;
                    }
                    case 4: {
                        bandClass = Float.class;
                        break;
                    }
                    case 3: {
                        bandClass = Integer.class;
                        break;
                    }
                    case 1: 
                    case 2: {
                        bandClass = Short.class;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                ftBuilder.add(sd.getDescription().toString(), bandClass);
            }
        }
        return ftBuilder.buildFeatureType();
    }

    public static RangeLookupTable getRangeLookupTable(List<Range> classificationRanges, Number noDataValue) {
        return CoverageUtilities.getRangeLookupTable(classificationRanges, noDataValue, noDataValue.getClass());
    }

    public static RangeLookupTable getRangeLookupTable(List<Range> classificationRanges, Number noDataValue, Class clazz) {
        return CoverageUtilities.getRangeLookupTable(classificationRanges, null, noDataValue, noDataValue.getClass());
    }

    public static RangeLookupTable getRangeLookupTable(List<Range> classificationRanges, int[] outputPixelValues, Number noDataValue) {
        return CoverageUtilities.getRangeLookupTable(classificationRanges, outputPixelValues, noDataValue, noDataValue.getClass());
    }

    public static RangeLookupTable getRangeLookupTable(List<Range> classificationRanges, int[] outputPixelValues, Number noDataValue, Class clazz) {
        RangeLookupTable rlt = new RangeLookupTable(noDataValue);
        int size = classificationRanges.size();
        boolean useCustomOutputPixelValues = outputPixelValues != null && outputPixelValues.length == size;
        for (int i = 0; i < size; ++i) {
            int reference = useCustomOutputPixelValues ? outputPixelValues[i] : i + 1;
            rlt.add(classificationRanges.get(i), CoverageUtilities.convert(reference, noDataValue.getClass()));
        }
        return rlt;
    }

    public static Number convert(Number val, Class<? extends Number> type) {
        if (val == null) {
            return null;
        }
        if (Double.class.equals(type)) {
            if (val instanceof Double) {
                return val;
            }
            return val.doubleValue();
        }
        if (Float.class.equals(type)) {
            if (val instanceof Float) {
                return val;
            }
            return Float.valueOf(val.floatValue());
        }
        if (Integer.class.equals(type)) {
            if (val instanceof Integer) {
                return val;
            }
            return val.intValue();
        }
        if (Byte.class.equals(type)) {
            if (val instanceof Byte) {
                return val;
            }
            return val.byteValue();
        }
        if (Short.class.equals(type)) {
            if (val instanceof Short) {
                return val;
            }
            return val.shortValue();
        }
        throw new UnsupportedOperationException("Class " + type + " can't be used in a value Range");
    }
}

