/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.info.internal.display;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import net.refractions.udig.tool.info.InfoDisplay;
import net.refractions.udig.tool.info.LayerPointInfo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class FeatureDisplay
extends InfoDisplay {
    protected Text text;

    @Override
    public Control getControl() {
        return this.text;
    }

    @Override
    public void createDisplay(Composite parent) {
        this.text = new Text(parent, 2632);
    }

    public void setInfo(SimpleFeature feature) {
        this.text.setToolTipText(null);
        if (feature == null) {
            this.text.setText("");
            return;
        }
        SimpleFeatureType type = feature.getFeatureType();
        StringBuffer buf = new StringBuffer();
        buf.append(feature.getID());
        buf.append(": (");
        buf.append(type.getName().getNamespaceURI());
        buf.append(":");
        buf.append(type.getName().getLocalPart());
        int i = 0;
        while (i < feature.getAttributeCount()) {
            AttributeDescriptor attribute = type.getDescriptor(i);
            Object value = feature.getAttribute(i);
            buf.append("\n");
            buf.append(attribute.getName());
            buf.append(" = ");
            if (attribute instanceof GeometryDescriptor) {
                buf.append(((Geometry)value).getGeometryType());
            } else {
                buf.append(value);
            }
            ++i;
        }
        this.text.setText(buf.toString());
    }

    @Override
    public void setInfo(LayerPointInfo info) {
        if (info == null) {
            this.text.setText("");
        } else {
            try {
                SimpleFeature feature = (SimpleFeature)info.acquireValue();
                this.setInfo(feature);
            }
            catch (IOException noValue) {
                this.text.setText(noValue.getLocalizedMessage());
            }
            if (info.getRequestURL() != null) {
                String req = info.getRequestURL().toString();
                this.text.setToolTipText(req);
            } else {
                this.text.setToolTipText(info.getMimeType());
            }
        }
    }
}

