/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.info.internal;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.render.ICompositeRenderContext;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.render.internal.wms.basic.BasicWMSRenderer2;
import net.refractions.udig.tool.info.InfoPlugin;
import net.refractions.udig.tool.info.LayerPointInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.request.GetFeatureInfoRequest;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.data.wms.response.GetFeatureInfoResponse;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.SAXException;

public class WMSDescribeLayer {
    private Map<Layer, ILayer> getLayerMap(ICompositeRenderContext composite, IProgressMonitor monitor) throws IOException {
        HashMap<Layer, ILayer> mapping = new HashMap<Layer, ILayer>();
        for (IRenderContext context : composite.getContexts()) {
            ILayer layer = context.getLayer();
            if (!context.getLayer().isVisible()) continue;
            Layer wmslayer = (Layer)layer.getResource(Layer.class, monitor);
            mapping.put(wmslayer, layer);
        }
        return mapping;
    }

    public WebMapServer getWMS(ICompositeRenderContext context, IProgressMonitor monitor) throws IOException {
        return (WebMapServer)context.getLayer().getResource(WebMapServer.class, monitor);
    }

    private List<Layer> getLayerList(ICompositeRenderContext composite) throws IOException {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (IRenderContext context : composite.getContexts()) {
            ILayer layer = context.getLayer();
            if (!layer.isVisible()) continue;
            Layer wmslayer = (Layer)layer.getResource(Layer.class, null);
            layers.add(wmslayer);
        }
        return layers;
    }

    private static String commonCode(CoordinateReferenceSystem crs, Set<String> codes) {
        CoordinateReferenceSystem check;
        HashSet<String> crsCodes = new HashSet<String>();
        for (Identifier id : crs.getIdentifiers()) {
            String code = id.toString();
            if (codes.contains(code)) {
                return code;
            }
            crsCodes.add(code);
        }
        for (String code : codes) {
            try {
                check = CRS.decode((String)code);
                if (!crs.equals(check)) continue;
                return ((ReferenceIdentifier)check.getIdentifiers().iterator().next()).getCode();
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
            }
            catch (FactoryException factoryException) {}
        }
        for (String code : codes) {
            try {
                check = CRS.decode((String)code);
                for (Identifier checkId : check.getIdentifiers()) {
                    String checkCode = checkId.toString();
                    if (!crsCodes.contains(checkCode)) continue;
                    return code;
                }
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
            }
            catch (FactoryException factoryException) {}
        }
        return null;
    }

    public static List<LayerPointInfo> info(ILayer layer, ReferencedEnvelope bbox) throws IOException {
        LayerPointInfo info = WMSDescribeLayer.info2(layer, bbox);
        if (info == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(info);
    }

    public static LayerPointInfo info2(ILayer layer, ReferencedEnvelope query) throws IOException {
        ReferencedEnvelope reprojected = null;
        IMap map = layer.getMap();
        try {
            reprojected = query.transform(map.getViewportModel().getCRS(), true);
        }
        catch (Exception e) {
            InfoPlugin.log("", e);
            return null;
        }
        Point centre = map.getViewportModel().worldToPixel(reprojected.centre());
        ReferencedEnvelope sanebbox = map.getViewportModel().getBounds();
        ReferencedEnvelope bbox = new ReferencedEnvelope((Envelope)sanebbox, query.getCoordinateReferenceSystem());
        Layer wmslayer = (Layer)layer.getResource(Layer.class, null);
        if (wmslayer == null) {
            throw new IllegalArgumentException("Provided layer is not a WMS layer");
        }
        if (!wmslayer.isQueryable()) {
            return null;
        }
        final WebMapServer wms = (WebMapServer)layer.getResource(WebMapServer.class, null);
        if (wms == null) {
            throw new IllegalArgumentException("Provided layer cannot resolve to a wms");
        }
        String desiredFormat = WMSDescribeLayer.desiredInfoFormat(wms);
        if (desiredFormat == null) {
            return null;
        }
        GetMapRequest getmap = wms.createGetMapRequest();
        BasicWMSRenderer2.findRequestCRS(Collections.singletonList(wmslayer), (CoordinateReferenceSystem)map.getViewportModel().getCRS(), (IMap)map);
        getmap.setBBox((org.opengis.geometry.Envelope)bbox);
        CRS.toSRS((CoordinateReferenceSystem)bbox.getCoordinateReferenceSystem());
        getmap.setProperty("LAYERS", wmslayer.getName());
        int width = map.getRenderManager().getMapDisplay().getWidth();
        int height = map.getRenderManager().getMapDisplay().getHeight();
        getmap.setDimensions(width, height);
        List formats = wms.getCapabilities().getRequest().getGetMap().getFormats();
        if (formats.contains("image/png")) {
            getmap.setProperty("FORMAT", "image/png");
        } else if (formats.contains("image/gif")) {
            getmap.setProperty("FORMAT", "image/gif");
        } else if (formats.contains("image/jpeg")) {
            getmap.setProperty("FORMAT", "image/jpeg");
        } else if (formats.contains("image/bmp")) {
            getmap.setProperty("FORMAT", "image/bmp");
        }
        StyleImpl wmsStyle = (StyleImpl)layer.getStyleBlackboard().get("net.refractions.udig.render.wmsStyle");
        if (wmsStyle != null) {
            getmap.setProperty("STYLES", wmsStyle.getName());
        } else {
            getmap.setProperty("STYLES", "");
        }
        final GetFeatureInfoRequest request = wms.createGetFeatureInfoRequest(getmap);
        request.setInfoFormat(desiredFormat);
        request.setQueryPoint(centre.x, centre.y);
        request.setQueryLayers(Collections.singleton(wmslayer));
        LayerPointInfo info = new LayerPointInfo(layer){
            private GetFeatureInfoResponse response;

            protected GetFeatureInfoResponse getResponse() throws IOException {
                if (this.response == null) {
                    try {
                        System.out.println(request.getFinalURL());
                        this.response = wms.issueRequest(request);
                    }
                    catch (SAXException sAXException) {
                        throw new IOException("Unable to parse the returned response from the server. Reason unknown.");
                    }
                }
                return this.response;
            }

            @Override
            public URL getRequestURL() {
                return request.getFinalURL();
            }

            @Override
            public String getMimeType() {
                try {
                    return this.getResponse().getContentType();
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            @Override
            public Object acquireValue() throws IOException {
                String result = "";
                InputStream input = this.getResponse().getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    result = String.valueOf(result) + line;
                }
                reader.close();
                input.close();
                return result;
            }
        };
        return info;
    }

    private static String desiredInfoFormat(WebMapServer wms) {
        List formats = wms.getCapabilities().getRequest().getGetFeatureInfo().getFormats();
        String desiredFormat = formats.contains("text/html") ? "text/html" : (formats.contains("text/plain") ? "text/plain" : (formats.contains("application/vnd.ogc.gml") ? "application/vnd.ogc.gml" : null));
        return desiredFormat;
    }
}

