/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.info.internal;

import java.util.List;
import net.refractions.udig.tool.info.LayerPointInfo;
import net.refractions.udig.ui.ImageCache;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class InfoTreeViewer
extends TreeViewer
implements ITreeContentProvider,
ILabelProvider {
    List<LayerPointInfo> information = null;
    ImageCache imageCache = new ImageCache();

    public InfoTreeViewer(Composite parent) {
        super(parent);
        this.setContentProvider((IContentProvider)this);
        this.setLabelProvider((IBaseLabelProvider)this);
        this.setInput(this.information);
        this.expandToLevel(2);
    }

    public void dispose() {
        if (this.information != null) {
            this.information.clear();
            this.information = null;
        }
        if (this.imageCache != null) {
            this.imageCache.dispose();
            this.imageCache = null;
        }
    }

    public Object[] getChildren(Object parent) {
        if (parent == this.information) {
            return this.information.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element == this.information) {
            return null;
        }
        if (element instanceof LayerPointInfo) {
            return this.information;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element == this.information;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput != null && oldInput instanceof List) {
            List oldInformation = (List)oldInput;
            oldInformation.clear();
        }
        if (input == null) {
            this.information = null;
        } else if (input instanceof List) {
            this.information = (List)input;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.inputChanged(newInput, oldInput);
    }

    public Image getImage(Object element) {
        if (element == this.information) {
            return null;
        }
        if (element instanceof LayerPointInfo) {
            LayerPointInfo info = (LayerPointInfo)element;
            return this.imageCache.getImage(info.getLayer().getIcon());
        }
        return null;
    }

    public String getText(Object element) {
        if (element == this.information) {
            return "information";
        }
        if (element instanceof LayerPointInfo) {
            LayerPointInfo info = (LayerPointInfo)element;
            return info.getLayer().getName();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

