/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.info.internal;

import java.io.IOException;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.tool.info.internal.Messages;
import net.refractions.udig.ui.filter.ExpressionInput;
import net.refractions.udig.ui.filter.ExpressionViewer;
import net.refractions.udig.ui.filter.IExpressionViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;

public class InfoPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private IGeoResource resource;
    private IExpressionViewer exViewer;
    private static final String FEATURE_LABEL = "FEATURE_LABEL";

    protected Control createContents(Composite parent) {
        this.resource = (IGeoResource)this.getElement().getAdapter(IGeoResource.class);
        Composite page = new Composite(parent, 0);
        page.setLayout((Layout)new MigLayout("fill, wrap 1, insets 0", "", ""));
        Label exLabel = new Label(page, 0);
        exLabel.setText(Messages.InfoPropertyPage_labelExpression);
        exLabel.setLayoutData((Object)"");
        this.exViewer = new ExpressionViewer(page, 2);
        this.exViewer.getControl().setLayoutData((Object)"h 100%!, w 100%!");
        ExpressionInput exInput = new ExpressionInput(this.getSchema());
        exInput.setBinding(String.class);
        this.exViewer.setInput(exInput);
        this.exViewer.refresh();
        this.setExpression(this.getLabelProperty());
        return page;
    }

    private SimpleFeatureType getSchema() {
        if (this.resource.canResolve(SimpleFeatureSource.class)) {
            try {
                SimpleFeatureSource featureSource = (SimpleFeatureSource)this.resource.resolve(SimpleFeatureSource.class, (IProgressMonitor)new NullProgressMonitor());
                return (SimpleFeatureType)featureSource.getSchema();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean performOk() {
        this.setLabelProperty(this.getExpression());
        return super.performOk();
    }

    protected void performDefaults() {
        this.setExpression(this.getLabelProperty());
        super.performDefaults();
    }

    private void setExpression(String expression) {
        if (expression != null && expression.length() > 0) {
            try {
                this.exViewer.setExpression(ECQL.toExpression((String)expression));
            }
            catch (CQLException e) {
                e.printStackTrace();
            }
        } else {
            this.exViewer.setExpression(null);
        }
    }

    private String getExpression() {
        Expression expression = this.exViewer.getExpression();
        if (expression != null) {
            return ECQL.toCQL((Expression)this.exViewer.getExpression());
        }
        return null;
    }

    private void setLabelProperty(String value) {
        this.resource.getPersistentProperties().put(FEATURE_LABEL, value);
    }

    private String getLabelProperty() {
        return (String)this.resource.getPersistentProperties().get(FEATURE_LABEL);
    }
}

