/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.info.internal;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.project.AdaptableFeature;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.tool.info.LayerPointInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DataStoreDescribeLayer {
    public static List<LayerPointInfo> info(ILayer layer, ReferencedEnvelope bbox, IProgressMonitor monitor) throws Exception {
        List<SimpleFeature> features = DataStoreDescribeLayer.info2(layer, bbox, monitor);
        ArrayList<LayerPointInfo> list = new ArrayList<LayerPointInfo>(features.size());
        Iterator<SimpleFeature> iterator = features.iterator();
        while (iterator.hasNext()) {
            SimpleFeature feature;
            final SimpleFeature feature2 = feature = iterator.next();
            LayerPointInfo info = new LayerPointInfo(layer){

                @Override
                public String getMimeType() {
                    return "application/vnd.ogc.gml";
                }

                @Override
                public Object acquireValue() {
                    return feature2;
                }
            };
            list.add(info);
        }
        return list;
    }

    public static List<SimpleFeature> info2(ILayer layer, ReferencedEnvelope bbox, IProgressMonitor monitor) throws Exception {
        FeatureSource source = (FeatureSource)layer.getResource(FeatureSource.class, null);
        SimpleFeatureType type = (SimpleFeatureType)source.getSchema();
        CoordinateReferenceSystem crs = layer.getCRS();
        if (!bbox.getCoordinateReferenceSystem().equals(crs)) {
            bbox = bbox.transform(crs, true);
        }
        FilterFactory2 factory = (FilterFactory2)CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Geometry geom = new GeometryFactory().toGeometry((Envelope)bbox);
        Intersects filter = factory.intersects((Expression)factory.property(type.getGeometryDescriptor().getName()), (Expression)factory.literal((Object)geom));
        layer.getQuery(false);
        FeatureCollection results = source.getFeatures((Filter)filter);
        ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>();
        FeatureIterator reader = results.features();
        try {
            while (reader.hasNext()) {
                if (monitor != null && monitor.isCanceled()) {
                    ArrayList<SimpleFeature> arrayList = list;
                    return arrayList;
                }
                list.add((SimpleFeature)new AdaptableFeature((SimpleFeature)reader.next(), layer));
            }
        }
        finally {
            reader.close();
        }
        return list;
    }
}

