/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.info;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class InfoPlugin
extends AbstractUIPlugin {
    private static InfoPlugin plugin;
    public static final String ID = "net.refractions.udig.info";
    public static final String IMG_OBJ_PATH = "icons/obj16/";
    public static final String IMG_OBJ_BASE = "icons/obj16/base_doc_obj.png";
    public static final String IMG_OBJ_FILE = "icons/obj16/file_doc_obj.png";
    public static final String IMG_OBJ_LINK = "icons/obj16/link_doc_obj.png";
    public static final String IMG_OBJ_ACTION = "icons/obj16/action_doc_obj.png";
    public static final String IMG_OVR_PATH = "icons/ovr16/";
    public static final String IMG_OVR_ATTACHMENT = "icons/ovr16/attach_ovr.png";
    public static final String IMG_OVR_TEMPLATE = "icons/ovr16/template_ovr.png";
    public static final String IMG_OVR_HOTLINK = "icons/ovr16/hotlink_ovr.png";

    public InfoPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static InfoPlugin getDefault() {
        return plugin;
    }

    public static void log(String message, Throwable e) {
        InfoPlugin.getDefault().getLog().log((IStatus)new Status(1, ID, 0, message, e));
    }

    public static void trace(String message, Throwable e) {
        if (InfoPlugin.getDefault().isDebugging()) {
            if (message != null) {
                System.out.println(message);
            }
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isDebugging(String trace) {
        return InfoPlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)trace));
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        this.addImage(reg, IMG_OBJ_BASE);
        this.addImage(reg, IMG_OBJ_FILE);
        this.addImage(reg, IMG_OBJ_LINK);
        this.addImage(reg, IMG_OBJ_ACTION);
        this.addImage(reg, IMG_OVR_ATTACHMENT);
        this.addImage(reg, IMG_OVR_HOTLINK);
        this.addImage(reg, IMG_OVR_TEMPLATE);
    }

    private void addImage(ImageRegistry reg, String imagePath) {
        ImageDescriptor attachImg;
        Path attachImgPath;
        Bundle bundle = Platform.getBundle((String)ID);
        URL url = FileLocator.find((Bundle)bundle, (IPath)(attachImgPath = new Path(imagePath)), null);
        if (url != null) {
            attachImg = ImageDescriptor.createFromURL((URL)url);
        } else {
            InfoPlugin.log("Unable to find image for " + imagePath, null);
            attachImg = ImageDescriptor.getMissingImageDescriptor();
        }
        reg.put(imagePath, attachImg);
    }
}

