/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.info;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.catalog.util.CRSUtil;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.SimpleTool;
import net.refractions.udig.tool.info.InfoPlugin;
import net.refractions.udig.tool.info.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.geotools.geometry.jts.JTS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class DistanceTool
extends SimpleTool
implements KeyListener {
    List<Point> points = new ArrayList<Point>();
    DistanceFeedbackCommand command;
    private Point now;

    public DistanceTool() {
        super(3);
    }

    protected void onMouseMoved(MapMouseEvent e) {
        this.now = e.getPoint();
        if (this.command == null || this.points.isEmpty()) {
            return;
        }
        Rectangle area = this.command.getValidArea();
        if (area != null) {
            this.getContext().getViewportPane().repaint(area.x, area.y, area.width, area.height);
        } else {
            this.getContext().getViewportPane().repaint();
        }
    }

    public void onMouseReleased(MapMouseEvent e) {
        Point current = e.getPoint();
        if (this.points.isEmpty() || !current.equals(this.points.get(this.points.size() - 1))) {
            this.points.add(current);
        }
        if (this.command == null || !this.command.isValid()) {
            this.command = new DistanceFeedbackCommand();
            this.getContext().sendASyncCommand((Command)this.command);
        }
    }

    protected void onMouseDoubleClicked(MapMouseEvent e) {
        this.disposeCommand();
        this.displayResult();
        this.points.clear();
    }

    private void disposeCommand() {
        if (this.command != null) {
            this.command.setValid(false);
            Rectangle area = this.command.getValidArea();
            if (area != null) {
                this.getContext().getViewportPane().repaint(area.x, area.y, area.width, area.height);
            } else {
                this.getContext().getViewportPane().repaint();
            }
            this.command = null;
        }
    }

    private void displayResult() {
        try {
            double distance = this.distance();
            this.displayOnStatusBar(distance);
        }
        catch (Exception e1) {
            InfoPlugin.log("", e1);
            this.displayError();
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        final IStatusLineManager statusBar = this.getContext().getActionBars().getStatusLineManager();
        this.disposeCommand();
        if (statusBar == null) {
            return;
        }
        this.getContext().updateUI(new Runnable(){

            @Override
            public void run() {
                statusBar.setErrorMessage(null);
                statusBar.setMessage(null);
            }
        });
        if (active) {
            Control control = this.getContext().getViewportPane().getControl();
            control.addKeyListener((KeyListener)this);
        } else {
            Control control = this.getContext().getViewportPane().getControl();
            control.removeKeyListener((KeyListener)this);
        }
    }

    private double distance() throws TransformException {
        Coordinate end;
        Coordinate begin;
        Point current;
        if (this.points.isEmpty()) {
            return 0.0;
        }
        Iterator<Point> iter = this.points.iterator();
        Point start = iter.next();
        double distance = 0.0;
        while (iter.hasNext()) {
            current = iter.next();
            begin = this.getContext().pixelToWorld(start.x, start.y);
            end = this.getContext().pixelToWorld(current.x, current.y);
            distance += JTS.orthodromicDistance((Coordinate)begin, (Coordinate)end, (CoordinateReferenceSystem)this.getContext().getCRS());
            start = current;
        }
        if (this.now != null) {
            current = this.now;
            begin = this.getContext().pixelToWorld(start.x, start.y);
            end = this.getContext().pixelToWorld(current.x, current.y);
            distance += JTS.orthodromicDistance((Coordinate)begin, (Coordinate)end, (CoordinateReferenceSystem)this.getContext().getCRS());
            start = current;
        }
        return distance;
    }

    private void displayError() {
        final IStatusLineManager statusBar = this.getContext().getActionBars().getStatusLineManager();
        if (statusBar == null) {
            return;
        }
        this.getContext().updateUI(new Runnable(){

            @Override
            public void run() {
                statusBar.setErrorMessage(Messages.DistanceTool_error);
            }
        });
    }

    private void displayOnStatusBar(double distance) {
        final IStatusLineManager statusBar = this.getContext().getActionBars().getStatusLineManager();
        if (statusBar == null) {
            return;
        }
        String units = UiPlugin.getDefault().getPreferenceStore().getString("P_DEFAULT_UNITS");
        if (units.equals("AUTO_UNITS") && CRSUtil.isCoordinateReferenceSystemImperial((CoordinateReferenceSystem)this.context.getCRS())) {
            units = "IMPERIAL_UNITS";
        }
        final String message = units.equals("IMPERIAL_UNITS") ? this.createMessageImperial(distance) : this.createMessageMetric(distance);
        this.getContext().updateUI(new Runnable(){

            @Override
            public void run() {
                statusBar.setErrorMessage(null);
                statusBar.setMessage(message);
            }
        });
    }

    private String createMessageMetric(double distance) {
        String message = Messages.DistanceTool_distance;
        message = distance > 100000.0 ? message.concat(String.valueOf((int)(distance / 1000.0)) + "km") : (distance > 10000.0 ? message.concat(String.valueOf(this.round(distance / 1000.0, 1)) + "km") : (distance > 1000.0 ? message.concat(String.valueOf(this.round(distance / 1000.0, 2)) + "km") : (distance > 100.0 ? message.concat(String.valueOf(this.round(distance, 1)) + "m") : (distance > 1.0 ? message.concat(String.valueOf(this.round(distance, 2)) + "m") : message.concat(String.valueOf(this.round(distance * 1000.0, 1)) + "mm")))));
        return message;
    }

    private String createMessageImperial(double distance) {
        String message = Messages.DistanceTool_distance;
        message = (distance = distance / 1000.0 * 0.621371192) > 1000.0 ? message.concat(String.valueOf((int)distance) + "mi") : (distance > 100.0 ? message.concat(String.valueOf(this.round(distance, 1)) + "mi") : (distance > 1.0 ? message.concat(String.valueOf(this.round(distance, 2)) + "mi") : (distance > 0.1 ? message.concat(String.valueOf((int)(distance * 5280.0)) + "ft") : (distance > 0.0189 ? message.concat(String.valueOf(this.round(distance * 5280.0, 1)) + "ft") : message.concat(String.valueOf(this.round(distance * 5280.0 * 12.0, 1)) + "in")))));
        return message;
    }

    private double round(double value, int decimalPlaces) {
        double divisor = Math.pow(10.0, decimalPlaces);
        double newVal = value * divisor;
        newVal = (double)Long.valueOf(Math.round(newVal)).intValue() / divisor;
        return newVal;
    }

    public void reset() {
        this.points.clear();
        if (this.command != null) {
            this.command.setValid(false);
            Rectangle area = this.command.getValidArea();
            if (area != null) {
                this.getContext().getViewportPane().repaint(area.x, area.y, area.width, area.height);
            } else {
                this.getContext().getViewportPane().repaint();
            }
            this.command = null;
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.character == '\r') {
            this.disposeCommand();
            this.displayResult();
            this.points.clear();
        }
    }

    class DistanceFeedbackCommand
    extends AbstractDrawCommand {
        DistanceFeedbackCommand() {
        }

        public Rectangle getValidArea() {
            return null;
        }

        public void run(IProgressMonitor monitor) throws Exception {
            if (DistanceTool.this.points.isEmpty()) {
                return;
            }
            this.graphics.setColor(Color.BLACK);
            Iterator<Point> iter = DistanceTool.this.points.iterator();
            Point start = iter.next();
            while (iter.hasNext()) {
                Point current = iter.next();
                this.graphics.drawLine(start.x, start.y, current.x, current.y);
                start = current;
            }
            if (start == null || DistanceTool.this.now == null) {
                return;
            }
            this.graphics.drawLine(start.x, start.y, ((DistanceTool)DistanceTool.this).now.x, ((DistanceTool)DistanceTool.this).now.y);
            DistanceTool.this.displayResult();
        }
    }
}

