/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.document.IAbstractDocumentSource;
import net.refractions.udig.catalog.document.IAttachment;
import net.refractions.udig.catalog.document.IAttachmentSource;
import net.refractions.udig.catalog.document.IDocument;
import net.refractions.udig.catalog.document.IDocumentFolder;
import net.refractions.udig.catalog.document.IDocumentSource;
import net.refractions.udig.catalog.document.IHotlink;
import net.refractions.udig.catalog.document.IHotlinkSource;
import net.refractions.udig.core.AdapterUtil;
import net.refractions.udig.document.model.DocumentFolder;
import net.refractions.udig.document.source.ShpDocFactory;
import net.refractions.udig.document.ui.DocSourceUtils;
import net.refractions.udig.document.ui.DocUtils;
import net.refractions.udig.document.ui.DocumentDialog;
import net.refractions.udig.document.ui.DocumentImageProvider;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.commands.edit.SetAttributeCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.tool.info.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FidFilterImpl;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;

public class DocumentView
extends ViewPart {
    private TreeViewer viewer;
    private Button attachButton;
    private Button linkButton;
    private Button editButton;
    private Button openButton;
    private Button saveAsButton;
    private Action saveAsAction;
    private Button removeButton;
    private ResourceSelectionProvider resourceSelectionProvider = new ResourceSelectionProvider();
    private IGeoResource geoResource;
    private SimpleFeature feature;
    private IStructuredSelection viewerSelection;
    private IStructuredSelection workbenchSelection;
    private DocumentItemModel itemModel = new DocumentItemModel();
    private boolean isActive = false;
    private ISelectionListener workbenchSelectionListener;
    private IPartListener workbenchPartListener;
    private boolean isResourceEnabled = false;
    private boolean isFeatureEnabled = false;
    private boolean isHotlinkEnabled = false;
    private static final int DOCUMENT_INDEX = 0;
    private static final int DOCUMENT_WEIGHT = 40;
    private static final int TYPE_INDEX = 1;
    private static final int TYPE_WEIGHT = 10;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int DESCRIPTION_WEIGHT = 50;
    private static final String FEATURE_LABEL = "FEATURE_LABEL";

    private void addWorkbenchListeners() {
        IWorkbenchPartSite partSite = this.getSite();
        final ISelectionService selectionService = partSite.getWorkbenchWindow().getSelectionService();
        this.workbenchSelectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (!(part instanceof DocumentView)) {
                    DocumentView.this.handleWorkbenchSelection(selection);
                }
            }
        };
        selectionService.addPostSelectionListener(this.workbenchSelectionListener);
        this.workbenchPartListener = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
                if (part instanceof DocumentView) {
                    DocumentView.this.handleWorkbenchSelection(selectionService.getSelection());
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                DocumentView.this.isActive = part instanceof DocumentView;
            }
        };
        partSite.getPage().addPartListener(this.workbenchPartListener);
    }

    private void removeWorkbenchListeners() {
        if (this.workbenchSelectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.workbenchSelectionListener);
            this.workbenchSelectionListener = null;
        }
        if (this.workbenchPartListener != null) {
            this.getSite().getPage().removePartListener(this.workbenchPartListener);
            this.workbenchPartListener = null;
        }
    }

    public void createPartControl(Composite viewParent) {
        this.setPartName(Messages.docView_name);
        this.createViewMenu();
        Composite parent = new Composite(viewParent, 0);
        parent.setLayout((Layout)new MigLayout("insets 0, fill, wrap 2", "[85%]0[15%]", "[100%]"));
        this.createTreeControlArea(parent);
        this.createButtonControlArea(parent);
        this.refreshBtns();
        this.addWorkbenchListeners();
    }

    private void createViewMenu() {
        this.saveAsAction = new Action(Messages.docView_saveAs){

            public void run() {
                DocumentView.this.saveAs();
            }
        };
        this.saveAsAction.setId(Messages.docView_saveAs);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IAction)this.saveAsAction);
        menuManager.add((IContributionItem)new Separator());
        PropertyDialogAction resourcePropertyAction = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.resourceSelectionProvider);
        menuManager.add((IAction)resourcePropertyAction);
    }

    private void createTreeControlArea(Composite parent) {
        Tree viewerTree = new Tree(parent, 68352);
        viewerTree.setLayoutData((Object)"grow, h 100%!, w 85%!");
        viewerTree.setHeaderVisible(true);
        viewerTree.setLinesVisible(true);
        TableLayout viewerTreeLayout = new TableLayout();
        TreeColumn nameColumn = new TreeColumn(viewerTree, 16384, 0);
        nameColumn.setText(Messages.docView_documentColumn);
        viewerTreeLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        TreeColumn detailColumn = new TreeColumn(viewerTree, 0x1000000, 1);
        detailColumn.setText(Messages.docView_typeColumn);
        viewerTreeLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        TreeColumn descColumn = new TreeColumn(viewerTree, 16384, 2);
        descColumn.setText(Messages.docView_descriptionColumn);
        viewerTreeLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        viewerTree.setLayout((Layout)viewerTreeLayout);
        this.viewer = new TreeViewer(viewerTree);
        this.viewer.setContentProvider((IContentProvider)new DocumentViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DocumentViewTableLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DocumentView.this.handleListSelection(event.getSelection());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DocumentView.this.handleListDoubleClick(event.getSelection());
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void createButtonControlArea(Composite parent) {
        SelectionAdapter btnSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                DocumentView.this.handleBtnSelection(e.widget);
            }
        };
        Composite btnSection = new Composite(parent, 0);
        btnSection.setLayout((Layout)new MigLayout("fillx, wrap 1", "", "[][][][][]push[]"));
        btnSection.setLayoutData((Object)"grow");
        this.attachButton = new Button(btnSection, 8);
        this.attachButton.setText(Messages.docView_attach);
        this.attachButton.setLayoutData((Object)"growx");
        this.attachButton.addSelectionListener((SelectionListener)btnSelectionListener);
        this.linkButton = new Button(btnSection, 8);
        this.linkButton.setText(Messages.docView_link);
        this.linkButton.setLayoutData((Object)"growx");
        this.linkButton.addSelectionListener((SelectionListener)btnSelectionListener);
        this.editButton = new Button(btnSection, 8);
        this.editButton.setText(Messages.docView_edit);
        this.editButton.setLayoutData((Object)"growx");
        this.editButton.addSelectionListener((SelectionListener)btnSelectionListener);
        this.openButton = new Button(btnSection, 8);
        this.openButton.setText(Messages.docView_open);
        this.openButton.setLayoutData((Object)"growx");
        this.openButton.addSelectionListener((SelectionListener)btnSelectionListener);
        this.saveAsButton = new Button(btnSection, 8);
        this.saveAsButton.setText(Messages.docView_saveAs);
        this.saveAsButton.setLayoutData((Object)"growx");
        this.saveAsButton.addSelectionListener((SelectionListener)btnSelectionListener);
        this.saveAsButton.setVisible(false);
        this.removeButton = new Button(btnSection, 8);
        this.removeButton.setText(Messages.docView_clear);
        this.removeButton.setLayoutData((Object)"growx");
        this.removeButton.addSelectionListener((SelectionListener)btnSelectionListener);
    }

    public void setFocus() {
    }

    public void dispose() {
        this.removeWorkbenchListeners();
        super.dispose();
    }

    private void handleListSelection(ISelection selection) {
        this.viewerSelection = null;
        if (selection instanceof StructuredSelection) {
            this.viewerSelection = (StructuredSelection)selection;
        }
        this.refreshBtns();
    }

    private void handleListDoubleClick(ISelection selection) {
        IDocument doc;
        StructuredSelection structSelection = (StructuredSelection)selection;
        Object element = structSelection.getFirstElement();
        if (element instanceof IDocument && !(doc = (IDocument)element).isEmpty()) {
            this.open();
        }
    }

    private void refreshBtns() {
        this.setBtns(false);
        this.refreshBtnsOnType();
    }

    private void setBtns(boolean isEnabled) {
        this.openButton.setEnabled(isEnabled);
        this.attachButton.setEnabled(isEnabled);
        this.linkButton.setEnabled(isEnabled);
        this.editButton.setEnabled(isEnabled);
        this.removeButton.setEnabled(isEnabled);
        this.saveAsButton.setEnabled(isEnabled);
        this.saveAsAction.setEnabled(isEnabled);
    }

    private void refreshBtnsOnType() {
        if (this.viewerSelection != null) {
            if (this.viewerSelection.size() == 1) {
                Object element = this.viewerSelection.getFirstElement();
                IAbstractDocumentSource folderSource = this.getDocumentSource();
                this.attachButton.setEnabled(DocSourceUtils.canAttach(folderSource));
                this.linkButton.setEnabled(DocSourceUtils.canLink(folderSource));
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    IDocument.Type docType = doc.getType();
                    this.editButton.setEnabled(DocSourceUtils.canUpdate(doc.getSource()));
                    if (IDocument.Type.ATTACHMENT == docType && IDocument.ContentType.FILE == doc.getContentType()) {
                        this.saveAsButton.setEnabled(true);
                        this.saveAsAction.setEnabled(true);
                    }
                    if (!doc.isEmpty()) {
                        this.openButton.setEnabled(true);
                    }
                    boolean isHotlink = IDocument.Type.HOTLINK == docType;
                    this.removeButton.setText(isHotlink ? Messages.docView_clear : Messages.docView_delete);
                    this.removeButton.setEnabled(isHotlink ? !doc.isEmpty() : true);
                    if (this.removeButton.isEnabled()) {
                        this.removeButton.setEnabled(DocSourceUtils.canRemove(doc.getSource()));
                    }
                }
            } else if (this.viewerSelection.size() > 1) {
                int count = 0;
                for (Object obj : this.viewerSelection.toList()) {
                    if (!(obj instanceof IDocumentFolder)) continue;
                    ++count;
                }
                boolean isAllFolders = count == this.viewerSelection.size();
                this.removeButton.setEnabled(!isAllFolders);
            }
        }
    }

    private void handleWorkbenchSelection(ISelection selection) {
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection newSelection = (IStructuredSelection)selection;
            if (this.workbenchSelection == null) {
                this.updateList(UpdateType.UPDATE, newSelection);
            } else {
                boolean isSameCount;
                boolean bl = isSameCount = this.workbenchSelection.size() == newSelection.size();
                if (isSameCount) {
                    this.updateList(UpdateType.CHECK_UPDATE, newSelection);
                } else {
                    this.updateList(UpdateType.UPDATE, newSelection);
                }
            }
            return;
        }
        this.updateList(UpdateType.CLEAR, null);
    }

    private void updateList(final UpdateType option, final IStructuredSelection selection) {
        Job getDocsJob = new Job(Messages.DocumentView_retrieveDocsProgressMsg){

            protected IStatus run(IProgressMonitor monitor) {
                switch (option) {
                    case CLEAR: {
                        DocumentView.this.workbenchSelection = null;
                        DocumentView.this.itemModel = null;
                        break;
                    }
                    case UPDATE: {
                        DocumentView.this.workbenchSelection = selection;
                        DocumentView.this.itemModel = new DocumentItemModel();
                        DocumentView.this.itemModel.setItems(DocumentView.this.getItems(monitor));
                        break;
                    }
                    case CHECK_UPDATE: {
                        if (DocumentView.this.isSameSelection(selection)) break;
                        DocumentView.this.workbenchSelection = selection;
                        DocumentView.this.itemModel = new DocumentItemModel();
                        DocumentView.this.itemModel.setItems(DocumentView.this.getItems(monitor));
                        break;
                    }
                }
                DocumentView.this.updateListCallback();
                return Status.OK_STATUS;
            }
        };
        getDocsJob.schedule();
    }

    private void updateListCallback() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Tree viewerTree;
                if (DocumentView.this.viewer != null && (viewerTree = DocumentView.this.viewer.getTree()) != null && !viewerTree.isDisposed()) {
                    DocumentView.this.viewer.setInput((Object)DocumentView.this.itemModel);
                    DocumentView.this.viewer.expandAll();
                    if (DocumentView.this.isActive) {
                        viewerTree.setFocus();
                    }
                }
            }
        });
    }

    private boolean isSameSelection(IStructuredSelection newSelection) {
        Iterator wbIterator = this.workbenchSelection.iterator();
        Iterator nwIterator = newSelection.iterator();
        while (nwIterator.hasNext() && wbIterator.hasNext()) {
            Object nwObj;
            Object wbObj = wbIterator.next();
            if (this.isSameSelectionObj(wbObj, nwObj = nwIterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isSameSelectionObj(Object obj1, Object obj2) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IGeoResource resource1 = this.toGeoResource(obj1, (IProgressMonitor)monitor);
        IGeoResource resource2 = this.toGeoResource(obj2, (IProgressMonitor)monitor);
        if (resource1 != null && resource2 != null && resource1.getID().equals((Object)resource2.getID())) {
            FidFilterImpl filter1 = this.toFilter(obj1, (IProgressMonitor)monitor);
            FidFilterImpl filter2 = this.toFilter(obj2, (IProgressMonitor)monitor);
            if (filter1 == null && filter2 == null) {
                return true;
            }
            if (filter1 != null && filter2 != null && filter1.equals((Object)filter2)) {
                return true;
            }
        }
        return false;
    }

    void setGeoResourceInternal(IGeoResource geoResource) {
        this.geoResource = geoResource;
        this.resourceSelectionProvider.setSelection(geoResource);
    }

    private List<Object> getItems(IProgressMonitor monitor) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object obj : this.workbenchSelection) {
            IDocumentSource docSource;
            this.setGeoResourceInternal(this.toGeoResource(obj, monitor));
            if (this.geoResource == null) continue;
            this.feature = this.getFeature(this.geoResource, this.toFilter(obj, monitor));
            if (this.feature != null) {
                IHotlinkSource hotlinkSource = this.toSource(this.geoResource, IHotlinkSource.class, monitor);
                this.isHotlinkEnabled = hotlinkSource != null && hotlinkSource.isEnabled();
                IAttachmentSource attachmentSource = this.toSource(this.geoResource, IAttachmentSource.class, monitor);
                boolean bl = this.isFeatureEnabled = attachmentSource != null && attachmentSource.isEnabled();
                if (this.isFeatureEnabled || this.isHotlinkEnabled) {
                    String featureLabel = this.getFeatureLabel(this.geoResource, this.feature);
                    DocumentFolder folder = ShpDocFactory.createFolder(this.feature, featureLabel, (IAbstractDocumentSource)attachmentSource);
                    if (this.isFeatureEnabled) {
                        folder.setDocuments(attachmentSource.getDocuments(this.feature, monitor));
                    }
                    if (this.isHotlinkEnabled) {
                        folder.insertDocuments(hotlinkSource.getDocuments(this.feature, monitor), 0);
                    }
                    items.add(folder);
                }
            }
            boolean bl = this.isResourceEnabled = (docSource = this.toSource(this.geoResource, IDocumentSource.class, monitor)) != null && docSource.isEnabled();
            if (!this.isResourceEnabled) continue;
            DocumentFolder folder = ShpDocFactory.createFolder(null, this.geoResource.getTitle(), (IAbstractDocumentSource)docSource);
            folder.setDocuments(docSource.getDocuments(monitor));
            items.add(folder);
        }
        return items;
    }

    private String getFeatureLabel(IGeoResource resource, SimpleFeature feature) {
        String labelExpression = (String)resource.getPersistentProperties().get(FEATURE_LABEL);
        if (labelExpression != null) {
            try {
                Expression exp = ECQL.toExpression((String)labelExpression);
                String featureLabel = (String)exp.evaluate((Object)feature);
                if (featureLabel != null && featureLabel.trim().length() > 0) {
                    return featureLabel;
                }
            }
            catch (CQLException e) {
                e.printStackTrace();
            }
        }
        return feature.getID();
    }

    private IGeoResource toGeoResource(Object obj, IProgressMonitor monitor) {
        AdapterUtil adapterUtil;
        if (obj != null && (adapterUtil = AdapterUtil.instance).canAdaptTo(obj, IGeoResource.class)) {
            try {
                return (IGeoResource)adapterUtil.adaptTo(IGeoResource.class, obj, monitor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private <T> T toSource(IGeoResource geoResource, Class<T> type, IProgressMonitor monitor) {
        if (geoResource != null && geoResource.canResolve(type)) {
            try {
                return (T)geoResource.resolve(type, monitor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private FidFilterImpl toFilter(Object obj, IProgressMonitor monitor) {
        if (obj != null) {
            AdapterUtil adapterUtil = AdapterUtil.instance;
            try {
                return (FidFilterImpl)adapterUtil.adaptTo(FidFilterImpl.class, obj, monitor);
            }
            catch (ClassCastException classCastException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SimpleFeature getFeature(IGeoResource geoResource, FidFilterImpl filter) {
        if (filter == null) return null;
        try {
            if (!geoResource.canResolve(SimpleFeatureStore.class)) return null;
            SimpleFeatureStore featureSource = (SimpleFeatureStore)geoResource.resolve(SimpleFeatureStore.class, (IProgressMonitor)new NullProgressMonitor());
            SimpleFeatureCollection featureCollection = featureSource.getFeatures((Filter)filter);
            SimpleFeatureIterator featureIterator = featureCollection.features();
            try {
                if (!featureIterator.hasNext()) return null;
                SimpleFeature simpleFeature = (SimpleFeature)featureIterator.next();
                return simpleFeature;
            }
            finally {
                if (featureIterator != null) {
                    featureIterator.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void handleBtnSelection(Widget btn) {
        if (this.openButton == btn) {
            this.open();
        } else if (this.attachButton == btn) {
            this.attach();
        } else if (this.linkButton == btn) {
            this.link();
        } else if (this.editButton == btn) {
            this.edit();
        } else if (this.removeButton == btn) {
            this.remove();
        } else if (this.saveAsButton == btn) {
            this.saveAs();
        }
    }

    private void open() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        IDocument doc = (IDocument)selection.getFirstElement();
        if (IDocument.ContentType.ACTION == doc.getContentType()) {
            this.openAction(doc);
        } else {
            doc.open();
        }
    }

    private void openAction(IDocument doc) {
        IHotlink hotlinkDoc = (IHotlink)doc;
        List descriptors = hotlinkDoc.getDescriptors();
        if (descriptors.size() > 1) {
            Object[] results;
            ListDialog dialog = new ListDialog(this.openButton.getShell());
            dialog.setTitle(Messages.DocumentView_openActionDialogTitle);
            dialog.setMessage(Messages.DocumentView_openActionDialogMessage);
            dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)element;
                    return DocUtils.getLabelAndDescDisplay(descriptor.getLabel(), descriptor.getDescription());
                }
            });
            dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            dialog.setInput((Object)descriptors.toArray());
            dialog.setInitialElementSelections(Collections.singletonList((IHotlinkSource.HotlinkDescriptor)descriptors.get(0)));
            if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length > 0) {
                IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)results[0];
                this.openAction(hotlinkDoc, descriptor);
            }
        } else if (descriptors.size() == 1) {
            IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)descriptors.get(0);
            this.openAction(hotlinkDoc, descriptor);
        }
    }

    private void openAction(IHotlink hotlinkDoc, IHotlinkSource.HotlinkDescriptor descriptor) {
        String action = descriptor.getConfig().replace("{0}", hotlinkDoc.getContent().toString());
        Program.launch((String)action);
    }

    private void attach() {
        IDocumentFolder folder = this.getDocumentFolder();
        if (folder != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("P_TYPE", IDocument.Type.ATTACHMENT);
            params.put("P_MODE", (Object)DocumentDialog.Mode.ADD);
            params.put("P_TEMPLATES", this.itemModel.getTemplates(folder));
            IAbstractDocumentSource source = folder.getSource();
            boolean isFeatureDoc = source instanceof IAttachmentSource;
            DocumentDialog docDialog = this.openDocDialog(new HashMap<String, Object>(), params, isFeatureDoc);
            if (docDialog != null) {
                this.addDocument(folder, docDialog.getDocInfo());
            }
        }
    }

    private void link() {
        IDocumentFolder folder = this.getDocumentFolder();
        if (folder != null) {
            boolean isFeatureDoc;
            DocumentDialog docDialog;
            IAbstractDocumentSource source = folder.getSource();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("P_TYPE", IDocument.Type.LINKED);
            params.put("P_MODE", (Object)DocumentDialog.Mode.ADD);
            params.put("P_TEMPLATES", this.itemModel.getTemplates(folder));
            ArrayList<IDocument.ContentType> contentTypes = new ArrayList<IDocument.ContentType>();
            if (DocSourceUtils.canLinkFile(source)) {
                contentTypes.add(IDocument.ContentType.FILE);
            }
            if (DocSourceUtils.canLinkWeb(source)) {
                contentTypes.add(IDocument.ContentType.WEB);
            }
            if (contentTypes != null && contentTypes.size() > 0) {
                params.put("P_CONTENT_TYPES", contentTypes);
            }
            if ((docDialog = this.openDocDialog(new HashMap<String, Object>(), params, isFeatureDoc = source instanceof IAttachmentSource)) != null) {
                this.addDocument(folder, docDialog.getDocInfo());
            }
        }
    }

    private void addDocument(final IDocumentFolder folder, final IDocumentSource.DocumentInfo info) {
        Job addDocJob = new Job(Messages.DocumentView_addDocProgressMsg){

            protected IStatus run(IProgressMonitor monitor) {
                IDocument doc = null;
                if (folder.getSource() instanceof IDocumentSource) {
                    IDocumentSource resourceDocSource = (IDocumentSource)folder.getSource();
                    doc = resourceDocSource.add(info, monitor);
                } else if (folder.getSource() instanceof IAttachmentSource) {
                    IAttachmentSource featureDocSource = (IAttachmentSource)folder.getSource();
                    doc = featureDocSource.add(DocumentView.this.feature, info, monitor);
                }
                DocumentView.this.addDocumentCallback(doc);
                return Status.OK_STATUS;
            }
        };
        addDocJob.schedule();
    }

    private void addDocumentCallback(final IDocument doc) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (doc == null) {
                    MessageDialog.openError((Shell)DocumentView.this.attachButton.getShell(), (String)Messages.DocumentView_addDocPopupTitle, (String)Messages.DocumentView_addDocError);
                } else {
                    DocumentView.this.viewer.refresh();
                    DocumentView.this.viewer.expandAll();
                }
            }
        });
    }

    private void edit() {
        Object obj = this.viewerSelection.getFirstElement();
        if (obj instanceof IDocument) {
            IDocument doc = (IDocument)obj;
            if (IDocument.Type.HOTLINK == doc.getType()) {
                this.editHotlink(doc);
            } else {
                this.editDocument(doc);
            }
        }
    }

    private void editDocument(final IDocument doc) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (!doc.isEmpty()) {
            values.put("V_INFO", doc.getContent().toString());
        }
        values.put("V_CONTENT_TYPE", doc.getContentType());
        values.put("V_LABEL", doc.getLabel());
        values.put("V_DESCRIPTION", doc.getDescription());
        values.put("V_TEMPLATE", doc.isTemplate());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("P_TYPE", doc.getType());
        params.put("P_MODE", (Object)DocumentDialog.Mode.EDIT);
        params.put("P_TEMPLATES", this.itemModel.getTemplates(doc));
        final IAbstractDocumentSource source = doc.getSource();
        boolean isFeatureDoc = source instanceof IAttachmentSource;
        final DocumentDialog docDialog = this.openDocDialog(values, params, isFeatureDoc);
        if (docDialog != null) {
            Job editDocJob = new Job(Messages.DocumentView_updateDocProgressMsg){

                protected IStatus run(IProgressMonitor monitor) {
                    boolean isUpdated = false;
                    IDocumentSource.DocumentInfo info = docDialog.getDocInfo();
                    if (source instanceof IDocumentSource) {
                        IDocumentSource resourceDocSource = (IDocumentSource)source;
                        isUpdated = resourceDocSource.update(doc, info, monitor);
                    } else if (source instanceof IAttachmentSource) {
                        IAttachmentSource featureDocSource = (IAttachmentSource)source;
                        isUpdated = featureDocSource.update(DocumentView.this.feature, doc, info, monitor);
                    }
                    DocumentView.this.editDocumentCallback(isUpdated);
                    return Status.OK_STATUS;
                }
            };
            editDocJob.schedule();
        }
    }

    private void editDocumentCallback(final boolean isUpdated) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!isUpdated) {
                    MessageDialog.openError((Shell)DocumentView.this.attachButton.getShell(), (String)Messages.DocumentView_updateDocPopupTitle, (String)Messages.DocumentView_updateDocError);
                } else {
                    DocumentView.this.viewer.refresh();
                    DocumentView.this.viewer.expandAll();
                }
            }
        });
    }

    private void editHotlink(final IDocument doc) {
        DocumentDialog docDialog;
        IHotlink hotlinkDoc = (IHotlink)doc;
        final String attributeName = hotlinkDoc.getAttributeName();
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (!doc.isEmpty()) {
            values.put("V_INFO", doc.getContent().toString());
        }
        values.put("V_CONTENT_TYPE", doc.getContentType());
        values.put("V_ATTRIBUTE", attributeName);
        values.put("V_LABEL", doc.getLabel());
        values.put("V_DESCRIPTION", doc.getDescription());
        if (IDocument.ContentType.ACTION == doc.getContentType()) {
            values.put("V_ACTIONS", hotlinkDoc.getDescriptors());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("P_TYPE", IDocument.Type.HOTLINK);
        params.put("P_MODE", (Object)DocumentDialog.Mode.EDIT);
        if (IDocument.ContentType.FILE == doc.getContentType()) {
            params.put("P_TEMPLATES", this.itemModel.getTemplates(doc));
        }
        if ((docDialog = this.openDocDialog(values, params, true)) != null) {
            Job editHotlinkJob = new Job(Messages.DocumentView_updateHotlinkProgressMsg){

                protected IStatus run(IProgressMonitor monitor) {
                    boolean isUpdated = false;
                    IHotlinkSource featureDocSource = (IHotlinkSource)doc.getSource();
                    switch (doc.getContentType()) {
                        case FILE: {
                            isUpdated = featureDocSource.setFile(DocumentView.this.feature, attributeName, docDialog.getFileInfo(), monitor);
                            break;
                        }
                        case WEB: {
                            isUpdated = featureDocSource.setLink(DocumentView.this.feature, attributeName, docDialog.getUrlInfo(), monitor);
                            break;
                        }
                        case ACTION: {
                            isUpdated = featureDocSource.setAction(DocumentView.this.feature, attributeName, docDialog.getInfo(), monitor);
                            break;
                        }
                    }
                    if (isUpdated) {
                        isUpdated = DocumentView.this.set(attributeName, DocumentView.this.feature.getAttribute(attributeName), monitor);
                    }
                    DocumentView.this.itemModel.getClass();
                    DocumentView.this.editHotlinkCallback(isUpdated);
                    return Status.OK_STATUS;
                }
            };
            editHotlinkJob.schedule();
        }
    }

    private void editHotlinkCallback(final boolean isUpdated) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!isUpdated) {
                    MessageDialog.openError((Shell)DocumentView.this.attachButton.getShell(), (String)Messages.DocumentView_setHotlinkPopupTitle, (String)Messages.DocumentView_setHotlinkError);
                } else {
                    DocumentView.this.viewer.refresh();
                    DocumentView.this.viewer.expandAll();
                }
            }
        });
    }

    private DocumentDialog openDocDialog(Map<String, Object> values, Map<String, Object> params, boolean isFeatureDoc) {
        if (isFeatureDoc && this.feature != null) {
            params.put("P_FEATURE_NAME", this.getFeatureLabel(this.geoResource, this.feature));
        }
        params.put("P_RESOURCE_NAME", this.geoResource.getTitle());
        DocumentDialog docDialog = new DocumentDialog(this.editButton.getShell(), values, params);
        int result = docDialog.open();
        if (result == 0) {
            return docDialog;
        }
        return null;
    }

    private void remove() {
        ArrayList<IDocument> docs;
        HashMap docMap = new HashMap();
        for (Object obj : this.viewerSelection) {
            if (!(obj instanceof IDocument)) continue;
            IDocument doc = (IDocument)obj;
            if (docMap.containsKey(doc.getSource())) {
                ((ArrayList)docMap.get(doc.getSource())).add(doc);
                continue;
            }
            docs = new ArrayList<IDocument>();
            docs.add(doc);
            docMap.put(doc.getSource(), docs);
        }
        for (final IAbstractDocumentSource source : docMap.keySet()) {
            docs = (ArrayList<IDocument>)docMap.get(source);
            for (final IDocument doc : docs) {
                boolean doDelete = true;
                if (IDocument.Type.ATTACHMENT == doc.getType() && IDocument.ContentType.FILE == doc.getContentType() && !doc.isEmpty()) {
                    doDelete = MessageDialog.openConfirm((Shell)this.removeButton.getShell(), (String)Messages.docView_deleteAttachConfirmTitle, (String)Messages.docView_deleteAttachConfirmMsg);
                }
                if (!doDelete) continue;
                if (source instanceof IDocumentSource) {
                    Job removeLayerDocJob = new Job(Messages.DocumentView_removeDocProgressMsg){

                        protected IStatus run(IProgressMonitor monitor) {
                            IDocumentSource docSource = (IDocumentSource)source;
                            boolean isRemoved = docSource.remove(doc, monitor);
                            DocumentView.this.removeDocumentCallback(isRemoved);
                            return Status.OK_STATUS;
                        }
                    };
                    removeLayerDocJob.schedule();
                    continue;
                }
                if (source instanceof IAttachmentSource) {
                    final IAttachmentSource featureDocSource = (IAttachmentSource)source;
                    Job removeFeatureDocJob = new Job(Messages.DocumentView_removeDocProgressMsg){

                        protected IStatus run(IProgressMonitor monitor) {
                            boolean isRemoved = featureDocSource.remove(DocumentView.this.feature, doc, monitor);
                            DocumentView.this.removeDocumentCallback(isRemoved);
                            return Status.OK_STATUS;
                        }
                    };
                    removeFeatureDocJob.schedule();
                    continue;
                }
                if (!(source instanceof IHotlinkSource)) continue;
                final IHotlinkSource featureHotlinkSource = (IHotlinkSource)source;
                Job clearHotlinkJob = new Job(Messages.DocumentView_clearHotlinkProgressMsg){

                    protected IStatus run(IProgressMonitor monitor) {
                        IHotlink hotlinkDoc = (IHotlink)doc;
                        String attributeName = hotlinkDoc.getAttributeName();
                        boolean isCleared = featureHotlinkSource.clear(DocumentView.this.feature, attributeName, monitor);
                        if (isCleared) {
                            isCleared = DocumentView.this.set(attributeName, null, monitor);
                        }
                        DocumentView.this.clearHotlinkCallback(isCleared);
                        return Status.OK_STATUS;
                    }
                };
                clearHotlinkJob.schedule();
            }
        }
    }

    private void clearHotlinkCallback(final boolean isCleared) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!isCleared) {
                    MessageDialog.openError((Shell)DocumentView.this.attachButton.getShell(), (String)Messages.DocumentView_clearHotlinkPopupTitle, (String)Messages.DocumentView_clearHotlinkError);
                } else {
                    DocumentView.this.viewer.refresh();
                    DocumentView.this.viewer.expandAll();
                }
            }
        });
    }

    private void removeDocumentCallback(final boolean isRemoved) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!isRemoved) {
                    MessageDialog.openError((Shell)DocumentView.this.attachButton.getShell(), (String)Messages.DocumentView_removeDocPopupTitle, (String)Messages.DocumentView_removeDocError);
                } else {
                    DocumentView.this.viewer.refresh();
                    DocumentView.this.viewer.expandAll();
                }
            }
        });
    }

    private boolean set(String attributeName, Object obj, IProgressMonitor monitor) {
        FeatureId fid = this.feature.getIdentifier();
        IMap map = ApplicationGIS.getActiveMap();
        if (map != null) {
            return this.setOnMap(map, fid, attributeName, obj);
        }
        return this.setOnGeoResource(fid, attributeName, obj, monitor);
    }

    private boolean setOnMap(IMap map, FeatureId fid, String attributeName, Object obj) {
        SetAttributeCommand cmd = new SetAttributeCommand(attributeName, obj);
        map.sendCommandASync((MapCommand)cmd);
        return true;
    }

    private boolean setOnGeoResource(FeatureId fid, String attributeName, Object obj, IProgressMonitor monitor) {
        try {
            if (this.geoResource.canResolve(SimpleFeatureStore.class)) {
                Id filter = CommonFactoryFinder.getFilterFactory2().id(new FeatureId[]{fid});
                SimpleFeatureStore featureStore = (SimpleFeatureStore)this.geoResource.resolve(SimpleFeatureStore.class, monitor);
                featureStore.modifyFeatures(attributeName, obj, (Filter)filter);
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void saveAs() {
        Object element = this.viewerSelection.getFirstElement();
        if (element instanceof IAttachment) {
            IAttachment attachDoc = (IAttachment)element;
            File file = (File)attachDoc.getContent();
            FileDialog dialog = new FileDialog(this.saveAsButton.getShell(), 8192);
            dialog.setText(Messages.DocumentView_saveAsDialogTitle);
            dialog.setOverwrite(true);
            dialog.setFileName(DocUtils.getSaveAsFilename(file));
            String filePath = dialog.open();
            if (filePath != null) {
                File newFile = new File(DocUtils.cleanFilename(filePath, file));
                boolean isSaved = attachDoc.saveAs(newFile);
                if (isSaved) {
                    MessageDialog.openInformation((Shell)this.saveAsButton.getShell(), (String)Messages.DocumentView_saveAsSuccessDialogTitle, (String)Messages.DocumentView_saveAsSuccessDialogMsg);
                } else {
                    MessageDialog.openError((Shell)this.saveAsButton.getShell(), (String)Messages.DocumentView_saveAsErrorDialogTitle, (String)Messages.DocumentView_saveAsErrorDialogMsg);
                }
            }
        }
    }

    private IDocumentFolder getDocumentFolder() {
        if (this.viewerSelection != null) {
            Object obj = this.viewerSelection.getFirstElement();
            IDocumentFolder folder = null;
            if (obj instanceof IDocumentFolder) {
                folder = (IDocumentFolder)obj;
            } else if (obj instanceof IDocument) {
                folder = this.itemModel.getFolder((IDocument)obj);
            }
            return folder;
        }
        return null;
    }

    private IAbstractDocumentSource getDocumentSource() {
        IDocumentFolder folder = this.getDocumentFolder();
        if (folder != null) {
            return folder.getSource();
        }
        return null;
    }

    private class DocumentItemModel {
        private List<Object> items = new ArrayList<Object>();

        public List<Object> getItems() {
            return this.items;
        }

        public void setItems(List<Object> items) {
            this.items = items;
        }

        public IDocumentFolder getFolder(IDocument doc) {
            for (Object item : this.items) {
                if (!(item instanceof IDocumentFolder)) continue;
                IDocumentFolder folder = (IDocumentFolder)item;
                for (IDocument folderDoc : folder.getDocuments()) {
                    if (!folderDoc.equals(doc)) continue;
                    return folder;
                }
            }
            return null;
        }

        public List<IDocument> getTemplates(IDocumentFolder folder) {
            return this.getTemplates(folder.getSource(), folder, null);
        }

        public List<IDocument> getTemplates(IDocument doc) {
            return this.getTemplates(doc.getSource(), this.getFolder(doc), doc);
        }

        private List<IDocument> getTemplates(IAbstractDocumentSource source, IDocumentFolder folder, IDocument doc) {
            if (source instanceof IDocumentSource) {
                return this.getTemplatesInternal(folder, doc);
            }
            return this.getTemplatesInternal(doc);
        }

        private List<IDocument> getTemplatesInternal(IDocumentFolder folder, IDocument refDoc) {
            ArrayList<IDocument> templates = new ArrayList<IDocument>();
            for (IDocument doc : folder.getDocuments()) {
                if (doc.equals(refDoc) || !doc.isTemplate()) continue;
                templates.add(doc);
            }
            return templates;
        }

        private List<IDocument> getTemplatesInternal(IDocument refDoc) {
            ArrayList<IDocument> templates = new ArrayList<IDocument>();
            for (Object item : this.items) {
                if (!(item instanceof IDocumentFolder)) continue;
                IDocumentFolder folder = (IDocumentFolder)item;
                templates.addAll(this.getTemplatesInternal(folder, refDoc));
            }
            return templates;
        }
    }

    private class DocumentViewContentProvider
    implements ITreeContentProvider {
        private DocumentViewContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof DocumentItemModel) {
                DocumentItemModel itemModel = (DocumentItemModel)inputElement;
                return itemModel.getItems().toArray(new Object[0]);
            }
            return null;
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IDocumentFolder) {
                IDocumentFolder folder = (IDocumentFolder)element;
                return folder.getItems().toArray(new Object[0]);
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IDocumentFolder) {
                IDocumentFolder folder = (IDocumentFolder)element;
                return folder.getItems().size() > 0;
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class DocumentViewTableLabelProvider
    implements ITableLabelProvider {
        private DocumentImageProvider imageProvider = new DocumentImageProvider();

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof IDocumentFolder) {
                        return this.imageProvider.createFolderImage();
                    }
                    if (element instanceof IDocument) {
                        IDocument doc = (IDocument)element;
                        return this.imageProvider.createDocumentImage(doc);
                    }
                    return this.imageProvider.createDefaultImage();
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IDocumentFolder) {
                IDocumentFolder folder = (IDocumentFolder)element;
                switch (columnIndex) {
                    case 0: {
                        return DocUtils.toCamelCase(folder.getName());
                    }
                }
            } else if (element instanceof IDocument) {
                IDocument doc = (IDocument)element;
                switch (columnIndex) {
                    case 0: {
                        return DocUtils.getDocStr(doc);
                    }
                    case 1: {
                        if (doc.isTemplate()) {
                            return Messages.DocumentView_templateLbl;
                        }
                        return DocUtils.toCamelCase(doc.getContentType().toString());
                    }
                    case 2: {
                        String description = doc.getDescription();
                        if (description != null) {
                            return description;
                        }
                        return "";
                    }
                }
            }
            return null;
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class ResourceSelectionProvider
    implements ISelectionProvider {
        protected ListenerList listeners = new ListenerList(1);
        ISelection selection = StructuredSelection.EMPTY;

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove((Object)listener);
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void setSelection(IGeoResource resource) {
            this.selection = resource != null ? new StructuredSelection((Object)DocumentView.this.geoResource) : StructuredSelection.EMPTY;
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
            this.fire();
        }

        private void fire() {
            SelectionChangedEvent event = null;
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                ISelectionChangedListener listener = (ISelectionChangedListener)item;
                if (event == null) {
                    event = new SelectionChangedEvent((ISelectionProvider)this, this.selection);
                }
                listener.selectionChanged(event);
                ++n2;
            }
        }
    }

    private static enum UpdateType {
        CLEAR,
        UPDATE,
        CHECK_UPDATE;

    }
}

