/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.catalog.document.IDocument;
import net.refractions.udig.catalog.document.IDocumentSource;
import net.refractions.udig.catalog.document.IHotlinkSource;
import net.refractions.udig.document.ui.DocUtils;
import net.refractions.udig.tool.info.internal.Messages;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class DocumentDialog
extends IconAndMessageDialog {
    private Composite composite;
    private Label headerImg;
    private Label headerText;
    private Label subHeaderText;
    private Label infoLbl;
    private Text info;
    private ControlDecoration infoDecoration;
    private Composite infoBtnComposite;
    private Button infoOpenBtn;
    private Button infoBrowseBtn;
    private Button infoNewBtn;
    private Label infoGoActionLbl;
    private ComboViewer infoGoAction;
    private Button infoGoActionBtn;
    private Label attributeLbl;
    private Text attribute;
    private Text document;
    private ComboViewer type;
    private Button templateCheckBtn;
    private Label labelLbl;
    private Text label;
    private Text description;
    private Properties templateProps;
    private Map<String, Object> values;
    public static final String V_INFO = "V_INFO";
    public static final String V_CONTENT_TYPE = "V_CONTENT_TYPE";
    public static final String V_LABEL = "V_LABEL";
    public static final String V_DESCRIPTION = "V_DESCRIPTION";
    public static final String V_ATTRIBUTE = "V_ATTRIBUTE";
    public static final String V_TEMPLATE = "V_TEMPLATE";
    public static final String V_ACTIONS = "V_ACTIONS";
    private Map<String, Object> params;
    public static final String P_MODE = "P_MODE";
    public static final String P_TYPE = "P_TYPE";
    public static final String P_CONTENT_TYPES = "P_CONTENT_TYPES";
    public static final String P_FEATURE_NAME = "P_FEATURE_NAME";
    public static final String P_RESOURCE_NAME = "P_RESOURCE_NAME";
    public static final String P_TEMPLATES = "P_TEMPLATES";
    private boolean hasError = false;
    private IDocument.ContentType typeValue;
    private Mode mode;
    private IDocument.Type docType;
    public static final String LABEL_FORMAT = "%s%s:";
    public static final String MANDATORY = "*";
    private static final String LABEL_WIDTH = "20%";
    private static final String CONTROL_WIDTH = "80%";
    private static final String LAYOUT_FORMAT = "[%s, right]8[%s]";
    private static final String WIDTH_LAYOUT_FORMAT = "w %s!";
    private static final String TEMPLATE_PROPS = "templates.properties";

    public DocumentDialog(Shell parentShell, Map<String, Object> values, Map<String, Object> params) {
        super(parentShell);
        this.values = values;
        this.params = params;
    }

    protected boolean isResizable() {
        return true;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public String getInfo() {
        return (String)this.values.get(V_INFO);
    }

    public IDocument.ContentType getType() {
        return (IDocument.ContentType)this.values.get(V_CONTENT_TYPE);
    }

    public String getLabel() {
        return (String)this.values.get(V_LABEL);
    }

    public String getDescription() {
        return (String)this.values.get(V_DESCRIPTION);
    }

    private String getAttribute() {
        return (String)this.values.get(V_ATTRIBUTE);
    }

    public boolean isTemplate() {
        Object isTemplateObj = this.values.get(V_TEMPLATE);
        if (isTemplateObj != null) {
            return (Boolean)isTemplateObj;
        }
        return false;
    }

    private List<IHotlinkSource.HotlinkDescriptor> getActions() {
        return (List)this.values.get(V_ACTIONS);
    }

    private IDocument.Type getParamType() {
        IDocument.Type paramDocType;
        if (this.docType == null && (paramDocType = (IDocument.Type)this.params.get(P_TYPE)) != null) {
            this.docType = paramDocType;
        }
        return this.docType;
    }

    private List<IDocument.ContentType> getParamContentTypes() {
        return (List)this.params.get(P_CONTENT_TYPES);
    }

    private boolean isLinked() {
        return IDocument.Type.LINKED == this.getParamType();
    }

    private boolean isAttachment() {
        return IDocument.Type.ATTACHMENT == this.getParamType();
    }

    private boolean isHotlink() {
        return IDocument.Type.HOTLINK == this.getParamType();
    }

    private Mode getParamMode() {
        Mode paramMode;
        if (this.mode == null && (paramMode = (Mode)((Object)this.params.get(P_MODE))) != null) {
            this.mode = paramMode;
        }
        return this.mode;
    }

    private boolean isAddMode() {
        return Mode.ADD == this.getParamMode();
    }

    private boolean isEditMode() {
        return Mode.EDIT == this.getParamMode();
    }

    private String getParamFeatureName() {
        return (String)this.params.get(P_FEATURE_NAME);
    }

    private String getParamResourceName() {
        return (String)this.params.get(P_RESOURCE_NAME);
    }

    private List<IDocument> getParamTemplates() {
        return (List)this.params.get(P_TEMPLATES);
    }

    protected Image getImage() {
        return this.getInfoImage();
    }

    protected void configureShell(Shell shell) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Point size = new Shell(display).computeSize(-1, -1);
        Rectangle screen = display.getMonitors()[0].getBounds();
        int xPos = (screen.width - size.x) / 2 - 230;
        int yPos = (screen.height - size.y) / 2 - 190;
        shell.setBounds(xPos, yPos, 460, 380);
        super.configureShell(shell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.isAddMode()) {
            Button okBtn = this.getButton(0);
            if (this.isAttachment()) {
                okBtn.setText(Messages.DocumentDialog_btnAttach);
            } else if (this.isLinked()) {
                okBtn.setText(Messages.DocumentDialog_btnLink);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = new Composite(parent, 0);
        String columnCons = String.format(LAYOUT_FORMAT, LABEL_WIDTH, CONTROL_WIDTH);
        this.composite.setLayout((Layout)new MigLayout("insets 0, fillx, wrap 2, hidemode 3", columnCons, "[][]15[][][]"));
        this.composite.setLayoutData((Object)new GridData(1808));
        this.createHeader();
        this.configHeaderDisplay();
        this.createTypeControls();
        this.createInfoControls();
        this.createInfoBtnControls();
        this.createInfoGoActionControls();
        this.attributeLbl = new Label(this.composite, 0);
        this.attributeLbl.setText(this.getLabel(Messages.DocumentDialog_attributeLabel));
        this.attributeLbl.setLayoutData((Object)"");
        this.attribute = new Text(this.composite, 2060);
        this.attribute.setLayoutData((Object)String.format(WIDTH_LAYOUT_FORMAT, CONTROL_WIDTH));
        Label documentLbl = new Label(this.composite, 0);
        documentLbl.setText(this.getLabel(Messages.DocumentDialog_documentLabel));
        documentLbl.setLayoutData((Object)"");
        documentLbl.setVisible(false);
        this.document = new Text(this.composite, 2060);
        this.document.setLayoutData((Object)String.format(WIDTH_LAYOUT_FORMAT, CONTROL_WIDTH));
        this.document.setVisible(false);
        this.templateCheckBtn = new Button(this.composite, 32);
        this.templateCheckBtn.setText(Messages.DocumentDialog_templateLabel);
        this.templateCheckBtn.setLayoutData((Object)"skip 1");
        this.labelLbl = new Label(this.composite, 0);
        this.labelLbl.setText(this.getLabel(Messages.DocumentDialog_labelLabel, !this.isHotlink()));
        this.labelLbl.setLayoutData((Object)"");
        this.label = new Text(this.composite, 2052);
        this.label.setLayoutData((Object)String.format(WIDTH_LAYOUT_FORMAT, CONTROL_WIDTH));
        this.label.addModifyListener((ModifyListener)new BasicModifyListener(null, null));
        Label descriptionLbl = new Label(this.composite, 0);
        descriptionLbl.setText(this.getLabel(Messages.DocumentDialog_descriptionLabel));
        descriptionLbl.setLayoutData((Object)"");
        this.description = new Text(this.composite, 2626);
        this.description.setLayoutData((Object)(String.valueOf(String.format(WIDTH_LAYOUT_FORMAT, CONTROL_WIDTH)) + ", h 60!"));
        return this.composite;
    }

    private void createHeader() {
        Image image = this.getImage();
        if (image != null) {
            this.headerImg = new Label(this.composite, 0);
            image.setBackground(this.headerImg.getBackground());
            this.headerImg.setImage(image);
            this.headerImg.setLayoutData((Object)"sy 2, top");
        }
        this.headerText = new Label(this.composite, 0);
        FontData[] fontData = this.headerText.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(14);
            ++i;
        }
        this.headerText.setFont(new Font(null, fontData));
        this.headerText.setLayoutData((Object)"");
        this.subHeaderText = new Label(this.composite, 64);
        this.subHeaderText.setLayoutData((Object)"wmax 80%");
    }

    private void createInfoControls() {
        this.infoLbl = new Label(this.composite, 0);
        this.infoLbl.setText(this.getLabel(Messages.DocumentDialog_fileLabel));
        this.infoLbl.setLayoutData((Object)"");
        this.info = new Text(this.composite, 2052);
        this.info.setLayoutData((Object)String.format(WIDTH_LAYOUT_FORMAT, CONTROL_WIDTH));
        this.info.addModifyListener((ModifyListener)new ValidatingModifyListener());
        this.infoDecoration = new ControlDecoration((Control)this.info, 16512);
        FieldDecoration errorFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.infoDecoration.setImage(errorFieldIndicator.getImage());
        this.infoDecoration.hide();
    }

    private void createInfoBtnControls() {
        this.infoBtnComposite = new Composite(this.composite, 0);
        this.infoBtnComposite.setLayoutData((Object)"skip, growx");
        this.infoBtnComposite.setLayout((Layout)new MigLayout("insets 0, nogrid, fillx"));
        this.infoOpenBtn = new Button(this.infoBtnComposite, 8);
        this.infoOpenBtn.setText(Messages.DocumentDialog_openBtn);
        this.infoOpenBtn.setLayoutData((Object)"sg btnGrp");
        this.infoOpenBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)DocumentDialog.this.info.getText());
            }
        });
        this.infoBrowseBtn = new Button(this.infoBtnComposite, 8);
        this.infoBrowseBtn.setText(Messages.DocumentDialog_fileBtn);
        this.infoBrowseBtn.setLayoutData((Object)"sg btnGrp, gap push");
        this.infoBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = DocumentDialog.this.openFileDialog();
                if (file != null) {
                    DocumentDialog.this.info.setText(file.getAbsolutePath());
                    DocumentDialog.this.refreshBtns();
                }
            }
        });
        this.infoNewBtn = new Button(this.infoBtnComposite, 8);
        this.infoNewBtn.setText(Messages.DocumentDialog_newBtn);
        this.infoNewBtn.setLayoutData((Object)"sg btnGrp");
        this.infoNewBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocumentDialog.this.createFromTemplate();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties getTemplateProps() {
        if (this.templateProps != null) return this.templateProps;
        InputStream inStream = null;
        try {
            try {
                inStream = ((Object)((Object)this)).getClass().getResourceAsStream(TEMPLATE_PROPS);
                this.templateProps = new Properties();
                this.templateProps.load(inStream);
                return this.templateProps;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (inStream == null) return this.templateProps;
                try {
                    inStream.close();
                    return this.templateProps;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return this.templateProps;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (inStream == null) return this.templateProps;
                try {
                    inStream.close();
                    return this.templateProps;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return this.templateProps;
            }
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private File createFromTemplate() {
        String filePath;
        File templateFile = this.openSelectTemplateDialog();
        if (templateFile != null && (filePath = this.openSaveFileDialog(templateFile)) != null) {
            return this.createFileFromTemplate(templateFile, filePath);
        }
        return null;
    }

    private File openSelectTemplateDialog() {
        IDocument doc;
        Object[] results;
        ListDialog selectDialog = new ListDialog(this.infoNewBtn.getShell());
        selectDialog.setTitle(Messages.DocumentDialog_selectTemplateTitle);
        selectDialog.setMessage(Messages.DocumentDialog_selectTemplateMsg);
        selectDialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IDocument doc = (IDocument)element;
                return DocUtils.getLabelAndDescDisplay(DocUtils.getDocStr(doc), doc.getDescription());
            }
        });
        selectDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        Object[] templates = this.getParamTemplates().toArray();
        selectDialog.setInput((Object)templates);
        selectDialog.setInitialElementSelections(Collections.singletonList(templates[0]));
        if (selectDialog.open() == 0 && (results = selectDialog.getResult()) != null && results.length > 0 && (doc = (IDocument)results[0]) != null) {
            return (File)doc.getContent();
        }
        return null;
    }

    private String openSaveFileDialog(File templateFile) {
        FileDialog dialog = new FileDialog(this.infoNewBtn.getShell(), 8192);
        dialog.setText(Messages.DocumentDialog_enterFilenameTitle);
        dialog.setOverwrite(true);
        dialog.setFileName(DocUtils.getFromTemplateFilename(templateFile, this.getTemplateProps()));
        String filePath = dialog.open();
        if (filePath != null) {
            return filePath;
        }
        return null;
    }

    private File createFileFromTemplate(File templateFile, String filePath) {
        File file = null;
        try {
            file = new File(DocUtils.cleanFromTemplateFilename(filePath, templateFile, this.getTemplateProps()));
            FileUtils.copyFile((File)templateFile, (File)file);
            this.info.setText(file.getAbsolutePath());
            boolean doOpen = MessageDialog.openQuestion((Shell)this.infoNewBtn.getShell(), (String)Messages.DocumentDialog_createFileFromTemplateTitle, (String)Messages.DocumentDialog_createFileFromTemplateSuccess);
            if (doOpen) {
                Program.launch((String)file.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            MessageDialog.openError((Shell)this.infoNewBtn.getShell(), (String)Messages.DocumentDialog_createFileFromTemplateTitle, (String)Messages.DocumentDialog_createFileFromTemplateError);
        }
        return file;
    }

    private void createInfoGoActionControls() {
        this.infoGoActionLbl = new Label(this.composite, 0);
        this.infoGoActionLbl.setText(this.getLabel(Messages.DocumentDialog_actionLabel));
        this.infoGoActionLbl.setLayoutData((Object)"");
        this.infoGoAction = new ComboViewer(this.composite, 12);
        this.infoGoAction.getControl().setLayoutData((Object)"split 2");
        this.infoGoAction.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)element;
                return descriptor.getLabel();
            }
        });
        this.infoGoAction.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.infoGoAction.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)selection.getFirstElement();
                DocumentDialog.this.label.setText(descriptor.getLabel());
                String descriptionStr = descriptor.getDescription();
                if (descriptionStr == null) {
                    DocumentDialog.this.description.setText("");
                } else {
                    DocumentDialog.this.description.setText(descriptionStr);
                }
            }
        });
        List<IHotlinkSource.HotlinkDescriptor> actions = this.getActions();
        if (actions != null && actions.size() > 0) {
            this.infoGoAction.setInput((Object)actions.toArray());
        }
        this.infoGoActionBtn = new Button(this.composite, 8);
        this.infoGoActionBtn.setText(Messages.DocumentDialog_goBtn);
        this.infoGoActionBtn.setLayoutData((Object)"");
        this.infoGoActionBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)DocumentDialog.this.infoGoAction.getSelection();
                IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)selection.getFirstElement();
                String action = descriptor.getConfig().replace("{0}", DocumentDialog.this.info.getText());
                Program.launch((String)action);
            }
        });
    }

    private void createTypeControls() {
        Label typeLbl = new Label(this.composite, 0);
        typeLbl.setText(this.getLabel(Messages.DocumentDialog_typeLabel, true));
        typeLbl.setLayoutData((Object)"");
        this.type = new ComboViewer(this.composite, 12);
        this.type.getControl().setLayoutData((Object)"");
        this.type.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.type.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return DocUtils.toCamelCase(element.toString());
            }
        });
        this.type.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IDocument.ContentType newTypeValue = DocumentDialog.this.getTypeComboValue();
                if (DocumentDialog.this.typeValue != newTypeValue) {
                    DocumentDialog.this.typeValue = newTypeValue;
                    if (newTypeValue != null) {
                        DocumentDialog.this.validateInfo();
                        DocumentDialog.this.refreshBtns();
                        DocumentDialog.this.configInfoControls(newTypeValue);
                    }
                }
            }
        });
        List<IDocument.ContentType> types = this.getParamContentTypes();
        if (types == null) {
            types = new ArrayList<IDocument.ContentType>();
            switch (this.getParamType()) {
                case LINKED: {
                    types.add(IDocument.ContentType.FILE);
                    types.add(IDocument.ContentType.WEB);
                    break;
                }
                case ATTACHMENT: {
                    types.add(IDocument.ContentType.FILE);
                    break;
                }
                case HOTLINK: {
                    types.add(IDocument.ContentType.FILE);
                    types.add(IDocument.ContentType.WEB);
                    types.add(IDocument.ContentType.ACTION);
                    break;
                }
            }
        }
        this.type.setInput((Object)types.toArray());
    }

    private void beforeCreateContents() {
    }

    protected Control createContents(Composite parent) {
        this.beforeCreateContents();
        Control control = super.createContents(parent);
        this.afterCreateContents();
        return control;
    }

    private void afterCreateContents() {
        this.setValues();
        this.configControlEnablements();
        this.refreshBtns();
    }

    private void setValues() {
        if (this.isAddMode()) {
            Object[] types = (Object[])this.type.getInput();
            if (types != null && types.length > 0) {
                this.type.setSelection((ISelection)new StructuredSelection(types[0]));
            }
        } else {
            this.type.setSelection((ISelection)new StructuredSelection((Object)this.getType()));
            this.setValue(this.info, this.getInfo());
            this.setValue(this.label, this.getLabel());
            this.setValue(this.description, this.getDescription());
            this.setValue(this.attribute, this.getAttribute());
            this.templateCheckBtn.setSelection(this.isTemplate());
            List<IHotlinkSource.HotlinkDescriptor> actions = this.getActions();
            if (actions != null && actions.size() > 0) {
                this.infoGoAction.setSelection((ISelection)new StructuredSelection((Object)actions.get(0)));
            }
        }
    }

    private void setValue(Text text, String value) {
        if (value != null) {
            text.setText(value);
        }
    }

    private void configHeaderDisplay() {
        if (this.isHotlink()) {
            this.setHeaderDisplayHotlink();
        } else {
            this.setHeaderDisplayLinkedOrAttachment();
        }
    }

    private void setHeaderDisplayHotlink() {
        String header = String.format(Messages.DocumentDialog_hotlinkHeader, DocUtils.toCamelCase(this.getAttribute()));
        this.getShell().setText(header);
        this.headerText.setText(header);
        this.subHeaderText.setText(this.getDescription());
        this.subHeaderText.setToolTipText(this.getDescription());
    }

    private void setHeaderDisplayLinkedOrAttachment() {
        String header = "";
        String subHeader = "";
        String featureName = this.getParamFeatureName();
        String shapefileName = this.getParamResourceName();
        if (this.isAddMode()) {
            header = Messages.DocumentDialog_addAttachHeader;
            if (this.isLinked()) {
                header = Messages.DocumentDialog_addLinkHeader;
            }
        } else {
            header = Messages.DocumentDialog_editAttachHeader;
            if (this.isLinked()) {
                header = Messages.DocumentDialog_editLinkHeader;
            }
        }
        if (shapefileName != null) {
            shapefileName = DocUtils.toCamelCase(shapefileName);
            if (featureName != null) {
                featureName = DocUtils.toCamelCase(featureName);
                String subHeaderFormat = Messages.DocumentDialog_attachSubHeaderFeature;
                if (this.isLinked()) {
                    subHeaderFormat = Messages.DocumentDialog_linkSubHeaderFeature;
                }
                subHeader = String.format(subHeaderFormat, featureName, shapefileName);
            } else {
                String subHeaderFormat = Messages.DocumentDialog_attachSubHeaderShapefile;
                if (this.isLinked()) {
                    subHeaderFormat = Messages.DocumentDialog_linkSubHeaderShapefile;
                }
                subHeader = String.format(subHeaderFormat, shapefileName);
            }
        } else {
            subHeader = Messages.DocumentDialog_attachSubHeader;
            if (this.isLinked()) {
                subHeader = Messages.DocumentDialog_linkSubHeader;
            }
        }
        this.getShell().setText(header);
        this.headerText.setText(header);
        this.subHeaderText.setText(subHeader);
        this.subHeaderText.setToolTipText(subHeader);
    }

    private void configControlEnablements() {
        if (this.isHotlink()) {
            this.configAttributeControls(true);
            this.configMetadataControls(false);
            this.templateCheckBtn.setVisible(false);
            this.type.getControl().setEnabled(false);
        } else {
            this.configAttributeControls(false);
            this.configMetadataControls(true);
            this.templateCheckBtn.setVisible(this.isAttachment());
            boolean isTypeEnabled = false;
            if (this.isLinked() && this.isAddMode()) {
                Object[] types = (Object[])this.type.getInput();
                isTypeEnabled = types != null && types.length > 1;
            }
            this.type.getControl().setEnabled(isTypeEnabled);
        }
    }

    protected void okPressed() {
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
        }
        this.values.put(V_LABEL, this.label.getText());
        this.values.put(V_DESCRIPTION, this.description.getText());
        this.values.put(V_CONTENT_TYPE, this.getTypeComboValue());
        this.values.put(V_INFO, this.info.getText());
        this.values.put(V_TEMPLATE, this.templateCheckBtn.getSelection());
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private void configInfoControls(IDocument.ContentType type) {
        switch (type) {
            case FILE: {
                this.infoLbl.setText(this.isHotlink() ? this.getLabel(Messages.DocumentDialog_valueLabel) : this.getLabel(Messages.DocumentDialog_fileLabel, true));
                this.configInfoBtnControls(true, true);
                this.configInfoGoActionControls(false);
                this.templateCheckBtn.setVisible(this.isAttachment());
                break;
            }
            case WEB: {
                this.infoLbl.setText(this.isHotlink() ? this.getLabel(Messages.DocumentDialog_valueLabel) : this.getLabel(Messages.DocumentDialog_urlLabel, true));
                this.configInfoBtnControls(true, false);
                this.configInfoGoActionControls(false);
                this.templateCheckBtn.setVisible(false);
                break;
            }
            case ACTION: {
                this.infoLbl.setText(this.isHotlink() ? this.getLabel(Messages.DocumentDialog_valueLabel) : this.getLabel(Messages.DocumentDialog_actionLabel, true));
                this.configInfoBtnControls(false, false);
                this.configInfoGoActionControls(true);
                this.templateCheckBtn.setVisible(false);
                break;
            }
        }
        this.composite.layout();
    }

    private void configInfoBtnControls(boolean isVisible, boolean isFile) {
        this.infoBtnComposite.setVisible(isVisible);
        if (isVisible) {
            this.infoBrowseBtn.setVisible(isFile);
            this.infoNewBtn.setVisible(isFile);
            List<IDocument> templates = this.getParamTemplates();
            boolean hasTemplates = templates != null && templates.size() > 0;
            this.infoNewBtn.setEnabled(hasTemplates);
        }
    }

    private void configInfoGoActionControls(boolean isVisible) {
        this.infoGoActionLbl.setVisible(isVisible);
        this.infoGoAction.getControl().setVisible(isVisible);
        this.infoGoActionBtn.setVisible(isVisible);
    }

    private void configAttributeControls(boolean isVisible) {
        this.attributeLbl.setVisible(isVisible);
        this.attribute.setVisible(isVisible);
    }

    private void configMetadataControls(boolean isEnabled) {
        this.label.setEditable(isEnabled);
        this.description.setEditable(isEnabled);
    }

    private File openFileDialog() {
        List<File> fileList = this.openFileDialog(false);
        if (fileList != null && fileList.size() > 0) {
            return fileList.get(0);
        }
        return null;
    }

    private List<File> openFileDialog(boolean isMultiSelect) {
        String[] filenames;
        int style = isMultiSelect ? 4098 : 4096;
        FileDialog fileDialog = new FileDialog(this.infoBrowseBtn.getShell(), style);
        fileDialog.setText(Messages.docView_openDialogTitle);
        String hasSelection = fileDialog.open();
        if (hasSelection != null && (filenames = fileDialog.getFileNames()) != null && filenames.length > 0) {
            ArrayList<File> fileList = new ArrayList<File>();
            String filePath = fileDialog.getFilterPath();
            int i = 0;
            int n = filenames.length;
            while (i < n) {
                String filename = filePath;
                if (filePath.charAt(filePath.length() - 1) != File.separatorChar) {
                    filename = String.valueOf(filename) + File.separatorChar;
                }
                filename = String.valueOf(filename) + filenames[i];
                fileList.add(new File(filename));
                ++i;
            }
            return fileList;
        }
        return null;
    }

    private void refreshBtns() {
        if (this.hasError) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(!this.isEmpty());
        }
    }

    private boolean isEmpty() {
        if ((this.isLinked() || this.isAttachment()) && this.isEmpty(this.label)) {
            return true;
        }
        if (this.isEmpty(this.type)) {
            return true;
        }
        return this.isEmpty(this.info);
    }

    private boolean isEmpty(Object control) {
        ComboViewer comboCtrl;
        Text textCtrl;
        String textCtrlValue;
        return control instanceof Text ? (textCtrlValue = (textCtrl = (Text)control).getText().trim()) == null || textCtrlValue.length() == 0 : control instanceof ComboViewer && this.getComboValue(comboCtrl = (ComboViewer)control) == null;
    }

    private Object getComboValue(ComboViewer combo) {
        ISelection selection = combo.getSelection();
        if (!selection.isEmpty() && selection instanceof StructuredSelection) {
            StructuredSelection structSelection = (StructuredSelection)selection;
            return structSelection.getFirstElement();
        }
        return null;
    }

    private IDocument.ContentType getTypeComboValue() {
        return (IDocument.ContentType)this.getComboValue(this.type);
    }

    private void validateInfo() {
        this.infoOpenBtn.setEnabled(false);
        this.infoDecoration.hide();
        String infoValue = this.info.getText().trim();
        if (infoValue != null && infoValue.length() > 0) {
            switch (this.getTypeComboValue()) {
                case FILE: {
                    File file = new File(infoValue);
                    if (file.exists() && file.isFile()) {
                        this.infoOpenBtn.setEnabled(true);
                        break;
                    }
                    this.infoDecoration.setDescriptionText(Messages.DocumentDialog_errValidFile);
                    this.infoDecoration.show();
                    this.hasError = true;
                    return;
                }
                case WEB: {
                    try {
                        new URL(infoValue);
                        this.infoOpenBtn.setEnabled(true);
                        break;
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.infoDecoration.setDescriptionText(Messages.DocumentDialog_errValidURL);
                        this.infoDecoration.show();
                        this.hasError = true;
                        return;
                    }
                }
                case ACTION: {
                    break;
                }
            }
        }
        this.hasError = false;
    }

    private void setDocumentValue() {
        if (!this.hasError) {
            String infoValue = this.info.getText().trim();
            if (infoValue != null && infoValue.length() > 0) {
                String labelValue = this.label.getText().trim();
                if ((labelValue == null || labelValue.length() == 0) && this.isHotlink()) {
                    labelValue = this.attribute.getText();
                }
                this.document.setText(DocUtils.getDocStr(this.getTypeComboValue(), infoValue, labelValue));
            } else {
                this.document.setText("");
            }
        }
    }

    private String getLabel(String label) {
        return this.getLabel(label, false);
    }

    private String getLabel(String label, boolean isMandatory) {
        return String.format(LABEL_FORMAT, label, isMandatory ? MANDATORY : "");
    }

    public IDocumentSource.DocumentInfo getDocInfo() {
        return new IDocumentSource.DocumentInfo(this.getLabel(), this.getDescription(), this.getInfo(), this.getType(), this.isTemplate(), this.getParamType());
    }

    public File getFileInfo() {
        File file = new File(this.getInfo());
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public URL getUrlInfo() {
        try {
            URL url = new URL(this.getInfo());
            return url;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private class BasicModifyListener
    implements ModifyListener {
        private BasicModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            DocumentDialog.this.setDocumentValue();
            DocumentDialog.this.refreshBtns();
        }

        /* synthetic */ BasicModifyListener(BasicModifyListener basicModifyListener, BasicModifyListener basicModifyListener2) {
            this();
        }
    }

    public static enum Mode {
        ADD,
        EDIT;

    }

    private class ValidatingModifyListener
    extends BasicModifyListener {
        private ValidatingModifyListener() {
        }

        @Override
        public void modifyText(ModifyEvent e) {
            DocumentDialog.this.validateInfo();
            super.modifyText(e);
        }
    }
}

