/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.source;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.document.IDocument;
import net.refractions.udig.catalog.document.IDocumentSource;
import net.refractions.udig.catalog.internal.shp.ShpGeoResourceImpl;
import net.refractions.udig.document.model.AbstractLinkedDocument;
import net.refractions.udig.document.source.AbstractShpDocumentSource;
import net.refractions.udig.document.source.ShpDocUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class ShpDocumentSource
extends AbstractShpDocumentSource
implements IDocumentSource {
    public ShpDocumentSource(ShpGeoResourceImpl resource) {
        super(resource);
    }

    public boolean isEnabled() {
        return this.propParser.getShapefileFlag();
    }

    public boolean isEnabledEditable() {
        return true;
    }

    public boolean canAttach() {
        return true;
    }

    public boolean canLinkFile() {
        return false;
    }

    public boolean canLinkWeb() {
        return true;
    }

    public boolean canUpdate() {
        return true;
    }

    public boolean canRemove() {
        return true;
    }

    public List<IDocument> getDocuments(IProgressMonitor monitor) {
        this.docs = new ArrayList();
        List<IDocumentSource.DocumentInfo> infos = this.propParser.getShapeDocumentInfos();
        if (infos != null && infos.size() > 0) {
            this.docs.addAll(this.docFactory.create(infos));
        }
        return this.docs;
    }

    private List<IDocument> getDocsInternal(IProgressMonitor monitor) {
        if (this.docs == null) {
            return this.getDocuments(monitor);
        }
        return this.docs;
    }

    public IDocument add(IDocumentSource.DocumentInfo info, IProgressMonitor monitor) {
        IDocument doc = this.addInternal(info, monitor);
        this.save(monitor);
        return doc;
    }

    public List<IDocument> add(List<IDocumentSource.DocumentInfo> infos, IProgressMonitor monitor) {
        ArrayList<IDocument> newDocs = new ArrayList<IDocument>();
        for (IDocumentSource.DocumentInfo info : infos) {
            this.addInternal(info, monitor);
        }
        this.save(monitor);
        return newDocs;
    }

    private IDocument addInternal(IDocumentSource.DocumentInfo info, IProgressMonitor monitor) {
        if (IDocument.Type.ATTACHMENT == info.getType()) {
            File newFile = ShpDocUtils.copyFile(info.getInfo(), this.propParser.getShapefileAttachDir());
            info.setInfo(newFile.getAbsolutePath());
        } else {
            info.getType();
        }
        IDocument newDoc = this.docFactory.create(info);
        this.getDocsInternal(monitor).add(newDoc);
        return newDoc;
    }

    public boolean remove(IDocument oldDoc, IProgressMonitor monitor) {
        this.removeInternal(oldDoc, monitor);
        this.save(monitor);
        return true;
    }

    public boolean remove(List<IDocument> oldDocs, IProgressMonitor monitor) {
        for (IDocument doc : oldDocs) {
            this.removeInternal(doc, monitor);
        }
        this.save(monitor);
        return true;
    }

    private boolean removeInternal(IDocument doc, IProgressMonitor monitor) {
        if (IDocument.Type.ATTACHMENT == doc.getType()) {
            ShpDocUtils.deleteFile(doc.getContent());
        } else {
            doc.getType();
        }
        this.getDocsInternal(monitor).remove(doc);
        return true;
    }

    public boolean update(IDocument doc, IDocumentSource.DocumentInfo info, IProgressMonitor monitor) {
        if (IDocument.Type.ATTACHMENT == info.getType()) {
            File oldFile = (File)doc.getContent();
            if (oldFile == null) {
                this.updateInternal(oldFile, info);
            } else if (!oldFile.getAbsolutePath().equals(info.getInfo())) {
                this.updateInternal(oldFile, info);
            }
        } else {
            info.getType();
        }
        ((AbstractLinkedDocument)doc).setInfo(info);
        this.save(monitor);
        return true;
    }

    private void updateInternal(File oldFile, IDocumentSource.DocumentInfo info) {
        ShpDocUtils.deleteFile(oldFile);
        File newFile = ShpDocUtils.copyFile(info.getInfo(), this.propParser.getShapefileAttachDir());
        info.setInfo(newFile.getAbsolutePath());
    }

    private void save(IProgressMonitor monitor) {
        ArrayList<IDocumentSource.DocumentInfo> infos = new ArrayList<IDocumentSource.DocumentInfo>();
        for (IDocument doc : this.getDocsInternal(monitor)) {
            AbstractLinkedDocument shpDoc = (AbstractLinkedDocument)doc;
            infos.add(shpDoc.getInfo());
        }
        this.propParser.setShapeDocmentInfos(infos);
        this.propParser.writeProperties();
    }
}

