/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.document.IDocument;
import net.refractions.udig.catalog.document.IDocumentSource;
import net.refractions.udig.catalog.document.IHotlinkSource;
import net.refractions.udig.document.source.ShpDocUtils;
import net.refractions.udig.document.ui.DocUtils;
import org.opengis.feature.simple.SimpleFeature;

public class ShpDocPropertyParser {
    private static final String DELIMITER = "|:|";
    private static final String DELIMITER_REGEX = "\\|:\\|";
    public static final String SHAPE_DOCUMENTS_FLAG = "shp_documents_enabled";
    public static final String FEATURE_DOCUMENTS_FLAG = "feature_documents_enabled";
    public static final String FEATURE_HOTLINKS_FLAG = "feature_hotlinks_enabled";
    public static final String SHAPE_ATTACHMENTS = "shp_documents";
    public static final String HOTLINK_ATTRIBUTES = "hotlink_attributes";
    public static final String ATTRIBUTE_ATTACHMENTS = "%s_documents";
    public static final String SHAPE_DOCS_FOLDER = "%s.documents";
    private static final String PROP_FILE_EXT = "properties";
    private URL url;
    private Properties properties;
    private long propsFileLastUpdate;

    public ShpDocPropertyParser(URL url) {
        this.url = url;
    }

    public boolean hasProperties() {
        return this.getProperties() != null;
    }

    private Properties getProperties() {
        File propertiesFile = this.getPropertiesFile();
        if (propertiesFile != null) {
            if (this.properties == null) {
                this.readProperties(propertiesFile);
            } else if (this.isPropertiesUpdated(propertiesFile)) {
                this.readProperties(propertiesFile);
            }
        }
        return this.properties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readProperties(File propertiesFile) {
        FileInputStream inStream = null;
        try {
            try {
                inStream = new FileInputStream(propertiesFile);
                this.properties = new Properties();
                this.properties.load(inStream);
                this.propsFileLastUpdate = propertiesFile.lastModified();
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (inStream == null) return;
                try {
                    inStream.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (inStream == null) return;
                try {
                    inStream.close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isPropertiesUpdated(File currentPropertiesFile) {
        return this.propsFileLastUpdate != currentPropertiesFile.lastModified();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeProperties() {
        File propertiesFile = this.getPropertiesFile();
        if (propertiesFile == null) return;
        FileOutputStream outStream = null;
        try {
            try {
                outStream = new FileOutputStream(propertiesFile);
                this.properties.store(outStream, "");
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (outStream == null) return;
                try {
                    outStream.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (outStream == null) return;
                try {
                    outStream.close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private File getPropertiesFile() {
        return ShpDocPropertyParser.getPropertiesFile(this.url);
    }

    public File createPropertiesFile() {
        File file = this.getPropertiesFile();
        if (file == null) {
            ID fileId = new ID(this.url);
            file = fileId.toFile(PROP_FILE_EXT);
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static File getPropertiesFile(ID id) {
        File file = id.toFile(PROP_FILE_EXT.toLowerCase());
        if (file.exists()) {
            return file;
        }
        file = id.toFile(PROP_FILE_EXT.toUpperCase());
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static File getPropertiesFile(URL url) {
        return ShpDocPropertyParser.getPropertiesFile(new ID(url));
    }

    private String getProperty(String property) {
        Properties properties = this.getProperties();
        if (properties != null) {
            return properties.getProperty(property);
        }
        return null;
    }

    private void setProperty(String property, String value) {
        this.getProperties().setProperty(property, value);
    }

    private List<IDocumentSource.DocumentInfo> toDocInfoList(String spec) {
        if (spec != null && !spec.isEmpty()) {
            String[] docInfoArray;
            ArrayList<IDocumentSource.DocumentInfo> docInfos = new ArrayList<IDocumentSource.DocumentInfo>();
            String[] stringArray = docInfoArray = spec.split(DELIMITER_REGEX);
            int n = docInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                String docInfo = stringArray[n2];
                IDocumentSource.DocumentInfo info = new IDocumentSource.DocumentInfo(docInfo);
                if (IDocument.ContentType.FILE == info.getContentType()) {
                    info.setInfo(ShpDocUtils.getAbsolutePath(this.url, info.getInfo()));
                }
                docInfos.add(info);
                ++n2;
            }
            return docInfos;
        }
        return null;
    }

    private String toDocInfoString(List<IDocumentSource.DocumentInfo> docInfos) {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (IDocumentSource.DocumentInfo info : docInfos) {
            ++count;
            if (IDocument.ContentType.FILE == info.getContentType()) {
                IDocumentSource.DocumentInfo writeInfo = new IDocumentSource.DocumentInfo(info.toString());
                writeInfo.setInfo(ShpDocUtils.getRelativePath(this.url, writeInfo.getInfo()));
                sb.append(writeInfo.toString());
            } else {
                sb.append(info.toString());
            }
            if (count >= docInfos.size()) continue;
            sb.append(DELIMITER);
        }
        return sb.toString();
    }

    private List<IHotlinkSource.HotlinkDescriptor> toHotlinkDescriptorList(String spec) {
        if (spec != null && !spec.isEmpty()) {
            String[] desriptorArray;
            ArrayList<IHotlinkSource.HotlinkDescriptor> descriptors = new ArrayList<IHotlinkSource.HotlinkDescriptor>();
            String[] stringArray = desriptorArray = spec.split(DELIMITER_REGEX);
            int n = desriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                String descriptor = stringArray[n2];
                descriptors.add(new IHotlinkSource.HotlinkDescriptor(descriptor));
                ++n2;
            }
            return descriptors;
        }
        return null;
    }

    private String toHotlinkDescriptorString(List<IHotlinkSource.HotlinkDescriptor> descriptors) {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (IHotlinkSource.HotlinkDescriptor descriptor : descriptors) {
            sb.append(descriptor.toString());
            if (++count >= descriptors.size()) continue;
            sb.append(DELIMITER);
        }
        return sb.toString();
    }

    public List<IDocumentSource.DocumentInfo> getShapeDocumentInfos() {
        return this.toDocInfoList(this.getProperty(SHAPE_ATTACHMENTS));
    }

    public void setShapeDocmentInfos(List<IDocumentSource.DocumentInfo> docInfos) {
        this.setProperty(SHAPE_ATTACHMENTS, this.toDocInfoString(docInfos));
    }

    public List<IHotlinkSource.HotlinkDescriptor> getHotlinkDescriptors() {
        return this.toHotlinkDescriptorList(this.getProperty(HOTLINK_ATTRIBUTES));
    }

    public void setHotlinkDescriptors(List<IHotlinkSource.HotlinkDescriptor> descriptors) {
        this.setProperty(HOTLINK_ATTRIBUTES, this.toHotlinkDescriptorString(descriptors));
    }

    public List<IDocumentSource.DocumentInfo> getFeatureDocumentInfos(SimpleFeature feature) {
        String property = String.format(ATTRIBUTE_ATTACHMENTS, feature.getIdentifier().getID());
        return this.toDocInfoList(this.getProperty(property));
    }

    public void setFeatureDocumentInfos(SimpleFeature feature, List<IDocumentSource.DocumentInfo> docInfos) {
        String property = String.format(ATTRIBUTE_ATTACHMENTS, feature.getIdentifier().getID());
        this.setProperty(property, this.toDocInfoString(docInfos));
    }

    public File getShapefileAttachDir() {
        try {
            File shapeFile = new File(this.url.toURI());
            String folderName = String.format(SHAPE_DOCS_FOLDER, DocUtils.getName(shapeFile));
            File attachDir = new File(shapeFile.getParent(), folderName);
            return attachDir;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public File getFeatureAttachDir(String fid) {
        File attachDir = new File(this.getShapefileAttachDir(), fid);
        return attachDir;
    }

    public void setShapefileFlag(boolean isEnabled) {
        this.setFlag(SHAPE_DOCUMENTS_FLAG, isEnabled);
    }

    public boolean getShapefileFlag() {
        return this.getFlag(SHAPE_DOCUMENTS_FLAG);
    }

    public void setFeatureDocsFlag(boolean isEnabled) {
        this.setFlag(FEATURE_DOCUMENTS_FLAG, isEnabled);
    }

    public boolean getFeatureDocsFlag() {
        return this.getFlag(FEATURE_DOCUMENTS_FLAG);
    }

    public void setFeatureHotlinksFlag(boolean isEnabled) {
        this.setFlag(FEATURE_HOTLINKS_FLAG, isEnabled);
    }

    public boolean getFeatureHotlinksFlag() {
        return this.getFlag(FEATURE_HOTLINKS_FLAG);
    }

    private void setFlag(String property, boolean isEnabled) {
        this.setProperty(property, Boolean.toString(isEnabled));
    }

    private boolean getFlag(String property) {
        String flagValue = this.getProperty(property);
        if (flagValue != null) {
            return Boolean.parseBoolean(flagValue);
        }
        return false;
    }
}

