/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.source;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.document.IAbstractDocumentSource;
import net.refractions.udig.catalog.document.IDocument;
import net.refractions.udig.catalog.document.IDocumentSource;
import net.refractions.udig.catalog.document.IHotlinkSource;
import net.refractions.udig.document.model.AbstractHotlinkDocument;
import net.refractions.udig.document.model.AbstractLinkedDocument;
import net.refractions.udig.document.model.ActionHotlinkDocument;
import net.refractions.udig.document.model.DocumentFolder;
import net.refractions.udig.document.model.FileAttachmentDocument;
import net.refractions.udig.document.model.FileHotlinkDocument;
import net.refractions.udig.document.model.FileLinkedDocument;
import net.refractions.udig.document.model.WebHotlinkDocument;
import net.refractions.udig.document.model.WebLinkedDocument;
import org.opengis.feature.simple.SimpleFeature;

public class ShpDocFactory {
    private IAbstractDocumentSource source;

    public ShpDocFactory(IAbstractDocumentSource source) {
        this.source = source;
    }

    public IDocument create(IDocumentSource.DocumentInfo info) {
        AbstractLinkedDocument doc = null;
        if (IDocument.Type.ATTACHMENT == info.getType()) {
            if (IDocument.ContentType.FILE == info.getContentType()) {
                doc = new FileAttachmentDocument(info);
            }
        } else if (IDocument.Type.LINKED == info.getType()) {
            if (IDocument.ContentType.FILE == info.getContentType()) {
                doc = new FileLinkedDocument(info);
            } else if (IDocument.ContentType.WEB == info.getContentType()) {
                doc = new WebLinkedDocument(info);
            }
        }
        if (doc != null) {
            doc.setSource(this.source);
        }
        return doc;
    }

    public List<IDocument> create(List<IDocumentSource.DocumentInfo> infos) {
        ArrayList<IDocument> docs = new ArrayList<IDocument>();
        for (IDocumentSource.DocumentInfo info : infos) {
            docs.add(this.create(info));
        }
        return docs;
    }

    public IDocument create(String info, List<IHotlinkSource.HotlinkDescriptor> descriptors) {
        AbstractHotlinkDocument doc = null;
        switch (descriptors.get(0).getType()) {
            case FILE: {
                doc = new FileHotlinkDocument(info, descriptors);
                break;
            }
            case WEB: {
                doc = new WebHotlinkDocument(info, descriptors);
                break;
            }
            case ACTION: {
                doc = new ActionHotlinkDocument(info, descriptors);
                break;
            }
        }
        if (doc != null) {
            doc.setSource(this.source);
        }
        return doc;
    }

    public static DocumentFolder createFolder(SimpleFeature feature, String name, IAbstractDocumentSource source) {
        DocumentFolder folder = new DocumentFolder(name, source);
        folder.setFeature(feature);
        return folder;
    }
}

