/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.source;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.document.IAttachmentSource;
import net.refractions.udig.catalog.document.IDocument;
import net.refractions.udig.catalog.document.IDocumentSource;
import net.refractions.udig.catalog.internal.shp.ShpGeoResourceImpl;
import net.refractions.udig.document.model.AbstractLinkedDocument;
import net.refractions.udig.document.source.AbstractShpDocumentSource;
import net.refractions.udig.document.source.ShpDocUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.opengis.feature.simple.SimpleFeature;

public class ShpAttachmentSource
extends AbstractShpDocumentSource
implements IAttachmentSource {
    public ShpAttachmentSource(ShpGeoResourceImpl geoResource) {
        super(geoResource);
    }

    public boolean isEnabled() {
        return this.propParser.getFeatureDocsFlag();
    }

    public boolean isEnabledEditable() {
        return true;
    }

    public boolean canAttach() {
        return true;
    }

    public boolean canLinkFile() {
        return false;
    }

    public boolean canLinkWeb() {
        return true;
    }

    public boolean canUpdate() {
        return true;
    }

    public boolean canRemove() {
        return true;
    }

    public List<IDocument> getDocuments(SimpleFeature feature, IProgressMonitor monitor) {
        this.docs = new ArrayList();
        List<IDocumentSource.DocumentInfo> infos = this.propParser.getFeatureDocumentInfos(feature);
        if (infos != null && infos.size() > 0) {
            List<IDocument> newDocs = this.docFactory.create(infos);
            this.setFeature(newDocs, feature);
            this.docs.addAll(newDocs);
        }
        return this.docs;
    }

    private List<IDocument> getDocsInternal(SimpleFeature feature, IProgressMonitor monitor) {
        if (this.docs == null) {
            return this.getDocuments(feature, monitor);
        }
        return this.docs;
    }

    public IDocument add(SimpleFeature feature, IDocumentSource.DocumentInfo info, IProgressMonitor monitor) {
        IDocument doc = this.addInternal(feature, info, monitor);
        this.save(feature, monitor);
        return doc;
    }

    public List<IDocument> add(SimpleFeature feature, List<IDocumentSource.DocumentInfo> infos, IProgressMonitor monitor) {
        ArrayList<IDocument> newDocs = new ArrayList<IDocument>();
        for (IDocumentSource.DocumentInfo info : infos) {
            this.addInternal(feature, info, monitor);
        }
        this.save(feature, monitor);
        return newDocs;
    }

    private IDocument addInternal(SimpleFeature feature, IDocumentSource.DocumentInfo info, IProgressMonitor monitor) {
        if (IDocument.Type.ATTACHMENT == info.getType()) {
            File newFile = ShpDocUtils.copyFile(info.getInfo(), this.getAttachmentDir(feature));
            info.setInfo(newFile.getAbsolutePath());
        } else {
            info.getType();
        }
        IDocument newDoc = this.docFactory.create(info);
        this.setFeature(newDoc, feature);
        this.getDocsInternal(feature, monitor).add(newDoc);
        return newDoc;
    }

    public boolean update(SimpleFeature feature, IDocument doc, IDocumentSource.DocumentInfo info, IProgressMonitor monitor) {
        if (IDocument.Type.ATTACHMENT == info.getType()) {
            File oldFile = (File)doc.getContent();
            if (oldFile == null) {
                this.updateInternal(feature, oldFile, info);
            } else if (!oldFile.getAbsolutePath().equals(info.getInfo())) {
                this.updateInternal(feature, oldFile, info);
            }
        } else {
            info.getType();
        }
        ((AbstractLinkedDocument)doc).setInfo(info);
        this.save(feature, monitor);
        return true;
    }

    private void updateInternal(SimpleFeature feature, File oldFile, IDocumentSource.DocumentInfo info) {
        ShpDocUtils.deleteFile(oldFile);
        File newFile = ShpDocUtils.copyFile(info.getInfo(), this.getAttachmentDir(feature));
        info.setInfo(newFile.getAbsolutePath());
    }

    public boolean remove(SimpleFeature feature, IDocument oldDoc, IProgressMonitor monitor) {
        this.removeInternal(feature, oldDoc, monitor);
        this.save(feature, monitor);
        return true;
    }

    public boolean remove(SimpleFeature feature, List<IDocument> oldDocs, IProgressMonitor monitor) {
        for (IDocument oldDoc : oldDocs) {
            this.removeInternal(feature, oldDoc, monitor);
        }
        this.save(feature, monitor);
        return true;
    }

    private boolean removeInternal(SimpleFeature feature, IDocument oldDoc, IProgressMonitor monitor) {
        if (IDocument.Type.ATTACHMENT == oldDoc.getType()) {
            ShpDocUtils.deleteFile(oldDoc.getContent());
        } else {
            oldDoc.getType();
        }
        this.getDocsInternal(feature, monitor).remove(oldDoc);
        return true;
    }

    private void save(SimpleFeature feature, IProgressMonitor monitor) {
        ArrayList<IDocumentSource.DocumentInfo> infos = new ArrayList<IDocumentSource.DocumentInfo>();
        for (IDocument doc : this.getDocsInternal(feature, monitor)) {
            if (IDocument.Type.HOTLINK == doc.getType()) continue;
            AbstractLinkedDocument shpDoc = (AbstractLinkedDocument)doc;
            infos.add(shpDoc.getInfo());
        }
        this.propParser.setFeatureDocumentInfos(feature, infos);
        this.propParser.writeProperties();
    }

    private File getAttachmentDir(SimpleFeature feature) {
        return this.propParser.getFeatureAttachDir(feature.getIdentifier().getID());
    }
}

