/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.source;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.document.IDocument;
import net.refractions.udig.catalog.document.IHotlink;
import net.refractions.udig.catalog.document.IHotlinkSource;
import net.refractions.udig.document.model.AbstractDocumentItem;
import net.refractions.udig.document.model.AbstractHotlinkDocument;
import net.refractions.udig.document.model.ActionHotlinkDocument;
import net.refractions.udig.document.model.FileHotlinkDocument;
import net.refractions.udig.document.model.WebHotlinkDocument;
import net.refractions.udig.document.source.AbstractDocumentSource;
import net.refractions.udig.document.source.BasicHotlinkDescriptorParser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.opengis.feature.simple.SimpleFeature;

public class BasicHotlinkSource
extends AbstractDocumentSource
implements IHotlinkSource {
    private BasicHotlinkDescriptorParser parser;
    private List<IHotlinkSource.HotlinkDescriptor> descriptors;
    private Map<String, List<IHotlinkSource.HotlinkDescriptor>> attributeDescriptorMap;

    public BasicHotlinkSource(IGeoResource resource) {
        super(resource);
        this.resource = resource;
        this.parser = new BasicHotlinkDescriptorParser(resource);
    }

    public boolean isEnabled() {
        return this.parser.isEnabled();
    }

    public boolean isEnabledEditable() {
        return true;
    }

    public boolean canSetHotlink() {
        return true;
    }

    public boolean canClearHotlink() {
        return true;
    }

    public List<IHotlinkSource.HotlinkDescriptor> getHotlinkDescriptors(SimpleFeature feature, IProgressMonitor monitor) {
        this.descriptors = this.parser.getDescriptors();
        this.attributeDescriptorMap = this.getDescriptorMap(this.descriptors);
        return this.descriptors;
    }

    public List<IDocument> getDocuments(SimpleFeature feature, IProgressMonitor monitor) {
        this.docs = new ArrayList();
        List<IHotlinkSource.HotlinkDescriptor> featureDescriptors = this.getHotlinkDescriptors(feature, monitor);
        if (featureDescriptors != null && featureDescriptors.size() > 0) {
            for (String attributeName : this.attributeDescriptorMap.keySet()) {
                List<IHotlinkSource.HotlinkDescriptor> attributeDescriptors = this.attributeDescriptorMap.get(attributeName);
                String info = (String)feature.getAttribute(attributeName);
                String decodedInfo = this.decodeInfo(attributeDescriptors.get(0).getType(), info);
                IDocument doc = this.create(decodedInfo, attributeDescriptors);
                this.setFeature(doc, feature);
                this.docs.add(doc);
            }
        }
        return this.docs;
    }

    private List<IDocument> getDocsInternal(SimpleFeature feature, IProgressMonitor monitor) {
        if (this.docs == null) {
            return this.getDocuments(feature, monitor);
        }
        return this.docs;
    }

    public IDocument getDocument(SimpleFeature feature, String attributeName, IProgressMonitor monitor) {
        for (IDocument doc : this.getDocsInternal(feature, monitor)) {
            IHotlink hotlinkDoc;
            if (!(doc instanceof IHotlink) || !attributeName.equals((hotlinkDoc = (IHotlink)doc).getAttributeName())) continue;
            return hotlinkDoc;
        }
        return null;
    }

    public boolean setFile(SimpleFeature feature, String attributeName, File file, IProgressMonitor monitor) {
        return this.setHotlink(feature, attributeName, file.getAbsolutePath(), monitor);
    }

    public boolean setLink(SimpleFeature feature, String attributeName, URL link, IProgressMonitor monitor) {
        return this.setHotlink(feature, attributeName, link.toString(), monitor);
    }

    public boolean setAction(SimpleFeature feature, String attributeName, String action, IProgressMonitor monitor) {
        return this.setHotlink(feature, attributeName, action, monitor);
    }

    public boolean clear(SimpleFeature feature, String attributeName, IProgressMonitor monitor) {
        return this.setHotlink(feature, attributeName, null, monitor);
    }

    protected String decodeInfo(IDocument.ContentType contentType, String featureInfo) {
        return featureInfo;
    }

    protected String encodeInfo(IDocument.ContentType contentType, String documentInfo) {
        return documentInfo;
    }

    private boolean setHotlink(SimpleFeature feature, String attributeName, String value, IProgressMonitor monitor) {
        AbstractHotlinkDocument doc = (AbstractHotlinkDocument)this.getDocument(feature, attributeName, monitor);
        String encodedValue = this.encodeInfo(doc.getContentType(), value);
        doc.setInfo(value);
        feature.setAttribute(attributeName, (Object)encodedValue);
        return true;
    }

    private Map<String, List<IHotlinkSource.HotlinkDescriptor>> getDescriptorMap(List<IHotlinkSource.HotlinkDescriptor> descriptors) {
        HashMap<String, List<IHotlinkSource.HotlinkDescriptor>> descriptorMap = new HashMap<String, List<IHotlinkSource.HotlinkDescriptor>>();
        for (IHotlinkSource.HotlinkDescriptor descriptor : descriptors) {
            String attributeName = descriptor.getAttributeName();
            if (descriptorMap.containsKey(attributeName)) {
                ((List)descriptorMap.get(attributeName)).add(descriptor);
                continue;
            }
            ArrayList<IHotlinkSource.HotlinkDescriptor> attributeDescriptors = new ArrayList<IHotlinkSource.HotlinkDescriptor>();
            attributeDescriptors.add(descriptor);
            descriptorMap.put(attributeName, attributeDescriptors);
        }
        return descriptorMap;
    }

    private IDocument create(String info, List<IHotlinkSource.HotlinkDescriptor> descriptors) {
        AbstractDocumentItem doc = null;
        switch (descriptors.get(0).getType()) {
            case FILE: {
                doc = new FileHotlinkDocument(info, descriptors);
                break;
            }
            case WEB: {
                doc = new WebHotlinkDocument(info, descriptors);
                break;
            }
            case ACTION: {
                doc = new ActionHotlinkDocument(info, descriptors);
                break;
            }
        }
        if (doc != null) {
            doc.setSource(this);
        }
        return doc;
    }
}

