/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.source;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.document.IHotlinkSource;
import net.refractions.udig.tool.info.InfoPlugin;

public class BasicHotlinkDescriptorParser {
    private static final String HOTLINK = "hotlink";
    private static final String HOTLINK_ENABLED = "hotlink_enabled";
    private static final String HOTLINK_DELIMITER = "|=|";
    private static final String HOTLINK_DELIMITER_REGEX = "\\|=\\|";
    private IGeoResource resource;

    public BasicHotlinkDescriptorParser(IGeoResource resource) {
        this.resource = resource;
    }

    public boolean isEnabled() {
        return this.getProperty(HOTLINK_ENABLED);
    }

    public void setEnabled(boolean isEnabled) {
        this.setProperty(HOTLINK_ENABLED, isEnabled);
    }

    private boolean getProperty(String key) {
        Map props = this.resource.getPersistentProperties();
        if (props.containsKey(key)) {
            return Boolean.parseBoolean((String)props.get(key));
        }
        return false;
    }

    private void setProperty(String key, boolean value) {
        Map props = this.resource.getPersistentProperties();
        props.put(key, Boolean.toString(value));
    }

    public boolean hasDescriptors() {
        return this.resource.getPersistentProperties().containsKey(HOTLINK);
    }

    public List<IHotlinkSource.HotlinkDescriptor> getDescriptors() {
        Map props = this.resource.getPersistentProperties();
        String definitions = (String)props.get(HOTLINK);
        ArrayList<IHotlinkSource.HotlinkDescriptor> descriptors = new ArrayList<IHotlinkSource.HotlinkDescriptor>();
        if (definitions != null && !definitions.isEmpty()) {
            String[] definitionArray;
            String[] stringArray = definitionArray = definitions.split(HOTLINK_DELIMITER_REGEX);
            int n = definitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                String definition = stringArray[n2];
                try {
                    IHotlinkSource.HotlinkDescriptor descriptor = new IHotlinkSource.HotlinkDescriptor(definition);
                    descriptors.add(descriptor);
                }
                catch (Throwable t) {
                    InfoPlugin.log("Unable describe hotlink:" + definition, t);
                }
                ++n2;
            }
        }
        return descriptors;
    }

    public void setDescriptors(List<IHotlinkSource.HotlinkDescriptor> descriptors) {
        Map props = this.resource.getPersistentProperties();
        if (descriptors == null || descriptors.size() == 0) {
            props.remove(HOTLINK);
        } else {
            StringBuilder sb = new StringBuilder();
            Iterator<IHotlinkSource.HotlinkDescriptor> i = descriptors.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append(HOTLINK_DELIMITER);
            }
            props.put(HOTLINK, sb.toString());
        }
    }

    public void clearDescriptors() {
        this.setDescriptors(null);
    }
}

