/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.model;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.document.IAbstractDocumentSource;
import net.refractions.udig.catalog.document.IDocument;
import net.refractions.udig.catalog.document.IDocumentFolder;
import net.refractions.udig.document.model.AbstractDocumentItem;

public class DocumentFolder
extends AbstractDocumentItem
implements IDocumentFolder {
    private String name;
    private List<IDocumentFolder> folders;
    private List<IDocument> docs;

    public DocumentFolder(String name, IAbstractDocumentSource source) {
        this.name = name;
        this.source = source;
        this.folders = new ArrayList<IDocumentFolder>();
        this.docs = new ArrayList<IDocument>();
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(IDocument doc) {
        return this.docs.contains(doc);
    }

    public boolean contains(IDocumentFolder folder) {
        return this.folders.contains(folder);
    }

    public List<Object> getItems() {
        ArrayList<Object> items = new ArrayList<Object>();
        items.addAll(this.folders);
        items.addAll(this.docs);
        return items;
    }

    public List<IDocument> getDocuments() {
        return this.docs;
    }

    public List<IDocumentFolder> getFolders() {
        return this.folders;
    }

    public void setDocuments(List<IDocument> docs) {
        this.docs = docs;
    }

    public void setFolders(List<IDocumentFolder> folders) {
        this.folders = folders;
    }

    public void addDocument(IDocument doc) {
        this.docs.add(doc);
    }

    public void addFolder(IDocumentFolder folder) {
        this.folders.add(folder);
    }

    public void addDocuments(List<IDocument> docs) {
        this.docs.addAll(docs);
    }

    public void addFolders(List<IDocumentFolder> folders) {
        this.folders.addAll(folders);
    }

    public void insertDocuments(List<IDocument> docs, int index) {
        this.docs.addAll(index, docs);
    }

    public void removeDocument(IDocument doc) {
        this.docs.remove(doc);
    }

    public void removeDocuments(List<IDocument> docs) {
        this.docs.removeAll(docs);
    }

    public void removeFolder(IDocumentFolder folder) {
        this.folders.remove(folder);
    }
}

