/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.model;

import java.util.List;
import net.refractions.udig.catalog.document.IDocument;
import net.refractions.udig.catalog.document.IHotlink;
import net.refractions.udig.catalog.document.IHotlinkSource;
import net.refractions.udig.document.model.AbstractDocument;

public abstract class AbstractHotlinkDocument
extends AbstractDocument
implements IHotlink {
    protected String info;
    protected List<IHotlinkSource.HotlinkDescriptor> descriptors;

    public AbstractHotlinkDocument(String info, List<IHotlinkSource.HotlinkDescriptor> descriptors) {
        this.setInfo(info);
        this.descriptors = descriptors;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public List<IHotlinkSource.HotlinkDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(List<IHotlinkSource.HotlinkDescriptor> descriptors) {
        this.descriptors = descriptors;
    }

    public String getLabel() {
        if (this.descriptors != null && this.descriptors.size() > 0) {
            int count = 0;
            StringBuilder sb = new StringBuilder();
            for (IHotlinkSource.HotlinkDescriptor descriptor : this.descriptors) {
                sb.append(descriptor.getLabel());
                if (++count >= this.descriptors.size()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
        return null;
    }

    public String getDescription() {
        if (this.descriptors != null && this.descriptors.size() > 0) {
            int count = 0;
            StringBuilder sb = new StringBuilder();
            for (IHotlinkSource.HotlinkDescriptor descriptor : this.descriptors) {
                ++count;
                String description = descriptor.getDescription();
                if (description == null) continue;
                sb.append(description);
                if (count >= this.descriptors.size()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
        return null;
    }

    public IDocument.Type getType() {
        return IDocument.Type.HOTLINK;
    }

    public IDocument.ContentType getContentType() {
        if (this.descriptors != null && this.descriptors.size() > 0) {
            return this.descriptors.get(0).getType();
        }
        return null;
    }

    public String getAttributeName() {
        if (this.descriptors != null && this.descriptors.size() > 0) {
            return this.descriptors.get(0).getAttributeName();
        }
        return null;
    }

    public boolean isTemplate() {
        return false;
    }
}

