/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import eu.udig.style.advanced.common.styleattributeclasses.FeatureTypeStyleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.StyleWrapper;
import eu.udig.style.advanced.utils.Drawing;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.refractions.udig.style.sld.SLD;
import net.refractions.udig.ui.graphics.SLDs;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.widgets.Spinner;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.function.FilterFunction_offset;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.style.Fill;
import org.opengis.style.GraphicalSymbol;

public class Utilities {
    public static final String NONE = "- none -";
    public static final String DEFAULT_SIZE = "5";
    public static final String DEFAULT_WIDTH = "1";
    public static final String DEFAULT_ROTATION = "0";
    public static final String DEFAULT_OFFSET = "0";
    public static final String DEFAULT_OPACITY = "1";
    public static final String DEFAULT_COLOR = "#000000";
    public static final String DEFAULT_MINSCALE = "0";
    public static final String DEFAULT_MAXSCALE = "infinity";
    public static final int OFFSET_MAX = 1000;
    public static final int OFFSET_MIN = -1000;
    public static final int OFFSET_STEP = 10;
    public static final int DISPLACEMENT_MAX = 1000;
    public static final int DISPLACEMENT_MIN = -1000;
    public static final int DISPLACEMENT_STEP = 10;
    public static final String DEFAULT_GROUPNAME = "group ";
    public static final String DEFAULT_STYLENAME = "default style";
    public static final String SLD_EXTENTION = ".sld";
    public static final String[] wkMarkDefs = new String[]{"", "cross", "circle", "triangle", "X", "star", "arrow", "hatch", "square"};
    public static final String[] wkMarkNames = new String[]{"", "cross", "circle", "triangle", "X", "star", "arrow", "hatch", "square"};
    public static final String SHAPE_PREFIX = "shape://";
    public static final String[] shapeMarkDefs = new String[]{"", "shape://vertline", "shape://horline", "shape://slash", "shape://backslash", "shape://times", "shape://dot", "shape://plus"};
    public static final String[] shapeMarkNames = new String[]{"", "vertical lines", "horizontal lines", "diagonal lines", "inverse diagonal lines", "crossed diagonal lines", "dots", "plus"};
    public static final BiMap<String, String> markNamesToDef = new HashBiMap();
    public static final String[] lineCapNames;
    public static final String[] verticalPlacementNames;
    public static final String[] lineJoinNames;
    public static StyleFactory sf;
    public static FilterFactory ff;
    public static StyleBuilder sb;
    private static Drawing d;

    static {
        markNamesToDef.put((Object)wkMarkNames[0], (Object)wkMarkDefs[0]);
        markNamesToDef.put((Object)wkMarkNames[1], (Object)wkMarkDefs[1]);
        markNamesToDef.put((Object)wkMarkNames[2], (Object)wkMarkDefs[2]);
        markNamesToDef.put((Object)wkMarkNames[3], (Object)wkMarkDefs[3]);
        markNamesToDef.put((Object)wkMarkNames[4], (Object)wkMarkDefs[4]);
        markNamesToDef.put((Object)wkMarkNames[5], (Object)wkMarkDefs[5]);
        markNamesToDef.put((Object)wkMarkNames[6], (Object)wkMarkDefs[6]);
        markNamesToDef.put((Object)wkMarkNames[7], (Object)wkMarkDefs[7]);
        markNamesToDef.put((Object)wkMarkNames[8], (Object)wkMarkDefs[8]);
        markNamesToDef.put((Object)shapeMarkNames[1], (Object)shapeMarkDefs[1]);
        markNamesToDef.put((Object)shapeMarkNames[2], (Object)shapeMarkDefs[2]);
        markNamesToDef.put((Object)shapeMarkNames[3], (Object)shapeMarkDefs[3]);
        markNamesToDef.put((Object)shapeMarkNames[4], (Object)shapeMarkDefs[4]);
        markNamesToDef.put((Object)shapeMarkNames[5], (Object)shapeMarkDefs[5]);
        markNamesToDef.put((Object)shapeMarkNames[6], (Object)shapeMarkDefs[6]);
        markNamesToDef.put((Object)shapeMarkNames[7], (Object)shapeMarkDefs[7]);
        lineCapNames = new String[]{"", "butt", "round", "square"};
        verticalPlacementNames = new String[]{"bevel", "miter", "round"};
        lineJoinNames = new String[]{"", "bevel", "miter", "round"};
        sf = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
        ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        sb = new StyleBuilder(sf, ff);
        d = Drawing.create();
    }

    public static String[] getAllMarksArray() {
        Set keySet = markNamesToDef.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public static StyledLayerDescriptor readStyle(File file) throws IOException {
        SLDParser stylereader = new SLDParser(sf, file);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        return sld;
    }

    public static BufferedImage rulesWrapperToImage(List<RuleWrapper> ruleWrappers, int width, int height, SLD type) {
        switch (type) {
            case POINT: {
                return Utilities.pointRulesWrapperToImage(ruleWrappers, width, height);
            }
            case LINE: {
                return Utilities.lineRulesWrapperToImage(ruleWrappers, width, height);
            }
            case POLYGON: {
                return Utilities.polygonRulesWrapperToImage(ruleWrappers, width, height);
            }
        }
        return null;
    }

    public static BufferedImage rulesWrapperToImage(RuleWrapper ruleWrapper, int width, int height, SLD type) {
        switch (type) {
            case POINT: {
                return Utilities.pointRuleWrapperToImage(ruleWrapper, width, height);
            }
            case LINE: {
                return Utilities.lineRuleWrapperToImage(ruleWrapper, width, height);
            }
            case POLYGON: {
                return Utilities.polygonRuleWrapperToImage(ruleWrapper, width, height);
            }
        }
        return null;
    }

    public static BufferedImage pointRulesWrapperToImage(List<RuleWrapper> ruleWrapperList, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (RuleWrapper ruleWrapper : ruleWrapperList) {
            BufferedImage tmpImage = Utilities.pointRuleWrapperToImage(ruleWrapper, width, height);
            g2d.drawImage((Image)tmpImage, 0, 0, null);
        }
        g2d.dispose();
        return image;
    }

    public static BufferedImage pointRuleWrapperToImage(RuleWrapper ruleWrapper, int width, int height) {
        return Utilities.pointRuleToImage(ruleWrapper.getRule(), width, height);
    }

    public static BufferedImage pointRuleToImage(Rule rule, int width, int height) {
        Symbolizer symbolizer;
        DuplicatingStyleVisitor copyStyle = new DuplicatingStyleVisitor();
        rule.accept((StyleVisitor)copyStyle);
        Rule newRule = (Rule)copyStyle.getCopy();
        int pointSize = 0;
        Stroke stroke = null;
        Symbolizer[] symbolizers = newRule.getSymbolizers();
        if (symbolizers.length > 0 && (symbolizer = newRule.getSymbolizers()[0]) instanceof PointSymbolizer) {
            PointSymbolizer pointSymbolizer = (PointSymbolizer)symbolizer;
            pointSize = SLDs.pointSize((PointSymbolizer)pointSymbolizer);
            stroke = SLDs.stroke((PointSymbolizer)pointSymbolizer);
        }
        int strokeSize = 0;
        if (stroke != null && (strokeSize = SLDs.width(stroke)) < 0) {
            strokeSize = 1;
            stroke.setWidth((Expression)ff.literal(strokeSize));
        }
        if ((pointSize += 2 * strokeSize) <= 0) {
            pointSize = width;
        }
        BufferedImage finalImage = new BufferedImage(width, height, 2);
        BufferedImage pointImage = new BufferedImage(pointSize, pointSize, 2);
        Point point = d.point(pointSize / 2, pointSize / 2);
        d.drawDirect(pointImage, d.feature(point), newRule);
        Graphics2D g2d = finalImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (pointSize > width || pointSize > height) {
            g2d.drawImage(pointImage, 0, 0, width, height, 0, 0, pointSize, pointSize, null);
        } else {
            int x = width / 2 - pointSize / 2;
            int y = height / 2 - pointSize / 2;
            g2d.drawImage((Image)pointImage, x, y, null);
        }
        g2d.dispose();
        return finalImage;
    }

    public static BufferedImage polygonRulesWrapperToImage(List<RuleWrapper> rulesWrapperList, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (RuleWrapper rule : rulesWrapperList) {
            BufferedImage tmpImage = Utilities.polygonRuleWrapperToImage(rule, width, height);
            g2d.drawImage((Image)tmpImage, 0, 0, null);
        }
        g2d.dispose();
        return image;
    }

    public static BufferedImage polygonRuleWrapperToImage(RuleWrapper ruleWrapper, int width, int height) {
        return Utilities.polygonRuleToImage(ruleWrapper.getRule(), width, height);
    }

    public static BufferedImage polygonRuleToImage(Rule rule, int width, int height) {
        Symbolizer symbolizer;
        DuplicatingStyleVisitor copyStyle = new DuplicatingStyleVisitor();
        rule.accept((StyleVisitor)copyStyle);
        Rule newRule = (Rule)copyStyle.getCopy();
        Stroke stroke = null;
        Symbolizer[] symbolizers = newRule.getSymbolizers();
        if (symbolizers.length > 0 && (symbolizer = symbolizers[0]) instanceof PolygonSymbolizer) {
            PolygonSymbolizer polygonSymbolizer = (PolygonSymbolizer)symbolizer;
            stroke = SLDs.stroke((PolygonSymbolizer)polygonSymbolizer);
        }
        int strokeSize = 0;
        if (stroke != null && (strokeSize = SLDs.width(stroke)) < 0) {
            strokeSize = 0;
            stroke.setWidth((Expression)ff.literal(strokeSize));
        }
        BufferedImage finalImage = new BufferedImage(width, height, 2);
        int[] xy = new int[]{(int)((double)height * 0.15), (int)((double)width * 0.2), (int)((double)height * 0.4), (int)((double)width * 0.3), (int)((double)height * 0.85), (int)((double)width * 0.15), (int)((double)height * 0.85), (int)((double)width * 0.85), (int)((double)height * 0.15), (int)((double)width * 0.85)};
        Polygon polygon = d.polygon(xy);
        d.drawDirect(finalImage, d.feature(polygon), newRule);
        Graphics2D g2d = finalImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawImage((Image)finalImage, 0, 0, null);
        g2d.dispose();
        return finalImage;
    }

    public static BufferedImage lineRulesWrapperToImage(List<RuleWrapper> rulesWrapperList, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (RuleWrapper rule : rulesWrapperList) {
            BufferedImage tmpImage = Utilities.lineRuleWrapperToImage(rule, width, height);
            g2d.drawImage((Image)tmpImage, 0, 0, null);
        }
        g2d.dispose();
        return image;
    }

    public static BufferedImage lineRuleWrapperToImage(RuleWrapper ruleWrapper, int width, int height) {
        return Utilities.lineRuleToImage(ruleWrapper.getRule(), width, height);
    }

    public static BufferedImage lineRuleToImage(Rule rule, int width, int height) {
        Symbolizer symbolizer;
        DuplicatingStyleVisitor copyStyle = new DuplicatingStyleVisitor();
        rule.accept((StyleVisitor)copyStyle);
        Rule newRule = (Rule)copyStyle.getCopy();
        Stroke stroke = null;
        Symbolizer[] symbolizers = newRule.getSymbolizers();
        if (symbolizers.length > 0 && (symbolizer = newRule.getSymbolizers()[0]) instanceof LineSymbolizer) {
            LineSymbolizer lineSymbolizer = (LineSymbolizer)symbolizer;
            stroke = SLDs.stroke((LineSymbolizer)lineSymbolizer);
        }
        int strokeSize = 0;
        if (stroke != null && (strokeSize = SLDs.width(stroke)) < 0) {
            strokeSize = 0;
            stroke.setWidth((Expression)ff.literal(strokeSize));
        }
        BufferedImage finalImage = new BufferedImage(width, height, 2);
        int[] xy = new int[]{(int)((double)height * 0.15), (int)((double)width * 0.85), (int)((double)height * 0.35), (int)((double)width * 0.15), (int)((double)height * 0.75), (int)((double)width * 0.85), (int)((double)height * 0.85), (int)((double)width * 0.15)};
        LineString line = d.line(xy);
        d.drawDirect(finalImage, d.feature(line), newRule);
        Graphics2D g2d = finalImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawImage((Image)finalImage, 0, 0, null);
        g2d.dispose();
        return finalImage;
    }

    public static List<ExternalGraphic> externalGraphicsFromRule(Rule rule) {
        ArrayList<ExternalGraphic> gList = new ArrayList<ExternalGraphic>();
        List symbolizers = rule.symbolizers();
        if (symbolizers.size() != 0) {
            for (Symbolizer symbolizer : symbolizers) {
                Stroke stroke;
                Graphic[] graphics = new Graphic[2];
                if (symbolizer instanceof PointSymbolizer) {
                    PointSymbolizer pointSymbolizer = (PointSymbolizer)symbolizer;
                    graphics[0] = pointSymbolizer.getGraphic();
                } else if (symbolizer instanceof LineSymbolizer) {
                    LineSymbolizer lineSymbolizer = (LineSymbolizer)symbolizer;
                    stroke = lineSymbolizer.getStroke();
                    graphics[0] = stroke.getGraphicStroke();
                } else if (symbolizer instanceof PolygonSymbolizer) {
                    org.geotools.styling.Fill fill;
                    PolygonSymbolizer polygonSymbolizer = (PolygonSymbolizer)symbolizer;
                    stroke = polygonSymbolizer.getStroke();
                    if (stroke != null) {
                        graphics[0] = stroke.getGraphicStroke();
                    }
                    if ((fill = polygonSymbolizer.getFill()) != null) {
                        graphics[1] = fill.getGraphicFill();
                    }
                }
                int i = 0;
                while (i < graphics.length) {
                    if (graphics[i] != null) {
                        for (GraphicalSymbol gs : graphics[i].graphicalSymbols()) {
                            if (gs == null || !(gs instanceof ExternalGraphic)) continue;
                            ExternalGraphic externalGraphic = (ExternalGraphic)gs;
                            gList.add(externalGraphic);
                        }
                    }
                    ++i;
                }
            }
            return gList;
        }
        return Collections.emptyList();
    }

    public static List<ExternalGraphic> externalGraphicsFromGraphic(Graphic graphic) {
        ArrayList<ExternalGraphic> gList = new ArrayList<ExternalGraphic>();
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            if (gs == null || !(gs instanceof ExternalGraphic)) continue;
            ExternalGraphic externalGraphic = (ExternalGraphic)gs;
            gList.add(externalGraphic);
        }
        return gList;
    }

    public static Style createDefaultPointStyle() {
        FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
        featureTypeStyle.rules().add(Utilities.createDefaultPointRule());
        Style style = sf.createStyle();
        style.featureTypeStyles().add(featureTypeStyle);
        return style;
    }

    public static Rule createDefaultPointRule() {
        Graphic graphic = sf.createDefaultGraphic();
        Mark circleMark = sf.getCircleMark();
        circleMark.setFill((Fill)sf.createFill((Expression)ff.literal((Object)Color.red)));
        circleMark.setStroke((org.opengis.style.Stroke)sf.createStroke((Expression)ff.literal((Object)Color.BLACK), (Expression)ff.literal((Object)"1")));
        graphic.graphicalSymbols().clear();
        graphic.graphicalSymbols().add(circleMark);
        graphic.setSize((Expression)ff.literal((Object)DEFAULT_SIZE));
        PointSymbolizer pointSymbolizer = sf.createPointSymbolizer();
        Rule rule = sf.createRule();
        rule.setName("New rule");
        rule.symbolizers().add(pointSymbolizer);
        pointSymbolizer.setGraphic((org.opengis.style.Graphic)graphic);
        return rule;
    }

    public static Style createDefaultPolygonStyle() {
        FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
        featureTypeStyle.rules().add(Utilities.createDefaultPolygonRule());
        Style style = sf.createStyle();
        style.featureTypeStyles().add(featureTypeStyle);
        return style;
    }

    public static Rule createDefaultPolygonRule() {
        PolygonSymbolizer polygonSymbolizer = sf.createPolygonSymbolizer();
        polygonSymbolizer.setFill((Fill)sf.createFill((Expression)ff.literal((Object)Color.red)));
        polygonSymbolizer.setStroke((org.opengis.style.Stroke)sf.createStroke((Expression)ff.literal((Object)Color.BLACK), (Expression)ff.literal((Object)"1")));
        Rule rule = sf.createRule();
        rule.setName("New rule");
        rule.symbolizers().add(polygonSymbolizer);
        return rule;
    }

    public static Style createDefaultLineStyle() {
        FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
        featureTypeStyle.rules().add(Utilities.createDefaultLineRule());
        Style style = sf.createStyle();
        style.featureTypeStyles().add(featureTypeStyle);
        return style;
    }

    public static Rule createDefaultLineRule() {
        LineSymbolizer lineSymbolizer = sf.createLineSymbolizer();
        lineSymbolizer.setStroke((org.opengis.style.Stroke)sf.createStroke((Expression)ff.literal((Object)Color.BLACK), (Expression)ff.literal(1)));
        Rule rule = sf.createRule();
        rule.setName("New rule");
        rule.symbolizers().add(lineSymbolizer);
        return rule;
    }

    public static TextSymbolizer createDefaultTextSymbolizer(SLD type) {
        LinePlacement labelPlacement = null;
        switch (type) {
            case POINT: 
            case POLYGON: {
                labelPlacement = sf.createPointPlacement(sf.createAnchorPoint((Expression)ff.literal(0.0), (Expression)ff.literal(0.0)), sf.createDisplacement((Expression)ff.literal(0.0), (Expression)ff.literal(0.0)), (Expression)ff.literal(0.0));
                break;
            }
            case LINE: {
                labelPlacement = sf.createLinePlacement((Expression)ff.literal(10.0));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Font font = sb.createFont("Arial", false, false, 12.0);
        TextSymbolizer textSymbolizer = sf.createTextSymbolizer(sf.createFill((Expression)ff.literal((Object)DEFAULT_COLOR)), new Font[]{font}, null, (Expression)ff.literal((Object)"dummy"), (LabelPlacement)labelPlacement, null);
        return textSymbolizer;
    }

    public static Symbolizer createDefaultGeometrySymbolizer(SLD type) {
        Symbolizer symbolizer = null;
        switch (type) {
            case POINT: {
                Rule defaultPointRule = Utilities.createDefaultPointRule();
                symbolizer = defaultPointRule.getSymbolizers()[0];
                break;
            }
            case POLYGON: {
                Rule defaultPolygonRule = Utilities.createDefaultPolygonRule();
                symbolizer = defaultPolygonRule.getSymbolizers()[0];
                break;
            }
            case LINE: {
                Rule defaultLineRule = Utilities.createDefaultLineRule();
                symbolizer = defaultLineRule.getSymbolizers()[0];
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return symbolizer;
    }

    public static PointSymbolizer pointSymbolizerFromRule(Rule rule) {
        List symbolizers = rule.symbolizers();
        PointSymbolizer pointSymbolizer = null;
        for (Symbolizer symbolizer : symbolizers) {
            if (!(symbolizer instanceof PointSymbolizer)) continue;
            pointSymbolizer = (PointSymbolizer)symbolizer;
            break;
        }
        if (pointSymbolizer == null) {
            throw new IllegalArgumentException();
        }
        return pointSymbolizer;
    }

    public static PolygonSymbolizer polygonSymbolizerFromRule(Rule rule) {
        List symbolizers = rule.symbolizers();
        PolygonSymbolizer polygonSymbolizer = null;
        for (Symbolizer symbolizer : symbolizers) {
            if (!(symbolizer instanceof PolygonSymbolizer)) continue;
            polygonSymbolizer = (PolygonSymbolizer)symbolizer;
            break;
        }
        if (polygonSymbolizer == null) {
            throw new IllegalArgumentException();
        }
        return polygonSymbolizer;
    }

    public static LineSymbolizer lineSymbolizerFromRule(Rule rule) {
        List symbolizers = rule.symbolizers();
        LineSymbolizer lineSymbolizer = null;
        for (Symbolizer symbolizer : symbolizers) {
            if (!(symbolizer instanceof LineSymbolizer)) continue;
            lineSymbolizer = (LineSymbolizer)symbolizer;
            break;
        }
        if (lineSymbolizer == null) {
            throw new IllegalArgumentException();
        }
        return lineSymbolizer;
    }

    public static void substituteMark(Rule rule, String wellKnownMarkName) {
        PointSymbolizer pointSymbolizer = Utilities.pointSymbolizerFromRule(rule);
        Mark oldMark = SLDs.mark((PointSymbolizer)pointSymbolizer);
        Graphic graphic = SLDs.graphic((PointSymbolizer)pointSymbolizer);
        graphic.graphicalSymbols().clear();
        Mark mark = sf.createMark();
        mark.setWellKnownName((Expression)ff.literal((Object)wellKnownMarkName));
        if (oldMark != null) {
            mark.setFill((Fill)oldMark.getFill());
            mark.setStroke((org.opengis.style.Stroke)oldMark.getStroke());
        }
        graphic.graphicalSymbols().add(mark);
    }

    public static void substituteExternalGraphics(Rule rule, URL externalGraphicsUrl) {
        String urlString = externalGraphicsUrl.toString();
        String format = "";
        if (urlString.toLowerCase().endsWith(".png")) {
            format = "image/png";
        } else if (urlString.toLowerCase().endsWith(".jpg")) {
            format = "image/jpg";
        } else if (urlString.toLowerCase().endsWith(".svg")) {
            format = "image/svg+xml";
        } else {
            urlString = "";
            try {
                externalGraphicsUrl = new URL("file:");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        PointSymbolizer pointSymbolizer = Utilities.pointSymbolizerFromRule(rule);
        Graphic graphic = SLDs.graphic((PointSymbolizer)pointSymbolizer);
        graphic.graphicalSymbols().clear();
        ExternalGraphic exGraphic = sf.createExternalGraphic(externalGraphicsUrl, format);
        graphic.graphicalSymbols().add(exGraphic);
    }

    public static String getFormat(String path) {
        String format = "";
        if (path.toLowerCase().endsWith(".png")) {
            format = "image/png";
        } else if (path.toLowerCase().endsWith(".jpg")) {
            format = "image/jpg";
        } else if (path.toLowerCase().endsWith(".gif")) {
            format = "image/gif";
        } else if (path.toLowerCase().endsWith(".svg")) {
            format = "image/svg+xml";
        }
        return format;
    }

    public static String getExternalGraphicFormat(String name) {
        String format = "";
        if (name.toLowerCase().endsWith(".png")) {
            format = "image/png";
        } else if (name.toLowerCase().endsWith(".jpg")) {
            format = "image/jpg";
        } else if (name.toLowerCase().endsWith(".gif")) {
            format = "image/gif";
        } else if (name.toLowerCase().endsWith(".svg")) {
            format = "image/svg+xml";
        } else {
            return null;
        }
        return format;
    }

    public static void changeMarkSize(Rule rule, int newSize) {
        PointSymbolizer pointSymbolizer = Utilities.pointSymbolizerFromRule(rule);
        Graphic graphic = SLDs.graphic((PointSymbolizer)pointSymbolizer);
        graphic.setSize((Expression)ff.literal(newSize));
    }

    public static void changeRotation(Rule rule, int newRotation) {
        PointSymbolizer pointSymbolizer = Utilities.pointSymbolizerFromRule(rule);
        Graphic graphic = SLDs.graphic((PointSymbolizer)pointSymbolizer);
        graphic.setRotation((Expression)ff.literal(newRotation));
    }

    public static Point2D getOffset(Symbolizer symbolizer) {
        Expression geometry = symbolizer.getGeometry();
        if (geometry != null && geometry instanceof FilterFunction_offset) {
            FilterFunction_offset offsetFunction = (FilterFunction_offset)geometry;
            List parameters = offsetFunction.getParameters();
            Expression xOffsetExpr = (Expression)parameters.get(1);
            Expression yOffsetExpr = (Expression)parameters.get(2);
            Double xOffsetDouble = (Double)xOffsetExpr.evaluate(null, Double.class);
            Double yOffsetDouble = (Double)yOffsetExpr.evaluate(null, Double.class);
            if (xOffsetDouble != null && yOffsetDouble != null) {
                Point2D.Double point = new Point2D.Double(xOffsetDouble, yOffsetDouble);
                return point;
            }
        }
        return null;
    }

    public static void setOffset(Symbolizer symbolizer, String text) {
        if (text.indexOf(44) == -1) {
            return;
        }
        String[] split = text.split(",");
        if (split.length != 2) {
            return;
        }
        double xOffset = Double.parseDouble(split[0]);
        double yOffset = Double.parseDouble(split[1]);
        Expression geometry = symbolizer.getGeometry();
        if (geometry != null) {
            if (geometry instanceof FilterFunction_offset) {
                FilterFunction_offset offsetFunction = (FilterFunction_offset)geometry;
                List parameters = offsetFunction.getParameters();
                parameters.set(1, ff.literal(xOffset));
                parameters.set(2, ff.literal(yOffset));
            }
        } else {
            Function function = ff.function("offset", new Expression[]{ff.property("the_geom"), ff.literal(xOffset), ff.literal(yOffset)});
            symbolizer.setGeometry((Expression)function);
        }
    }

    public static String checkSameNameRule(List<RuleWrapper> rulesWrapper, String ruleName) {
        int index = 1;
        String name = ruleName.trim();
        int i = 0;
        while (i < rulesWrapper.size()) {
            RuleWrapper ruleWrapper = rulesWrapper.get(i);
            String tmpName = ruleWrapper.getName();
            if (tmpName != null) {
                if ((tmpName = tmpName.trim()).equals(name)) {
                    name = name.endsWith(")") ? name.trim().replaceFirst("\\([0-9]+\\)$", "(" + index++ + ")") : String.valueOf(name) + " (" + index++ + ")";
                    i = 0;
                }
                if (index == 1000) {
                    throw new RuntimeException();
                }
            }
            ++i;
        }
        return name;
    }

    public static String checkSameNameFeatureTypeStyle(List<FeatureTypeStyleWrapper> ftsWrapperList, String ftsName) {
        int index = 1;
        String name = ftsName.trim();
        int i = 0;
        while (i < ftsWrapperList.size()) {
            FeatureTypeStyleWrapper ftsWrapper = ftsWrapperList.get(i);
            String tmpName = ftsWrapper.getName();
            if (tmpName != null) {
                if ((tmpName = tmpName.trim()).equals(name)) {
                    name = name.endsWith(")") ? name.trim().replaceFirst("\\([0-9]+\\)$", "(" + index++ + ")") : String.valueOf(name) + " (" + index++ + ")";
                    i = 0;
                }
                if (index == 1000) {
                    throw new RuntimeException();
                }
            }
            ++i;
        }
        return name;
    }

    public static String checkSameNameStyle(List<StyleWrapper> styles, String styleName) {
        int index = 1;
        String name = styleName.trim();
        int i = 0;
        while (i < styles.size()) {
            StyleWrapper styleWrapper = styles.get(i);
            String tmpName = styleWrapper.getName();
            if (tmpName != null) {
                if ((tmpName = tmpName.trim()).equals(name)) {
                    name = name.endsWith(")") ? name.trim().replaceFirst("\\([0-9]+\\)$", "(" + index++ + ")") : String.valueOf(name) + " (" + index++ + ")";
                    i = 0;
                }
                if (index == 1000) {
                    throw new RuntimeException();
                }
            }
            ++i;
        }
        return name;
    }

    public static Style rulesToStyle(List<Rule> rules, String name, boolean oneFeaturetypestylePerRule) {
        Style namedStyle = sf.createStyle();
        if (!oneFeaturetypestylePerRule) {
            FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
            List currentRules = featureTypeStyle.rules();
            int i = 0;
            while (i < rules.size()) {
                Rule rule = rules.get(i);
                currentRules.add(rule);
                ++i;
            }
            namedStyle.featureTypeStyles().add(featureTypeStyle);
        } else {
            int i = 0;
            while (i < rules.size()) {
                FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
                Rule rule = rules.get(i);
                featureTypeStyle.rules().add(rule);
                namedStyle.featureTypeStyles().add(featureTypeStyle);
                ++i;
            }
        }
        namedStyle.setName(name);
        return namedStyle;
    }

    public static String styleToString(Style style) throws Exception {
        StyledLayerDescriptor sld = sf.createStyledLayerDescriptor();
        UserLayer layer = sf.createUserLayer();
        layer.setLayerFeatureConstraints(new FeatureTypeConstraint[1]);
        sld.addStyledLayer((StyledLayer)layer);
        layer.addUserStyle(style);
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(4);
        String xml = aTransformer.transform((Object)sld);
        return xml;
    }

    public static StyleWrapper createStyleFromGraphic(File graphicsPath) throws IOException {
        String name = graphicsPath.getName();
        ExternalGraphic exGraphic = null;
        if (name.toLowerCase().endsWith(".png")) {
            exGraphic = sf.createExternalGraphic(graphicsPath.toURI().toURL(), "image/png");
        } else if (name.toLowerCase().endsWith(".svg")) {
            exGraphic = sf.createExternalGraphic(graphicsPath.toURI().toURL(), "image/svg+xml");
        } else if (name.toLowerCase().endsWith(SLD_EXTENTION)) {
            StyledLayerDescriptor sld = Utilities.readStyle(graphicsPath);
            Style style = SLDs.getDefaultStyle((StyledLayerDescriptor)sld);
            return new StyleWrapper(style);
        }
        if (exGraphic == null) {
            throw new IOException("Style could not be created!");
        }
        Graphic gr = sf.createDefaultGraphic();
        gr.graphicalSymbols().clear();
        gr.graphicalSymbols().add(exGraphic);
        Literal size = ff.literal(20);
        gr.setSize((Expression)size);
        Rule rule = sf.createRule();
        PointSymbolizer pointSymbolizer = sf.createPointSymbolizer(gr, null);
        rule.symbolizers().add(pointSymbolizer);
        FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
        featureTypeStyle.rules().add(rule);
        Style namedStyle = sf.createStyle();
        namedStyle.featureTypeStyles().add(featureTypeStyle);
        namedStyle.setName(FilenameUtils.removeExtension((String)name));
        return new StyleWrapper(namedStyle);
    }

    public static float[] getDash(String dashStr) {
        if (dashStr == null) {
            return null;
        }
        String[] dashSplit = dashStr.split(",");
        int size = dashSplit.length;
        float[] dash = new float[size];
        try {
            int i = 0;
            while (i < dash.length) {
                dash[i] = Float.parseFloat(dashSplit[i].trim());
                ++i;
            }
            return dash;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static String getDashString(float[] dashArray) {
        StringBuilder sb = null;
        float[] fArray = dashArray;
        int n = dashArray.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            if (sb == null) {
                sb = new StringBuilder(String.valueOf(f));
            } else {
                sb.append(",");
                sb.append(String.valueOf(f));
            }
            ++n2;
        }
        return sb.toString();
    }

    public static <T extends Number> T isNumber(String value, Class<T> adaptee) {
        if (value == null) {
            return null;
        }
        if (adaptee == null) {
            adaptee = Double.class;
        }
        if (adaptee.isAssignableFrom(Double.class)) {
            try {
                Double parsed = Double.parseDouble(value);
                return (T)((Number)adaptee.cast(parsed));
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (adaptee.isAssignableFrom(Float.class)) {
            try {
                Float parsed = Float.valueOf(Float.parseFloat(value));
                return (T)((Number)adaptee.cast(parsed));
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (adaptee.isAssignableFrom(Integer.class)) {
            try {
                Integer parsed = Integer.parseInt(value);
                return (T)((Number)adaptee.cast(parsed));
            }
            catch (Exception exception) {
                Double number = Utilities.isNumber(value, Double.class);
                if (number != null) {
                    return (T)((Number)adaptee.cast(number.intValue()));
                }
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    public static double getDoubleSpinnerSelection(Spinner spinner) {
        int selection = spinner.getSelection();
        int digits = spinner.getDigits();
        double value = (double)selection / Math.pow(10.0, digits);
        return value;
    }

    public static int sld2awtJoin(String sldJoin) {
        if (sldJoin.equals(lineJoinNames[1])) {
            return 2;
        }
        if (sldJoin.equals("") || sldJoin.equals(lineJoinNames[2])) {
            return 0;
        }
        if (sldJoin.equals(lineJoinNames[3])) {
            return 1;
        }
        throw new IllegalArgumentException("unsupported line join");
    }

    public static int sld2awtCap(String sldCap) {
        if (sldCap.equals("") || sldCap.equals(lineCapNames[1])) {
            return 0;
        }
        if (sldCap.equals(lineCapNames[2])) {
            return 1;
        }
        if (sldCap.equals(lineCapNames[3])) {
            return 2;
        }
        throw new IllegalArgumentException("unsupported line cap");
    }
}

