/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.utils;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import eu.udig.style.advanced.common.styleattributeclasses.PointSymbolizerWrapper;
import eu.udig.style.advanced.utils.Utilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Arrays;
import net.refractions.udig.ui.graphics.AWTGraphics;
import net.refractions.udig.ui.graphics.NonAdvancedSWTGraphics;
import net.refractions.udig.ui.graphics.SLDs;
import net.refractions.udig.ui.graphics.SWTGraphics;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.geotools.data.DataUtilities;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.style.Fill;

public final class Drawing {
    private GeometryFactory gf = new GeometryFactory();
    static SimpleFeatureType pointSchema;
    static SimpleFeatureType lineSchema;
    static SimpleFeatureType polygonSchema;
    static SimpleFeatureType multipointSchema;
    static SimpleFeatureType multilineSchema;
    static SimpleFeatureType multipolygonSchema;

    static {
        try {
            pointSchema = DataUtilities.createType((String)"generated:point", (String)"*point:Point");
            lineSchema = DataUtilities.createType((String)"generated:linestring", (String)"*linestring:LineString");
            polygonSchema = DataUtilities.createType((String)"generated:polygon", (String)"*polygon:Polygon");
            multipointSchema = DataUtilities.createType((String)"generated:multipoint", (String)"*multipoint:MultiPoint");
            multilineSchema = DataUtilities.createType((String)"generated:multilinestring", (String)"*multilinestring:MultiLineString");
            multipolygonSchema = DataUtilities.createType((String)"generated:multipolygon", (String)"*multipolygon:MultiPolygon");
        }
        catch (SchemaException unExpected) {
            System.err.println((Object)unExpected);
        }
    }

    private Drawing() {
    }

    public static Drawing create() {
        return new Drawing();
    }

    public static ViewportGraphics createGraphics(GC gc, Display display, Dimension displaySize) {
        if (Platform.getOS().equals("linux")) {
            return new NonAdvancedSWTGraphics(gc, display, displaySize);
        }
        return new SWTGraphics(gc, display);
    }

    public static ViewportGraphics createGraphics(Graphics2D graphics) {
        return new AWTGraphics(graphics);
    }

    public void drawDirect(Image image, Display display, SimpleFeature feature, Style style) {
        ViewportGraphics graphics = this.createSWTGraphics(image, display);
        this.drawFeature(graphics, feature, style, new AffineTransform());
        graphics.dispose();
    }

    public void drawDirect(Image image, Display display, SimpleFeature feature, Rule rule) {
        AffineTransform worldToScreenTransform = new AffineTransform();
        ViewportGraphics graphics = this.createSWTGraphics(image, display);
        this.drawFeature(graphics, feature, worldToScreenTransform, false, this.getSymbolizers(rule), null);
        graphics.dispose();
    }

    public void drawDirect(BufferedImage image, SimpleFeature feature, Rule rule) {
        AffineTransform worldToScreenTransform = new AffineTransform();
        ViewportGraphics graphics = Drawing.createGraphics(image.createGraphics());
        this.drawFeature(graphics, feature, worldToScreenTransform, false, this.getSymbolizers(rule), null);
        graphics.dispose();
    }

    private ViewportGraphics createSWTGraphics(Image image, Display display) {
        if (Platform.getOS().equals("linux")) {
            return new NonAdvancedSWTGraphics(image, display);
        }
        return new SWTGraphics(image, display);
    }

    public void drawFeature(ViewportGraphics graphics, SimpleFeature feature, AffineTransform worldToScreenTransform, boolean drawVertices, MathTransform mt) {
        if (feature == null) {
            return;
        }
        this.drawFeature(graphics, feature, worldToScreenTransform, drawVertices, Drawing.getSymbolizers(feature), mt);
    }

    public void drawFeature(ViewportGraphics graphics, SimpleFeature feature, AffineTransform worldToScreenTransform) {
        if (feature == null) {
            return;
        }
        this.drawFeature(graphics, feature, worldToScreenTransform, false, Drawing.getSymbolizers(feature), null);
    }

    public void drawFeature(ViewportGraphics graphics, SimpleFeature feature, AffineTransform worldToScreenTransform, Style style) {
        if (feature == null) {
            return;
        }
        this.drawFeature(graphics, feature, worldToScreenTransform, false, this.getSymbolizers(style), null);
    }

    public void drawFeature(ViewportGraphics graphics, SimpleFeature feature, Style style, AffineTransform worldToScreenTransform) {
        if (feature == null) {
            return;
        }
        this.drawFeature(graphics, feature, worldToScreenTransform, false, this.getSymbolizers(style), null);
    }

    Symbolizer[] getSymbolizers(Style style) {
        ArrayList<Symbolizer> symbs = new ArrayList<Symbolizer>();
        FeatureTypeStyle[] styles = style.getFeatureTypeStyles();
        int i = 0;
        while (i < styles.length) {
            FeatureTypeStyle fstyle = styles[i];
            Rule[] rules = fstyle.getRules();
            int j = 0;
            while (j < rules.length) {
                Rule rule = rules[j];
                symbs.addAll(Arrays.asList(rule.getSymbolizers()));
                ++j;
            }
            ++i;
        }
        return symbs.toArray(new Symbolizer[symbs.size()]);
    }

    Symbolizer[] getSymbolizers(Rule rule) {
        ArrayList<Symbolizer> symbs = new ArrayList<Symbolizer>();
        symbs.addAll(Arrays.asList(rule.getSymbolizers()));
        return symbs.toArray(new Symbolizer[symbs.size()]);
    }

    public void drawFeature(ViewportGraphics graphics, SimpleFeature feature, AffineTransform worldToScreenTransform, boolean drawVertices, Symbolizer[] symbs, MathTransform mt) {
        LiteShape shape = new LiteShape(null, worldToScreenTransform, false);
        if (symbs == null) {
            return;
        }
        int m = 0;
        while (m < symbs.length) {
            this.drawFeature(graphics, feature, worldToScreenTransform, drawVertices, symbs[m], mt, shape);
            ++m;
        }
    }

    public void drawFeature(ViewportGraphics graphics, SimpleFeature feature, AffineTransform worldToScreenTransform, boolean drawVertices, Symbolizer symbolizer, MathTransform mathTransform, LiteShape shape) {
        if (!(symbolizer instanceof RasterSymbolizer)) {
            Geometry g = this.findGeometry(feature, symbolizer);
            if (g == null) {
                return;
            }
            if (mathTransform != null) {
                try {
                    g = JTS.transform((Geometry)g, (MathTransform)mathTransform);
                }
                catch (Exception exception) {}
            }
            shape.setGeometry(g);
            this.paint(graphics, feature, shape, symbolizer);
            if (drawVertices) {
                double averageDistance = 0.0;
                Coordinate[] coords = g.getCoordinates();
                java.awt.Point oldP = this.worldToPixel(coords[0], worldToScreenTransform);
                int i = 1;
                while (i < coords.length) {
                    Coordinate coord = coords[i];
                    java.awt.Point p = this.worldToPixel(coord, worldToScreenTransform);
                    averageDistance += p.distance(oldP) / (double)i;
                    oldP = p;
                    ++i;
                }
                int pixels = 1;
                if (averageDistance > 20.0) {
                    pixels = 3;
                }
                if (averageDistance > 60.0) {
                    pixels = 5;
                }
                if (pixels > 1) {
                    graphics.setColor(Color.RED);
                    int i2 = 0;
                    while (i2 < coords.length) {
                        Coordinate coord = coords[i2];
                        java.awt.Point p = this.worldToPixel(coord, worldToScreenTransform);
                        graphics.fillRect(p.x - (pixels - 1) / 2, p.y - (pixels - 1) / 2, pixels, pixels);
                        ++i2;
                    }
                }
            }
        }
    }

    public java.awt.Point worldToPixel(Coordinate coord, AffineTransform worldToScreenTransform) {
        Point2D.Double w = new Point2D.Double(coord.x, coord.y);
        AffineTransform at = worldToScreenTransform;
        Point2D p = at.transform(w, new Point2D.Double());
        return new java.awt.Point((int)p.getX(), (int)p.getY());
    }

    private void paint(ViewportGraphics g, SimpleFeature feature, LiteShape shape, Symbolizer symb) {
        if (symb instanceof PolygonSymbolizer) {
            PolygonSymbolizer polySymb = (PolygonSymbolizer)symb;
            double opacity = SLDs.polyFillOpacity((PolygonSymbolizer)polySymb);
            Color fillColor = SLDs.polyFill((PolygonSymbolizer)polySymb);
            Stroke stroke = SLDs.stroke((PolygonSymbolizer)polySymb);
            Color strokeColor = SLDs.polyColor((PolygonSymbolizer)polySymb);
            int width = SLDs.width((Stroke)stroke);
            if (width == -1) {
                width = 1;
            }
            if (Double.isNaN(opacity)) {
                opacity = 1.0;
            }
            if (fillColor != null) {
                fillColor = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), (int)(255.0 * opacity));
                g.setColor(fillColor);
                g.fill((Shape)shape);
            }
            if (stroke != null && strokeColor != null) {
                Graphics2D g2d = (Graphics2D)g.getGraphics(Graphics2D.class);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(strokeColor);
                float[] dashArray = stroke.getDashArray();
                Float dashOffset = (Float)stroke.getDashOffset().evaluate(null, Float.class);
                if (dashOffset == null) {
                    dashOffset = Float.valueOf(0.0f);
                }
                String cap = (String)stroke.getLineCap().evaluate(null, String.class);
                int capInt = Utilities.sld2awtCap(cap);
                String join = (String)stroke.getLineJoin().evaluate(null, String.class);
                int joinInt = Utilities.sld2awtJoin(join);
                BasicStroke bStroke = new BasicStroke(width, capInt, joinInt, 1.0f, dashArray, dashOffset.floatValue());
                g2d.setStroke(bStroke);
                g2d.draw((Shape)shape);
            }
        }
        if (symb instanceof LineSymbolizer) {
            LineSymbolizer lineSymbolizer = (LineSymbolizer)symb;
            Color c = SLDs.color((LineSymbolizer)lineSymbolizer);
            int w = SLDs.width((LineSymbolizer)lineSymbolizer);
            Stroke stroke = SLDs.stroke((LineSymbolizer)lineSymbolizer);
            if (c != null && w > 0) {
                Graphics2D g2d = (Graphics2D)g.getGraphics(Graphics2D.class);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(c);
                float[] dashArray = stroke.getDashArray();
                Float dashOffset = (Float)stroke.getDashOffset().evaluate(null, Float.class);
                if (dashOffset == null) {
                    dashOffset = Float.valueOf(0.0f);
                }
                String cap = (String)stroke.getLineCap().evaluate(null, String.class);
                int capInt = Utilities.sld2awtCap(cap);
                String join = (String)stroke.getLineJoin().evaluate(null, String.class);
                int joinInt = Utilities.sld2awtJoin(join);
                BasicStroke bStroke = new BasicStroke(w, capInt, joinInt, 1.0f, dashArray, dashOffset.floatValue());
                g2d.setStroke(bStroke);
                g2d.draw((Shape)shape);
            }
        }
        if (symb instanceof PointSymbolizer) {
            MarkStyle2D style;
            PointSymbolizer pointSymbolizer = (PointSymbolizer)symb;
            g.getTransform();
            Point2D offset = Utilities.getOffset((Symbolizer)pointSymbolizer);
            if (offset != null) {
                java.awt.Point off = new java.awt.Point((int)offset.getX(), -1 * (int)offset.getY());
                g.translate(off);
            }
            Graphic graphic = SLDs.graphic((PointSymbolizer)pointSymbolizer);
            Double rotation = (Double)graphic.getRotation().evaluate(null, Double.class);
            Double gSize = (Double)graphic.getSize().evaluate(null, Double.class);
            if (gSize != null && rotation != null) {
                g.setTransform(AffineTransform.getRotateInstance(Math.toRadians(rotation), gSize / 2.0, gSize / 2.0));
            }
            Color c = SLDs.pointStrokeColorWithAlpha((PointSymbolizer)pointSymbolizer);
            Color fill = SLDs.pointFillWithAlpha((PointSymbolizer)pointSymbolizer);
            int width = SLDs.width((Stroke)SLDs.stroke((PointSymbolizer)pointSymbolizer));
            if (width < 0) {
                width = 0;
            }
            float[] point = new float[6];
            PathIterator pathIterator = shape.getPathIterator(null);
            pathIterator.currentSegment(point);
            SLDStyleFactory styleFactory = new SLDStyleFactory();
            Style2D tmp = null;
            try {
                tmp = styleFactory.createStyle((Object)feature, (Symbolizer)pointSymbolizer, (Range)new NumberRange(Double.class, (Number)Double.NEGATIVE_INFINITY, (Number)Double.POSITIVE_INFINITY));
            }
            catch (Exception exception) {
                new PointSymbolizerWrapper((Symbolizer)pointSymbolizer, null);
                tmp = styleFactory.createStyle((Object)feature, (Symbolizer)pointSymbolizer, (Range)new NumberRange(Double.class, (Number)Double.NEGATIVE_INFINITY, (Number)Double.POSITIVE_INFINITY));
            }
            if (tmp instanceof MarkStyle2D) {
                style = (MarkStyle2D)tmp;
                Shape shape2 = style.getTransformedShape(point[0], point[1]);
                if (c == null) {
                    // empty if block
                }
                if (fill != null) {
                    g.setColor(fill);
                    g.fill(shape2);
                }
                if (c != null) {
                    g.setStroke(1, width);
                    g.setColor(c);
                    g.draw(shape2);
                }
            } else if (tmp instanceof GraphicStyle2D) {
                style = (GraphicStyle2D)tmp;
                BufferedImage image = style.getImage();
                g.drawImage((RenderedImage)image, (int)((double)point[0] - (double)image.getWidth() / 2.0), (int)((double)point[1] - (double)image.getHeight() / 2.0));
            }
        }
    }

    public static Symbolizer[] getSymbolizers(SimpleFeature feature) {
        return Drawing.getSymbolizers(feature.getDefaultGeometry().getClass(), Color.RED);
    }

    public static Symbolizer[] getSymbolizers(Class<? extends Geometry> type, Color baseColor) {
        return Drawing.getSymbolizers(type, baseColor, true);
    }

    public static Symbolizer[] getSymbolizers(Class<? extends Geometry> type, Color baseColor, boolean useTransparency) {
        StyleBuilder builder = new StyleBuilder();
        Symbolizer[] syms = new Symbolizer[1];
        if (LineString.class.isAssignableFrom(type) || MultiLineString.class.isAssignableFrom(type)) {
            syms[0] = builder.createLineSymbolizer(baseColor, 2.0);
        }
        if (Point.class.isAssignableFrom(type) || MultiPoint.class.isAssignableFrom(type)) {
            PointSymbolizer point = builder.createPointSymbolizer(builder.createGraphic());
            FilterFactory2 ff = builder.getFilterFactory();
            point.getGraphic().setSize((Expression)ff.literal(10));
            Mark mark = (Mark)point.getGraphic().graphicalSymbols().get(0);
            mark.setFill((Fill)builder.createFill(baseColor));
            syms[0] = point;
        }
        if (Polygon.class.isAssignableFrom(type) || MultiPolygon.class.isAssignableFrom(type)) {
            syms[0] = builder.createPolygonSymbolizer(builder.createStroke(baseColor, 2.0), builder.createFill(baseColor, useTransparency ? 0.6 : 1.0));
        }
        return syms;
    }

    private Geometry findGeometry(SimpleFeature feature, Symbolizer symbolizer) {
        String geomName = this.getGeometryPropertyName(symbolizer);
        Geometry geometry = geomName == null || feature.getType().getDescriptor(geomName) == null ? (Geometry)feature.getDefaultGeometry() : (Geometry)feature.getAttribute(geomName);
        if (geometry == null) {
            return null;
        }
        if ((symbolizer instanceof PointSymbolizer || symbolizer instanceof TextSymbolizer) && !(geometry instanceof Point)) {
            if (geometry instanceof LineString && !(geometry instanceof LinearRing)) {
                Coordinate[] coordinates = geometry.getCoordinates();
                Coordinate start = coordinates[0];
                Coordinate end = coordinates[1];
                Coordinate mid = new Coordinate((start.x + end.x) / 2.0, (start.y + end.y) / 2.0);
                geometry = geometry.getFactory().createPoint(mid);
            } else {
                geometry = geometry.getCentroid();
            }
        }
        return geometry;
    }

    private String getGeometryPropertyName(Symbolizer s) {
        String geomName = null;
        if (s instanceof PolygonSymbolizer) {
            geomName = ((PolygonSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof PointSymbolizer) {
            geomName = ((PointSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof LineSymbolizer) {
            geomName = ((LineSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof TextSymbolizer) {
            geomName = ((TextSymbolizer)s).getGeometryPropertyName();
        }
        return geomName;
    }

    public static AffineTransform worldToScreenTransform(BoundingBox mapExtent, Rectangle screenSize) {
        double scaleX = screenSize.getWidth() / mapExtent.getWidth();
        double scaleY = screenSize.getHeight() / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + screenSize.getHeight();
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        return at;
    }

    public SimpleFeatureType schema(String name, String spec) {
        try {
            return DataUtilities.createType((String)name, (String)spec);
        }
        catch (SchemaException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public SimpleFeature feature(Geometry geom) {
        if (geom instanceof Polygon) {
            return this.feature((Polygon)geom);
        }
        if (geom instanceof MultiPolygon) {
            return this.feature((MultiPolygon)geom);
        }
        if (geom instanceof Point) {
            return this.feature((Point)geom);
        }
        if (geom instanceof LineString) {
            return this.feature((LineString)geom);
        }
        if (geom instanceof MultiPoint) {
            return this.feature((MultiPoint)geom);
        }
        if (geom instanceof MultiLineString) {
            return this.feature((MultiLineString)geom);
        }
        throw new IllegalArgumentException("Geometry is not supported to create feature");
    }

    public SimpleFeature feature(Point point) {
        if (point == null) {
            throw new NullPointerException("Point required");
        }
        try {
            return SimpleFeatureBuilder.build((SimpleFeatureType)pointSchema, (Object[])new Object[]{point}, null);
        }
        catch (IllegalAttributeException illegalAttributeException) {
            throw new RuntimeException("Could not generate feature for point " + point);
        }
    }

    public SimpleFeature feature(LineString line) {
        if (line == null) {
            throw new NullPointerException("line required");
        }
        try {
            return SimpleFeatureBuilder.build((SimpleFeatureType)lineSchema, (Object[])new Object[]{line}, null);
        }
        catch (IllegalAttributeException illegalAttributeException) {
            throw new RuntimeException("Could not generate feature for point " + line);
        }
    }

    public SimpleFeature feature(Polygon polygon) {
        if (polygon == null) {
            throw new NullPointerException("polygon required");
        }
        try {
            return SimpleFeatureBuilder.build((SimpleFeatureType)polygonSchema, (Object[])new Object[]{polygon}, null);
        }
        catch (IllegalAttributeException illegalAttributeException) {
            throw new RuntimeException("Could not generate feature for point " + polygon);
        }
    }

    public SimpleFeature feature(MultiPoint multipoint) {
        if (multipoint == null) {
            throw new NullPointerException("multipoint required");
        }
        try {
            return SimpleFeatureBuilder.build((SimpleFeatureType)multipointSchema, (Object[])new Object[]{multipoint}, null);
        }
        catch (IllegalAttributeException illegalAttributeException) {
            throw new RuntimeException("Could not generate feature for point " + multipoint);
        }
    }

    public SimpleFeature feature(MultiLineString multilinestring) {
        if (multilinestring == null) {
            throw new NullPointerException("multilinestring required");
        }
        try {
            return SimpleFeatureBuilder.build((SimpleFeatureType)multilineSchema, (Object[])new Object[]{multilinestring}, null);
        }
        catch (IllegalAttributeException illegalAttributeException) {
            throw new RuntimeException("Could not generate feature for point " + multilinestring);
        }
    }

    public SimpleFeature feature(MultiPolygon multipolygon) {
        if (multipolygon == null) {
            throw new NullPointerException("multipolygon required");
        }
        try {
            return SimpleFeatureBuilder.build((SimpleFeatureType)multipolygonSchema, (Object[])new Object[]{multipolygon}, null);
        }
        catch (IllegalAttributeException illegalAttributeException) {
            throw new RuntimeException("Could not generate feature for point " + multipolygon);
        }
    }

    public Point point(int x, int y) {
        return this.gf.createPoint(new Coordinate((double)x, (double)y));
    }

    public LineString line(int[] xy) {
        Coordinate[] coords = new Coordinate[xy.length / 2];
        int i = 0;
        while (i < xy.length) {
            coords[i / 2] = new Coordinate((double)xy[i], (double)xy[i + 1]);
            i += 2;
        }
        return this.gf.createLineString(coords);
    }

    public MultiLineString lines(int[][] xy) {
        LineString[] lines = new LineString[xy.length];
        int i = 0;
        while (i < xy.length) {
            lines[i] = this.line(xy[i]);
            ++i;
        }
        return this.gf.createMultiLineString(lines);
    }

    public Polygon polygon(int[] xy) {
        LinearRing shell = this.ring(xy);
        return this.gf.createPolygon(shell, null);
    }

    public Polygon polygon(int[] xy, int[][] holes) {
        if (holes == null || holes.length == 0) {
            return this.polygon(xy);
        }
        LinearRing shell = this.ring(xy);
        LinearRing[] rings = new LinearRing[holes.length];
        int i = 0;
        while (i < xy.length) {
            rings[i] = this.ring(holes[i]);
            ++i;
        }
        return this.gf.createPolygon(shell, rings);
    }

    public LinearRing ring(int[] xy) {
        int length = xy.length / 2;
        if (xy[0] != xy[xy.length - 2] || xy[1] != xy[xy.length - 1]) {
            ++length;
        }
        Coordinate[] coords = new Coordinate[length];
        int i = 0;
        while (i < xy.length) {
            coords[i / 2] = new Coordinate((double)xy[i], (double)xy[i + 1]);
            i += 2;
        }
        if (xy[0] != xy[xy.length - 2] || xy[1] != xy[xy.length - 1]) {
            coords[length - 1] = coords[0];
        }
        return this.gf.createLinearRing(coords);
    }
}

