/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.raster;

import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.raster.CoverageRule;
import eu.udig.style.advanced.raster.CoverageRuleComposite;
import eu.udig.style.advanced.raster.PredefinedColorRules;
import eu.udig.style.advanced.raster.RuleValues;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.Layer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.geotools.coverage.grid.GridCoverage2D;

public class CoverageColorEditor
extends Composite
implements SelectionListener {
    private ArrayList<CoverageRule> listOfRules = new ArrayList();
    private Button addRuleButton = null;
    private Button removeRuleButton = null;
    private Button moveRuleUpButton = null;
    private Button moveRuleDownButton = null;
    private Composite rulesComposite = null;
    private Group alphaGroup = null;
    private Scale alphaScale = null;
    private ScrolledComposite scrolledRulesComposite = null;
    private Layer layer;
    private Label alphaLabel = null;
    private Combo predefinedRulesCombo;
    private Button resetColormapButton;
    private HashMap<String, String[][]> colorRulesMap;
    private GridCoverage2D gridCoverage;
    private double[] minMax = null;
    private Text novaluesText;

    public CoverageColorEditor(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.verticalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 2;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.verticalAlignment = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        this.addRuleButton = new Button((Composite)this, 0);
        this.addRuleButton.setText("+");
        this.addRuleButton.setLayoutData((Object)gridData);
        this.addRuleButton.addSelectionListener((SelectionListener)this);
        this.removeRuleButton = new Button((Composite)this, 0);
        this.removeRuleButton.setText("-");
        this.removeRuleButton.setLayoutData((Object)gridData1);
        this.removeRuleButton.addSelectionListener((SelectionListener)this);
        this.moveRuleUpButton = new Button((Composite)this, 132);
        this.moveRuleUpButton.setLayoutData((Object)gridData2);
        this.moveRuleUpButton.addSelectionListener((SelectionListener)this);
        this.moveRuleDownButton = new Button((Composite)this, 1028);
        this.moveRuleDownButton.setLayoutData((Object)gridData3);
        this.moveRuleDownButton.addSelectionListener((SelectionListener)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)gridLayout);
        GridData gd = new GridData(4, 4, true, true);
        this.setLayoutData(gd);
        this.createScrolledRulesComposite();
        GridData gridDataBC = new GridData();
        gridDataBC.horizontalAlignment = 4;
        gridDataBC.horizontalSpan = 4;
        gridDataBC.verticalAlignment = 2;
        Composite buttonComposite = new Composite((Composite)this, 0);
        buttonComposite.setLayoutData((Object)gridDataBC);
        buttonComposite.setLayout((Layout)new GridLayout(8, true));
        Button selectAllButton = new Button(buttonComposite, 8);
        GridData selectAllGD = new GridData(4, 0x1000000, true, false);
        selectAllGD.horizontalSpan = 3;
        selectAllButton.setLayoutData((Object)selectAllGD);
        selectAllButton.setText(Messages.CoverageColorEditor_2);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (CoverageRule cRule : CoverageColorEditor.this.listOfRules) {
                    cRule.setActive(true);
                }
                CoverageColorEditor.this.redoLayout();
            }
        });
        Button unselectAllButton = new Button(buttonComposite, 8);
        GridData unselectAllGD = new GridData(4, 0x1000000, true, false);
        unselectAllGD.horizontalSpan = 3;
        unselectAllButton.setLayoutData((Object)unselectAllGD);
        unselectAllButton.setText(Messages.CoverageColorEditor_3);
        unselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (CoverageRule cRule : CoverageColorEditor.this.listOfRules) {
                    cRule.setActive(false);
                }
                CoverageColorEditor.this.redoLayout();
            }
        });
        Button invertSelectionButton = new Button(buttonComposite, 8);
        GridData invertSelectionGD = new GridData(4, 0x1000000, true, false);
        invertSelectionGD.horizontalSpan = 2;
        invertSelectionButton.setLayoutData((Object)invertSelectionGD);
        invertSelectionButton.setText(Messages.CoverageColorEditor_4);
        invertSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator iterator = CoverageColorEditor.this.listOfRules.iterator();
                while (iterator.hasNext()) {
                    CoverageRule cRule;
                    cRule.setActive(!(cRule = (CoverageRule)iterator.next()).isActive());
                }
                CoverageColorEditor.this.redoLayout();
            }
        });
        GridData resetGD = new GridData(4, 0x1000000, true, false);
        resetGD.horizontalSpan = 8;
        this.resetColormapButton = new Button(buttonComposite, 0);
        this.resetColormapButton.setText(Messages.CoverageColorEditor_5);
        this.resetColormapButton.setLayoutData((Object)resetGD);
        this.resetColormapButton.addSelectionListener((SelectionListener)this);
        Label predefinedRulesLabel = new Label(buttonComposite, 0);
        GridData rulesLabelGD = new GridData(4, 0x1000000, true, false);
        rulesLabelGD.horizontalSpan = 3;
        predefinedRulesLabel.setLayoutData((Object)rulesLabelGD);
        predefinedRulesLabel.setText(Messages.CoverageColorEditor_6);
        this.predefinedRulesCombo = new Combo(buttonComposite, 12);
        GridData comboGD = new GridData(4, 0x1000000, true, false);
        comboGD.horizontalSpan = 5;
        this.predefinedRulesCombo.setLayoutData((Object)comboGD);
        this.colorRulesMap = PredefinedColorRules.getColorsFolder(true);
        Set<String> keySet = this.colorRulesMap.keySet();
        Object[] rulesNames = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(rulesNames);
        this.predefinedRulesCombo.setItems((String[])rulesNames);
        this.predefinedRulesCombo.addSelectionListener((SelectionListener)this);
        this.createRulesComposite();
        GridLayout novaluesLayout = new GridLayout();
        novaluesLayout.numColumns = 4;
        GridData novaluesGD = new GridData();
        novaluesGD.horizontalSpan = 4;
        novaluesGD.verticalAlignment = 2;
        novaluesGD.grabExcessHorizontalSpace = true;
        novaluesGD.horizontalAlignment = 4;
        Group novaluesGroup = new Group((Composite)this, 0);
        novaluesGroup.setLayoutData((Object)novaluesGD);
        novaluesGroup.setLayout((Layout)novaluesLayout);
        novaluesGroup.setText(Messages.CoverageColorEditor_7);
        this.novaluesText = new Text((Composite)novaluesGroup, 18436);
        this.novaluesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.novaluesText.setText("-9999.0");
        Button addNovalueRulesButton = new Button((Composite)novaluesGroup, 8);
        addNovalueRulesButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        addNovalueRulesButton.setText(Messages.CoverageColorEditor_9);
        addNovalueRulesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                double[] nvArray = CoverageColorEditor.this.getExtraNovalues();
                if (nvArray.length > 0) {
                    double[] dArray = nvArray;
                    int n = nvArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        double nv = dArray[n2];
                        Color fromColor = Display.getDefault().getSystemColor(1);
                        Color toColor = Display.getDefault().getSystemColor(1);
                        CoverageRule rule = new CoverageRule(new double[]{nv, nv}, fromColor, toColor, 0.0, true);
                        CoverageColorEditor.this.listOfRules.add(0, rule);
                        CoverageColorEditor.this.redoLayout();
                        ++n2;
                    }
                }
            }
        });
        this.createAlphaGroup();
    }

    private void createRulesComposite() {
        GridData gridData4 = new GridData();
        gridData4.horizontalSpan = 4;
        gridData4.verticalAlignment = 4;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.grabExcessVerticalSpace = true;
        gridData4.horizontalAlignment = 4;
        this.rulesComposite = new Composite((Composite)this.scrolledRulesComposite, 0);
        this.rulesComposite.setLayout((Layout)new GridLayout());
        this.rulesComposite.setLayoutData((Object)gridData4);
        this.scrolledRulesComposite.setContent((Control)this.rulesComposite);
    }

    private void createScrolledRulesComposite() {
        GridData gridData7 = new GridData();
        gridData7.horizontalSpan = 4;
        gridData7.verticalAlignment = 4;
        gridData7.grabExcessVerticalSpace = true;
        gridData7.grabExcessHorizontalSpace = false;
        gridData7.horizontalAlignment = 4;
        this.scrolledRulesComposite = new ScrolledComposite((Composite)this, 2560);
        this.scrolledRulesComposite.setLayoutData((Object)gridData7);
        this.scrolledRulesComposite.setExpandHorizontal(true);
        this.scrolledRulesComposite.setExpandVertical(true);
        this.scrolledRulesComposite.setMinHeight(2000);
    }

    private void createAlphaGroup() {
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 4;
        GridData gridData6 = new GridData();
        gridData6.horizontalAlignment = 4;
        gridData6.grabExcessHorizontalSpace = true;
        gridData6.horizontalSpan = 3;
        gridData6.verticalAlignment = 2;
        GridData gridData5 = new GridData();
        gridData5.horizontalSpan = 4;
        gridData5.verticalAlignment = 2;
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.horizontalAlignment = 4;
        this.alphaGroup = new Group((Composite)this, 0);
        this.alphaGroup.setLayoutData((Object)gridData5);
        this.alphaGroup.setLayout((Layout)gridLayout1);
        this.alphaGroup.setText(Messages.CoverageColorEditor_10);
        this.alphaScale = new Scale((Composite)this.alphaGroup, 0);
        this.alphaScale.setLayoutData((Object)gridData6);
        this.alphaScale.setMinimum(0);
        this.alphaScale.setMaximum(100);
        this.alphaScale.setPageIncrement(10);
        this.alphaScale.setSelection(100);
        this.alphaLabel = new Label((Composite)this.alphaGroup, 0);
        this.alphaLabel.setText(String.valueOf(this.alphaScale.getSelection()));
        this.alphaScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int perspectiveValue = CoverageColorEditor.this.alphaScale.getSelection();
                CoverageColorEditor.this.alphaLabel.setText(String.valueOf(perspectiveValue));
            }
        });
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Combo combo;
        CoverageRule rule;
        Color toColor;
        Color fromColor;
        Object source = e.getSource();
        if (source instanceof Button) {
            CoverageRule r;
            Button selectedButton = (Button)source;
            if (selectedButton.equals(this.addRuleButton)) {
                CoverageRule r2 = new CoverageRule();
                this.listOfRules.add(0, r2);
                this.redoLayout();
            } else if (selectedButton.equals(this.removeRuleButton)) {
                int i = 0;
                while (i < this.listOfRules.size()) {
                    r = this.listOfRules.get(i);
                    if (r.isActive()) {
                        this.listOfRules.remove(r);
                    }
                    ++i;
                }
                this.redoLayout();
            } else if (selectedButton.equals(this.moveRuleUpButton)) {
                int i = 0;
                while (i < this.listOfRules.size()) {
                    r = this.listOfRules.get(i);
                    if (r.isActive() && i > 0) {
                        this.listOfRules.remove(r);
                        this.listOfRules.add(i - 1, r);
                    }
                    ++i;
                }
                this.redoLayout();
            } else if (selectedButton.equals(this.moveRuleDownButton)) {
                int i = 0;
                while (i < this.listOfRules.size()) {
                    r = this.listOfRules.get(i);
                    if (r.isActive() && i < this.listOfRules.size() - 1) {
                        this.listOfRules.remove(r);
                        this.listOfRules.add(i + 1, r);
                        ++i;
                    }
                    ++i;
                }
                this.redoLayout();
            } else if (selectedButton.equals(this.resetColormapButton)) {
                double[] nvArray = this.getExtraNovalues();
                RenderedImage renderedImage = this.gridCoverage.getRenderedImage();
                RectIter iter = RectIterFactory.create((RenderedImage)renderedImage, null);
                double min = Double.MAX_VALUE;
                double max = -4.9E-324;
                while (true) {
                    double value;
                    if (!Double.isNaN(value = iter.getSampleDouble())) {
                        boolean jump = false;
                        int i = 0;
                        while (i < nvArray.length) {
                            if (value - nvArray[i] < 1.0E-5) {
                                jump = true;
                                break;
                            }
                            ++i;
                        }
                        if (!jump) {
                            if (value < min) {
                                min = value;
                            }
                            if (value > max) {
                                max = value;
                            }
                        }
                    }
                    if (!iter.nextPixelDone()) continue;
                    iter.startPixels();
                    if (iter.nextLineDone()) break;
                }
                this.minMax = new double[]{min, max};
                fromColor = Display.getDefault().getSystemColor(1);
                toColor = Display.getDefault().getSystemColor(2);
                rule = new CoverageRule(this.minMax, fromColor, toColor, 1.0, true);
                this.listOfRules.clear();
                this.listOfRules.add(rule);
                this.redoLayout();
            }
        }
        if (source instanceof Combo && (combo = (Combo)source).equals(this.predefinedRulesCombo)) {
            int selectionIndex = this.predefinedRulesCombo.getSelectionIndex();
            String item = this.predefinedRulesCombo.getItem(selectionIndex);
            String[][] colorRules = this.colorRulesMap.get(item);
            try {
                this.listOfRules.clear();
                List<RuleValues> rulesValuesList = PredefinedColorRules.getRulesValuesList(colorRules, this.minMax);
                for (RuleValues ruleValues : rulesValuesList) {
                    double[] fromToValues = new double[]{ruleValues.fromValue, ruleValues.toValue};
                    fromColor = RuleValues.asSWT(ruleValues.fromColor);
                    toColor = RuleValues.asSWT(ruleValues.toColor);
                    rule = new CoverageRule(fromToValues, fromColor, toColor, 1.0, true);
                    this.listOfRules.add(rule);
                }
                this.redoLayout();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private double[] getExtraNovalues() {
        ArrayList<Double> novaluesList = new ArrayList<Double>();
        String novaluesStr = this.novaluesText.getText();
        if (novaluesStr != null && novaluesStr.length() > 0) {
            String[] nvSplit;
            String[] stringArray = nvSplit = novaluesStr.split(",");
            int n = nvSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String nvStr = stringArray[n2];
                try {
                    double nv = Double.parseDouble(nvStr.trim());
                    novaluesList.add(nv);
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        double[] nvArray = new double[novaluesList.size()];
        int i = 0;
        while (i < nvArray.length) {
            nvArray[i] = (Double)novaluesList.get(i);
            ++i;
        }
        return nvArray;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
        IGeoResource resource = layer.getGeoResource();
        try {
            this.gridCoverage = (GridCoverage2D)resource.resolve(GridCoverage2D.class, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setAlphaValue(final int value) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                CoverageColorEditor.this.alphaScale.setSelection(value);
                CoverageColorEditor.this.alphaLabel.setText(String.valueOf(value));
            }
        });
    }

    public int getAlphaVAlue() {
        try {
            return Integer.parseInt(this.alphaLabel.getText());
        }
        catch (Exception exception) {
            return 100;
        }
    }

    public void setRulesList(ArrayList<CoverageRule> listOfRules) {
        this.listOfRules = listOfRules;
        if (listOfRules.size() > 0) {
            CoverageRule coverageRule = listOfRules.get(0);
            double from = coverageRule.getFromToValues()[0];
            coverageRule = listOfRules.get(listOfRules.size() - 1);
            double to = coverageRule.getFromToValues()[1];
            this.minMax = new double[]{from, to};
        }
        this.redoLayout();
    }

    protected void redoLayout() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Control[] rulesControls = CoverageColorEditor.this.rulesComposite.getChildren();
                int i = 0;
                while (i < rulesControls.length) {
                    rulesControls[i].dispose();
                    ++i;
                }
                for (CoverageRule rule : CoverageColorEditor.this.listOfRules) {
                    new CoverageRuleComposite(CoverageColorEditor.this.rulesComposite, 2048, rule);
                }
                CoverageColorEditor.this.rulesComposite.layout();
            }
        });
    }

    public ArrayList<CoverageRule> getRulesList() {
        return this.listOfRules;
    }
}

