/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.points.widgets;

import eu.udig.style.advanced.common.IStyleChangesListener;
import eu.udig.style.advanced.common.ParameterComposite;
import eu.udig.style.advanced.common.styleattributeclasses.PointSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.utils.StolenColorEditor;
import eu.udig.style.advanced.utils.Utilities;
import java.awt.Color;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.opengis.filter.expression.Literal;

public class PointBoderParametersComposite
extends ParameterComposite {
    private final Composite parent;
    private final String[] numericAttributesArrays;
    private Composite mainComposite;
    private Button borderEnableButton;
    private Spinner borderWidthSpinner;
    private Combo borderWidthAttributecombo;
    private StolenColorEditor borderColorEditor;
    private Spinner borderOpacitySpinner;
    private Combo borderOpacityAttributecombo;
    private Button borderColorButton;

    public PointBoderParametersComposite(Composite parent, String[] numericAttributesArrays) {
        this.parent = parent;
        this.numericAttributesArrays = numericAttributesArrays;
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    public void init(RuleWrapper ruleWrapper) {
        Color tmpColor;
        int index;
        int index2;
        PointSymbolizerWrapper symbolizersWrapper = ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
        this.mainComposite = new Composite(this.parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)new GridLayout(3, true));
        boolean widgetEnabled = symbolizersWrapper.hasStroke();
        this.borderEnableButton = new Button(this.mainComposite, 32);
        GridData borderEnableButtonGD = new GridData(1, 0x1000000, false, false);
        borderEnableButtonGD.horizontalSpan = 3;
        this.borderEnableButton.setLayoutData((Object)borderEnableButtonGD);
        this.borderEnableButton.setText(Messages.PointBoderParametersComposite_0);
        this.borderEnableButton.setSelection(widgetEnabled);
        this.borderEnableButton.addSelectionListener((SelectionListener)this);
        new Label(this.mainComposite, 0);
        Label valueLabel = new Label(this.mainComposite, 0);
        valueLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        valueLabel.setText(Messages.PointBoderParametersComposite_1);
        Label fieldsLabel = new Label(this.mainComposite, 0);
        fieldsLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        fieldsLabel.setText(Messages.PointBoderParametersComposite_2);
        Label borderWidthLabel = new Label(this.mainComposite, 0);
        borderWidthLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        borderWidthLabel.setText(Messages.PointBoderParametersComposite_3);
        this.borderWidthSpinner = new Spinner(this.mainComposite, 2048);
        this.borderWidthSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.borderWidthSpinner.setMaximum(500);
        this.borderWidthSpinner.setMinimum(0);
        this.borderWidthSpinner.setIncrement(10);
        String width = symbolizersWrapper.getStrokeWidth();
        Double tmpWidth = this.isDouble(width);
        int tmp = 3;
        if (tmpWidth != null) {
            tmp = tmpWidth.intValue();
        }
        this.borderWidthSpinner.setSelection(tmp * 10);
        this.borderWidthSpinner.setDigits(1);
        this.borderWidthSpinner.addSelectionListener((SelectionListener)this);
        this.borderWidthAttributecombo = new Combo(this.mainComposite, 12);
        this.borderWidthAttributecombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.borderWidthAttributecombo.setItems(this.numericAttributesArrays);
        this.borderWidthAttributecombo.addSelectionListener((SelectionListener)this);
        this.borderWidthAttributecombo.select(0);
        if (tmpWidth == null && (index2 = this.getAttributeIndex(width, this.numericAttributesArrays)) != -1) {
            this.borderWidthAttributecombo.select(index2);
        }
        Label borderOpactityLabel = new Label(this.mainComposite, 0);
        borderOpactityLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        borderOpactityLabel.setText(Messages.PointBoderParametersComposite_4);
        this.borderOpacitySpinner = new Spinner(this.mainComposite, 2048);
        this.borderOpacitySpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.borderOpacitySpinner.setMaximum(100);
        this.borderOpacitySpinner.setMinimum(0);
        this.borderOpacitySpinner.setIncrement(10);
        String opacity = symbolizersWrapper.getStrokeOpacity();
        Double tmpOpacity = this.isDouble(opacity);
        tmp = 100;
        if (tmpOpacity != null) {
            tmp = (int)(tmpOpacity * 100.0);
        }
        this.borderOpacitySpinner.setSelection(tmp);
        this.borderOpacitySpinner.addSelectionListener((SelectionListener)this);
        this.borderOpacityAttributecombo = new Combo(this.mainComposite, 12);
        this.borderOpacityAttributecombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.borderOpacityAttributecombo.setItems(this.numericAttributesArrays);
        this.borderOpacityAttributecombo.addSelectionListener((SelectionListener)this);
        this.borderOpacityAttributecombo.select(0);
        if (tmpOpacity == null && (index = this.getAttributeIndex(opacity, this.numericAttributesArrays)) != -1) {
            this.borderOpacityAttributecombo.select(index);
        }
        Label borderColorLabel = new Label(this.mainComposite, 0);
        borderColorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        borderColorLabel.setText(Messages.PointBoderParametersComposite_5);
        try {
            tmpColor = Color.decode(symbolizersWrapper.getStrokeColor());
        }
        catch (Exception exception) {
            tmpColor = Color.gray;
        }
        this.borderColorEditor = new StolenColorEditor(this.mainComposite, (SelectionListener)this);
        this.borderColorEditor.setColor(tmpColor);
        this.borderColorButton = this.borderColorEditor.getButton();
        GridData borderColorButtonSIMPLEGD = new GridData(4, 0x1000000, true, false);
        borderColorButtonSIMPLEGD.horizontalSpan = 2;
        this.borderColorButton.setLayoutData((Object)borderColorButtonSIMPLEGD);
        this.checkEnablements();
    }

    public void update(RuleWrapper ruleWrapper) {
        int index;
        Color tmpColor;
        int index2;
        PointSymbolizerWrapper pointSymbolizerWrapper = ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
        boolean widgetEnabled = pointSymbolizerWrapper.hasStroke();
        this.borderEnableButton.setSelection(widgetEnabled);
        String width = pointSymbolizerWrapper.getStrokeWidth();
        Double tmpWidth = this.isDouble(width);
        int tmp = 3;
        if (tmpWidth != null) {
            tmp = tmpWidth.intValue();
        }
        this.borderWidthSpinner.setSelection(tmp * 10);
        if (tmpWidth == null && (index2 = this.getAttributeIndex(width, this.numericAttributesArrays)) != -1) {
            this.borderWidthAttributecombo.select(index2);
        }
        try {
            tmpColor = Color.decode(pointSymbolizerWrapper.getStrokeColor());
        }
        catch (Exception exception) {
            tmpColor = Color.gray;
        }
        this.borderColorEditor.setColor(tmpColor);
        String opacity = pointSymbolizerWrapper.getStrokeOpacity();
        Double tmpOpacity = this.isDouble(opacity);
        tmp = 100;
        if (tmpOpacity != null) {
            tmp = (int)(tmpOpacity * 100.0);
        }
        this.borderOpacitySpinner.setSelection(tmp);
        if (tmpOpacity == null && (index = this.getAttributeIndex(opacity, this.numericAttributesArrays)) != -1) {
            this.borderOpacityAttributecombo.select(index);
        }
        this.checkEnablements();
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.borderEnableButton)) {
            boolean selected = this.borderEnableButton.getSelection();
            this.notifyListeners(String.valueOf(selected), false, IStyleChangesListener.STYLEEVENTTYPE.BORDERENABLE);
        } else if (source.equals(this.borderWidthSpinner) || source.equals(this.borderWidthAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.borderWidthAttributecombo);
            if (comboIsNone) {
                int selection = this.borderWidthSpinner.getSelection();
                int digits = this.borderWidthSpinner.getDigits();
                double value = (double)selection / Math.pow(10.0, digits);
                String strokeWidth = String.valueOf(value);
                this.notifyListeners(strokeWidth, false, IStyleChangesListener.STYLEEVENTTYPE.BORDERWIDTH);
            } else {
                int index = this.borderWidthAttributecombo.getSelectionIndex();
                String field = this.borderWidthAttributecombo.getItem(index);
                if (field.length() == 0) {
                    return;
                }
                this.notifyListeners(field, true, IStyleChangesListener.STYLEEVENTTYPE.BORDERWIDTH);
            }
        } else if (source.equals(this.borderColorButton)) {
            Color color = this.borderColorEditor.getColor();
            Literal colorExpr = Utilities.ff.literal((Object)color);
            String strokeColor = (String)colorExpr.evaluate(null, String.class);
            this.notifyListeners(strokeColor, false, IStyleChangesListener.STYLEEVENTTYPE.BORDERCOLOR);
        } else if (source.equals(this.borderOpacitySpinner) || source.equals(this.borderOpacityAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.borderOpacityAttributecombo);
            if (comboIsNone) {
                int opacity = this.borderOpacitySpinner.getSelection();
                float opacityNorm = (float)opacity / 100.0f;
                String strokeOpacity = String.valueOf(opacityNorm);
                this.notifyListeners(strokeOpacity, false, IStyleChangesListener.STYLEEVENTTYPE.BORDEROPACITY);
            } else {
                int index = this.borderOpacityAttributecombo.getSelectionIndex();
                String field = this.borderOpacityAttributecombo.getItem(index);
                if (field.length() == 0) {
                    return;
                }
                this.notifyListeners(field, true, IStyleChangesListener.STYLEEVENTTYPE.BORDEROPACITY);
            }
        }
        this.checkEnablements();
    }

    private void checkEnablements() {
        boolean comboIsNone = this.comboIsNone(this.borderWidthAttributecombo);
        this.borderWidthSpinner.setEnabled(comboIsNone);
        comboIsNone = this.comboIsNone(this.borderOpacityAttributecombo);
        this.borderOpacitySpinner.setEnabled(comboIsNone);
    }
}

