/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.points;

import eu.udig.style.advanced.StylePlugin;
import eu.udig.style.advanced.common.StyleFilter;
import eu.udig.style.advanced.common.StyleManager;
import eu.udig.style.advanced.common.styleattributeclasses.FeatureTypeStyleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.StyleWrapper;
import eu.udig.style.advanced.utils.Utilities;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class PointStyleManager
extends StyleManager {
    public PointStyleManager() {
        IPath stateLocation = StylePlugin.getDefault().getStateLocation();
        File stateLocationFile = stateLocation.toFile();
        this.styleFolderFile = new File(stateLocationFile, POINTSTYLEFOLDER);
        if (!this.styleFolderFile.exists()) {
            this.styleFolderFile.mkdirs();
        }
    }

    public void init(Composite parent) {
        this.createStylesTableViewer(parent);
        this.reloadStyleFolder();
    }

    private TableViewer createStylesTableViewer(Composite parent) {
        final StyleFilter filter = new StyleFilter();
        final Text searchText = new Text(parent, 2176);
        searchText.setLayoutData((Object)new GridData(768));
        searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                filter.setSearchText(searchText.getText());
                PointStyleManager.this.stylesViewer.refresh();
            }
        });
        this.stylesViewer = new TableViewer(parent, 2052);
        Table table = this.stylesViewer.getTable();
        GridData tableGD = new GridData(4, 4, true, true);
        tableGD.heightHint = 200;
        table.setLayoutData((Object)tableGD);
        this.stylesViewer.addFilter((ViewerFilter)filter);
        this.stylesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    List styles = (List)inputElement;
                    Object[] array = styles.toArray(new StyleWrapper[styles.size()]);
                    return array;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.stylesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public org.eclipse.swt.graphics.Image getImage(Object element) {
                if (element instanceof StyleWrapper) {
                    StyleWrapper styleWrapper = (StyleWrapper)element;
                    List<FeatureTypeStyleWrapper> featureTypeStyles = styleWrapper.getFeatureTypeStylesWrapperList();
                    int iconSize = 48;
                    BufferedImage image = new BufferedImage(iconSize, iconSize, 2);
                    Graphics2D g2d = image.createGraphics();
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    for (FeatureTypeStyleWrapper featureTypeStyle : featureTypeStyles) {
                        List<RuleWrapper> rulesWrapperList = featureTypeStyle.getRulesWrapperList();
                        BufferedImage tmpImage = Utilities.pointRulesWrapperToImage(rulesWrapperList, iconSize, iconSize);
                        g2d.drawImage((Image)tmpImage, 0, 0, null);
                    }
                    g2d.dispose();
                    org.eclipse.swt.graphics.Image convertToSWTImage = AWTSWTImageUtils.convertToSWTImage((BufferedImage)image);
                    return convertToSWTImage;
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof StyleWrapper) {
                    StyleWrapper styleWrapper = (StyleWrapper)element;
                    String styleName = styleWrapper.getName();
                    if (styleName == null || styleName.length() == 0) {
                        styleName = "default style";
                        styleName = Utilities.checkSameNameStyle(PointStyleManager.this.getStyles(), styleName);
                        styleWrapper.setName(styleName);
                    }
                    return styleName;
                }
                return "";
            }
        });
        this.stylesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (sel.isEmpty()) {
                    return;
                }
                Object selectedItem = sel.getFirstElement();
                if (selectedItem == null) {
                    return;
                }
                if (selectedItem instanceof StyleWrapper) {
                    PointStyleManager.this.currentSelectedStyleWrapper = (StyleWrapper)selectedItem;
                }
            }
        });
        return this.stylesViewer;
    }

    public void importToStyle(File ... files) throws Exception {
        List<StyleWrapper> styles = this.getStyles();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            File newFile = new File(this.styleFolderFile, name);
            FileUtils.copyFile((File)file, (File)newFile);
            StyleWrapper style = Utilities.createStyleFromGraphic(newFile);
            styles.add(style);
            this.styleToDisk(style);
            ++n2;
        }
        this.stylesViewer.refresh(false, true);
    }
}

