/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.points;

import eu.udig.style.advanced.common.FiltersComposite;
import eu.udig.style.advanced.common.IStyleChangesListener;
import eu.udig.style.advanced.common.styleattributeclasses.PointSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.SymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.TextSymbolizerWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.points.PointPropertiesEditor;
import eu.udig.style.advanced.points.widgets.PointBoderParametersComposite;
import eu.udig.style.advanced.points.widgets.PointCharacterChooserComposite;
import eu.udig.style.advanced.points.widgets.PointFillParametersComposite;
import eu.udig.style.advanced.points.widgets.PointGeneralParametersComposite;
import eu.udig.style.advanced.points.widgets.PointLabelsParametersComposite;
import eu.udig.style.advanced.utils.Utilities;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import net.refractions.udig.style.sld.SLD;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.styling.Font;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.opengis.filter.Filter;

public class PointPropertiesComposite
extends SelectionAdapter
implements ModifyListener,
IStyleChangesListener {
    private static final String[] POINT_STYLE_TYPES = new String[]{Messages.PointPropertiesComposite_0, Messages.PointPropertiesComposite_1, Messages.PointPropertiesComposite_2};
    private static final String[] WK_MARK_NAMES = Utilities.wkMarkNames;
    private static final String TTF_PREFIX = "ttf://";
    private RuleWrapper ruleWrapper;
    private Composite simplePointComposite = null;
    private Composite graphicsPointComposite = null;
    private Composite fontPointComposite = null;
    private PointPropertiesEditor pointPropertiesEditor;
    private Composite mainComposite;
    private StackLayout mainStackLayout;
    private Combo wknMarksCombo;
    private String[] numericAttributesArrays;
    private String[] allAttributesArrays;
    private Text graphicsPathText;
    private Composite parentComposite;
    private Combo styleTypecombo;
    private final Composite parent;
    private PointGeneralParametersComposite generalParametersCompositeSIMPLE;
    private PointGeneralParametersComposite generalParametersCompositeGRAPHICS;
    private PointGeneralParametersComposite generalParametersCompositeFONT;
    private PointCharacterChooserComposite fontParametersComposite;
    private PointBoderParametersComposite borderParametersComposite;
    private PointBoderParametersComposite fontBorderParametersComposite;
    private PointFillParametersComposite fillParametersComposite;
    private PointFillParametersComposite fontFillParametersComposite;
    private PointLabelsParametersComposite labelsParametersComposite;
    private PointLabelsParametersComposite fontLabelsParametersComposite;
    private FiltersComposite filtersComposite;
    private FiltersComposite fontFiltersComposite;

    public PointPropertiesComposite(PointPropertiesEditor pointPropertiesEditor, Composite parent) {
        this.pointPropertiesEditor = pointPropertiesEditor;
        this.parent = parent;
    }

    public void setRule(RuleWrapper ruleWrapper) {
        this.ruleWrapper = ruleWrapper;
        if (this.mainComposite == null) {
            this.init();
            if (this.simplePointComposite == null) {
                this.createSimpleComposite();
            }
            if (this.graphicsPointComposite == null) {
                this.createGraphicsComposite();
            }
            if (this.fontPointComposite == null) {
                this.createFontComposite();
            }
        } else {
            this.update();
        }
        this.setRightPanel();
    }

    private void update() {
        SymbolizerWrapper geometrySymbolizersWrapper = this.ruleWrapper.getGeometrySymbolizersWrapper();
        PointSymbolizerWrapper pointSymbolizerWrapper = geometrySymbolizersWrapper.adapt(PointSymbolizerWrapper.class);
        this.filtersComposite.update(this.ruleWrapper);
        String markName = pointSymbolizerWrapper.getMarkName();
        if (pointSymbolizerWrapper.hasExternalGraphic()) {
            this.generalParametersCompositeGRAPHICS.update(this.ruleWrapper);
            this.graphicsPathText.removeModifyListener((ModifyListener)this);
            try {
                this.graphicsPathText.setText(pointSymbolizerWrapper.getExternalGraphicPath());
            }
            catch (MalformedURLException malformedURLException) {
                this.graphicsPathText.setText("");
            }
            this.graphicsPathText.addModifyListener((ModifyListener)this);
        } else if (markName != null && markName.toLowerCase().startsWith(TTF_PREFIX)) {
            this.generalParametersCompositeFONT.update(this.ruleWrapper);
            this.fontBorderParametersComposite.update(this.ruleWrapper);
            this.fontFillParametersComposite.update(this.ruleWrapper);
            this.fontLabelsParametersComposite.update(this.ruleWrapper);
        } else {
            this.generalParametersCompositeSIMPLE.update(this.ruleWrapper);
            this.borderParametersComposite.update(this.ruleWrapper);
            this.fillParametersComposite.update(this.ruleWrapper);
            this.labelsParametersComposite.update(this.ruleWrapper);
            if (markName == null) {
                markName = WK_MARK_NAMES[0];
            }
            int i = 0;
            while (i < WK_MARK_NAMES.length) {
                if (markName.equalsIgnoreCase(WK_MARK_NAMES[i])) {
                    this.wknMarksCombo.removeSelectionListener((SelectionListener)this);
                    this.wknMarksCombo.select(i);
                    this.wknMarksCombo.addSelectionListener((SelectionListener)this);
                    break;
                }
                ++i;
            }
        }
        this.pointPropertiesEditor.refreshTreeViewer(this.ruleWrapper);
        this.pointPropertiesEditor.refreshPreviewCanvasOnStyle();
    }

    private void init() {
        List<String> numericAttributeNames = this.pointPropertiesEditor.getNumericAttributeNames();
        this.numericAttributesArrays = numericAttributeNames.toArray(new String[numericAttributeNames.size()]);
        List<String> allAttributeNames = this.pointPropertiesEditor.getAllAttributeNames();
        this.allAttributesArrays = allAttributeNames.toArray(new String[allAttributeNames.size()]);
        this.parentComposite = new Composite(this.parent, 0);
        this.parentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.parentComposite.setLayout((Layout)new GridLayout(1, false));
        this.styleTypecombo = new Combo(this.parentComposite, 12);
        this.styleTypecombo.setLayoutData((Object)new GridData(1, 4, false, false));
        this.styleTypecombo.setItems(POINT_STYLE_TYPES);
        this.styleTypecombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PointSymbolizerWrapper pointSymbolizerWrapper = PointPropertiesComposite.this.ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
                int selectionIndex = PointPropertiesComposite.this.styleTypecombo.getSelectionIndex();
                if (selectionIndex == 0) {
                    int index = PointPropertiesComposite.this.wknMarksCombo.getSelectionIndex();
                    if (index != -1) {
                        String markName = PointPropertiesComposite.this.wknMarksCombo.getItem(index);
                        pointSymbolizerWrapper.setMarkName(markName);
                    }
                    ((PointPropertiesComposite)PointPropertiesComposite.this).mainStackLayout.topControl = PointPropertiesComposite.this.simplePointComposite;
                    PointPropertiesComposite.this.generalParametersCompositeSIMPLE.update(PointPropertiesComposite.this.ruleWrapper);
                    PointPropertiesComposite.this.pointPropertiesEditor.refreshTreeViewer(PointPropertiesComposite.this.ruleWrapper);
                    PointPropertiesComposite.this.pointPropertiesEditor.refreshPreviewCanvasOnStyle();
                } else if (selectionIndex == 1) {
                    try {
                        URL iconUrl = Platform.getBundle((String)"eu.udig.style.advanced").getResource("icons/delete.png");
                        String iconPath = "";
                        try {
                            iconPath = FileLocator.toFileURL((URL)iconUrl).getPath();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        pointSymbolizerWrapper.setExternalGraphicPath(iconPath);
                        PointPropertiesComposite.this.graphicsPathText.setText(iconPath);
                    }
                    catch (MalformedURLException malformedURLException) {}
                    ((PointPropertiesComposite)PointPropertiesComposite.this).mainStackLayout.topControl = PointPropertiesComposite.this.graphicsPointComposite;
                    PointPropertiesComposite.this.generalParametersCompositeGRAPHICS.update(PointPropertiesComposite.this.ruleWrapper);
                    PointPropertiesComposite.this.pointPropertiesEditor.refreshTreeViewer(PointPropertiesComposite.this.ruleWrapper);
                    PointPropertiesComposite.this.pointPropertiesEditor.refreshPreviewCanvasOnStyle();
                } else {
                    String markName = PointPropertiesComposite.this.fontParametersComposite.getCharacterPath();
                    pointSymbolizerWrapper.setMarkName(markName);
                    ((PointPropertiesComposite)PointPropertiesComposite.this).mainStackLayout.topControl = PointPropertiesComposite.this.fontPointComposite;
                    PointPropertiesComposite.this.generalParametersCompositeFONT.update(PointPropertiesComposite.this.ruleWrapper);
                    PointPropertiesComposite.this.pointPropertiesEditor.refreshTreeViewer(PointPropertiesComposite.this.ruleWrapper);
                    PointPropertiesComposite.this.pointPropertiesEditor.refreshPreviewCanvasOnStyle();
                }
                PointPropertiesComposite.this.mainComposite.layout();
            }
        });
        this.mainComposite = new Composite(this.parentComposite, 0);
        this.mainStackLayout = new StackLayout();
        this.mainComposite.setLayout((Layout)this.mainStackLayout);
        GridData mainCompositeGD = new GridData(4, 4, true, true);
        this.mainComposite.setLayoutData((Object)mainCompositeGD);
    }

    private void setRightPanel() {
        PointSymbolizerWrapper pointSymbolizerWrapper = this.ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
        String markName = pointSymbolizerWrapper.getMarkName();
        boolean hasExt = pointSymbolizerWrapper.hasExternalGraphic();
        if (hasExt) {
            this.styleTypecombo.select(1);
            this.mainStackLayout.topControl = this.graphicsPointComposite;
        } else if (markName != null && markName.toLowerCase().startsWith(TTF_PREFIX)) {
            this.styleTypecombo.select(2);
            this.mainStackLayout.topControl = this.fontPointComposite;
        } else {
            this.styleTypecombo.select(0);
            this.mainStackLayout.topControl = this.simplePointComposite;
        }
        this.mainComposite.layout();
    }

    public Composite getComposite() {
        return this.parentComposite;
    }

    private void createSimpleComposite() {
        PointSymbolizerWrapper pointSymbolizerWrapper = this.ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
        this.simplePointComposite = new Composite(this.mainComposite, 0);
        this.simplePointComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.simplePointComposite.setLayout((Layout)new GridLayout(1, false));
        Composite nameComposite = new Composite(this.simplePointComposite, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        nameComposite.setLayout((Layout)new GridLayout(2, true));
        this.wknMarksCombo = new Combo(this.simplePointComposite, 4);
        GridData wknMarksComboGD = new GridData(4, 0x1000000, true, false);
        this.wknMarksCombo.setLayoutData((Object)wknMarksComboGD);
        this.wknMarksCombo.setItems(WK_MARK_NAMES);
        String markName = pointSymbolizerWrapper.getMarkName();
        if (markName == null) {
            markName = WK_MARK_NAMES[0];
        }
        int i = 0;
        while (i < WK_MARK_NAMES.length) {
            if (markName.equalsIgnoreCase(WK_MARK_NAMES[i])) {
                this.wknMarksCombo.select(i);
                break;
            }
            ++i;
        }
        this.wknMarksCombo.addSelectionListener((SelectionListener)this);
        Group propertiesGroup = new Group(this.simplePointComposite, 16);
        propertiesGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        propertiesGroup.setLayout((Layout)new GridLayout(1, false));
        propertiesGroup.setText(Messages.PointPropertiesComposite_8);
        TabFolder tabFolder = new TabFolder((Composite)propertiesGroup, 2048);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.generalParametersCompositeSIMPLE = new PointGeneralParametersComposite((Composite)tabFolder, this.numericAttributesArrays);
        this.generalParametersCompositeSIMPLE.init(this.ruleWrapper);
        this.generalParametersCompositeSIMPLE.addListener(this);
        Composite generalParametersInternalComposite = this.generalParametersCompositeSIMPLE.getComposite();
        TabItem tabItem1 = new TabItem(tabFolder, 0);
        tabItem1.setText(Messages.PointPropertiesComposite_9);
        tabItem1.setControl((Control)generalParametersInternalComposite);
        this.borderParametersComposite = new PointBoderParametersComposite((Composite)tabFolder, this.numericAttributesArrays);
        this.borderParametersComposite.init(this.ruleWrapper);
        this.borderParametersComposite.addListener(this);
        Composite borderParametersInternalComposite = this.borderParametersComposite.getComposite();
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText(Messages.PointPropertiesComposite_10);
        tabItem2.setControl((Control)borderParametersInternalComposite);
        this.fillParametersComposite = new PointFillParametersComposite((Composite)tabFolder, this.numericAttributesArrays);
        this.fillParametersComposite.init(this.ruleWrapper);
        this.fillParametersComposite.addListener(this);
        Composite fillParametersInternalComposite = this.fillParametersComposite.getComposite();
        TabItem tabItem3 = new TabItem(tabFolder, 0);
        tabItem3.setText(Messages.PointPropertiesComposite_11);
        tabItem3.setControl((Control)fillParametersInternalComposite);
        this.labelsParametersComposite = new PointLabelsParametersComposite((Composite)tabFolder, this.numericAttributesArrays, this.allAttributesArrays);
        this.labelsParametersComposite.init(this.ruleWrapper);
        this.labelsParametersComposite.addListener(this);
        Composite labelParametersInternalComposite = this.labelsParametersComposite.getComposite();
        TabItem tabItem4 = new TabItem(tabFolder, 0);
        tabItem4.setText(Messages.PointPropertiesComposite_12);
        tabItem4.setControl((Control)labelParametersInternalComposite);
        this.filtersComposite = new FiltersComposite((Composite)tabFolder);
        this.filtersComposite.init(this.ruleWrapper);
        this.filtersComposite.addListener(this);
        Composite filtersInternalComposite = this.filtersComposite.getComposite();
        TabItem tabItem5 = new TabItem(tabFolder, 0);
        tabItem5.setText(Messages.PointPropertiesComposite_13);
        tabItem5.setControl((Control)filtersInternalComposite);
    }

    private void createGraphicsComposite() {
        PointSymbolizerWrapper pointSymbolizerWrapper = this.ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
        this.graphicsPointComposite = new Composite(this.mainComposite, 0);
        this.graphicsPointComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.graphicsPointComposite.setLayout((Layout)new GridLayout(1, false));
        Composite nameComposite = new Composite(this.graphicsPointComposite, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        nameComposite.setLayout((Layout)new GridLayout(2, true));
        Group pathGroup = new Group(this.graphicsPointComposite, 0);
        pathGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        pathGroup.setLayout((Layout)new GridLayout(2, false));
        pathGroup.setText(Messages.PointPropertiesComposite_14);
        this.graphicsPathText = new Text((Composite)pathGroup, 18436);
        this.graphicsPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        try {
            this.graphicsPathText.setText(pointSymbolizerWrapper.getExternalGraphicPath());
        }
        catch (MalformedURLException malformedURLException) {
            this.graphicsPathText.setText("");
        }
        this.graphicsPathText.addModifyListener((ModifyListener)this);
        Button pathButton = new Button((Composite)pathGroup, 8);
        pathButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        pathButton.setText("...");
        pathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(PointPropertiesComposite.this.graphicsPathText.getShell(), 4096);
                String path = fileDialog.open();
                if (path == null || path.length() < 1) {
                    PointPropertiesComposite.this.graphicsPathText.setText("");
                } else {
                    PointPropertiesComposite.this.graphicsPathText.setText(path);
                }
            }
        });
        Group genericsGroup = new Group(this.graphicsPointComposite, 0);
        genericsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        genericsGroup.setLayout((Layout)new GridLayout(1, true));
        genericsGroup.setText(Messages.PointPropertiesComposite_18);
        this.generalParametersCompositeGRAPHICS = new PointGeneralParametersComposite((Composite)genericsGroup, this.numericAttributesArrays);
        this.generalParametersCompositeGRAPHICS.init(this.ruleWrapper);
        this.generalParametersCompositeGRAPHICS.addListener(this);
    }

    private void createFontComposite() {
        this.fontPointComposite = new Composite(this.mainComposite, 0);
        this.fontPointComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fontPointComposite.setLayout((Layout)new GridLayout(1, false));
        Composite nameComposite = new Composite(this.fontPointComposite, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        nameComposite.setLayout((Layout)new GridLayout(2, true));
        Group propertiesGroup = new Group(this.fontPointComposite, 16);
        propertiesGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        propertiesGroup.setLayout((Layout)new GridLayout(1, false));
        propertiesGroup.setText(Messages.PointPropertiesComposite_19);
        TabFolder tabFolder = new TabFolder((Composite)propertiesGroup, 2048);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.fontParametersComposite = new PointCharacterChooserComposite((Composite)tabFolder);
        this.fontParametersComposite.init(this.ruleWrapper);
        this.fontParametersComposite.addListener(this);
        Composite fontParametersInternalComposite = this.fontParametersComposite.getComposite();
        TabItem tabItem1 = new TabItem(tabFolder, 0);
        tabItem1.setText(Messages.PointPropertiesComposite_20);
        tabItem1.setControl((Control)fontParametersInternalComposite);
        this.generalParametersCompositeFONT = new PointGeneralParametersComposite((Composite)tabFolder, this.numericAttributesArrays);
        this.generalParametersCompositeFONT.init(this.ruleWrapper);
        this.generalParametersCompositeFONT.addListener(this);
        Composite generalParametersInternalComposite = this.generalParametersCompositeFONT.getComposite();
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText(Messages.PointPropertiesComposite_21);
        tabItem2.setControl((Control)generalParametersInternalComposite);
        this.fontBorderParametersComposite = new PointBoderParametersComposite((Composite)tabFolder, this.numericAttributesArrays);
        this.fontBorderParametersComposite.init(this.ruleWrapper);
        this.fontBorderParametersComposite.addListener(this);
        Composite borderParametersInternalComposite = this.fontBorderParametersComposite.getComposite();
        TabItem tabItem3 = new TabItem(tabFolder, 0);
        tabItem3.setText(Messages.PointPropertiesComposite_22);
        tabItem3.setControl((Control)borderParametersInternalComposite);
        this.fontFillParametersComposite = new PointFillParametersComposite((Composite)tabFolder, this.numericAttributesArrays);
        this.fontFillParametersComposite.init(this.ruleWrapper);
        this.fontFillParametersComposite.addListener(this);
        Composite fillParametersInternalComposite = this.fontFillParametersComposite.getComposite();
        TabItem tabItem4 = new TabItem(tabFolder, 0);
        tabItem4.setText(Messages.PointPropertiesComposite_23);
        tabItem4.setControl((Control)fillParametersInternalComposite);
        this.fontLabelsParametersComposite = new PointLabelsParametersComposite((Composite)tabFolder, this.numericAttributesArrays, this.allAttributesArrays);
        this.fontLabelsParametersComposite.init(this.ruleWrapper);
        this.fontLabelsParametersComposite.addListener(this);
        Composite labelParametersInternalComposite = this.fontLabelsParametersComposite.getComposite();
        TabItem tabItem5 = new TabItem(tabFolder, 0);
        tabItem5.setText(Messages.PointPropertiesComposite_24);
        tabItem5.setControl((Control)labelParametersInternalComposite);
        this.fontFiltersComposite = new FiltersComposite((Composite)tabFolder);
        this.fontFiltersComposite.init(this.ruleWrapper);
        this.fontFiltersComposite.addListener(this);
        Composite filtersInternalComposite = this.fontFiltersComposite.getComposite();
        TabItem tabItem6 = new TabItem(tabFolder, 0);
        tabItem6.setText(Messages.PointPropertiesComposite_25);
        tabItem6.setControl((Control)filtersInternalComposite);
    }

    public void widgetSelected(SelectionEvent e) {
        int selectionIndex;
        Object source = e.getSource();
        PointSymbolizerWrapper pointSymbolizerWrapper = this.ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
        if (source.equals(this.wknMarksCombo) && (selectionIndex = this.wknMarksCombo.getSelectionIndex()) != -1) {
            String item = this.wknMarksCombo.getItem(selectionIndex);
            pointSymbolizerWrapper.setMarkName(item);
            this.pointPropertiesEditor.refreshTreeViewer(this.ruleWrapper);
            this.pointPropertiesEditor.refreshPreviewCanvasOnStyle();
        }
    }

    public void modifyText(ModifyEvent e) {
        Object source = e.getSource();
        if (source.equals(this.graphicsPathText)) {
            try {
                this.setNewGraphicPath();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
                return;
            }
        }
        this.pointPropertiesEditor.refreshTreeViewer(this.ruleWrapper);
        this.pointPropertiesEditor.refreshPreviewCanvasOnStyle();
    }

    private void setNewGraphicPath() throws MalformedURLException {
        String path = this.graphicsPathText.getText();
        if (!path.equals("")) {
            PointSymbolizerWrapper pointSymbolizerWrapper = this.ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
            pointSymbolizerWrapper.setExternalGraphicPath(path);
        }
    }

    @Override
    public void onStyleChanged(Object source, String[] values, boolean fromField, IStyleChangesListener.STYLEEVENTTYPE styleEventType) {
        String value = values[0];
        PointSymbolizerWrapper pointSymbolizerWrapper = this.ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
        TextSymbolizerWrapper textSymbolizerWrapper = this.ruleWrapper.getTextSymbolizersWrapper();
        switch (styleEventType) {
            case NAME: {
                this.ruleWrapper.setName(value);
                break;
            }
            case SIZE: {
                pointSymbolizerWrapper.setSize(value, fromField);
                break;
            }
            case ROTATION: {
                pointSymbolizerWrapper.setRotation(value, fromField);
                break;
            }
            case OFFSET: {
                pointSymbolizerWrapper.setOffset(value);
                break;
            }
            case MAXSCALE: {
                this.ruleWrapper.setMaxScale(value);
                break;
            }
            case MINSCALE: {
                this.ruleWrapper.setMinScale(value);
                break;
            }
            case BORDERENABLE: {
                boolean enabled = Boolean.parseBoolean(value);
                pointSymbolizerWrapper.setHasStroke(enabled);
                break;
            }
            case BORDERWIDTH: {
                pointSymbolizerWrapper.setStrokeWidth(value, fromField);
                break;
            }
            case BORDERCOLOR: {
                pointSymbolizerWrapper.setStrokeColor(value);
                break;
            }
            case BORDEROPACITY: {
                pointSymbolizerWrapper.setStrokeOpacity(value, fromField);
                break;
            }
            case FILLENABLE: {
                boolean enabled = Boolean.parseBoolean(value);
                pointSymbolizerWrapper.setHasFill(enabled);
                break;
            }
            case FILLCOLOR: {
                pointSymbolizerWrapper.setFillColor(value);
                break;
            }
            case FILLOPACITY: {
                pointSymbolizerWrapper.setFillOpacity(value, fromField);
                break;
            }
            case LABELENABLE: {
                boolean doEnable = Boolean.parseBoolean(value);
                if (doEnable) {
                    if (textSymbolizerWrapper != null) break;
                    TextSymbolizer textSymbolizer = Utilities.createDefaultTextSymbolizer(SLD.POINT);
                    this.ruleWrapper.addSymbolizer((Symbolizer)textSymbolizer, TextSymbolizerWrapper.class);
                    this.labelsParametersComposite.update(this.ruleWrapper);
                    break;
                }
                this.ruleWrapper.removeTextSymbolizersWrapper();
                break;
            }
            case LABEL: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setLabelName(value, fromField);
                break;
            }
            case LABELFONT: {
                if (textSymbolizerWrapper == null) break;
                String name = values[0];
                int style = Integer.parseInt(values[1]);
                int height = Integer.parseInt(values[2]);
                Font font = Utilities.sb.createFont(name, style == 2, style == 1, (double)height);
                textSymbolizerWrapper.setFont(font);
                break;
            }
            case LABELCOLOR: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setColor(value);
                break;
            }
            case LABELHALOCOLOR: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setHaloColor(value);
                break;
            }
            case LABELHALORADIUS: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setHaloRadius(value);
                break;
            }
            case LABELANCHOR: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setAnchorX(values[0]);
                textSymbolizerWrapper.setAnchorY(values[1]);
                break;
            }
            case LABELDISPLACEMENT: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setDisplacement(value);
                break;
            }
            case LABELROTATION: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setRotation(value, fromField);
                break;
            }
            case LABELMAXDISPLACEMENT_VO: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setMaxDisplacementVO(value);
                break;
            }
            case LABELAUTOWRAP_VO: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setAutoWrapVO(value);
                break;
            }
            case LABELSPACEAROUND_VO: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setSpaceAroundVO(value);
                break;
            }
            case FILTER: {
                if (value.length() <= 0) break;
                try {
                    Filter filter = ECQL.toFilter((String)value);
                    this.ruleWrapper.getRule().setFilter(filter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case MARKNAME: {
                pointSymbolizerWrapper.setMarkName(value);
                break;
            }
        }
        this.pointPropertiesEditor.refreshTreeViewer(this.ruleWrapper);
        this.pointPropertiesEditor.refreshPreviewCanvasOnStyle();
    }
}

