/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.lines.widgets;

import eu.udig.style.advanced.common.IStyleChangesListener;
import eu.udig.style.advanced.common.ParameterComposite;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.TextSymbolizerWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.utils.FontEditor;
import eu.udig.style.advanced.utils.StolenColorEditor;
import eu.udig.style.advanced.utils.Utilities;
import eu.udig.style.advanced.utils.VendorOptions;
import java.awt.Color;
import net.refractions.udig.style.sld.SLD;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.opengis.filter.expression.Literal;

public class LineLabelsParametersComposite
extends ParameterComposite {
    private final Composite parent;
    private final String[] numericAttributesArrays;
    private Composite mainComposite;
    private Button labelEnableButton;
    private Spinner labelOpacitySpinner;
    private Combo labelOpacityAttributecombo;
    private Button haloColorButton;
    private StolenColorEditor haloColorEditor;
    private Spinner haloRadiusSpinner;
    private Text initialGapText;
    private Text maxDisplacementText;
    private Text repeatText;
    private Text autoWrapText;
    private Text spaceAroundText;
    private FontEditor fontEditor;
    private Button fontButton;
    private StolenColorEditor fontColorEditor;
    private Button fontColorButton;
    private Text perpendicularOffsetText;
    private Text followLineText;
    private Text maxAngleDeltaText;
    private Text labelNameText;
    private Combo labelNameAttributecombo;
    private String[] allAttributesArrays;

    public LineLabelsParametersComposite(Composite parent, String[] numericAttributesArrays, String[] allAttributesArrays) {
        this.parent = parent;
        this.numericAttributesArrays = numericAttributesArrays;
        this.allAttributesArrays = allAttributesArrays;
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    public void init(RuleWrapper ruleWrapper) {
        int index;
        TextSymbolizerWrapper textSymbolizerWrapper = ruleWrapper.getTextSymbolizersWrapper();
        boolean widgetEnabled = true;
        if (textSymbolizerWrapper == null) {
            widgetEnabled = false;
            TextSymbolizer newSymbolizer = Utilities.createDefaultTextSymbolizer(SLD.LINE);
            textSymbolizerWrapper = new TextSymbolizerWrapper((Symbolizer)newSymbolizer, null, SLD.LINE);
        }
        this.mainComposite = new Composite(this.parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)new GridLayout(3, true));
        this.labelEnableButton = new Button(this.mainComposite, 32);
        GridData labelEnableButtonGD = new GridData(1, 0x1000000, false, false);
        labelEnableButtonGD.horizontalSpan = 3;
        this.labelEnableButton.setLayoutData((Object)labelEnableButtonGD);
        this.labelEnableButton.setText(Messages.LineLabelsParametersComposite_0);
        this.labelEnableButton.setSelection(widgetEnabled);
        this.labelEnableButton.addSelectionListener((SelectionListener)this);
        new Label(this.mainComposite, 0);
        Label valueLabel = new Label(this.mainComposite, 0);
        valueLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        valueLabel.setText(Messages.LineLabelsParametersComposite_1);
        Label fieldsLabel = new Label(this.mainComposite, 0);
        fieldsLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        fieldsLabel.setText(Messages.LineLabelsParametersComposite_2);
        Label labelNameLabel = new Label(this.mainComposite, 0);
        labelNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        labelNameLabel.setText(Messages.LineLabelsParametersComposite_3);
        this.labelNameText = new Text(this.mainComposite, 18436);
        GridData labelNameTextGD = new GridData(4, 0x1000000, true, false);
        this.labelNameText.setLayoutData((Object)labelNameTextGD);
        this.labelNameText.addFocusListener((FocusListener)this);
        this.labelNameAttributecombo = new Combo(this.mainComposite, 12);
        GridData labelNameAttributecomboGD = new GridData(4, 0x1000000, true, false);
        this.labelNameAttributecombo.setLayoutData((Object)labelNameAttributecomboGD);
        this.labelNameAttributecombo.setItems(this.allAttributesArrays);
        this.labelNameAttributecombo.addSelectionListener((SelectionListener)this);
        this.labelNameAttributecombo.select(0);
        String labelName = textSymbolizerWrapper.getLabelName();
        if (labelName != null) {
            int index2 = this.getAttributeIndex(labelName, this.allAttributesArrays);
            if (index2 != -1) {
                this.labelNameAttributecombo.select(index2);
            } else {
                this.labelNameText.setText(labelName);
            }
        } else {
            this.labelNameText.setText("");
        }
        Label labelOpactityLabel = new Label(this.mainComposite, 0);
        labelOpactityLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        labelOpactityLabel.setText(Messages.LineLabelsParametersComposite_5);
        this.labelOpacitySpinner = new Spinner(this.mainComposite, 2048);
        this.labelOpacitySpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelOpacitySpinner.setMaximum(100);
        this.labelOpacitySpinner.setMinimum(0);
        this.labelOpacitySpinner.setIncrement(10);
        String opacity = textSymbolizerWrapper.getOpacity();
        Double tmpOpacity = this.isDouble(opacity);
        int tmp = 100;
        if (tmpOpacity != null) {
            tmp = (int)(tmpOpacity * 100.0);
        }
        this.labelOpacitySpinner.setSelection(tmp);
        this.labelOpacitySpinner.addSelectionListener((SelectionListener)this);
        this.labelOpacityAttributecombo = new Combo(this.mainComposite, 12);
        this.labelOpacityAttributecombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelOpacityAttributecombo.setItems(this.numericAttributesArrays);
        this.labelOpacityAttributecombo.addSelectionListener((SelectionListener)this);
        this.labelOpacityAttributecombo.select(0);
        if (tmpOpacity == null && (index = this.getAttributeIndex(opacity, this.numericAttributesArrays)) != -1) {
            this.labelOpacityAttributecombo.select(index);
        }
        Label fontLabel = new Label(this.mainComposite, 0);
        fontLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        fontLabel.setText(Messages.LineLabelsParametersComposite_6);
        this.fontEditor = new FontEditor(this.mainComposite);
        GridData fontButtonGD = new GridData(4, 4, true, false);
        fontButtonGD.horizontalSpan = 2;
        this.fontButton = this.fontEditor.getButton();
        this.fontButton.setLayoutData((Object)fontButtonGD);
        this.fontEditor.setListener((SelectionListener)this);
        FontData[] fontData = textSymbolizerWrapper.getFontData();
        if (fontData != null) {
            this.fontEditor.setFontList(fontData);
        }
        Label fontColorLabel = new Label(this.mainComposite, 0);
        fontColorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        fontColorLabel.setText(Messages.LineLabelsParametersComposite_7);
        this.fontColorEditor = new StolenColorEditor(this.mainComposite, (SelectionListener)this);
        this.fontColorButton = this.fontColorEditor.getButton();
        GridData fontColorButtonGD = new GridData(4, 0x1000000, true, false);
        fontColorButtonGD.horizontalSpan = 2;
        this.fontColorButton.setLayoutData((Object)fontColorButtonGD);
        Color tmpColor = null;
        try {
            tmpColor = Color.decode(textSymbolizerWrapper.getColor());
        }
        catch (Exception exception) {
            tmpColor = Color.black;
        }
        this.fontColorEditor.setColor(tmpColor);
        Label haloLabel = new Label(this.mainComposite, 0);
        haloLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        haloLabel.setText(Messages.LineLabelsParametersComposite_8);
        this.haloColorEditor = new StolenColorEditor(this.mainComposite, (SelectionListener)this);
        this.haloColorButton = this.haloColorEditor.getButton();
        GridData haloColorButtonGD = new GridData(4, 0x1000000, true, false);
        this.haloColorButton.setLayoutData((Object)haloColorButtonGD);
        tmpColor = null;
        try {
            tmpColor = Color.decode(textSymbolizerWrapper.getHaloColor());
        }
        catch (Exception exception) {
            tmpColor = Color.black;
        }
        this.haloColorEditor.setColor(tmpColor);
        this.haloRadiusSpinner = new Spinner(this.mainComposite, 2048);
        this.haloRadiusSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.haloRadiusSpinner.setMaximum(20);
        this.haloRadiusSpinner.setMinimum(0);
        this.haloRadiusSpinner.setIncrement(1);
        String haloRadius = textSymbolizerWrapper.getHaloRadius();
        Double tmpRadius = this.isDouble(haloRadius);
        tmp = 0;
        if (tmpRadius != null) {
            tmp = tmpRadius.intValue();
        }
        this.haloRadiusSpinner.setSelection(tmp);
        this.haloRadiusSpinner.addSelectionListener((SelectionListener)this);
        Label perpendicularOffsetLabel = new Label(this.mainComposite, 0);
        perpendicularOffsetLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        perpendicularOffsetLabel.setText(Messages.LineLabelsParametersComposite_9);
        this.perpendicularOffsetText = new Text(this.mainComposite, 18436);
        GridData perpendicularOffsetTextGD = new GridData(4, 0x1000000, true, false);
        perpendicularOffsetTextGD.horizontalSpan = 2;
        this.perpendicularOffsetText.setLayoutData((Object)perpendicularOffsetTextGD);
        this.perpendicularOffsetText.addFocusListener((FocusListener)this);
        String perpendicularOffset = textSymbolizerWrapper.getPerpendicularOffset();
        if (perpendicularOffset != null) {
            this.perpendicularOffsetText.setText(perpendicularOffset);
        } else {
            this.perpendicularOffsetText.setText("");
        }
        Label initialGapLabel = new Label(this.mainComposite, 0);
        initialGapLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        initialGapLabel.setText(Messages.LineLabelsParametersComposite_11);
        this.initialGapText = new Text(this.mainComposite, 18436);
        GridData initialGapTextGD = new GridData(4, 0x1000000, true, false);
        initialGapTextGD.horizontalSpan = 2;
        this.initialGapText.setLayoutData((Object)initialGapTextGD);
        this.initialGapText.addFocusListener((FocusListener)this);
        String initialGap = textSymbolizerWrapper.getInitialGap();
        if (initialGap != null) {
            this.initialGapText.setText(initialGap);
        } else {
            this.initialGapText.setText("");
        }
        Group vendorOptionsGroup = new Group(this.mainComposite, 16);
        GridData vendorOptionsGD = new GridData(4, 4, true, true);
        vendorOptionsGD.horizontalSpan = 3;
        vendorOptionsGroup.setLayoutData((Object)vendorOptionsGD);
        vendorOptionsGroup.setLayout((Layout)new GridLayout(2, false));
        vendorOptionsGroup.setText(Messages.LineLabelsParametersComposite_13);
        Label maxDisplacementLabel = new Label((Composite)vendorOptionsGroup, 0);
        maxDisplacementLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        maxDisplacementLabel.setText(VendorOptions.VENDOROPTION_MAXDISPLACEMENT.toGuiString());
        this.maxDisplacementText = new Text((Composite)vendorOptionsGroup, 18436);
        GridData maxDisplacementTextGD = new GridData(4, 0x1000000, true, false);
        this.maxDisplacementText.setLayoutData((Object)maxDisplacementTextGD);
        this.maxDisplacementText.addFocusListener((FocusListener)this);
        String maxDisplacementVO = textSymbolizerWrapper.getMaxDisplacementVO();
        if (maxDisplacementVO != null) {
            this.maxDisplacementText.setText(maxDisplacementVO);
        } else {
            this.maxDisplacementText.setText("");
        }
        Label repeatLabel = new Label((Composite)vendorOptionsGroup, 0);
        repeatLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        repeatLabel.setText(VendorOptions.VENDOROPTION_REPEAT.toGuiString());
        this.repeatText = new Text((Composite)vendorOptionsGroup, 18436);
        GridData repeatTextGD = new GridData(4, 0x1000000, true, false);
        this.repeatText.setLayoutData((Object)repeatTextGD);
        this.repeatText.addFocusListener((FocusListener)this);
        String repeatVO = textSymbolizerWrapper.getRepeatVO();
        if (repeatVO != null) {
            this.repeatText.setText(repeatVO);
        } else {
            this.repeatText.setText("");
        }
        Label autoWrapLabel = new Label((Composite)vendorOptionsGroup, 0);
        autoWrapLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        autoWrapLabel.setText(VendorOptions.VENDOROPTION_AUTOWRAP.toGuiString());
        this.autoWrapText = new Text((Composite)vendorOptionsGroup, 18436);
        GridData autoWrapTextGD = new GridData(4, 0x1000000, true, false);
        this.autoWrapText.setLayoutData((Object)autoWrapTextGD);
        this.autoWrapText.addFocusListener((FocusListener)this);
        String autoWrapVO = textSymbolizerWrapper.getAutoWrapVO();
        if (autoWrapVO != null) {
            this.autoWrapText.setText(autoWrapVO);
        } else {
            this.autoWrapText.setText("");
        }
        Label spaceAroundLabel = new Label((Composite)vendorOptionsGroup, 0);
        spaceAroundLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        spaceAroundLabel.setText(VendorOptions.VENDOROPTION_SPACEAROUND.toGuiString());
        this.spaceAroundText = new Text((Composite)vendorOptionsGroup, 18436);
        GridData spaceAroundTextGD = new GridData(4, 0x1000000, true, false);
        this.spaceAroundText.setLayoutData((Object)spaceAroundTextGD);
        this.spaceAroundText.addFocusListener((FocusListener)this);
        String spaceAroundVO = textSymbolizerWrapper.getSpaceAroundVO();
        if (spaceAroundVO != null) {
            this.spaceAroundText.setText(spaceAroundVO);
        } else {
            this.spaceAroundText.setText("");
        }
        Label flollowLineLabel = new Label((Composite)vendorOptionsGroup, 0);
        flollowLineLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        flollowLineLabel.setText(VendorOptions.VENDOROPTION_FOLLOWLINE.toGuiString());
        this.followLineText = new Text((Composite)vendorOptionsGroup, 18436);
        GridData flollowLineTextGD = new GridData(4, 0x1000000, true, false);
        this.followLineText.setLayoutData((Object)flollowLineTextGD);
        this.followLineText.addFocusListener((FocusListener)this);
        String flollowLineVO = textSymbolizerWrapper.getFollowLineVO();
        if (flollowLineVO != null) {
            this.followLineText.setText(flollowLineVO);
        } else {
            this.followLineText.setText("");
        }
        Label maxAngleDeltaLabel = new Label((Composite)vendorOptionsGroup, 0);
        maxAngleDeltaLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        maxAngleDeltaLabel.setText(VendorOptions.VENDOROPTION_MAXANGLEDELTA.toGuiString());
        this.maxAngleDeltaText = new Text((Composite)vendorOptionsGroup, 18436);
        GridData maxAngleDeltaTextGD = new GridData(4, 0x1000000, true, false);
        this.maxAngleDeltaText.setLayoutData((Object)maxAngleDeltaTextGD);
        this.maxAngleDeltaText.addFocusListener((FocusListener)this);
        String maxAngleDeltaVO = textSymbolizerWrapper.getMaxAngleDeltaVO();
        if (maxAngleDeltaVO != null) {
            this.maxAngleDeltaText.setText(maxAngleDeltaVO);
        } else {
            this.maxAngleDeltaText.setText("");
        }
        this.checkEnablements();
    }

    public void update(RuleWrapper ruleWrapper) {
        int index;
        String color;
        TextSymbolizerWrapper textSymbolizerWrapper = ruleWrapper.getTextSymbolizersWrapper();
        if (textSymbolizerWrapper == null) {
            this.labelEnableButton.setSelection(false);
            return;
        }
        this.labelEnableButton.setSelection(true);
        String labelName = textSymbolizerWrapper.getLabelName();
        if (labelName != null) {
            int index2 = this.getAttributeIndex(labelName, this.allAttributesArrays);
            if (index2 != -1) {
                this.labelNameAttributecombo.select(index2);
            } else {
                this.labelNameText.setText(labelName);
            }
        } else {
            this.labelNameText.setText("");
        }
        FontData[] fontData = textSymbolizerWrapper.getFontData();
        if (fontData != null) {
            this.fontEditor.setFontList(fontData);
        }
        if ((color = textSymbolizerWrapper.getColor()) != null) {
            this.fontColorEditor.setColor(Color.decode(color));
        }
        String opacity = textSymbolizerWrapper.getOpacity();
        Double tmpOpacity = this.isDouble(opacity);
        int tmp = 100;
        if (tmpOpacity != null) {
            tmp = (int)(tmpOpacity * 100.0);
        }
        this.labelOpacitySpinner.setSelection(tmp);
        if (tmpOpacity == null && (index = this.getAttributeIndex(opacity, this.numericAttributesArrays)) != -1) {
            this.labelOpacityAttributecombo.select(index);
        }
        Color tmpColor = null;
        try {
            tmpColor = Color.decode(textSymbolizerWrapper.getHaloColor());
        }
        catch (Exception exception) {
            tmpColor = Color.black;
        }
        this.haloColorEditor.setColor(tmpColor);
        String haloRadius = textSymbolizerWrapper.getHaloRadius();
        Double tmpRadius = this.isDouble(haloRadius);
        tmp = 0;
        if (tmpRadius != null) {
            tmp = tmpRadius.intValue();
        }
        this.haloRadiusSpinner.setSelection(tmp);
        String perpendicularOffset = textSymbolizerWrapper.getPerpendicularOffset();
        if (perpendicularOffset != null) {
            this.perpendicularOffsetText.setText(perpendicularOffset);
        } else {
            this.perpendicularOffsetText.setText("");
        }
        String initialGap = textSymbolizerWrapper.getInitialGap();
        if (initialGap != null) {
            this.initialGapText.setText(initialGap);
        } else {
            this.initialGapText.setText("");
        }
        String maxDisplacementVO = textSymbolizerWrapper.getMaxDisplacementVO();
        if (maxDisplacementVO != null) {
            this.maxDisplacementText.setText(maxDisplacementVO);
        } else {
            this.maxDisplacementText.setText("");
        }
        String repeatVO = textSymbolizerWrapper.getRepeatVO();
        if (repeatVO != null) {
            this.repeatText.setText(repeatVO);
        } else {
            this.repeatText.setText("");
        }
        String autoWrapVO = textSymbolizerWrapper.getAutoWrapVO();
        if (autoWrapVO != null) {
            this.autoWrapText.setText(autoWrapVO);
        } else {
            this.autoWrapText.setText("");
        }
        String spaceAroundVO = textSymbolizerWrapper.getSpaceAroundVO();
        if (spaceAroundVO != null) {
            this.spaceAroundText.setText(spaceAroundVO);
        } else {
            this.spaceAroundText.setText(Messages.LineLabelsParametersComposite_26);
        }
        String flollowLineVO = textSymbolizerWrapper.getFollowLineVO();
        if (flollowLineVO != null) {
            this.followLineText.setText(flollowLineVO);
        } else {
            this.followLineText.setText(Messages.LineLabelsParametersComposite_27);
        }
        String maxAngleDeltaVO = textSymbolizerWrapper.getMaxAngleDeltaVO();
        if (maxAngleDeltaVO != null) {
            this.maxAngleDeltaText.setText(maxAngleDeltaVO);
        } else {
            this.maxAngleDeltaText.setText(Messages.LineLabelsParametersComposite_28);
        }
        this.checkEnablements();
    }

    private void checkEnablements() {
        boolean comboIsNone = this.comboIsNone(this.labelNameAttributecombo);
        boolean selected = this.labelEnableButton.getSelection();
        if (!selected) {
            this.setEnabled(false);
        } else {
            this.labelNameText.setEnabled(comboIsNone);
            comboIsNone = this.comboIsNone(this.labelOpacityAttributecombo);
            this.labelOpacitySpinner.setEnabled(comboIsNone);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.labelEnableButton)) {
            boolean selected = this.labelEnableButton.getSelection();
            this.setEnabled(selected);
            this.notifyListeners(String.valueOf(selected), false, IStyleChangesListener.STYLEEVENTTYPE.LABELENABLE);
        } else if (source.equals(this.labelNameAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.labelNameAttributecombo);
            if (comboIsNone) {
                String text = this.labelNameText.getText();
                this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABEL);
            } else {
                int index = this.labelNameAttributecombo.getSelectionIndex();
                String nameField = this.labelNameAttributecombo.getItem(index);
                this.notifyListeners(nameField, true, IStyleChangesListener.STYLEEVENTTYPE.LABEL);
            }
        } else if (source.equals(this.fontButton)) {
            FontData[] fontData = this.fontEditor.getFontList();
            if (fontData.length > 0) {
                FontData fd = fontData[0];
                String name = fd.getName();
                String style = String.valueOf(fd.getStyle());
                String height = String.valueOf(fd.getHeight());
                Color color = this.fontEditor.getAWTColor();
                Literal colorExpr = Utilities.ff.literal((Object)color);
                String fontColor = (String)colorExpr.evaluate(null, String.class);
                this.notifyListeners(new String[]{name, style, height, fontColor}, false, IStyleChangesListener.STYLEEVENTTYPE.LABELFONT);
            }
        } else if (source.equals(this.fontColorButton)) {
            Color color = this.fontColorEditor.getColor();
            Literal colorExpr = Utilities.ff.literal((Object)color);
            String fontColor = (String)colorExpr.evaluate(null, String.class);
            this.notifyListeners(fontColor, false, IStyleChangesListener.STYLEEVENTTYPE.LABELCOLOR);
        } else if (source.equals(this.haloColorButton)) {
            Color color = this.haloColorEditor.getColor();
            Literal colorExpr = Utilities.ff.literal((Object)color);
            String haloColor = (String)colorExpr.evaluate(null, String.class);
            this.notifyListeners(haloColor, false, IStyleChangesListener.STYLEEVENTTYPE.LABELHALOCOLOR);
        } else if (source.equals(this.haloRadiusSpinner)) {
            int radius = this.haloRadiusSpinner.getSelection();
            this.notifyListeners(String.valueOf(radius), false, IStyleChangesListener.STYLEEVENTTYPE.LABELHALORADIUS);
        } else if (source.equals(this.labelOpacitySpinner) || source.equals(this.labelOpacityAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.labelOpacityAttributecombo);
            if (comboIsNone) {
                int index = this.labelOpacityAttributecombo.getSelectionIndex();
                String opacityField = this.labelOpacityAttributecombo.getItem(index);
                this.notifyListeners(opacityField, true, IStyleChangesListener.STYLEEVENTTYPE.LABELOPACITY);
            } else {
                int opacity = this.labelOpacitySpinner.getSelection();
                String opacityStr = String.valueOf(opacity);
                this.notifyListeners(opacityStr, false, IStyleChangesListener.STYLEEVENTTYPE.LABELOPACITY);
            }
        }
        this.checkEnablements();
    }

    private void setEnabled(boolean enable) {
        this.labelOpacitySpinner.setEnabled(enable);
        this.labelOpacityAttributecombo.setEnabled(enable);
        this.haloColorButton.setEnabled(enable);
        this.haloColorEditor.setEnabled(enable);
        this.haloRadiusSpinner.setEnabled(enable);
        this.initialGapText.setEnabled(enable);
        this.maxDisplacementText.setEnabled(enable);
        this.repeatText.setEnabled(enable);
        this.autoWrapText.setEnabled(enable);
        this.spaceAroundText.setEnabled(enable);
        this.fontEditor.setEnabled(enable);
        this.fontButton.setEnabled(enable);
        this.fontColorEditor.setEnabled(enable);
        this.fontColorButton.setEnabled(enable);
        this.perpendicularOffsetText.setEnabled(enable);
        this.followLineText.setEnabled(enable);
        this.maxAngleDeltaText.setEnabled(enable);
        this.labelNameText.setEnabled(enable);
        this.labelNameAttributecombo.setEnabled(enable);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source.equals(this.initialGapText)) {
            String text = this.initialGapText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABELINITIALGAP);
        } else if (source.equals(this.perpendicularOffsetText)) {
            String text = this.perpendicularOffsetText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABELPERPENDICULAROFFSET);
        } else if (source.equals(this.maxDisplacementText)) {
            String text = this.maxDisplacementText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABELMAXDISPLACEMENT_VO);
        } else if (source.equals(this.spaceAroundText)) {
            String text = this.spaceAroundText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABELSPACEAROUND_VO);
        } else if (source.equals(this.autoWrapText)) {
            String text = this.autoWrapText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABELAUTOWRAP_VO);
        } else if (source.equals(this.repeatText)) {
            String text = this.repeatText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABELREPEAT_VO);
        } else if (source.equals(this.followLineText)) {
            String text = this.followLineText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABELFOLLOWLINE_VO);
        } else if (source.equals(this.maxAngleDeltaText)) {
            String text = this.maxAngleDeltaText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABELMAXANGLEDELTA_VO);
        } else if (source.equals(this.labelNameText)) {
            String text = this.labelNameText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABEL);
        }
        this.checkEnablements();
    }
}

