/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.lines;

import eu.udig.style.advanced.common.GroupRulesTreeContentProvider;
import eu.udig.style.advanced.common.GroupRulesTreeLabelProvider;
import eu.udig.style.advanced.common.PropertiesEditor;
import eu.udig.style.advanced.common.styleattributeclasses.FeatureTypeStyleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.LineSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.StyleWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.lines.LinePropertiesComposite;
import eu.udig.style.advanced.lines.LineStyleManager;
import eu.udig.style.advanced.utils.ImageCache;
import eu.udig.style.advanced.utils.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.style.internal.StyleLayer;
import net.refractions.udig.style.sld.SLD;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Style;

public class LinePropertiesEditor
extends PropertiesEditor {
    private Composite propertiesComposite;
    private StackLayout propertiesStackLayout;
    private LineStyleManager lineStyleManager;

    public LinePropertiesEditor(StyleLayer layer) {
        super(layer);
    }

    @Override
    protected void createGui(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)new GridLayout(2, true));
        Composite leftComposite = new Composite(this.mainComposite, 0);
        leftComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        leftComposite.setLayout((Layout)new GridLayout(1, false));
        Group rulesAndPreviewGroup = new Group(leftComposite, 64);
        rulesAndPreviewGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout rulesAndPreviewGroupLayout = new GridLayout(2, false);
        rulesAndPreviewGroupLayout.marginTop = 0;
        rulesAndPreviewGroup.setLayout((Layout)rulesAndPreviewGroupLayout);
        rulesAndPreviewGroup.setText(Messages.LinePropertiesEditor_0);
        Composite canvasComposite = new Composite((Composite)rulesAndPreviewGroup, 0);
        canvasComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        canvasComposite.setLayout((Layout)new GridLayout(1, false));
        this.previewCanvas = new Canvas(canvasComposite, 2048);
        GridData previewCanvasGD = new GridData(1, 128, true, true);
        previewCanvasGD.minimumHeight = 150;
        previewCanvasGD.minimumWidth = 150;
        this.previewCanvas.setSize(150, 150);
        this.previewCanvas.setBackground(this.white);
        this.previewCanvas.setLayoutData((Object)previewCanvasGD);
        this.previewCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (LinePropertiesEditor.this.previewImage == null) {
                    Display display = Display.getDefault();
                    LinePropertiesEditor.this.previewImage = new Image((Device)display, 150, 150);
                }
                e.gc.drawImage(LinePropertiesEditor.this.previewImage, 0, 0);
                e.gc.setLineWidth(1);
                e.gc.setLineStyle(3);
                e.gc.setForeground(LinePropertiesEditor.this.gray);
                e.gc.drawLine(75, 0, 75, 150);
                e.gc.drawLine(0, 75, 150, 75);
            }
        });
        Composite rulesComposite = new Composite((Composite)rulesAndPreviewGroup, 0);
        GridData rulesCompositeGD = new GridData(4, 4, true, false);
        rulesComposite.setLayoutData((Object)rulesCompositeGD);
        GridLayout rulesCompositeLayout = new GridLayout(6, true);
        rulesComposite.setLayout((Layout)rulesCompositeLayout);
        this.groupRulesTreeViewer = this.createGroupRulesTableViewer(rulesComposite);
        this.createRulesButtons(rulesComposite);
        this.groupRulesTreeViewer.setInput(this.styleWrapper.getFeatureTypeStylesWrapperList());
        Group styleViewerGroup = new Group(leftComposite, 0);
        GridData styleViewerGroupGD = new GridData(4, 4, true, true);
        styleViewerGroup.setLayoutData((Object)styleViewerGroupGD);
        styleViewerGroup.setLayout((Layout)new GridLayout(10, false));
        styleViewerGroup.setText(Messages.LinePropertiesEditor_1);
        Composite styleManagerComposite = new Composite((Composite)styleViewerGroup, 0);
        GridData styleManagerCompositeGD = new GridData(4, 4, true, true);
        styleManagerCompositeGD.horizontalSpan = 10;
        styleManagerComposite.setLayoutData((Object)styleManagerCompositeGD);
        styleManagerComposite.setLayout((Layout)new GridLayout(1, false));
        this.lineStyleManager = new LineStyleManager();
        this.lineStyleManager.init(styleManagerComposite);
        this.createStyleButtons((Composite)styleViewerGroup);
        Composite rightComposite = new Composite(this.mainComposite, 0);
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        rightComposite.setLayout((Layout)new GridLayout(1, false));
        this.propertiesComposite = new Composite(rightComposite, 0);
        this.propertiesStackLayout = new StackLayout();
        this.propertiesComposite.setLayout((Layout)this.propertiesStackLayout);
        GridData propertiesCompositeGD = new GridData(4, 4, true, true);
        this.propertiesComposite.setLayoutData((Object)propertiesCompositeGD);
        RuleWrapper ruleWrapper = this.styleWrapper.getFirstRule();
        if (ruleWrapper != null) {
            this.setRuleToSelected(ruleWrapper);
        } else {
            Label l = new Label(this.propertiesComposite, 16);
            l.setText(Messages.LinePropertiesEditor_2);
            this.propertiesStackLayout.topControl = l;
        }
    }

    private TreeViewer createGroupRulesTableViewer(Composite rulesGroup) {
        TreeViewer rulesViewer = new TreeViewer(rulesGroup, 2052);
        Control treeControl = rulesViewer.getControl();
        GridData treeGD = new GridData(4, 128, true, false);
        treeGD.horizontalSpan = 6;
        treeGD.heightHint = 100;
        treeControl.setLayoutData((Object)treeGD);
        rulesViewer.setContentProvider((IContentProvider)new GroupRulesTreeContentProvider());
        rulesViewer.setLabelProvider((IBaseLabelProvider)new GroupRulesTreeLabelProvider(SLD.LINE));
        rulesViewer.addSelectionChangedListener(new ISelectionChangedListener(){
            private LinePropertiesComposite linePropertieComposite;

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (sel.isEmpty()) {
                    this.showEmptyLabel();
                    return;
                }
                Object selectedItem = sel.getFirstElement();
                if (selectedItem == null) {
                    return;
                }
                if (selectedItem instanceof FeatureTypeStyleWrapper) {
                    this.showEmptyLabel();
                }
                if (selectedItem instanceof RuleWrapper) {
                    RuleWrapper currentSelectedRule = (RuleWrapper)selectedItem;
                    if (LinePropertiesEditor.this.propertiesComposite != null) {
                        if (this.linePropertieComposite == null) {
                            this.linePropertieComposite = new LinePropertiesComposite(LinePropertiesEditor.this, LinePropertiesEditor.this.propertiesComposite);
                        }
                        this.linePropertieComposite.setRule(currentSelectedRule);
                        ((LinePropertiesEditor)LinePropertiesEditor.this).propertiesStackLayout.topControl = this.linePropertieComposite.getComposite();
                        LinePropertiesEditor.this.propertiesComposite.layout();
                    }
                }
            }

            private void showEmptyLabel() {
                Label emptyLabel = new Label(LinePropertiesEditor.this.propertiesComposite, 0);
                emptyLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
                emptyLabel.setText(Messages.LinePropertiesEditor_3);
                ((LinePropertiesEditor)LinePropertiesEditor.this).propertiesStackLayout.topControl = emptyLabel;
                LinePropertiesEditor.this.propertiesComposite.layout();
            }
        });
        return rulesViewer;
    }

    private void createRulesButtons(Composite rulesGroup) {
        Image addGroupImg = ImageCache.getInstance().getImage("icons/addgroup.gif");
        Image addImg = ImageCache.getInstance().getImage("icons/add.gif");
        Image delImg = ImageCache.getInstance().getImage("icons/delete.gif");
        Image delAllImg = ImageCache.getInstance().getImage("icons/deleteall.gif");
        Image upImg = ImageCache.getInstance().getImage("icons/up.gif");
        Image downImg = ImageCache.getInstance().getImage("icons/down.gif");
        Button addGroupButton = new Button(rulesGroup, 8);
        addGroupButton.setLayoutData((Object)new GridData(4, 4, true, false));
        addGroupButton.setImage(addGroupImg);
        addGroupButton.setToolTipText(Messages.LinePropertiesEditor_4);
        addGroupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureTypeStyle featureTypeStyle = Utilities.sf.createFeatureTypeStyle();
                FeatureTypeStyleWrapper addedFeatureTypeStyle = LinePropertiesEditor.this.styleWrapper.addFeatureTypeStyle(featureTypeStyle);
                String tmpName = Messages.LinePropertiesEditor_5;
                tmpName = Utilities.checkSameNameFeatureTypeStyle(LinePropertiesEditor.this.styleWrapper.getFeatureTypeStylesWrapperList(), tmpName);
                addedFeatureTypeStyle.setName(tmpName);
                LinePropertiesEditor.this.reloadGroupsAndRules();
                LinePropertiesEditor.this.refreshPreviewCanvasOnStyle();
            }
        });
        final Button addButton = new Button(rulesGroup, 8);
        addButton.setLayoutData((Object)new GridData(4, 4, true, false));
        addButton.setImage(addImg);
        addButton.setToolTipText(Messages.LinePropertiesEditor_6);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleWrapper selectedRule;
                FeatureTypeStyleWrapper selectedFtsw = LinePropertiesEditor.this.getSelectedFtsw();
                if (selectedFtsw == null && (selectedRule = LinePropertiesEditor.this.getSelectedRule()) != null) {
                    selectedFtsw = selectedRule.getParent();
                }
                if (selectedFtsw == null) {
                    MessageDialog.openWarning((Shell)addButton.getShell(), (String)Messages.LinePropertiesEditor_7, (String)Messages.LinePropertiesEditor_8);
                    return;
                }
                RuleWrapper addedRuleWrapper = selectedFtsw.addRule(null, LineSymbolizerWrapper.class);
                String tmpName = Messages.LinePropertiesEditor_9;
                tmpName = Utilities.checkSameNameRule(addedRuleWrapper.getParent().getRulesWrapperList(), tmpName);
                addedRuleWrapper.setName(tmpName);
                LinePropertiesEditor.this.reloadGroupsAndRules();
                LinePropertiesEditor.this.refreshPreviewCanvasOnStyle();
                LinePropertiesEditor.this.setRuleToSelected(addedRuleWrapper);
            }
        });
        Button deleteButton = new Button(rulesGroup, 8);
        deleteButton.setLayoutData((Object)new GridData(4, 4, true, false));
        deleteButton.setImage(delImg);
        deleteButton.setToolTipText(Messages.LinePropertiesEditor_10);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureTypeStyleWrapper selectedFtsw = LinePropertiesEditor.this.getSelectedFtsw();
                RuleWrapper selectedRule = LinePropertiesEditor.this.getSelectedRule();
                if (selectedFtsw != null) {
                    LinePropertiesEditor.this.styleWrapper.removeFeatureTypeStyle(selectedFtsw);
                } else if (selectedRule != null) {
                    selectedRule.getParent().removeRule(selectedRule);
                } else {
                    MessageDialog.openWarning((Shell)addButton.getShell(), (String)Messages.LinePropertiesEditor_11, (String)Messages.LinePropertiesEditor_12);
                    return;
                }
                LinePropertiesEditor.this.reloadGroupsAndRules();
                LinePropertiesEditor.this.refreshPreviewCanvasOnStyle();
            }
        });
        Button deleteAllButton = new Button(rulesGroup, 8);
        deleteAllButton.setLayoutData((Object)new GridData(4, 4, true, false));
        deleteAllButton.setImage(delAllImg);
        deleteAllButton.setToolTipText(Messages.LinePropertiesEditor_13);
        deleteAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinePropertiesEditor.this.styleWrapper.clear();
                LinePropertiesEditor.this.reloadGroupsAndRules();
                LinePropertiesEditor.this.refreshPreviewCanvasOnStyle();
            }
        });
        Button upButton = new Button(rulesGroup, 8);
        upButton.setLayoutData((Object)new GridData(4, 4, true, false));
        upButton.setImage(upImg);
        upButton.setToolTipText(Messages.LinePropertiesEditor_14);
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinePropertiesEditor.this.swap(true);
            }
        });
        Button downButton = new Button(rulesGroup, 8);
        downButton.setLayoutData((Object)new GridData(4, 4, true, false));
        downButton.setImage(downImg);
        downButton.setToolTipText(Messages.LinePropertiesEditor_15);
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinePropertiesEditor.this.swap(false);
            }
        });
    }

    private void createStyleButtons(Composite rulesGroup) {
        Image saveImg = ImageCache.getInstance().getImage("icons/save.gif");
        Image saveAllImg = ImageCache.getInstance().getImage("icons/saveall.gif");
        Image delImg = ImageCache.getInstance().getImage("icons/delete.gif");
        Image loadImg = ImageCache.getInstance().getImage("icons/apply.gif");
        Image exportImg = ImageCache.getInstance().getImage("icons/export.gif");
        Image openImg = ImageCache.getInstance().getImage("icons/open.gif");
        Button saveButton = new Button(rulesGroup, 8);
        saveButton.setLayoutData((Object)new GridData(4, 4, true, false));
        saveButton.setImage(saveImg);
        saveButton.setToolTipText(Messages.LinePropertiesEditor_16);
        saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleWrapper selectedRule = LinePropertiesEditor.this.getSelectedRule();
                FeatureTypeStyle featureTypeStyle = Utilities.sf.createFeatureTypeStyle();
                featureTypeStyle.rules().add(selectedRule.getRule());
                Style namedStyle = Utilities.sf.createStyle();
                namedStyle.featureTypeStyles().add(featureTypeStyle);
                namedStyle.setName(selectedRule.getName());
                try {
                    LinePropertiesEditor.this.lineStyleManager.addStyle(new StyleWrapper(namedStyle));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        final Button saveAllButton = new Button(rulesGroup, 8);
        saveAllButton.setLayoutData((Object)new GridData(4, 4, true, false));
        saveAllButton.setImage(saveAllImg);
        saveAllButton.setToolTipText(Messages.LinePropertiesEditor_17);
        saveAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newStyleName = Messages.LinePropertiesEditor_18;
                InputDialog iDialog = new InputDialog(saveAllButton.getShell(), Messages.LinePropertiesEditor_19, Messages.LinePropertiesEditor_20, newStyleName, null);
                iDialog.setBlockOnOpen(true);
                int open = iDialog.open();
                if (open == 256) {
                    return;
                }
                String name = iDialog.getValue();
                if (name == null || name.length() == 0) {
                    name = newStyleName;
                }
                LinePropertiesEditor.this.styleWrapper.setName(name);
                try {
                    LinePropertiesEditor.this.lineStyleManager.addStyle(LinePropertiesEditor.this.styleWrapper);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        Button deleteButton = new Button(rulesGroup, 8);
        deleteButton.setLayoutData((Object)new GridData(4, 4, true, false));
        deleteButton.setImage(delImg);
        deleteButton.setToolTipText(Messages.LinePropertiesEditor_21);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyleWrapper styleWrapper = LinePropertiesEditor.this.lineStyleManager.getCurrentSelectedStyle();
                if (styleWrapper == null) {
                    return;
                }
                try {
                    LinePropertiesEditor.this.lineStyleManager.removeStyle(styleWrapper);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        Button loadButton = new Button(rulesGroup, 8);
        loadButton.setLayoutData((Object)new GridData(4, 4, true, false));
        loadButton.setImage(loadImg);
        loadButton.setToolTipText(Messages.LinePropertiesEditor_22);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyleWrapper styleWrapperToLoad = LinePropertiesEditor.this.lineStyleManager.getCurrentSelectedStyle();
                if (styleWrapperToLoad == null) {
                    return;
                }
                List<FeatureTypeStyleWrapper> featureTypeStylesWrapperList = styleWrapperToLoad.getFeatureTypeStylesWrapperList();
                for (FeatureTypeStyleWrapper featureTypeStyleWrapper : featureTypeStylesWrapperList) {
                    LinePropertiesEditor.this.styleWrapper.addFeatureTypeStyle(featureTypeStyleWrapper.getFeatureTypeStyle());
                }
                LinePropertiesEditor.this.reloadGroupsAndRules();
                LinePropertiesEditor.this.refreshPreviewCanvasOnStyle();
            }
        });
        final Button exportButton = new Button(rulesGroup, 8);
        exportButton.setLayoutData((Object)new GridData(4, 4, true, false));
        exportButton.setImage(exportImg);
        exportButton.setToolTipText(Messages.LinePropertiesEditor_23);
        exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IGeoResource geoResource = LinePropertiesEditor.this.layer.getGeoResource();
                ID id = geoResource.getID();
                if (id.isFile()) {
                    try {
                        File file = id.toFile();
                        LinePropertiesEditor.this.lineStyleManager.exportStyle(LinePropertiesEditor.this.styleWrapper, file);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    MessageDialog.openWarning((Shell)exportButton.getShell(), (String)Messages.LinePropertiesEditor_24, (String)Messages.LinePropertiesEditor_25);
                }
            }
        });
        Button openFolderButton = new Button(rulesGroup, 8);
        openFolderButton.setLayoutData((Object)new GridData(4, 4, true, false));
        openFolderButton.setImage(openImg);
        openFolderButton.setToolTipText(Messages.LinePropertiesEditor_26);
        openFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File styleFolderFile = LinePropertiesEditor.this.lineStyleManager.getStyleFolderFile();
                Program.launch((String)styleFolderFile.getAbsolutePath());
            }
        });
    }
}

