/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.editorpages;

import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.raster.CoverageColorEditor;
import eu.udig.style.advanced.raster.CoverageRule;
import java.util.ArrayList;
import java.util.MissingResourceException;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.style.internal.StyleLayer;
import net.refractions.udig.style.sld.SLDContentManager;
import net.refractions.udig.style.sld.editor.StyleEditorPage;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.renderer.i18n.Errors;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ColorMap;

public class CoverageStyleEditorPage
extends StyleEditorPage {
    public static String COVERAGERASTERSTYLEID = "eu.hydrologis.jgrass.coveragerasterstyle";
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private CoverageColorEditor colorRulesEditor = null;
    private boolean editorSupported = false;

    public CoverageStyleEditorPage() {
        this.setSize(new Point(500, 450));
    }

    public void createPageContent(Composite parent) {
        StyleLayer layer = this.getSelectedLayer();
        IGeoResource resource = layer.getGeoResource();
        this.editorSupported = resource.canResolve(GridCoverage.class);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        parent.setLayout((Layout)gridLayout);
        if (this.editorSupported) {
            this.colorRulesEditor = new CoverageColorEditor(parent, 0);
            StyleBlackboard styleBlackboard = layer.getStyleBlackboard();
            Style style = (Style)styleBlackboard.get("net.refractions.udig.style.sld");
            if (style == null) {
                style = this.createDefaultStyle();
                styleBlackboard.put("net.refractions.udig.style.sld", (Object)style);
                styleBlackboard.setSelected(new String[]{"net.refractions.udig.style.sld"});
            }
            style.setName(layer.getName());
            ArrayList<CoverageRule> listOfRules = new ArrayList<CoverageRule>();
            RasterSymbolizer rasterSymbolizer = SLDs.rasterSymbolizer((Style)style);
            org.geotools.styling.ColorMap colorMap = rasterSymbolizer.getColorMap();
            ColorMapEntry[] colorMapEntries = colorMap.getColorMapEntries();
            int i = 0;
            while (i < colorMapEntries.length - 1) {
                double fromQuantity = CoverageStyleEditorPage.getQuantity(colorMapEntries[i]);
                java.awt.Color f = CoverageStyleEditorPage.getColor(colorMapEntries[i]);
                double fromOpacity = CoverageStyleEditorPage.getOpacity(colorMapEntries[i]);
                double toQuantity = CoverageStyleEditorPage.getQuantity(colorMapEntries[i + 1]);
                java.awt.Color t = CoverageStyleEditorPage.getColor(colorMapEntries[i + 1]);
                Color fromColor = new Color((Device)Display.getDefault(), f.getRed(), f.getGreen(), f.getBlue());
                Color toColor = new Color((Device)Display.getDefault(), t.getRed(), t.getGreen(), t.getBlue());
                CoverageRule rule = new CoverageRule(new double[]{fromQuantity, toQuantity}, fromColor, toColor, fromOpacity, true);
                listOfRules.add(rule);
                i += 2;
            }
            this.colorRulesEditor.setLayer((Layer)layer);
            Double globalOpacity = (Double)rasterSymbolizer.getOpacity().evaluate(null, Double.class);
            if (globalOpacity != null) {
                this.colorRulesEditor.setAlphaValue((int)(globalOpacity * 100.0));
            } else {
                this.colorRulesEditor.setAlphaValue(100);
            }
            this.colorRulesEditor.setRulesList(listOfRules);
        } else {
            Label problemLabel = new Label(parent, 0);
            problemLabel.setText(Messages.CoverageStyleEditorPage_0);
        }
    }

    public String getErrorMessage() {
        return null;
    }

    public String getLabel() {
        return null;
    }

    public boolean performCancel() {
        return false;
    }

    public boolean okToLeave() {
        return true;
    }

    public boolean performApply() {
        return this.applyCurrentStyle();
    }

    public boolean performOk() {
        return this.applyCurrentStyle();
    }

    private boolean applyCurrentStyle() {
        try {
            if (this.editorSupported) {
                StyleLayer layer = this.getSelectedLayer();
                StyleBuilder sB = new StyleBuilder(this.sf);
                RasterSymbolizer rasterSym = this.sf.createRasterSymbolizer();
                org.geotools.styling.ColorMap colorMap = this.sf.createColorMap();
                ArrayList<CoverageRule> rulesList = this.colorRulesEditor.getRulesList();
                int i = 0;
                while (i < rulesList.size()) {
                    CoverageRule coverageRule = rulesList.get(i);
                    if (coverageRule.isActive()) {
                        Color fromColor = coverageRule.getFromColor();
                        Color toColor = coverageRule.getToColor();
                        double[] values = coverageRule.getFromToValues();
                        double opacity = coverageRule.getOpacity();
                        Expression fromColorExpr = sB.colorExpression(new java.awt.Color(fromColor.getRed(), fromColor.getGreen(), fromColor.getBlue(), 255));
                        Expression toColorExpr = sB.colorExpression(new java.awt.Color(toColor.getRed(), toColor.getGreen(), toColor.getBlue(), 255));
                        Expression fromExpr = sB.literalExpression(values[0]);
                        Expression toExpr = sB.literalExpression(values[1]);
                        Expression opacityExpr = sB.literalExpression(opacity);
                        ColorMapEntry entry = this.sf.createColorMapEntry();
                        entry.setQuantity(fromExpr);
                        entry.setColor(fromColorExpr);
                        entry.setOpacity(opacityExpr);
                        colorMap.addColorMapEntry(entry);
                        entry = this.sf.createColorMapEntry();
                        entry.setQuantity(toExpr);
                        entry.setOpacity(opacityExpr);
                        entry.setColor(toColorExpr);
                        colorMap.addColorMapEntry(entry);
                    }
                    ++i;
                }
                rasterSym.setColorMap((ColorMap)colorMap);
                rasterSym.setOpacity(sB.literalExpression((double)this.colorRulesEditor.getAlphaVAlue() / 100.0));
                Style newStyle = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{rasterSym});
                StyleLayer selLayer = this.getSelectedLayer();
                newStyle.setName(selLayer.getName());
                StyleBlackboard styleBlackboard = layer.getStyleBlackboard();
                styleBlackboard.put("net.refractions.udig.style.sld", (Object)newStyle);
                styleBlackboard.setSelected(new String[]{"net.refractions.udig.style.sld"});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = Messages.CoverageStyleEditorPage_2;
            ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.style.advanced", (Throwable)e);
            return false;
        }
        return true;
    }

    public void refresh() {
    }

    public void dispose() {
        if (this.editorSupported) {
            this.colorRulesEditor = null;
        }
        super.dispose();
    }

    public void styleChanged(Object source) {
    }

    public Style createDefaultStyle() {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
        StyleBuilder styleBuilder = new StyleBuilder(styleFactory);
        RasterSymbolizer rasterSymbolizer = styleFactory.createRasterSymbolizer();
        Rule rule = styleFactory.createRule();
        rule.setSymbolizers(new Symbolizer[]{rasterSymbolizer});
        Style style = styleBuilder.createStyle();
        SLDContentManager sldContentManager = new SLDContentManager(styleBuilder, style);
        sldContentManager.addSymbolizer((Symbolizer)rasterSymbolizer);
        FeatureTypeStyle fts = sldContentManager.getDefaultFeatureTypeStyle();
        fts.setFeatureTypeName("Feature");
        fts.setName("simple");
        fts.setSemanticTypeIdentifiers(new String[]{"generic:geometry", "simple"});
        fts.addRule(rule);
        style.addFeatureTypeStyle(fts);
        style.setName("simpleStyle");
        return style;
    }

    private static java.awt.Color getColor(ColorMapEntry entry) throws NumberFormatException {
        Expression color = entry.getColor();
        String colorString = (String)color.evaluate(null, String.class);
        return java.awt.Color.decode(colorString);
    }

    private static double getOpacity(ColorMapEntry entry) throws IllegalArgumentException, MissingResourceException {
        Expression opacity = entry.getOpacity();
        Double opacityValue = null;
        if (opacity == null) {
            return 1.0;
        }
        opacityValue = (Double)opacity.evaluate(null, Double.class);
        if (opacityValue - 1.0 > 0.0 || opacityValue < 0.0) {
            throw new IllegalArgumentException(Errors.format((int)10, (Object)Messages.CoverageStyleEditorPage_4, (Object)opacityValue));
        }
        return opacityValue;
    }

    private static double getQuantity(ColorMapEntry entry) {
        Expression quantity = entry.getQuantity();
        Double quantityString = (Double)quantity.evaluate(null, Double.class);
        double q = quantityString;
        return q;
    }

    public void gotFocus() {
    }
}

