/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.common.styleattributeclasses;

import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.SymbolizerWrapper;
import eu.udig.style.advanced.utils.Utilities;
import eu.udig.style.advanced.utils.VendorOptions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.style.sld.SLD;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.swt.graphics.FontData;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.Displacement;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;
import org.opengis.style.Font;
import org.opengis.style.Halo;

public class TextSymbolizerWrapper
extends SymbolizerWrapper {
    private String fontFamily;
    private String fontStyle;
    private String fontWeight;
    private String fontSize;
    private String color;
    private String opacity;
    private String haloColor;
    private String anchorX;
    private String anchorY;
    private String displacementX;
    private String displacementY;
    private String rotation;
    private String maxDisplacementVO;
    private String repeatVO;
    private String autoWrapVO;
    private String spaceAroundVO;
    private org.geotools.styling.Font font;
    private TextSymbolizer textSymbolizer;
    private org.geotools.styling.Fill fill;
    private org.geotools.styling.Halo halo;
    private org.geotools.styling.Fill haloFill;
    private PointPlacement pointPlacement;
    private LinePlacement linePlacement;
    private AnchorPoint anchorPoint;
    private Displacement displacement;
    private String haloRadius;
    private String initialGap;
    private String perpendicularOffset;
    private String followLineVO;
    private String maxAngleDeltaVO;
    private SLD geomType;
    private String labelName;

    public TextSymbolizerWrapper(Symbolizer symbolizer, RuleWrapper parent, SLD geomType) {
        super(symbolizer, parent);
        this.geomType = geomType;
        this.textSymbolizer = (TextSymbolizer)symbolizer;
        Expression labelExpression = this.textSymbolizer.getLabel();
        if (labelExpression != null) {
            this.labelName = this.expressionToString(labelExpression);
        }
        this.font = this.textSymbolizer.getFont();
        if (this.font != null) {
            List family = this.font.getFamily();
            this.fontFamily = (String)((Expression)family.get(0)).evaluate(null, String.class);
            Expression styleExpression = this.font.getStyle();
            this.fontStyle = (String)styleExpression.evaluate(null, String.class);
            Expression styleWeight = this.font.getWeight();
            this.fontWeight = (String)styleWeight.evaluate(null, String.class);
            Expression styleSize = this.font.getSize();
            this.fontSize = (String)styleSize.evaluate(null, String.class);
        }
        this.fill = this.textSymbolizer.getFill();
        if (this.fill != null) {
            Expression colorExpression = this.fill.getColor();
            this.color = (String)colorExpression.evaluate(null, String.class);
            Expression opacityExpression = this.fill.getOpacity();
            if (opacityExpression != null) {
                this.opacity = this.expressionToString(opacityExpression);
            }
        }
        this.halo = this.textSymbolizer.getHalo();
        if (this.halo != null) {
            this.haloFill = this.halo.getFill();
            Expression haloColorExpression = this.haloFill.getColor();
            this.haloColor = (String)haloColorExpression.evaluate(null, String.class);
            Expression haloRadiusExpression = this.halo.getRadius();
            this.haloRadius = (String)haloRadiusExpression.evaluate(null, String.class);
        }
        LabelPlacement labelPlacement = this.textSymbolizer.getLabelPlacement();
        if (geomType != null) {
            switch (geomType) {
                case POINT: 
                case POLYGON: {
                    if (!(labelPlacement instanceof PointPlacement)) break;
                    this.pointPlacement = (PointPlacement)labelPlacement;
                    if (this.pointPlacement == null) break;
                    this.anchorPoint = this.pointPlacement.getAnchorPoint();
                    if (this.anchorPoint != null) {
                        Expression anchorPointXExpression = this.anchorPoint.getAnchorPointX();
                        this.anchorX = (String)anchorPointXExpression.evaluate(null, String.class);
                        Expression anchorPointYExpression = this.anchorPoint.getAnchorPointY();
                        this.anchorY = (String)anchorPointYExpression.evaluate(null, String.class);
                    }
                    this.displacement = this.pointPlacement.getDisplacement();
                    if (this.displacement != null) {
                        Expression displacementXExpression = this.displacement.getDisplacementX();
                        this.displacementX = (String)displacementXExpression.evaluate(null, String.class);
                        Expression displacementYExpression = this.displacement.getDisplacementY();
                        this.displacementY = (String)displacementYExpression.evaluate(null, String.class);
                    } else {
                        this.displacementX = "0.0";
                        this.displacementY = "0.0";
                    }
                    Expression rotationExpression = this.pointPlacement.getRotation();
                    this.rotation = this.expressionToString(rotationExpression);
                    break;
                }
                case LINE: {
                    if (!(labelPlacement instanceof LinePlacement)) break;
                    this.linePlacement = (LinePlacement)labelPlacement;
                    if (this.linePlacement == null) break;
                    Expression initialGapExpression = this.linePlacement.getInitialGap();
                    if (initialGapExpression != null) {
                        this.initialGap = (String)initialGapExpression.evaluate(null, String.class);
                    }
                    Expression perpendicularOffsetExpression = this.linePlacement.getPerpendicularOffset();
                    if (this.perpendicularOffset == null) break;
                    this.perpendicularOffset = (String)perpendicularOffsetExpression.evaluate(null, String.class);
                    break;
                }
            }
        }
        Map vendorOptions = this.textSymbolizer.getOptions();
        Set entrySet = vendorOptions.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            switch (VendorOptions.toVendorOption(key)) {
                case VENDOROPTION_MAXDISPLACEMENT: {
                    this.maxDisplacementVO = value;
                    break;
                }
                case VENDOROPTION_REPEAT: {
                    this.repeatVO = value;
                    break;
                }
                case VENDOROPTION_AUTOWRAP: {
                    this.autoWrapVO = value;
                    break;
                }
                case VENDOROPTION_SPACEAROUND: {
                    this.spaceAroundVO = value;
                    break;
                }
                case VENDOROPTION_FOLLOWLINE: {
                    this.followLineVO = value;
                    break;
                }
                case VENDOROPTION_MAXANGLEDELTA: {
                    this.maxAngleDeltaVO = value;
                    break;
                }
            }
        }
    }

    public FontData[] getFontData() {
        return SLDs.textFont((TextSymbolizer)((TextSymbolizer)this.getSymbolizer()));
    }

    private void checkFontExists() {
        if (this.font == null) {
            this.font = Utilities.sb.createFont("Arial", false, false, 12.0);
            this.textSymbolizer.setFont((Font)this.font);
        }
    }

    private void checkFillExists() {
        if (this.fill == null) {
            this.fill = Utilities.sb.createFill((Expression)Utilities.ff.literal((Object)"#000000"));
            this.textSymbolizer.setFill((Fill)this.fill);
        }
    }

    private void checkHaloFillExists() {
        if (this.haloFill == null) {
            this.haloFill = Utilities.sb.createFill((Expression)Utilities.ff.literal((Object)"#000000"));
            this.checkHaloExists();
            this.halo.setFill((Fill)this.haloFill);
        }
    }

    private void checkHaloExists() {
        if (this.halo == null) {
            this.halo = Utilities.sb.createHalo();
            this.textSymbolizer.setHalo((Halo)this.halo);
        }
    }

    private void checkPlacementExists() {
        switch (this.geomType) {
            case POINT: 
            case POLYGON: {
                if (this.pointPlacement != null) break;
                this.pointPlacement = Utilities.sb.createPointPlacement();
                this.textSymbolizer.setLabelPlacement((org.opengis.style.LabelPlacement)this.pointPlacement);
                break;
            }
            case LINE: {
                if (this.linePlacement != null) break;
                this.linePlacement = Utilities.sb.createLinePlacement(0.0);
                this.textSymbolizer.setLabelPlacement((org.opengis.style.LabelPlacement)this.linePlacement);
                break;
            }
        }
    }

    private void checkAnchorPointExists() {
        if (this.anchorPoint == null) {
            this.anchorPoint = Utilities.sb.createAnchorPoint(0.5, 0.5);
            this.checkPlacementExists();
            this.pointPlacement.setAnchorPoint((org.opengis.style.AnchorPoint)this.anchorPoint);
        }
    }

    private void checkDisplacementExists() {
        if (this.displacement == null) {
            this.displacement = Utilities.sb.createDisplacement(0.0, 0.0);
            this.checkPlacementExists();
            this.pointPlacement.setDisplacement((org.opengis.style.Displacement)this.displacement);
        }
    }

    public void setLabelName(String labelName, boolean fromField) {
        this.labelName = labelName;
        if (fromField) {
            this.textSymbolizer.setLabel((Expression)Utilities.ff.property(labelName));
        } else {
            this.textSymbolizer.setLabel((Expression)Utilities.ff.literal((Object)labelName));
        }
    }

    public void setFont(org.geotools.styling.Font font) {
        this.font = font;
        this.textSymbolizer.setFont((Font)font);
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
        this.checkFontExists();
        this.font.getFamily().set(0, Utilities.ff.literal((Object)fontFamily));
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.checkFontExists();
        this.font.setStyle((Expression)Utilities.ff.literal((Object)fontStyle));
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
        this.checkFontExists();
        this.font.setWeight((Expression)Utilities.ff.literal((Object)fontWeight));
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
        this.checkFontExists();
        this.font.setSize((Expression)Utilities.ff.literal((Object)fontSize));
    }

    public void setColor(String color) {
        this.color = color;
        this.checkFillExists();
        this.fill.setColor((Expression)Utilities.ff.literal((Object)color));
    }

    public void setOpacity(String opacity, boolean fromField) {
        this.opacity = opacity;
        this.checkFillExists();
        if (fromField) {
            this.fill.setOpacity((Expression)Utilities.ff.property(opacity));
        } else {
            this.fill.setOpacity((Expression)Utilities.ff.literal((Object)opacity));
        }
    }

    public void setHaloColor(String haloColor) {
        this.haloColor = haloColor;
        this.checkHaloFillExists();
        this.haloFill.setColor((Expression)Utilities.ff.literal((Object)haloColor));
    }

    public void setHaloRadius(String haloRadius) {
        this.haloRadius = haloRadius;
        this.checkHaloExists();
        this.halo.setRadius((Expression)Utilities.ff.literal((Object)haloRadius));
    }

    public void setAnchorX(String anchorX) {
        this.anchorX = anchorX;
        this.checkAnchorPointExists();
        this.anchorPoint.setAnchorPointX((Expression)Utilities.ff.literal((Object)anchorX));
    }

    public void setAnchorY(String anchorY) {
        this.anchorY = anchorY;
        this.checkAnchorPointExists();
        this.anchorPoint.setAnchorPointY((Expression)Utilities.ff.literal((Object)anchorY));
    }

    public void setDisplacement(String displacement) {
        if (displacement == null || displacement.indexOf(44) == -1) {
            return;
        }
        String[] split = displacement.split(",");
        try {
            Double.parseDouble(split[0]);
            Double.parseDouble(split[1]);
            this.setDisplacementX(split[0]);
            this.setDisplacementY(split[1]);
        }
        catch (Exception exception) {}
    }

    public void setDisplacementX(String displacementX) {
        this.displacementX = displacementX;
        this.checkDisplacementExists();
        this.displacement.setDisplacementX((Expression)Utilities.ff.literal((Object)displacementX));
    }

    public void setDisplacementY(String displacementY) {
        this.displacementY = displacementY;
        this.checkDisplacementExists();
        this.displacement.setDisplacementY((Expression)Utilities.ff.literal((Object)displacementY));
    }

    public void setRotation(String rotation, boolean fromField) {
        this.rotation = rotation;
        this.checkPlacementExists();
        if (fromField) {
            this.pointPlacement.setRotation((Expression)Utilities.ff.property(rotation));
        } else {
            this.pointPlacement.setRotation((Expression)Utilities.ff.literal((Object)rotation));
        }
    }

    public void setInitialGap(String initialGap) {
        this.initialGap = initialGap;
        this.checkPlacementExists();
        this.linePlacement.setInitialGap((Expression)Utilities.ff.literal((Object)initialGap));
    }

    public void setPerpendicularOffset(String perpendicularOffset) {
        this.perpendicularOffset = perpendicularOffset;
        this.checkPlacementExists();
        this.linePlacement.setPerpendicularOffset((Expression)Utilities.ff.literal((Object)perpendicularOffset));
    }

    public void setMaxDisplacementVO(String maxDisplacementVO) {
        this.maxDisplacementVO = maxDisplacementVO;
        if (maxDisplacementVO == null || maxDisplacementVO.equals("")) {
            this.textSymbolizer.getOptions().remove(VendorOptions.VENDOROPTION_MAXDISPLACEMENT.toString());
        } else {
            this.textSymbolizer.getOptions().put(VendorOptions.VENDOROPTION_MAXDISPLACEMENT.toString(), maxDisplacementVO);
        }
    }

    public void setRepeatVO(String repeatVO) {
        this.repeatVO = repeatVO;
        if (repeatVO == null || repeatVO.equals("") || this.geomType != SLD.LINE) {
            this.textSymbolizer.getOptions().remove(VendorOptions.VENDOROPTION_REPEAT.toString());
        } else {
            this.textSymbolizer.getOptions().put(VendorOptions.VENDOROPTION_REPEAT.toString(), repeatVO);
        }
    }

    public void setAutoWrapVO(String autoWrapVO) {
        this.autoWrapVO = autoWrapVO;
        if (autoWrapVO == null || autoWrapVO.equals("")) {
            this.textSymbolizer.getOptions().remove(VendorOptions.VENDOROPTION_AUTOWRAP.toString());
        } else {
            this.textSymbolizer.getOptions().put(VendorOptions.VENDOROPTION_AUTOWRAP.toString(), autoWrapVO);
        }
    }

    public void setSpaceAroundVO(String spaceAroundVO) {
        this.spaceAroundVO = spaceAroundVO;
        if (spaceAroundVO == null || spaceAroundVO.equals("")) {
            this.textSymbolizer.getOptions().remove(VendorOptions.VENDOROPTION_SPACEAROUND.toString());
        } else {
            this.textSymbolizer.getOptions().put(VendorOptions.VENDOROPTION_SPACEAROUND.toString(), spaceAroundVO);
        }
    }

    public void setFollowLineVO(String followLineVO) {
        this.followLineVO = followLineVO;
        if (followLineVO == null || followLineVO.equals("") || this.geomType != SLD.LINE) {
            this.textSymbolizer.getOptions().remove(VendorOptions.VENDOROPTION_FOLLOWLINE.toString());
        } else {
            this.textSymbolizer.getOptions().put(VendorOptions.VENDOROPTION_FOLLOWLINE.toString(), followLineVO);
        }
    }

    public void setMaxAngleDeltaVO(String maxAngleDeltaVO) {
        this.maxAngleDeltaVO = maxAngleDeltaVO;
        if (maxAngleDeltaVO == null || maxAngleDeltaVO.equals("") || this.geomType != SLD.LINE) {
            this.textSymbolizer.getOptions().remove(VendorOptions.VENDOROPTION_MAXANGLEDELTA.toString());
        } else {
            this.textSymbolizer.getOptions().put(VendorOptions.VENDOROPTION_MAXANGLEDELTA.toString(), maxAngleDeltaVO);
        }
    }

    public String getLabelName() {
        return this.labelName;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public String getColor() {
        return this.color;
    }

    public String getOpacity() {
        return this.opacity;
    }

    public String getHaloColor() {
        return this.haloColor;
    }

    public String getHaloRadius() {
        return this.haloRadius;
    }

    public String getAnchorX() {
        return this.anchorX;
    }

    public String getAnchorY() {
        return this.anchorY;
    }

    public String getDisplacementX() {
        return this.displacementX;
    }

    public String getDisplacementY() {
        return this.displacementY;
    }

    public String getRotation() {
        return this.rotation;
    }

    public String getInitialGap() {
        return this.initialGap;
    }

    public String getPerpendicularOffset() {
        return this.perpendicularOffset;
    }

    public String getMaxDisplacementVO() {
        return this.maxDisplacementVO;
    }

    public String getRepeatVO() {
        return this.repeatVO;
    }

    public String getAutoWrapVO() {
        return this.autoWrapVO;
    }

    public String getSpaceAroundVO() {
        return this.spaceAroundVO;
    }

    public String getFollowLineVO() {
        return this.followLineVO;
    }

    public String getMaxAngleDeltaVO() {
        return this.maxAngleDeltaVO;
    }
}

