/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.common.styleattributeclasses;

import eu.udig.style.advanced.common.styleattributeclasses.LineSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.utils.Utilities;
import java.awt.geom.Point2D;
import java.util.List;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.expression.Expression;
import org.opengis.style.GraphicalSymbol;
import org.opengis.style.Stroke;

public class PolygonSymbolizerWrapper
extends LineSymbolizerWrapper {
    private Fill fill;
    private String fillColor;
    private String fillOpacity;
    private Graphic fillGraphicFill;
    private String wkMarkNameFill;
    private String wkMarkColorFill;
    private String wkMarkWidthFill;
    private String wkMarkSizeFill;
    private boolean hasFill;
    private Mark mark;

    public PolygonSymbolizerWrapper(Symbolizer tmpSymbolizer, RuleWrapper parent) {
        super((PolygonSymbolizer)tmpSymbolizer, parent);
        Expression color;
        PolygonSymbolizer polygonSymbolizer = (PolygonSymbolizer)tmpSymbolizer;
        Point2D offset = Utilities.getOffset((Symbolizer)polygonSymbolizer);
        if (offset != null) {
            this.xOffset = String.valueOf(offset.getX());
            this.yOffset = String.valueOf(offset.getY());
        } else {
            this.xOffset = "0";
            this.yOffset = "0";
        }
        this.stroke = polygonSymbolizer.getStroke();
        if (this.stroke != null) {
            float[] dashArray;
            GraphicalSymbol graphicalSymbol;
            List graphicalSymbolsList;
            color = this.stroke.getColor();
            this.strokeColor = this.expressionToString(color);
            Expression width = this.stroke.getWidth();
            this.strokeWidth = this.expressionToString(width);
            Expression opacity = this.stroke.getOpacity();
            this.strokeOpacity = this.expressionToString(opacity);
            if (this.strokeColor == null) {
                this.strokeColor = "#000000";
                this.stroke.setColor((Expression)Utilities.ff.literal((Object)"#000000"));
            }
            if (this.strokeOpacity == null) {
                this.strokeOpacity = "1";
                this.stroke.setOpacity((Expression)Utilities.ff.literal((Object)"1"));
            }
            if (this.strokeWidth == null) {
                this.strokeWidth = "1";
                this.stroke.setWidth((Expression)Utilities.ff.literal((Object)"1"));
            }
            this.strokeGraphicStroke = this.stroke.getGraphicStroke();
            if (this.strokeGraphicStroke != null && (graphicalSymbolsList = this.strokeGraphicStroke.graphicalSymbols()).size() > 0 && (graphicalSymbol = (GraphicalSymbol)graphicalSymbolsList.get(0)) instanceof ExternalGraphic) {
                this.strokeExternalGraphicStroke = (ExternalGraphic)graphicalSymbol;
            }
            this.dash = (dashArray = this.stroke.getDashArray()) != null ? Utilities.getDashString(dashArray) : "";
            this.dashOffset = (String)this.stroke.getDashOffset().evaluate(null, String.class);
            this.lineCap = (String)this.stroke.getLineCap().evaluate(null, String.class);
            this.lineJoin = (String)this.stroke.getLineJoin().evaluate(null, String.class);
            this.hasStroke = true;
        } else {
            this.hasStroke = false;
        }
        this.fill = polygonSymbolizer.getFill();
        if (this.fill != null) {
            List graphicalSymbolsList;
            color = this.fill.getColor();
            if (color != null) {
                this.fillColor = this.expressionToString(color);
            }
            Expression opacity = this.fill.getOpacity();
            this.fillOpacity = this.expressionToString(opacity);
            this.fillGraphicFill = this.fill.getGraphicFill();
            if (this.fillGraphicFill != null && (graphicalSymbolsList = this.fillGraphicFill.graphicalSymbols()).size() > 0) {
                GraphicalSymbol graphicalSymbol = (GraphicalSymbol)graphicalSymbolsList.get(0);
                if (graphicalSymbol instanceof ExternalGraphic) {
                    this.fillExternalGraphicFill = (ExternalGraphic)graphicalSymbol;
                } else if (graphicalSymbol instanceof Mark) {
                    this.mark = (Mark)graphicalSymbol;
                    this.wkMarkNameFill = (String)this.mark.getWellKnownName().evaluate(null, String.class);
                    org.geotools.styling.Stroke stroke = this.mark.getStroke();
                    this.wkMarkColorFill = (String)stroke.getColor().evaluate(null, String.class);
                    this.wkMarkWidthFill = (String)stroke.getWidth().evaluate(null, String.class);
                    this.wkMarkSizeFill = (String)this.fillGraphicFill.getSize().evaluate(null, String.class);
                }
            }
            this.hasFill = true;
        } else {
            this.hasFill = false;
        }
    }

    private void checkFillExists() {
        if (this.fill == null) {
            if (this.fillColor == null) {
                this.fillColor = "#000000";
            }
            this.fill = Utilities.sf.createFill((Expression)Utilities.ff.literal((Object)this.fillColor));
            PolygonSymbolizer polygonSymbolizer = (PolygonSymbolizer)this.getSymbolizer();
            polygonSymbolizer.setFill((org.opengis.style.Fill)this.fill);
            this.fillGraphicFill = this.fill.getGraphicFill();
        }
    }

    private void checkMarkExists() {
        if (this.mark == null) {
            this.mark = Utilities.sf.createMark();
            this.checkFillExists();
            if (this.fillGraphicFill == null) {
                this.fillGraphicFill = Utilities.sf.createDefaultGraphic();
                this.fill.setGraphicFill((org.opengis.style.Graphic)this.fillGraphicFill);
            }
            this.fillGraphicFill.graphicalSymbols().clear();
            this.fillGraphicFill.graphicalSymbols().add(this.mark);
        }
    }

    public Graphic getFillGraphicFill() {
        return this.fillGraphicFill;
    }

    public void setFillGraphicFill(Graphic fillGraphicFill) {
        this.fillGraphicFill = fillGraphicFill;
        this.checkFillExists();
        this.fill.setGraphicFill((org.opengis.style.Graphic)fillGraphicFill);
    }

    public void setHasFill(boolean hasFill) {
        this.hasFill = hasFill;
        if (hasFill) {
            this.checkFillExists();
        } else {
            this.fill = null;
            PolygonSymbolizer polygonSymbolizer = (PolygonSymbolizer)this.getSymbolizer();
            polygonSymbolizer.setFill(null);
        }
    }

    @Override
    public void setHasStroke(boolean hasStroke) {
        this.hasStroke = hasStroke;
        if (hasStroke) {
            this.checkStrokeExists();
        } else {
            this.stroke = null;
            PolygonSymbolizer polygonSymbolizer = (PolygonSymbolizer)this.getSymbolizer();
            polygonSymbolizer.setStroke(null);
        }
    }

    @Override
    protected void checkStrokeExists() {
        if (this.stroke == null) {
            if (this.strokeColor == null) {
                this.strokeColor = "#000000";
            }
            if (this.strokeWidth == null) {
                this.strokeWidth = "1";
            }
            this.stroke = Utilities.sf.createStroke((Expression)Utilities.ff.literal((Object)this.strokeColor), (Expression)Utilities.ff.literal((Object)this.strokeWidth));
            PolygonSymbolizer polygonSymbolizer = (PolygonSymbolizer)this.getSymbolizer();
            polygonSymbolizer.setStroke((Stroke)this.stroke);
            this.strokeGraphicStroke = this.stroke.getGraphicStroke();
        }
    }

    public void setFillColor(String fillColor, boolean isProperty) {
        this.fillColor = fillColor;
        this.checkFillExists();
        this.fill.setGraphicFill(null);
        if (isProperty) {
            this.fill.setColor((Expression)Utilities.ff.property(fillColor));
        } else {
            this.hasFill = fillColor != null;
            this.fill.setColor((Expression)Utilities.ff.literal((Object)fillColor));
        }
    }

    public void setFillOpacity(String fillOpacity, boolean isProperty) {
        this.fillOpacity = fillOpacity;
        this.checkFillExists();
        if (isProperty) {
            this.fill.setOpacity((Expression)Utilities.ff.property(fillOpacity));
        } else {
            this.fill.setOpacity((Expression)Utilities.ff.literal((Object)fillOpacity));
        }
    }

    public void setWkMarkNameFill(String wkMarkNameFill) {
        this.wkMarkNameFill = wkMarkNameFill;
        this.checkMarkExists();
        if (wkMarkNameFill != null) {
            this.mark.setWellKnownName((Expression)Utilities.ff.literal((Object)wkMarkNameFill));
        }
    }

    public void setWkMarkColorFill(String wkMarkColorFill) {
        this.wkMarkColorFill = wkMarkColorFill;
        this.checkMarkExists();
        if (wkMarkColorFill != null) {
            org.geotools.styling.Stroke markStroke = this.mark.getStroke();
            markStroke.setColor((Expression)Utilities.ff.literal((Object)wkMarkColorFill));
        }
    }

    public void setWkMarkWidthFill(String wkMarkWidthFill) {
        this.wkMarkWidthFill = wkMarkWidthFill;
        this.checkMarkExists();
        if (wkMarkWidthFill != null) {
            org.geotools.styling.Stroke markStroke = this.mark.getStroke();
            markStroke.setWidth((Expression)Utilities.ff.literal((Object)wkMarkWidthFill));
        }
    }

    public void setWkMarkSizeFill(String wkMarkSizeFill) {
        this.wkMarkSizeFill = wkMarkSizeFill;
        this.checkFillExists();
        this.fillGraphicFill.setSize((Expression)Utilities.ff.literal((Object)wkMarkSizeFill));
    }

    public boolean hasFill() {
        return this.hasFill;
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public String getFillOpacity() {
        return this.fillOpacity;
    }

    public String getWkMarkNameFill() {
        return this.wkMarkNameFill;
    }

    public String getWkMarkColorFill() {
        return this.wkMarkColorFill;
    }

    public String getWkMarkWidthFill() {
        return this.wkMarkWidthFill;
    }

    public String getWkMarkSizeFill() {
        return this.wkMarkSizeFill;
    }
}

