/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.common.styleattributeclasses;

import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.SymbolizerWrapper;
import eu.udig.style.advanced.utils.Utilities;
import java.awt.geom.Point2D;
import java.util.List;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.expression.Expression;
import org.opengis.style.GraphicalSymbol;
import org.opengis.style.Stroke;

public class LineSymbolizerWrapper
extends SymbolizerWrapper {
    protected String strokeColor;
    protected String strokeOpacity;
    protected String strokeWidth;
    protected boolean hasStroke;
    protected org.geotools.styling.Stroke stroke;
    protected Graphic strokeGraphicStroke;
    protected String dash;
    protected String dashOffset;
    protected String lineCap;
    protected String lineJoin;

    public LineSymbolizerWrapper(PolygonSymbolizer polygonSymbolizer, RuleWrapper parent) {
        super((Symbolizer)polygonSymbolizer, parent);
    }

    public LineSymbolizerWrapper(Symbolizer symbolizer, RuleWrapper parent) {
        super(symbolizer, parent);
        LineSymbolizer lineSymbolizer = (LineSymbolizer)symbolizer;
        Point2D offset = Utilities.getOffset((Symbolizer)lineSymbolizer);
        if (offset != null) {
            this.xOffset = String.valueOf(offset.getX());
            this.yOffset = String.valueOf(offset.getY());
        } else {
            this.xOffset = "0";
            this.yOffset = "0";
        }
        this.stroke = lineSymbolizer.getStroke();
        if (this.stroke != null) {
            float[] dashArray;
            GraphicalSymbol graphicalSymbol;
            List graphicalSymbolsList;
            Expression color = this.stroke.getColor();
            this.strokeColor = this.expressionToString(color);
            Expression width = this.stroke.getWidth();
            this.strokeWidth = this.expressionToString(width);
            Expression opacity = this.stroke.getOpacity();
            this.strokeOpacity = this.expressionToString(opacity);
            if (this.strokeColor == null) {
                this.strokeColor = "#000000";
                this.stroke.setColor((Expression)Utilities.ff.literal((Object)"#000000"));
            }
            if (this.strokeOpacity == null) {
                this.strokeOpacity = "1";
                this.stroke.setOpacity((Expression)Utilities.ff.literal((Object)"1"));
            }
            if (this.strokeWidth == null) {
                this.strokeWidth = "1";
                this.stroke.setWidth((Expression)Utilities.ff.literal((Object)"1"));
            }
            this.strokeGraphicStroke = this.stroke.getGraphicStroke();
            if (this.strokeGraphicStroke != null && (graphicalSymbolsList = this.strokeGraphicStroke.graphicalSymbols()).size() > 0 && (graphicalSymbol = (GraphicalSymbol)graphicalSymbolsList.get(0)) instanceof ExternalGraphic) {
                this.strokeExternalGraphicStroke = (ExternalGraphic)graphicalSymbol;
            }
            this.dash = (dashArray = this.stroke.getDashArray()) != null ? Utilities.getDashString(dashArray) : "";
            this.dashOffset = (String)this.stroke.getDashOffset().evaluate(null, String.class);
            this.lineCap = (String)this.stroke.getLineCap().evaluate(null, String.class);
            this.lineJoin = (String)this.stroke.getLineJoin().evaluate(null, String.class);
            this.hasStroke = true;
        } else {
            this.hasStroke = false;
        }
    }

    public Graphic getStrokeGraphicStroke() {
        return this.strokeGraphicStroke;
    }

    public void setStrokeGraphicStroke(Graphic strokeGraphicStroke) {
        this.strokeGraphicStroke = strokeGraphicStroke;
        this.checkStrokeExists();
        this.stroke.setGraphicStroke((org.opengis.style.Graphic)strokeGraphicStroke);
    }

    public void setHasStroke(boolean hasStroke) {
        this.hasStroke = hasStroke;
        if (hasStroke) {
            this.checkStrokeExists();
        } else {
            this.stroke = null;
            LineSymbolizer lineSymbolizer = (LineSymbolizer)this.getSymbolizer();
            lineSymbolizer.setStroke(null);
        }
    }

    protected void checkStrokeExists() {
        if (this.stroke == null) {
            if (this.strokeColor == null) {
                this.strokeColor = "#000000";
            }
            if (this.strokeWidth == null) {
                this.strokeWidth = "1";
            }
            this.stroke = Utilities.sf.createStroke((Expression)Utilities.ff.literal((Object)this.strokeColor), (Expression)Utilities.ff.literal((Object)this.strokeWidth));
            LineSymbolizer lineSymbolizer = (LineSymbolizer)this.getSymbolizer();
            lineSymbolizer.setStroke((Stroke)this.stroke);
            this.strokeGraphicStroke = this.stroke.getGraphicStroke();
        }
    }

    public void setStrokeWidth(String strokeWidth, boolean isProperty) {
        this.strokeWidth = strokeWidth;
        this.checkStrokeExists();
        if (isProperty) {
            this.stroke.setWidth((Expression)Utilities.ff.property(strokeWidth));
        } else {
            this.stroke.setWidth((Expression)Utilities.ff.literal((Object)strokeWidth));
        }
    }

    public void setStrokeColor(String strokeColor, boolean isProperty) {
        this.strokeColor = strokeColor;
        this.checkStrokeExists();
        if (isProperty) {
            this.stroke.setColor((Expression)Utilities.ff.property(strokeColor));
        } else if (strokeColor != null) {
            this.stroke.setColor((Expression)Utilities.ff.literal((Object)strokeColor));
        }
    }

    public void setStrokeOpacity(String strokeOpacity, boolean isProperty) {
        this.strokeOpacity = strokeOpacity;
        this.checkStrokeExists();
        if (isProperty) {
            this.stroke.setOpacity((Expression)Utilities.ff.property(strokeOpacity));
        } else {
            this.stroke.setOpacity((Expression)Utilities.ff.literal((Object)strokeOpacity));
        }
    }

    public void setDash(String dash) {
        this.dash = dash;
        this.checkStrokeExists();
        float[] dashArray = Utilities.getDash(dash);
        this.stroke.setDashArray(dashArray);
    }

    public void setDashOffset(String dashOffset) {
        this.dashOffset = dashOffset;
        this.checkStrokeExists();
        if (dashOffset != null && dashOffset.length() > 0) {
            this.stroke.setDashOffset((Expression)Utilities.ff.literal((Object)dashOffset));
        }
    }

    public void setLineCap(String lineCap) {
        this.lineCap = lineCap;
        this.checkStrokeExists();
        this.stroke.setLineCap((Expression)Utilities.ff.literal((Object)lineCap));
    }

    public void setLineJoin(String lineJoin) {
        this.lineJoin = lineJoin;
        this.checkStrokeExists();
        this.stroke.setLineJoin((Expression)Utilities.ff.literal((Object)lineJoin));
    }

    public String getStrokeColor() {
        return this.strokeColor;
    }

    public String getStrokeOpacity() {
        return this.strokeOpacity;
    }

    public String getStrokeWidth() {
        return this.strokeWidth;
    }

    public boolean hasStroke() {
        return this.hasStroke;
    }

    public String getDash() {
        return this.dash;
    }

    public String getDashOffset() {
        return this.dashOffset;
    }

    public String getLineCap() {
        return this.lineCap;
    }

    public String getLineJoin() {
        return this.lineJoin;
    }
}

