/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.common.styleattributeclasses;

import eu.udig.style.advanced.common.styleattributeclasses.LineSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.PointSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.PolygonSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.StyleWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.utils.Utilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;

public class FeatureTypeStyleWrapper {
    private FeatureTypeStyle featureTypeStyle;
    private String name;
    private List<RuleWrapper> rulesWrapperList = new ArrayList<RuleWrapper>();
    private final StyleWrapper parent;

    public FeatureTypeStyleWrapper(FeatureTypeStyle featureTypeStyle, StyleWrapper parent) {
        this.featureTypeStyle = featureTypeStyle;
        this.parent = parent;
        this.name = featureTypeStyle.getName();
        List rules = featureTypeStyle.rules();
        for (Rule rule : rules) {
            RuleWrapper ruleWrapper = new RuleWrapper(rule, this);
            this.rulesWrapperList.add(ruleWrapper);
        }
    }

    public StyleWrapper getParent() {
        return this.parent;
    }

    public FeatureTypeStyle getFeatureTypeStyle() {
        return this.featureTypeStyle;
    }

    public String getName() {
        int indexOf = this.parent.getStyle().featureTypeStyles().indexOf(this.featureTypeStyle);
        this.name = String.valueOf(Messages.FeatureTypeStyleWrapper_0) + indexOf;
        this.featureTypeStyle.setName(this.name);
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.featureTypeStyle.setName(name);
    }

    public List<RuleWrapper> getRulesWrapperList() {
        return Collections.unmodifiableList(this.rulesWrapperList);
    }

    public RuleWrapper addRule(Rule tmpRule, Class<?> symbolizerWrapperClass) {
        if (tmpRule == null) {
            if (symbolizerWrapperClass.isAssignableFrom(PointSymbolizerWrapper.class)) {
                tmpRule = Utilities.createDefaultPointRule();
            } else if (symbolizerWrapperClass.isAssignableFrom(LineSymbolizerWrapper.class)) {
                tmpRule = Utilities.createDefaultLineRule();
            } else if (symbolizerWrapperClass.isAssignableFrom(PolygonSymbolizerWrapper.class)) {
                tmpRule = Utilities.createDefaultPolygonRule();
            } else {
                throw new IllegalArgumentException("Unsupported symbolizer.");
            }
        }
        this.featureTypeStyle.rules().add(0, tmpRule);
        RuleWrapper wrapper = new RuleWrapper(tmpRule, this);
        this.rulesWrapperList.add(0, wrapper);
        return wrapper;
    }

    public void removeRule(RuleWrapper remRule) {
        Rule rule = remRule.getRule();
        this.featureTypeStyle.rules().remove(rule);
        this.rulesWrapperList.remove(remRule);
    }

    public void clear() {
        this.featureTypeStyle.rules().clear();
        this.rulesWrapperList.clear();
    }

    public void swap(int src, int dest) {
        List rules = this.featureTypeStyle.rules();
        if (src >= 0 && src < rules.size() && dest >= 0 && dest < rules.size()) {
            Collections.swap(rules, src, dest);
            Collections.swap(this.rulesWrapperList, src, dest);
        }
    }
}

