/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.common;

import eu.udig.style.advanced.common.styleattributeclasses.FeatureTypeStyleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.StyleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.SymbolizerWrapper;
import eu.udig.style.advanced.utils.Utilities;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.ui.graphics.SLDs;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.viewers.TableViewer;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;

public abstract class StyleManager {
    public static String POINTSTYLEFOLDER = "pointstylefolder";
    public static String POLYGONSTYLEFOLDER = "polygonstylefolder";
    public static String LINESTYLEFOLDER = "linestylefolder";
    protected TableViewer stylesViewer;
    protected StyleWrapper currentSelectedStyleWrapper;
    protected File styleFolderFile;

    public void reloadStyleFolder() {
        File[] sldFilesArray = this.styleFolderFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".sld");
            }
        });
        ArrayList<StyleWrapper> newStylesList = new ArrayList<StyleWrapper>();
        File[] fileArray = sldFilesArray;
        int n = sldFilesArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                StyledLayerDescriptor sld = Utilities.readStyle(file);
                Style style = SLDs.getDefaultStyle((StyledLayerDescriptor)sld);
                String name = FilenameUtils.removeExtension((String)file.getName());
                style.setName(name);
                StyleWrapper styleWrapper = new StyleWrapper(style);
                newStylesList.add(styleWrapper);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        this.stylesViewer.setInput(newStylesList);
    }

    protected void styleToDisk(StyleWrapper styleWrapper) throws Exception {
        String name = styleWrapper.getName();
        String styleStr = styleWrapper.toXml();
        File newFile = new File(this.styleFolderFile, String.valueOf(name) + ".sld");
        FileUtils.writeStringToFile((File)newFile, (String)styleStr);
    }

    public void setStyleFolderFile(File styleFolderFile) {
        this.styleFolderFile = styleFolderFile;
        this.reloadStyleFolder();
    }

    public File getStyleFolderFile() {
        return this.styleFolderFile;
    }

    public TableViewer getTableViewer() {
        return this.stylesViewer;
    }

    public StyleWrapper getCurrentSelectedStyle() {
        return this.currentSelectedStyleWrapper;
    }

    public List<StyleWrapper> getStyles() {
        List styles = (List)this.stylesViewer.getInput();
        return styles;
    }

    public void addStyle(StyleWrapper styleWrapper) throws Exception {
        this.styleToDisk(styleWrapper);
        this.reloadStyleFolder();
    }

    public void removeStyle(StyleWrapper styleWrapper) throws IOException {
        String name = styleWrapper.getName();
        File styleFile = new File(this.styleFolderFile, String.valueOf(name) + ".sld");
        if (styleFile.exists()) {
            FileUtils.forceDelete((File)styleFile);
        }
        this.reloadStyleFolder();
    }

    public void exportStyle(StyleWrapper styleWrapper, File file) throws Exception {
        File parentFolder = file.getParentFile();
        String baseName = FilenameUtils.getBaseName((String)file.getAbsolutePath());
        int index = 1;
        List<FeatureTypeStyleWrapper> featureTypeStylesWrapperList = styleWrapper.getFeatureTypeStylesWrapperList();
        for (FeatureTypeStyleWrapper featureTypeStyleWrapper : featureTypeStylesWrapperList) {
            List<RuleWrapper> rulesWrapperList = featureTypeStyleWrapper.getRulesWrapperList();
            for (RuleWrapper ruleWrapper : rulesWrapperList) {
                SymbolizerWrapper symbolizersWrapper = ruleWrapper.getGeometrySymbolizersWrapper();
                String externalGraphicPath = symbolizersWrapper.getExternalGraphicPath();
                if (externalGraphicPath == null || externalGraphicPath.length() <= 0) continue;
                File graphicsFile = new File(externalGraphicPath);
                String extension = FilenameUtils.getExtension((String)graphicsFile.getName());
                String newImageName = String.valueOf(baseName) + "_" + index + "." + extension;
                ++index;
                File newFile = new File(parentFolder, newImageName);
                FileUtils.copyFile((File)graphicsFile, (File)newFile);
                symbolizersWrapper.setExternalGraphicPath(newFile.getAbsolutePath());
            }
        }
        String styleString = styleWrapper.toXml();
        File newFile = new File(parentFolder, String.valueOf(baseName) + ".sld");
        FileUtils.writeStringToFile((File)newFile, (String)styleString);
    }
}

