/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.common;

import eu.udig.style.advanced.common.styleattributeclasses.FeatureTypeStyleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.StyleWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.utils.Utilities;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.style.internal.StyleLayer;
import net.refractions.udig.style.sld.SLD;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;

public abstract class PropertiesEditor {
    protected final StyleLayer layer;
    protected StyleWrapper styleWrapper;
    protected TreeViewer groupRulesTreeViewer;
    protected Image previewImage;
    protected SLD type;
    protected Name geometryPropertyName;
    protected List<String> stringAttributeNames = new ArrayList<String>();
    protected List<String> numericAttributeNames = new ArrayList<String>();
    protected List<String> allAttributeNames = new ArrayList<String>();
    protected Composite mainComposite;
    protected Canvas previewCanvas;
    protected static final int PREVIEWWIDTH = 150;
    protected static final int PREVIEWHEIGHT = 150;
    protected Color white = Display.getDefault().getSystemColor(1);
    protected Color gray = Display.getDefault().getSystemColor(15);

    public PropertiesEditor(StyleLayer layer) {
        this.layer = layer;
        this.loadWithAttributeTypes(layer);
        SimpleFeatureType schema = layer.getSchema();
        if (SLD.isPoint((SimpleFeatureType)schema)) {
            this.type = SLD.POINT;
        } else if (SLD.isLine((SimpleFeatureType)schema)) {
            this.type = SLD.LINE;
        } else if (SLD.isPolygon((SimpleFeatureType)schema)) {
            this.type = SLD.POLYGON;
        }
    }

    public void open(Composite parent, Style style) {
        if (style == null) {
            switch (this.type) {
                case POINT: {
                    style = Utilities.createDefaultPointStyle();
                    break;
                }
                case LINE: {
                    style = Utilities.createDefaultLineStyle();
                    break;
                }
                case POLYGON: {
                    style = Utilities.createDefaultPolygonStyle();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        this.styleWrapper = new StyleWrapper(style);
        this.createGui(parent);
    }

    protected abstract void createGui(Composite var1);

    public Composite getControl() {
        return this.mainComposite;
    }

    public Style getStyle() {
        return this.styleWrapper.getStyle();
    }

    public void close() {
        if (this.previewImage != null) {
            this.previewImage.dispose();
            this.previewImage = null;
        }
    }

    public void updateStyle(Style style) {
        if (style == null) {
            style = Utilities.createDefaultPointStyle();
        }
        this.styleWrapper = new StyleWrapper(style);
        this.groupRulesTreeViewer.setInput(this.styleWrapper.getFeatureTypeStylesWrapperList());
        RuleWrapper ruleWrapper = this.styleWrapper.getFirstRule();
        if (ruleWrapper != null) {
            this.setRuleToSelected(ruleWrapper);
            this.refreshTreeViewer(ruleWrapper);
            this.refreshPreviewCanvasOnStyle();
        }
    }

    public void reloadGroupsAndRules() {
        List<FeatureTypeStyleWrapper> featureTypeStylesWrapperList = this.styleWrapper.getFeatureTypeStylesWrapperList();
        if (featureTypeStylesWrapperList.size() > 0) {
            this.groupRulesTreeViewer.setInput(featureTypeStylesWrapperList);
        } else {
            this.groupRulesTreeViewer.setInput(null);
        }
    }

    public void refreshTreeViewer(RuleWrapper rule) {
        this.groupRulesTreeViewer.update((Object)rule.getParent(), null);
        this.groupRulesTreeViewer.update((Object)rule, null);
    }

    public void refreshPreviewCanvasOnStyle() {
        if (this.previewImage == null || this.previewImage.getImageData().width < 1) {
            Display display = Display.getDefault();
            this.previewImage = new Image((Device)display, 150, 150);
        }
        GC gc = null;
        try {
            gc = new GC((Drawable)this.previewImage);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.previewImage = null;
            return;
        }
        Rectangle clientArea = this.previewCanvas.getClientArea();
        gc.setBackground(this.white);
        gc.fillRectangle(clientArea);
        List<FeatureTypeStyleWrapper> featureTypeStylesWrapperList = this.styleWrapper.getFeatureTypeStylesWrapperList();
        for (FeatureTypeStyleWrapper featureTypeStyleWrapper : featureTypeStylesWrapperList) {
            List<RuleWrapper> rulesWrapperList = featureTypeStyleWrapper.getRulesWrapperList();
            BufferedImage tmpImage = Utilities.rulesWrapperToImage(rulesWrapperList, 150, 150, this.type);
            Image convertToSWTImage = AWTSWTImageUtils.convertToSWTImage((BufferedImage)tmpImage);
            gc.drawImage(convertToSWTImage, 0, 0);
            convertToSWTImage.dispose();
        }
        gc.dispose();
        this.previewCanvas.redraw();
    }

    protected void setRuleToSelected(RuleWrapper ruleWrapper) {
        StructuredSelection sel = new StructuredSelection((Object)ruleWrapper);
        this.groupRulesTreeViewer.setSelection((ISelection)sel, true);
        this.groupRulesTreeViewer.update((Object)ruleWrapper, null);
    }

    protected RuleWrapper getSelectedRule() {
        TreeSelection selection = (TreeSelection)this.groupRulesTreeViewer.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof RuleWrapper) {
            RuleWrapper wrapper = (RuleWrapper)firstElement;
            return wrapper;
        }
        return null;
    }

    protected FeatureTypeStyleWrapper getSelectedFtsw() {
        TreeSelection selection = (TreeSelection)this.groupRulesTreeViewer.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof FeatureTypeStyleWrapper) {
            FeatureTypeStyleWrapper wrapper = (FeatureTypeStyleWrapper)firstElement;
            return wrapper;
        }
        return null;
    }

    protected void swap(boolean doUp) {
        FeatureTypeStyleWrapper selectedFtsw = this.getSelectedFtsw();
        RuleWrapper selectedRule = this.getSelectedRule();
        if (selectedFtsw != null) {
            List<FeatureTypeStyleWrapper> featureTypeStylesWrapperList = selectedFtsw.getParent().getFeatureTypeStylesWrapperList();
            if (featureTypeStylesWrapperList.size() < 2) {
                return;
            }
            int ftsWIndex = featureTypeStylesWrapperList.indexOf(selectedFtsw);
            if (doUp) {
                if (ftsWIndex > 0) {
                    this.styleWrapper.swap(ftsWIndex, ftsWIndex - 1);
                    this.reloadGroupsAndRules();
                    this.refreshPreviewCanvasOnStyle();
                }
            } else if (ftsWIndex < featureTypeStylesWrapperList.size() - 1) {
                this.styleWrapper.swap(ftsWIndex + 1, ftsWIndex);
                this.reloadGroupsAndRules();
                this.refreshPreviewCanvasOnStyle();
            }
        } else if (selectedRule != null) {
            FeatureTypeStyleWrapper featureTypeStyleWrapper = selectedRule.getParent();
            List<RuleWrapper> rulesWrapperList = featureTypeStyleWrapper.getRulesWrapperList();
            if (rulesWrapperList.size() < 2) {
                return;
            }
            int ruleWrapperIndex = rulesWrapperList.indexOf(selectedRule);
            if (doUp) {
                if (ruleWrapperIndex > 0) {
                    featureTypeStyleWrapper.swap(ruleWrapperIndex - 1, ruleWrapperIndex);
                    this.reloadGroupsAndRules();
                    this.refreshPreviewCanvasOnStyle();
                }
            } else if (ruleWrapperIndex < rulesWrapperList.size() - 1) {
                featureTypeStyleWrapper.swap(ruleWrapperIndex, ruleWrapperIndex + 1);
                this.reloadGroupsAndRules();
                this.refreshPreviewCanvasOnStyle();
            }
        } else {
            MessageDialog.openWarning((Shell)this.mainComposite.getShell(), (String)Messages.PropertiesEditor_0, (String)Messages.PropertiesEditor_1);
            return;
        }
    }

    private void loadWithAttributeTypes(StyleLayer selectedLayer) {
        SimpleFeatureType featureType = selectedLayer.getSchema();
        if (featureType != null) {
            int i = 0;
            while (i < featureType.getAttributeCount()) {
                AttributeDescriptor attributeType = featureType.getDescriptor(i);
                if (!(attributeType instanceof GeometryDescriptor)) {
                    if (this.isNumber(attributeType)) {
                        this.numericAttributeNames.add(attributeType.getName().getLocalPart());
                    } else if (this.isString(attributeType)) {
                        this.stringAttributeNames.add(attributeType.getName().getLocalPart());
                    }
                    this.allAttributeNames.add(attributeType.getName().getLocalPart());
                } else {
                    this.geometryPropertyName = attributeType.getName();
                }
                ++i;
            }
            this.numericAttributeNames.add(0, "- none -");
            this.allAttributeNames.add(0, "- none -");
            this.stringAttributeNames.add(0, "- none -");
        }
    }

    private boolean isNumber(AttributeDescriptor attributeType) {
        return Number.class.isAssignableFrom(attributeType.getType().getBinding());
    }

    private boolean isString(AttributeDescriptor attributeType) {
        return String.class.isAssignableFrom(attributeType.getType().getBinding());
    }

    public Name getGeometryPropertyName() {
        return this.geometryPropertyName;
    }

    public List<String> getNumericAttributeNames() {
        return this.numericAttributeNames;
    }

    public List<String> getAllAttributeNames() {
        return this.allAttributeNames;
    }

    public List<String> getStringAttributeNames() {
        return this.stringAttributeNames;
    }
}

