/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.jiffle.parser;

import java.util.Collections;
import java.util.List;
import org.jaitools.CollectionFactory;
import org.jaitools.jiffle.parser.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolScope {
    private final String name;
    private final List<Symbol> symbols;

    public SymbolScope(String name) {
        this.name = name;
        this.symbols = CollectionFactory.list();
    }

    public String getName() {
        return this.name;
    }

    public List<Symbol> getSymbols() {
        return Collections.unmodifiableList(this.symbols);
    }

    public boolean isEmpty() {
        return this.symbols.isEmpty();
    }

    public int size() {
        return this.symbols.size();
    }

    public void add(Symbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException("symbol must not be null");
        }
        this.symbols.add(symbol);
    }

    public boolean hasSymbolNamed(String name) {
        return this.findSymbolNamed(name) != null;
    }

    public Symbol findSymbolNamed(String name) {
        for (Symbol s : this.symbols) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }
}

