/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.jiffle.parser;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jaitools.CollectionFactory;
import org.jaitools.jiffle.parser.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageTable {
    private Map<String, List<Message>> errors = CollectionFactory.map();

    public void add(String varName, Message code) {
        List codes = this.errors.get(varName);
        if (codes == null) {
            codes = CollectionFactory.list();
            this.errors.put(varName, codes);
        }
        codes.add(code);
    }

    public boolean hasErrors() {
        for (List<Message> codes : this.errors.values()) {
            for (Message code : codes) {
                if (!code.isError()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasWarnings() {
        for (List<Message> codes : this.errors.values()) {
            for (Message code : codes) {
                if (!code.isWarning()) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, List<Message>> getMessages() {
        return Collections.unmodifiableMap(this.errors);
    }
}

