/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.jiffle.parser;

import java.util.Arrays;
import java.util.List;
import org.jaitools.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionInfo {
    private final String jiffleName;
    private final String runtimeName;
    private final Provider provider;
    private final boolean isVolatile;
    private final String returnType;
    private final List<String> argTypes;

    public FunctionInfo(String jiffleName, String runtimeName, Provider provider, boolean isVolatile, String returnType, String ... argTypes) {
        this.jiffleName = jiffleName;
        this.runtimeName = runtimeName;
        this.provider = provider;
        this.isVolatile = isVolatile;
        this.returnType = returnType;
        this.argTypes = CollectionFactory.list();
        if (argTypes != null && argTypes.length > 0) {
            this.argTypes.addAll(Arrays.asList(argTypes));
        }
    }

    public String getJiffleName() {
        return this.jiffleName;
    }

    public String getRuntimeExpr() {
        switch (this.provider) {
            case MATH: {
                return "Math." + this.runtimeName;
            }
            case JIFFLE: {
                return "_FN." + this.runtimeName;
            }
            case PROXY: {
                return this.runtimeName;
            }
        }
        throw new IllegalStateException("Internal compiler error: getRuntimeExpr");
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public int getNumArgs() {
        return this.argTypes.size();
    }

    public boolean isProxy() {
        return this.provider == Provider.PROXY;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean matches(String name, List<String> argTypes) {
        if (!this.jiffleName.equals(name)) {
            return false;
        }
        if ((argTypes == null || argTypes.isEmpty()) && !this.argTypes.isEmpty()) {
            return false;
        }
        if (argTypes != null && argTypes.size() != this.argTypes.size()) {
            return false;
        }
        int k = 0;
        for (String argType : this.argTypes) {
            if (argType.equals(argTypes.get(k++))) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Provider {
        JIFFLE("jiffle"),
        MATH("math"),
        PROXY("proxy");

        private String name;

        private Provider(String name) {
            this.name = name;
        }

        public static Provider get(String name) {
            String s = name.toLowerCase().trim();
            for (Provider p : Provider.values()) {
                if (!p.name.equals(s)) continue;
                return p;
            }
            return null;
        }
    }
}

