/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.jiffle.parser;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.RuleReturnScope;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jaitools.CollectionFactory;
import org.jaitools.jiffle.Jiffle;
import org.jaitools.jiffle.JiffleException;
import org.jaitools.jiffle.JiffleProperties;
import org.jaitools.jiffle.parser.CommentFinder;
import org.jaitools.jiffle.parser.DeferredErrorReporter;
import org.jaitools.jiffle.parser.ErrorHandlingTreeParser;
import org.jaitools.jiffle.parser.FunctionLookup;
import org.jaitools.jiffle.parser.OptionLookup;
import org.jaitools.jiffle.parser.SourceGenerator;
import org.jaitools.jiffle.parser.UndefinedFunctionException;
import org.jaitools.jiffle.parser.UndefinedOptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSourceGenerator
extends ErrorHandlingTreeParser
implements SourceGenerator {
    protected Jiffle.RuntimeModel model;
    protected String pkgName = JiffleProperties.get("runtime.package");
    protected List<String> imports = CollectionFactory.list();
    protected String className;
    protected String baseClassName;
    protected int varIndex = 0;

    public AbstractSourceGenerator(TreeNodeStream input) {
        this(input, new RecognizerSharedState());
    }

    protected AbstractSourceGenerator(TreeNodeStream input, RecognizerSharedState state) {
        super(input, state);
        String value = JiffleProperties.get("runtime.imports");
        if (value != null && value.trim().length() != 0) {
            this.imports.addAll(Arrays.asList(value.split(";")));
        }
    }

    @Override
    public void setRuntimeModel(Jiffle.RuntimeModel model) {
        this.model = model;
        switch (model) {
            case DIRECT: {
                this.className = JiffleProperties.get("direct.class");
                break;
            }
            case INDIRECT: {
                this.className = JiffleProperties.get("indirect.class");
                break;
            }
            default: {
                throw new IllegalArgumentException("Internal compiler error");
            }
        }
    }

    @Override
    public void setBaseClassName(String baseClassName) {
        this.baseClassName = baseClassName;
    }

    @Override
    public String getSource(String script) throws JiffleException {
        if (this.model == null) {
            throw new RuntimeException("Runtime model has not been set");
        }
        if (this.baseClassName == null || this.baseClassName.trim().length() == 0) {
            throw new RuntimeException("Base class name has not been set");
        }
        String commonTemplateFile = JiffleProperties.get("common.source.templates");
        String modelTemplateFile = null;
        switch (this.model) {
            case DIRECT: {
                modelTemplateFile = JiffleProperties.get("direct.source.templates");
                break;
            }
            case INDIRECT: {
                modelTemplateFile = JiffleProperties.get("indirect.source.templates");
            }
        }
        try {
            InputStream strm = AbstractSourceGenerator.class.getResourceAsStream(commonTemplateFile);
            InputStreamReader reader = new InputStreamReader(strm);
            StringTemplateGroup commonSTG = new StringTemplateGroup((Reader)reader);
            reader.close();
            strm = AbstractSourceGenerator.class.getResourceAsStream(modelTemplateFile);
            reader = new InputStreamReader(strm);
            StringTemplateGroup modelSTG = new StringTemplateGroup((Reader)reader);
            this.setTemplateLib(modelSTG);
            reader.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.setErrorReporter(new DeferredErrorReporter());
            return this.generate(script).getTemplate().toString();
        }
        catch (RecognitionException ex) {
            if (this.errorReporter != null && this.errorReporter.getNumErrors() > 0) {
                throw new JiffleException(this.errorReporter.getErrors());
            }
            throw new JiffleException("Error creating runtime source. No details available.");
        }
    }

    protected abstract RuleReturnScope generate(String var1) throws RecognitionException;

    public abstract void setTemplateLib(StringTemplateGroup var1);

    protected String getRuntimeExpr(String name, List<String> argTypes) {
        try {
            return FunctionLookup.getRuntimeExpr(name, argTypes);
        }
        catch (UndefinedFunctionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected String getRuntimeExpr(String name, String ... argTypes) {
        return this.getRuntimeExpr(name, Arrays.asList(argTypes));
    }

    protected String getOptionExpr(String name, String value) {
        try {
            return OptionLookup.getActiveRuntimExpr(name, value);
        }
        catch (UndefinedOptionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected void addImport(String ... importNames) {
        for (String name : importNames) {
            boolean found = false;
            for (String imp : this.imports) {
                if (!imp.equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.imports.add(name);
        }
    }

    protected List<String> prepareScriptForComments(String script) {
        ANTLRStringStream stream = new ANTLRStringStream(script);
        CommentFinder finder = new CommentFinder((CharStream)stream);
        Token tok = finder.nextToken();
        while (tok.getType() != -1) {
            tok = finder.nextToken();
        }
        List<Integer> indices = finder.getStartEndIndices();
        StringBuilder sb = new StringBuilder();
        if (indices.isEmpty()) {
            sb.append(script);
        } else {
            int pos = 0;
            for (int i = 0; i < indices.size() && pos < script.length(); i += 2) {
                int start = indices.get(i);
                int end = indices.get(i + 1);
                sb.append(script.substring(pos, start));
                pos = end;
            }
            if (pos < script.length()) {
                sb.append(script.substring(pos, script.length()));
            }
        }
        String[] lines = sb.toString().split("[\n\r]+");
        return Arrays.asList(lines);
    }
}

