/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.jiffle;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.media.jai.TiledImage;
import org.jaitools.CollectionFactory;
import org.jaitools.imageutils.ImageUtils;
import org.jaitools.jiffle.Jiffle;
import org.jaitools.jiffle.JiffleException;
import org.jaitools.jiffle.runtime.CoordinateTransform;
import org.jaitools.jiffle.runtime.IdentityCoordinateTransform;
import org.jaitools.jiffle.runtime.JiffleDirectRuntime;

public class JiffleBuilder {
    private static final double EPS = 1.0E-8;
    private WorldInfo worldInfo;
    private String script;
    private final Map<String, Jiffle.ImageRole> imageParams = CollectionFactory.orderedMap();
    private final Map<String, ImageRef> images = CollectionFactory.orderedMap();
    private CoordinateTransform _defaultTransform;
    private final Map<String, CoordinateTransform> transforms = CollectionFactory.orderedMap();

    public void clear() {
        this.worldInfo = null;
        this._defaultTransform = null;
        this.script = null;
        this.imageParams.clear();
        this.images.clear();
        this.transforms.clear();
    }

    public JiffleBuilder worldAndRes(Rectangle2D worldBounds, double xres, double yres) {
        if (worldBounds == null || worldBounds.isEmpty()) {
            throw new IllegalArgumentException("bounds must not be null or empty");
        }
        if (xres <= 1.0E-8) {
            throw new IllegalArgumentException("xres must be greater than zero");
        }
        if (xres <= 1.0E-8) {
            throw new IllegalArgumentException("xres must be greater than zero");
        }
        return this.doSetWorld(worldBounds, xres, yres);
    }

    public JiffleBuilder worldAndNumPixels(Rectangle2D worldBounds, int numX, int numY) {
        if (worldBounds == null || worldBounds.isEmpty()) {
            throw new IllegalArgumentException("bounds must not be null or empty");
        }
        if (numX <= 0) {
            throw new IllegalArgumentException("numX must be greater than zero");
        }
        if (numY <= 0) {
            throw new IllegalArgumentException("numY must be greater than zero");
        }
        double xres = worldBounds.getWidth() / (double)numX;
        double yres = worldBounds.getHeight() / (double)numY;
        return this.doSetWorld(worldBounds, xres, yres);
    }

    private JiffleBuilder doSetWorld(Rectangle2D worldBounds, double xres, double yres) {
        this.worldInfo = new WorldInfo();
        this.worldInfo.bounds = worldBounds;
        this.worldInfo.xres = xres;
        this.worldInfo.yres = yres;
        return this;
    }

    public JiffleBuilder script(String script) {
        this.script = script;
        return this;
    }

    public JiffleBuilder script(File scriptFile) throws JiffleException {
        this.script = this.readScriptFile(scriptFile);
        return this;
    }

    public JiffleBuilder source(String varName, RenderedImage sourceImage) {
        return this.source(varName, sourceImage, null);
    }

    public JiffleBuilder source(String varName, RenderedImage sourceImage, CoordinateTransform transform) {
        this.imageParams.put(varName, Jiffle.ImageRole.SOURCE);
        this.images.put(varName, new ImageRef(sourceImage, true));
        this.transforms.put(varName, transform);
        return this;
    }

    public JiffleBuilder dest(String varName, Rectangle destBounds) {
        if (destBounds == null || destBounds.isEmpty()) {
            throw new IllegalArgumentException("destBounds argument cannot be null or empty");
        }
        return this.dest(varName, destBounds.x, destBounds.y, destBounds.width, destBounds.height);
    }

    public JiffleBuilder dest(String varName, Rectangle destBounds, CoordinateTransform transform) {
        if (destBounds == null || destBounds.isEmpty()) {
            throw new IllegalArgumentException("destBounds argument cannot be null or empty");
        }
        return this.dest(varName, destBounds.x, destBounds.y, destBounds.width, destBounds.height, transform);
    }

    public JiffleBuilder dest(String varName, int width, int height) {
        return this.dest(varName, 0, 0, width, height);
    }

    public JiffleBuilder dest(String varName, int width, int height, CoordinateTransform transform) {
        return this.dest(varName, 0, 0, width, height, transform);
    }

    public JiffleBuilder dest(String varName, int minx, int miny, int width, int height) {
        return this.dest(varName, minx, miny, width, height, null);
    }

    public JiffleBuilder dest(String varName, int minx, int miny, int width, int height, CoordinateTransform transform) {
        TiledImage image = ImageUtils.createConstantImage((int)minx, (int)miny, (int)width, (int)height, (Number)0.0);
        this.imageParams.put(varName, Jiffle.ImageRole.DEST);
        this.images.put(varName, new ImageRef((RenderedImage)image, false));
        this.transforms.put(varName, transform);
        return this;
    }

    public JiffleBuilder dest(String varName, WritableRenderedImage destImage) {
        return this.dest(varName, destImage, null);
    }

    public JiffleBuilder dest(String varName, WritableRenderedImage destImage, CoordinateTransform transform) {
        this.imageParams.put(varName, Jiffle.ImageRole.DEST);
        this.images.put(varName, new ImageRef(destImage, true));
        this.transforms.put(varName, transform);
        return this;
    }

    public JiffleBuilder defaultTransform(CoordinateTransform transform) {
        this._defaultTransform = transform == null ? new IdentityCoordinateTransform() : transform;
        return this;
    }

    public JiffleBuilder run() throws JiffleException {
        this.getRuntime().evaluateAll(null);
        return this;
    }

    public JiffleDirectRuntime getRuntime() throws JiffleException {
        if (this.script == null) {
            throw new IllegalStateException("Jiffle script has not been set yet");
        }
        Jiffle jiffle = new Jiffle(this.script, this.imageParams);
        JiffleDirectRuntime runtime = jiffle.getRuntimeInstance();
        runtime.setDefaultTransform(this._defaultTransform);
        if (this.worldInfo != null) {
            runtime.setWorldByResolution(this.worldInfo.bounds, this.worldInfo.xres, this.worldInfo.yres);
        }
        for (String var : this.images.keySet()) {
            RenderedImage img = this.images.get(var).get();
            if (img == null) {
                throw new JiffleException("Image for variable " + var + " has been garbage collected");
            }
            CoordinateTransform transform = this.transforms.get(var);
            switch (this.imageParams.get(var)) {
                case SOURCE: {
                    runtime.setSourceImage(var, img, transform);
                    break;
                }
                case DEST: {
                    runtime.setDestinationImage(var, (WritableRenderedImage)img, transform);
                }
            }
        }
        return runtime;
    }

    public String getRuntimeSource() throws JiffleException {
        if (this.script == null) {
            throw new IllegalStateException("Jiffle script has not been set yet");
        }
        Jiffle jiffle = new Jiffle(this.script, this.imageParams);
        return jiffle.getRuntimeSource(Jiffle.RuntimeModel.DIRECT, true);
    }

    public RenderedImage getImage(String varName) {
        ImageRef ref = this.images.get(varName);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public RenderedImage removeImage(String varName) {
        ImageRef ref = this.images.remove(varName);
        this.transforms.remove(varName);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    private String readScriptFile(File scriptFile) throws JiffleException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(scriptFile));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                sb.append(line);
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            throw new JiffleException("Could not read the script file", ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private static class ImageRef {
        Object ref;
        boolean weak;

        ImageRef(RenderedImage image, boolean weak) {
            this.ref = weak ? new WeakReference<RenderedImage>(image) : image;
            this.weak = weak;
        }

        RenderedImage get() {
            if (this.weak) {
                RenderedImage image = (RenderedImage)((WeakReference)this.ref).get();
                return image;
            }
            return (RenderedImage)this.ref;
        }
    }

    private static class WorldInfo {
        Rectangle2D bounds;
        double xres;
        double yres;

        private WorldInfo() {
        }
    }
}

