/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.oracle;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.AbstractDataStoreServiceExtension;
import net.refractions.udig.catalog.ServiceExtension2;
import net.refractions.udig.catalog.internal.oracle.OraclePlugin;
import net.refractions.udig.catalog.internal.oracle.OracleServiceImpl;
import net.refractions.udig.catalog.oracle.internal.Messages;
import net.refractions.udig.core.internal.CorePlugin;
import org.eclipse.core.runtime.Platform;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.oracle.OracleNGDataStoreFactory;

public class OracleServiceExtension
extends AbstractDataStoreServiceExtension
implements ServiceExtension2 {
    private static OracleNGDataStoreFactory factory = null;

    public OracleServiceImpl createService(URL id, Map<String, Serializable> params) {
        block9: {
            try {
                if (OracleServiceExtension.getFactory() != null && OracleServiceExtension.getFactory().isAvailable()) break block9;
                return null;
            }
            catch (Exception unexpected) {
                if (Platform.inDevelopmentMode()) {
                    OraclePlugin.log("OracleServiceExtension canProcess errored out with: " + unexpected, unexpected);
                }
                return null;
            }
        }
        if (!OracleServiceExtension.getFactory().canProcess(params)) {
            return null;
        }
        if (id == null) {
            String jdbc_url = OracleServiceExtension.getJDBCUrl(params);
            if (jdbc_url == null) {
                return null;
            }
            try {
                id = new URL(null, jdbc_url, CorePlugin.RELAXED_HANDLER);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return new OracleServiceImpl(id, params);
    }

    public Map<String, Serializable> createParams(URL url) {
        if (!OracleServiceExtension.isOracle(url)) {
            return null;
        }
        AbstractDataStoreServiceExtension.ParamInfo info = this.parseParamInfo(url);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(OracleNGDataStoreFactory.DBTYPE.key, (Serializable)((Object)"oracle"));
        params.put(OracleNGDataStoreFactory.HOST.key, (Serializable)((Object)info.host));
        params.put(OracleNGDataStoreFactory.PORT.key, info.the_port);
        params.put(OracleNGDataStoreFactory.USER.key, (Serializable)((Object)info.username));
        params.put(OracleNGDataStoreFactory.PASSWD.key, (Serializable)((Object)info.password));
        params.put(OracleNGDataStoreFactory.DATABASE.key, (Serializable)((Object)info.the_database));
        return params;
    }

    public static synchronized OracleNGDataStoreFactory getFactory() {
        if (factory == null) {
            factory = new OracleNGDataStoreFactory();
        }
        return factory;
    }

    static String getJDBCUrl(Map<String, Serializable> params) {
        try {
            String host = (String)OracleNGDataStoreFactory.HOST.lookUp(params);
            String db = (String)OracleNGDataStoreFactory.DATABASE.lookUp(params);
            int port = (Integer)OracleNGDataStoreFactory.PORT.lookUp(params);
            if (db.startsWith("(")) {
                return "jdbc:oracle:thin:@" + db;
            }
            if (db.startsWith("/")) {
                return "jdbc:oracle:thin:@//" + host + ":" + port + db;
            }
            return "jdbc:oracle:thin:@" + host + ":" + port + ":" + db;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static final boolean isOracle(URL url) {
        if (url == null) {
            return false;
        }
        return url.getProtocol().toLowerCase().equals("oracle") || url.getProtocol().toLowerCase().equals("oracle.jdbc") || url.getProtocol().toLowerCase().equals("jdbc.oracle");
    }

    public String reasonForFailure(URL url) {
        if (!OracleServiceExtension.isOracle(url)) {
            return Messages.OracleServiceExtension_badUrl;
        }
        return this.reasonForFailure(this.createParams(url));
    }

    protected DataStoreFactorySpi getDataStoreFactory() {
        return OracleServiceExtension.getFactory();
    }
}

