/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.workflow;

import java.lang.reflect.InvocationTargetException;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.Listener;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.Workflow;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizard;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardAdapter;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPage;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WorkflowWizardDialog
extends WizardDialog
implements Listener {
    boolean headless = false;
    private WorkflowWizardAdapter workflowWizardAdapter;

    public WorkflowWizardDialog(Shell parentShell, WorkflowWizard wizard) {
        super(parentShell, (IWizard)wizard);
        wizard.getWorkflow().addListener(this);
    }

    protected WorkflowWizard getWizard() {
        return (WorkflowWizard)super.getWizard();
    }

    public WorkflowWizard getWorkflowWizard() {
        return this.getWizard();
    }

    public WorkflowWizardPage getCurrentPage() {
        return (WorkflowWizardPage)super.getCurrentPage();
    }

    protected void nextPressed() {
        if (this.getWorkflowWizard().getWorkflow().isFinished()) {
            return;
        }
        if (!this.getCurrentPage().leavingPage()) {
            return;
        }
        final Workflow pipe = this.getWizard().getWorkflow();
        try {
            this.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    pipe.next(monitor);
                }
            });
        }
        catch (Exception e) {
            CatalogUIPlugin.log("Exception while moving workflow forward", e);
        }
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress request) throws InvocationTargetException, InterruptedException {
        if (this.headless && Display.getCurrent() == null) {
            PlatformGIS.run((IRunnableWithProgress)request);
            return;
        }
        if (this.getProgressMonitor() instanceof ProgressMonitorPart) {
            ProgressMonitorPart part = (ProgressMonitorPart)this.getProgressMonitor();
            if (Display.getCurrent() != null) {
                part.setVisible(true);
            }
            try {
                this.setEnablement(this.buttonBar, false);
                if (fork) {
                    PlatformGIS.run((IRunnableWithProgress)request, (IProgressMonitor)part);
                }
                PlatformGIS.runBlockingOperation((IRunnableWithProgress)request, (IProgressMonitor)part);
            }
            finally {
                this.setEnablement(this.buttonBar, true);
                if (Display.getCurrent() != null && !part.isDisposed()) {
                    part.setVisible(false);
                }
            }
        } else if (fork) {
            PlatformGIS.run((IRunnableWithProgress)request);
        } else {
            PlatformGIS.runBlockingOperation((IRunnableWithProgress)request, (IProgressMonitor)ProgressManager.instance().get(new Object[0]));
        }
    }

    private void setEnablement(Control controlA, boolean enabled) {
        if (controlA == null) {
            return;
        }
        if (controlA instanceof Composite) {
            Control[] children;
            Composite composite = (Composite)controlA;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                this.setEnablement(control, enabled);
                ++n2;
            }
        } else if (controlA != this.getButton(1)) {
            controlA.setEnabled(enabled);
        }
    }

    protected void nextPressedSuper() {
        try {
            super.nextPressed();
        }
        catch (Exception e) {
            this.setErrorMessage(Messages.WorkflowWizard_PageTransitionError);
            CatalogUIPlugin.log("WorkflowWizardDialog#nextPressedSuper(): Error moving to " + this.getWorkflowWizard().getWorkflow().getCurrentState().getName(), e);
        }
    }

    protected void backPressed() {
        final Workflow pipe = this.getWizard().getWorkflow();
        if (pipe.getCurrentState().getPreviousState() == null) {
            this.workflowWizardAdapter.backPressed();
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                pipe.previous(monitor);
            }
        };
        try {
            this.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            CatalogUIPlugin.log(e.getLocalizedMessage(), e);
        }
        catch (InterruptedException e) {
            CatalogUIPlugin.log(e.getLocalizedMessage(), e);
        }
    }

    protected void backPressedSuper() {
        super.backPressed();
    }

    protected void finishPressed() {
        if (this.getWorkflowWizard().getWorkflow().isFinished()) {
            return;
        }
        if (!this.getCurrentPage().leavingPage()) {
            return;
        }
        final Workflow pipe = this.getWizard().getWorkflow();
        try {
            this.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    pipe.run(monitor);
                }
            });
        }
        catch (Exception e) {
            CatalogUIPlugin.log("Exception while moving workflow forward", e);
        }
    }

    protected void finishPressedSuper() {
        super.finishPressed();
    }

    public int open() {
        this.initWorkflow();
        return super.open();
    }

    public boolean close() {
        this.getWorkflowWizard().getWorkflow().shutdown();
        return super.close();
    }

    public void showPage(IWizardPage page) {
        super.showPage(page);
        ((WorkflowWizardPage)page).shown();
    }

    public boolean runHeadless(IProgressMonitor monitor) {
        try {
            WorkflowWizardPage page;
            this.headless = true;
            int ticks = this.getWorkflowWizard().getWorkflow().getStates().length * 10;
            monitor.beginTask(Messages.WorkflowWizardDialog_importTask, ticks);
            if (this.getShell() == null) {
                PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WorkflowWizardDialog.this.create();
                    }
                });
            }
            Workflow pipe = this.getWizard().getWorkflow();
            pipe.run((IProgressMonitor)new SubProgressMonitor(monitor, ticks));
            boolean[] result = new boolean[]{true};
            if (!pipe.isFinished() && (page = this.getWizard().getPage(pipe.getCurrentState())) != null) {
                WorkflowWizardPage dpPage;
                if (page instanceof WorkflowWizardPage && (dpPage = page).getState() == null) {
                    dpPage.setState(pipe.getCurrentState());
                }
                PlatformGIS.syncInDisplayThread((Runnable)new Runnable((IWizardPage)page, result){
                    private final /* synthetic */ IWizardPage val$page;
                    private final /* synthetic */ boolean[] val$result;
                    {
                        this.val$page = iWizardPage;
                        this.val$result = blArray;
                    }

                    @Override
                    public void run() {
                        WorkflowWizardDialog.this.headless = false;
                        WorkflowWizardDialog.this.showPage(this.val$page);
                        if (WorkflowWizardDialog.this.open() == 1) {
                            this.val$result[0] = false;
                        }
                    }
                });
            }
            this.headless = false;
            boolean bl = result[0];
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    protected void initWorkflow() {
        final Workflow pipe = this.getWizard().getWorkflow();
        final IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (!pipe.started) {
                    pipe.start(monitor);
                }
            }
        };
        if (Display.getCurrent() != null) {
            try {
                runnable.run(ProgressManager.instance().get(new Object[0]));
            }
            catch (Exception e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        } else {
            PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, runnable);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    @Override
    public void started(State first) {
    }

    @Override
    public void forward(State current, State prev) {
        if (this.headless) {
            return;
        }
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WorkflowWizardDialog.this.nextPressedSuper();
            }
        });
    }

    @Override
    public void backward(State current, State next) {
        if (this.headless) {
            return;
        }
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WorkflowWizardDialog.this.backPressedSuper();
            }
        });
    }

    @Override
    public void statePassed(State state) {
    }

    @Override
    public void stateFailed(State state) {
    }

    @Override
    public void finished(State last) {
        if (this.headless) {
            this.getWizard().performFinish();
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WorkflowWizardDialog.this.finishPressedSuper();
                }
            };
            PlatformGIS.asyncInDisplayThread((Runnable)runnable, (boolean)true);
        }
    }

    void setAdapter(WorkflowWizardAdapter workflowWizardAdapter, IWizardPage previousPage) {
        this.workflowWizardAdapter = workflowWizardAdapter;
        IWizardPage startingPage = this.getWizard().getStartingPage();
        startingPage.setPreviousPage(previousPage);
        this.updateButtons();
    }
}

