/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.workflow;

import net.refractions.udig.catalog.ui.workflow.WorkflowWizard;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class WorkflowWizardAdapter
extends Wizard
implements IImportWizard,
IExportWizard,
Listener {
    private WorkflowWizardDialog dialog;
    private final WorkflowWizard wizard;
    private WizardPage placeHolderPage;

    public WorkflowWizardAdapter(WorkflowWizard wizard) {
        this.wizard = wizard;
        this.placeHolderPage = new WizardPage("placeholder"){

            public void createControl(Composite parent) {
                this.setControl((Control)new Composite(parent, 0));
            }

            public IWizard getWizard() {
                return WorkflowWizardAdapter.this;
            }
        };
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        this.getStartingPage();
    }

    public boolean performFinish() {
        return false;
    }

    public IWizardPage getStartingPage() {
        if (this.getContainer() == null) {
            return this.placeHolderPage;
        }
        Shell containerShell = this.getContainer().getShell();
        if (this.dialog == null) {
            Shell shell = new Shell(containerShell.getDisplay());
            this.configureShell(containerShell, shell);
            this.dialog = new WorkflowWizardDialog(shell, this.wizard);
            this.dialog.setBlockOnOpen(false);
            this.dialog.open();
            this.dialog.setAdapter(this, this.placeHolderPage.getPreviousPage());
            this.dialog.getShell().addListener(12, (Listener)this);
        }
        Shell adapterShell = this.dialog.getShell();
        this.configureShell(containerShell, adapterShell);
        adapterShell.setVisible(true);
        containerShell.setVisible(false);
        return this.placeHolderPage;
    }

    void backPressed() {
        Shell containerShell = this.getContainer().getShell();
        Shell adapterShell = this.dialog.getShell();
        this.configureShell(adapterShell, containerShell);
        containerShell.setVisible(true);
        adapterShell.setVisible(false);
    }

    private void configureShell(Shell from, Shell to) {
        to.setLocation(from.getLocation());
        to.setSize(from.getSize());
        this.getContainer().showPage(this.placeHolderPage.getPreviousPage());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (this.wizard instanceof IWorkbenchWizard) {
            IWorkbenchWizard workbenchWizard = (IWorkbenchWizard)this.wizard;
            workbenchWizard.init(workbench, selection);
        }
    }

    public void handleEvent(Event event) {
        if (this.getContainer() != null && this.getContainer().getShell() != null) {
            this.getContainer().getShell().close();
        }
    }
}

