/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.workflow;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.DefaultThreading;
import net.refractions.udig.catalog.ui.workflow.Listener;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.ThreadingStrategy;
import net.refractions.udig.core.Pair;
import net.refractions.udig.ui.OffThreadProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;

public class Workflow {
    private State[] states;
    private Map<Class<State>, State> lookup;
    private LinkedList<State> queue;
    private State current;
    private Set<Listener> listeners = new CopyOnWriteArraySet<Listener>();
    boolean started = false;
    private boolean finished = false;
    private Object context;
    private ThreadingStrategy threading;

    public Workflow(ThreadingStrategy threading) {
        threading.init();
        this.threading = threading;
    }

    public Workflow(ThreadingStrategy strategy, State[] states) {
        this(strategy);
        this.setStates(states);
    }

    public Workflow() {
        this(new DefaultThreading());
    }

    public Workflow(State[] states) {
        this(new DefaultThreading(), states);
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    public void shutdown() {
        this.threading.shutdown();
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public void setStates(State[] states) {
        int i2 = 0;
        if (states != null) {
            i2 = states.length;
        }
        State[] s = new State[i2];
        if (states != null) {
            System.arraycopy(states, 0, s, 0, s.length);
        }
        this.states = s;
        this.queue = new LinkedList();
        this.lookup = new HashMap<Class<State>, State>();
        int i = 0;
        while (i < s.length) {
            s[i].setWorkflow(this);
            this.queue.addLast(s[i]);
            this.lookup.put(s[i].getClass(), s[i]);
            ++i;
        }
    }

    public State[] getStates() {
        State[] s = new State[this.states.length];
        System.arraycopy(this.states, 0, s, 0, s.length);
        return s;
    }

    public <T> T getState(Class<T> c) {
        State state = this.lookup.get(c);
        if (state == null) {
            for (State current : this.lookup.values()) {
                if (!c.isAssignableFrom(current.getClass())) continue;
                state = current;
                break;
            }
        }
        return c.cast(state);
    }

    public void start() {
        this.start((IProgressMonitor)new NullProgressMonitor());
    }

    public void start(IProgressMonitor monitor) {
        final IProgressMonitor progressMonitor = this.checkMonitor(monitor);
        this.threading.init();
        Runnable request = new Runnable(){

            @Override
            public void run() {
                try {
                    Workflow.this.current = (State)Workflow.this.queue.removeFirst();
                    Workflow.this.current.setPrevious(null);
                    Workflow.this.current.init(progressMonitor);
                    Workflow.this.started = true;
                    Workflow.this.dispatchStarted(Workflow.this.current);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String toString() {
                return "Workflow.java start() task";
            }
        };
        this.threading.run(request);
    }

    public boolean dryRun() {
        LinkedList<State> copiedQueue = new LinkedList<State>(this.queue);
        State state = this.getCurrentState();
        while (state != null) {
            Pair<Boolean, State> dryRunResult = state.dryRun();
            if (!((Boolean)dryRunResult.getLeft()).booleanValue()) {
                return false;
            }
            state = (State)dryRunResult.getRight();
            if (state != null) continue;
            state = (State)copiedQueue.poll();
        }
        return true;
    }

    public void next() {
        this.next((IProgressMonitor)new NullProgressMonitor());
    }

    public void next(IProgressMonitor monitor) {
        final IProgressMonitor progressMonitor = this.checkMonitor(monitor);
        Runnable request = new Runnable(){

            @Override
            public void run() {
                Workflow.this.doNextInternal(progressMonitor);
            }

            public String toString() {
                return "Workflow.java run() task";
            }
        };
        this.threading.run(request);
    }

    private IProgressMonitor checkMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            throw new NullPointerException("monitor is null");
        }
        Object progressMonitor = monitor instanceof OffThreadProgressMonitor ? monitor : new OffThreadProgressMonitor(monitor);
        return progressMonitor;
    }

    private void doNextInternal(IProgressMonitor monitor) {
        block19: {
            try {
                SubProgressMonitor subProgressMonitor;
                boolean ok;
                block17: {
                    this.assertStarted();
                    this.assertNotFinished();
                    String name = this.getCurrentState().getName();
                    String string = name != null ? name : Messages.Workflow_busy;
                    monitor.beginTask(string, 20);
                    monitor.setTaskName(string);
                    if (this.queue == null) {
                        String msg = "No states";
                        throw new IllegalStateException(msg);
                    }
                    ok = false;
                    subProgressMonitor = new SubProgressMonitor(monitor, 10);
                    try {
                        try {
                            ok = this.current.run((IProgressMonitor)subProgressMonitor) && !monitor.isCanceled();
                        }
                        catch (Throwable t) {
                            CatalogUIPlugin.log(t.getLocalizedMessage(), t);
                            if (Platform.inDevelopmentMode()) {
                                System.out.println("Could not " + this.current.getName() + ":" + t.getLocalizedMessage());
                                t.printStackTrace();
                            }
                            subProgressMonitor.done();
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        subProgressMonitor.done();
                        throw throwable;
                    }
                    subProgressMonitor.done();
                }
                if (ok) {
                    this.dispatchPassed(this.current);
                    State next = this.current.next();
                    if (next == null) {
                        if (!this.queue.isEmpty()) {
                            next = this.queue.removeFirst();
                        }
                    } else {
                        this.lookup.put(next.getClass(), next);
                    }
                    if (next != null) {
                        next.setWorkflow(this);
                        next.setPrevious(this.current);
                        try {
                            subProgressMonitor = new SubProgressMonitor(monitor, 10);
                            next.init((IProgressMonitor)subProgressMonitor);
                        }
                        finally {
                            subProgressMonitor.done();
                        }
                        State prev = this.current;
                        this.current = next;
                        this.dispatchForward(this.current, prev);
                        break block19;
                    }
                    State last = this.current;
                    this.current = null;
                    this.finished = true;
                    this.threading.shutdown();
                    this.dispatchFinished(last);
                    break block19;
                }
                this.dispatchFailed(this.current);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void previous() {
        this.previous((IProgressMonitor)new NullProgressMonitor());
    }

    public void previous(IProgressMonitor monitor) {
        final IProgressMonitor progressMonitor = this.checkMonitor(monitor);
        Runnable request = new Runnable(){

            @Override
            public void run() {
                try {
                    Workflow.this.assertStarted();
                    Workflow.this.assertNotFinished();
                    if (Workflow.this.current.getPreviousState() != null) {
                        if (Workflow.this.isPrimaryState(Workflow.this.current)) {
                            Workflow.this.queue.addFirst(Workflow.this.current);
                        }
                        State next = Workflow.this.current;
                        Workflow.this.current = Workflow.this.current.getPreviousState();
                        Workflow.this.current.init(progressMonitor);
                        Workflow.this.dispatchBackward(Workflow.this.current, next);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String toString() {
                return "Workflow.java run() task";
            }
        };
        this.threading.run(request);
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public State getCurrentState() {
        return this.current;
    }

    public boolean hasMoreStates() {
        if (!this.queue.isEmpty()) {
            return true;
        }
        if (this.current != null) {
            return this.current.hasNext();
        }
        return false;
    }

    public boolean run(IProgressMonitor monitor) {
        if (monitor == null) {
            throw new NullPointerException("monitor is null");
        }
        WorkflowRunner runner = new WorkflowRunner(this);
        return runner.run(monitor);
    }

    public void reset() {
        this.assertFinished();
        this.finished = false;
        this.started = false;
        this.setStates(this.states);
    }

    protected void assertStarted() {
        if (!this.started) {
            String msg = "Not started";
            throw new IllegalStateException(msg);
        }
    }

    protected void assertNotStarted() {
        if (this.started) {
            String msg = "Already started";
            throw new IllegalStateException(msg);
        }
    }

    protected void assertFinished() {
        if (!this.finished) {
            String msg = "Not finished";
            throw new IllegalStateException(msg);
        }
    }

    protected void assertNotFinished() {
        if (this.finished) {
            String msg = "Already finished";
            throw new IllegalStateException(msg);
        }
    }

    protected boolean isPrimaryState(State state) {
        int i = 0;
        while (i < this.states.length) {
            if (this.states[i].equals(state)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void dispatchStarted(State start) {
        for (Listener l : this.listeners) {
            l.started(start);
        }
    }

    protected void dispatchForward(State current, State prev) {
        for (Listener l : this.listeners) {
            l.forward(current, prev);
        }
    }

    protected void dispatchBackward(State current, State next) {
        for (Listener l : this.listeners) {
            l.backward(current, next);
        }
    }

    protected void dispatchPassed(State state) {
        for (Listener l : this.listeners) {
            l.statePassed(state);
        }
    }

    protected void dispatchFailed(State state) {
        for (Listener l : this.listeners) {
            l.stateFailed(state);
        }
    }

    protected void dispatchFinished(State last) {
        for (Listener l : this.listeners) {
            l.finished(last);
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("Workflow: Start ");
        if (this.started) {
            text.append(" -> ");
        } else {
            text.append(" -- ");
        }
        State[] stateArray = this.states;
        int n = this.states.length;
        int n2 = 0;
        while (n2 < n) {
            State state = stateArray[n2];
            if (state == this.current) {
                text.append("[");
            }
            text.append(state.getName());
            if (state == this.current) {
                text.append("]");
            }
            if (this.queue.contains(state)) {
                text.append(" -- ");
            } else {
                text.append(" -> ");
            }
            ++n2;
        }
        if (this.finished) {
            text.append("[Finish]");
        } else {
            text.append("Finish");
        }
        return text.toString();
    }

    public static class WorkflowRunner
    implements Listener {
        Workflow pipe;
        boolean stopped;

        WorkflowRunner(Workflow pipe) {
            this.pipe = pipe;
        }

        public boolean run(final IProgressMonitor monitor) {
            final boolean[] result = new boolean[1];
            this.pipe.threading.run(new Runnable(){

                @Override
                public void run() {
                    result[0] = WorkflowRunner.this.runInternal(monitor);
                }
            });
            return result[0];
        }

        private boolean runInternal(IProgressMonitor monitor) {
            try {
                monitor.beginTask(Messages.Workflow_task_name, -1);
                this.stopped = false;
                this.pipe.addListener(this);
                if (this.pipe.isFinished()) {
                    return true;
                }
                if (!this.pipe.isStarted()) {
                    this.pipe.start(monitor);
                }
                while (!this.stopped && !this.pipe.isFinished()) {
                    this.pipe.next((IProgressMonitor)new SubProgressMonitor(monitor, 10, 4));
                }
                this.pipe.removeListener(this);
                boolean bl = !this.stopped;
                return bl;
            }
            finally {
                monitor.done();
            }
        }

        @Override
        public void forward(State current, State prev) {
        }

        @Override
        public void backward(State current, State next) {
        }

        @Override
        public void statePassed(State state) {
        }

        @Override
        public void stateFailed(State state) {
            this.stopped = true;
        }

        @Override
        public void started(State first) {
        }

        @Override
        public void finished(State last) {
        }
    }
}

