/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.workflow;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.EndConnectionState;
import net.refractions.udig.catalog.ui.workflow.ResourceSearchState;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.core.Pair;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ResourceSelectionState
extends State {
    Map<IGeoResource, IService> resources;
    private Collection<IService> services;

    public Collection<IService> getServices() {
        Collection<IService> imported;
        EndConnectionState state;
        if (this.services != null) {
            return this.services;
        }
        ArrayList<IService> list = new ArrayList<IService>();
        ResourceSearchState search = this.getWorkflow().getState(ResourceSearchState.class);
        if (search != null) {
            for (IResolve resolve : search.getSelected()) {
                if (resolve instanceof IGeoResource) {
                    try {
                        IGeoResource geoResource = (IGeoResource)resolve;
                        IService service = geoResource.service((IProgressMonitor)new NullProgressMonitor());
                        list.add(service);
                    }
                    catch (IOException t) {
                        CatalogUIPlugin.log("Unable to connect to service " + t, t);
                    }
                }
                if (!(resolve instanceof IService)) continue;
                IService service = (IService)resolve;
                list.add(service);
            }
        }
        if ((state = this.getWorkflow().getState(EndConnectionState.class)) != null && (imported = state.getServices()) != null) {
            list.addAll(imported);
        }
        return list;
    }

    public void setServices(Collection<IService> services) {
        this.services = services;
    }

    public void setResources(Map<IGeoResource, IService> resources) {
        this.resources = resources;
    }

    public Map<IGeoResource, IService> getResources() {
        return this.resources;
    }

    @Override
    public void init(IProgressMonitor monitor) throws IOException {
        ResourceSearchState search;
        super.init(monitor);
        this.resources = new LinkedHashMap<IGeoResource, IService>();
        Object context = this.getWorkflow().getContext();
        if (context != null) {
            URL url = CatalogPlugin.locateURL((Object)context);
            if (url != null) {
                this.addResource(monitor, url);
            } else if (context instanceof Iterable) {
                Iterable iterable = (Iterable)context;
                for (Iterator<Object> object : iterable) {
                    url = CatalogPlugin.locateURL(object);
                    if (url == null) continue;
                    this.addResource(monitor, url);
                }
            }
        }
        if ((search = this.getWorkflow().getState(ResourceSearchState.class)) != null) {
            for (IResolve resolve : search.getSelected()) {
                if (!(resolve instanceof IGeoResource)) continue;
                IGeoResource geoResource = (IGeoResource)resolve;
                IService service = geoResource.service((IProgressMonitor)new NullProgressMonitor());
                this.resources.put(geoResource, service);
            }
        }
        Collection<IService> services = this.getServices();
        ArrayList<IService> toRemove = new ArrayList<IService>();
        if (services != null) {
            for (IService service : services) {
                List members = service.resources(monitor);
                if (members != null && members.size() < 1) {
                    toRemove.add(service);
                    continue;
                }
                this.addPreferredResources(service, members);
                this.selectResourcesForDND(service, members);
            }
        }
        if (!toRemove.isEmpty()) {
            services.removeAll(toRemove);
        }
    }

    private void selectResourcesForDND(IService service, List<? extends IGeoResource> members) {
        if (members.size() == 1) {
            this.resources.put(members.get(0), service);
        }
    }

    private void addPreferredResources(IService service, List<? extends IGeoResource> members) {
        Collection<URL> selectedResources = this.getPreferredResources();
        block0: for (IGeoResource iGeoResource : members) {
            for (URL url : selectedResources) {
                if (this.resources.size() >= selectedResources.size() || !URLUtils.urlEquals((URL)url, (URL)iGeoResource.getIdentifier(), (boolean)false)) continue;
                this.resources.put(iGeoResource, service);
                continue block0;
            }
        }
    }

    private Collection<URL> getPreferredResources() {
        EndConnectionState state = this.getWorkflow().getState(EndConnectionState.class);
        if (state == null) {
            return Collections.emptyList();
        }
        Collection<URL> selectedResources = state.getSelectedResources();
        return selectedResources;
    }

    private void addResource(IProgressMonitor monitor, URL url) throws IOException {
        IGeoResource match = this.match(this.getServices(), url, monitor);
        if (match != null) {
            this.resources.put(match, match.service(monitor));
        }
    }

    @Override
    public Pair<Boolean, State> dryRun() {
        boolean resourcesReady = this.resources != null && !this.resources.isEmpty();
        boolean connectionStateProvidesSelection = !this.getPreferredResources().isEmpty();
        boolean done = resourcesReady || connectionStateProvidesSelection;
        return new Pair((Object)done, null);
    }

    @Override
    public boolean run(IProgressMonitor monitor) throws IOException {
        if (this.resources == null || this.resources.isEmpty()) {
            return false;
        }
        HashSet<IService> parents = new HashSet<IService>();
        for (Map.Entry<IGeoResource, IService> entry : this.resources.entrySet()) {
            parents.add(entry.getValue());
        }
        Collection<IService> services = this.getServices();
        if (services != null) {
            try {
                monitor.beginTask("", services.size() * 10);
                for (IService service : services) {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
                    try {
                        URL identifier = service.getIdentifier();
                        monitor.setTaskName(MessageFormat.format(Messages.ResourceSelectionState_taskName, String.valueOf(identifier.getProtocol()) + "://" + identifier.getPath()));
                        service.resources((IProgressMonitor)subMonitor).size();
                    }
                    finally {
                        subMonitor.done();
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
        return this.resources.size() > 0;
    }

    private IGeoResource match(Collection<IService> services, URL url, IProgressMonitor monitor) throws IOException {
        if (url.getRef() == null || url.getRef().isEmpty()) {
            return null;
        }
        for (IService service : services) {
            for (IGeoResource resource : service.resources(monitor)) {
                if (resource.getIdentifier() == null || !url.equals(resource.getIdentifier())) continue;
                return resource;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return Messages.ResourceSelectionState_stateName;
    }
}

