/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.workflow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.DataSourceSelectionState;
import net.refractions.udig.catalog.ui.workflow.ImportPlaceholder;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.core.Pair;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class ResourceSearchState
extends State {
    public static final IResolve IMPORT_PLACEHOLDER = new ImportPlaceholder();
    private String search;
    private ReferencedEnvelope extent;
    private List<IResolve> results;
    private Set<IResolve> selected = Collections.emptySet();

    @Override
    public void init(IProgressMonitor monitor) throws IOException {
        this.results = new ArrayList<IResolve>();
        this.selected = new HashSet<IResolve>();
        Object context = this.getWorkflow().getContext();
        if (context != null) {
            if (context instanceof String) {
                this.search = (String)context;
            }
            if (context instanceof IResolve) {
                this.results.add((IResolve)context);
            }
            if (context instanceof Iterable) {
                Iterable iterable = (Iterable)context;
                for (Object object : iterable) {
                    if (!(object instanceof IResolve)) continue;
                    this.results.add((IResolve)object);
                }
            }
        }
        if (this.results != null && this.results.size() == 1) {
            this.selected.add(this.results.get(0));
        }
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public ReferencedEnvelope getExtent() {
        return this.extent;
    }

    public void setExtent(ReferencedEnvelope extent) {
        this.extent = extent;
    }

    public List<IResolve> getResults() {
        return this.results;
    }

    public Set<IResolve> getSelected() {
        return this.selected;
    }

    public void setSelected(Set<IResolve> selected) {
        this.selected = selected;
    }

    @Override
    public Pair<Boolean, State> dryRun() {
        boolean singeSelection = this.selected != null && this.selected.size() == 1;
        return new Pair((Object)singeSelection, null);
    }

    @Override
    public boolean run(IProgressMonitor monitor) throws IOException {
        return this.selected != null && !this.selected.isEmpty();
    }

    @Override
    public boolean hasNext() {
        if (this.selected == null || this.selected.isEmpty()) {
            return false;
        }
        return this.selected.contains(IMPORT_PLACEHOLDER);
    }

    @Override
    public State next() {
        if (this.selected.isEmpty()) {
            return null;
        }
        if (this.selected.contains(IMPORT_PLACEHOLDER)) {
            DataSourceSelectionState dsState = new DataSourceSelectionState(true);
            return dsState;
        }
        return null;
    }

    @Override
    public String getName() {
        return Messages.ResourceSelectionPage_searching;
    }
}

