/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.workflow;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.workflow.ThreadingStrategy;
import org.eclipse.swt.widgets.Display;

public class DefaultThreading
implements ThreadingStrategy {
    private WorkflowThread thread;

    @Override
    public synchronized void init() {
        if (this.thread == null) {
            this.thread = new WorkflowThread();
            this.thread.setDaemon(true);
            this.thread.setName("Workflow Thread");
            this.thread.start();
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    @Override
    public void shutdown() {
        if (this.thread != null && this.thread.running) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DefaultThreading.this.thread.running = false;
                    DefaultThreading.this.thread = null;
                }
            };
            this.thread.requests.add(runnable);
        }
    }

    @Override
    public void run(final Runnable runnable) {
        if (Thread.currentThread() == this.thread) {
            runnable.run();
        } else {
            final boolean[] done = new boolean[1];
            final Throwable[] exception = new Throwable[1];
            this.thread.requests.add(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            runnable.run();
                        }
                        catch (Throwable e) {
                            exception[0] = e;
                            CatalogUIPlugin.log(e.getMessage(), e);
                            done[0] = true;
                        }
                    }
                    finally {
                        done[0] = true;
                    }
                }
            });
            Display display = Display.getCurrent();
            while (!done[0]) {
                if (display != null && display.readAndDispatch()) continue;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            if (exception[0] instanceof RuntimeException) {
                throw (RuntimeException)exception[0];
            }
            if (exception[0] != null) {
                throw new RuntimeException(exception[0]);
            }
        }
    }

    private static final class WorkflowThread
    extends Thread {
        private final BlockingQueue<Runnable> requests = new LinkedBlockingQueue<Runnable>();
        private volatile boolean running = true;

        private WorkflowThread() {
        }

        @Override
        public void run() {
            while (this.running) {
                Runnable runnable;
                try {
                    runnable = this.requests.take();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                runnable.run();
            }
        }
    }
}

