/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.workflow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ui.ConnectionFactoryManager;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import net.refractions.udig.catalog.ui.UDIGConnectionFactoryDescriptor;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.EndConnectionState;
import net.refractions.udig.catalog.ui.workflow.IntermediateState;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.core.Pair;
import org.eclipse.core.runtime.IProgressMonitor;

public class DataSourceSelectionState
extends State {
    UDIGConnectionFactoryDescriptor descriptor;
    private boolean validateService;
    private ArrayList<UDIGConnectionFactoryDescriptor> shortlist;

    public DataSourceSelectionState(boolean validateServices) {
        this.validateService = validateServices;
    }

    @Override
    public void init(IProgressMonitor monitor) throws IOException {
        super.init(monitor);
        this.descriptor = null;
        Object context = this.getWorkflow().getContext();
        if (context == null) {
            return;
        }
        List<UDIGConnectionFactoryDescriptor> descriptors = ConnectionFactoryManager.instance().getConnectionFactoryDescriptors();
        this.descriptor = null;
        this.shortlist = new ArrayList();
        for (UDIGConnectionFactoryDescriptor d : descriptors) {
            UDIGConnectionFactory factory = d.getConnectionFactory();
            try {
                if (!factory.canProcess(context)) continue;
                this.shortlist.add(d);
            }
            catch (Throwable t) {
                CatalogPlugin.trace((String)("Factory " + d.getId() + " unable to handle " + context), (Throwable)t);
            }
        }
        if (this.shortlist.isEmpty()) {
            this.descriptor = null;
        } else if (this.shortlist.size() == 1) {
            this.descriptor = this.shortlist.get(0);
        } else {
            Iterator<UDIGConnectionFactoryDescriptor> i = this.shortlist.iterator();
            while (i.hasNext()) {
                UDIGConnectionFactoryDescriptor d = i.next();
                String id = d.getId();
                if (!"net.refractions.udig.catalog.geotools.connection.dataStore".equals(id)) continue;
                i.remove();
            }
            if (this.shortlist.size() == 1) {
                this.descriptor = this.shortlist.get(0);
                return;
            }
            this.descriptor = null;
            return;
        }
        if (this.descriptor != null) {
            String value = context.toString();
            String type = context.getClass().getName();
            CatalogPlugin.trace((String)("Drag and Drop selected factory " + this.descriptor.getId() + " to handle " + type + ":" + value), null);
        }
    }

    @Override
    public Pair<Boolean, State> dryRun() {
        return new Pair((Object)(this.descriptor != null ? 1 : 0), null);
    }

    @Override
    public boolean run(IProgressMonitor monitor) throws IOException {
        monitor.beginTask(this.getName(), 1);
        monitor.done();
        return this.descriptor != null;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public State next() {
        int numberOfPages = this.descriptor.getWizardPageCount();
        if (numberOfPages == 1) {
            return new EndConnectionState(this.descriptor, this.validateService);
        }
        return new IntermediateState(0, numberOfPages, new EndConnectionState(this.descriptor, this.validateService));
    }

    public UDIGConnectionFactoryDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(UDIGConnectionFactoryDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public String getName() {
        return Messages.DataSourceSelectionState_name;
    }

    public List<UDIGConnectionFactoryDescriptor> getShortlist() {
        return this.shortlist;
    }
}

