/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.ConnectionFailureState;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ConnectionFailurePage
extends WorkflowWizardPage
implements ILabelProvider,
ITreeContentProvider {
    private TreeViewer viewer;
    private Text details;
    private static String canProcess = Messages.ConnectionFailurePage_canProcess;

    public ConnectionFailurePage() {
        super(Messages.ConnectionFailurePage_title);
        this.setTitle(Messages.ConnectionFailurePage_displayedTitle);
        this.setMessage(Messages.ConnectionFailurePage_message);
    }

    public void createControl(Composite parent) {
        SashForm form = new SashForm(parent, 512);
        Tree tree = new Tree((Composite)form, 516);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        tree.setLayout((Layout)layout);
        tree.setLinesVisible(true);
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setLabelProvider((IBaseLabelProvider)this);
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConnectionFailurePage.this.setDetails();
            }
        });
        this.viewer.setSorter(new ViewerSorter(){

            public void sort(Viewer viewer, Object[] elements) {
                Arrays.sort(elements, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return 0;
                    }
                });
            }
        });
        Composite composite = new Composite((Composite)form, 2048);
        composite.setLayout((Layout)new FillLayout());
        this.details = new Text(composite, 2632);
        form.setWeights(new int[]{75, 25});
        this.setControl((Control)form);
    }

    private void setDetails() {
        Object firstElement = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (firstElement instanceof ConnectionFailureState.Data) {
            ConnectionFailureState.Data data = (ConnectionFailureState.Data)firstElement;
            String string = data.message;
            if (string == null) {
                string = canProcess;
            }
            this.details.setText(string);
        } else {
            this.details.setText(Messages.ConnectionFailurePage_selectChild);
        }
    }

    @Override
    public void shown() {
        this.viewer.setInput(this.getState().getReports());
        if (this.viewer.getTree().getItemCount() > 0) {
            TreeItem item = this.viewer.getTree().getItem(0);
            this.viewer.getTree().setSelection(item);
            this.setDetails();
        }
    }

    @Override
    public ConnectionFailureState getState() {
        return (ConnectionFailureState)super.getState();
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)element;
            return ((ConnectionFailureState.Data)((List)entry.getValue()).get((int)0)).name;
        }
        if (element instanceof ConnectionFailureState.Data) {
            ConnectionFailureState.Data data = (ConnectionFailureState.Data)element;
            if (this.getParent(element) == this.getState().getReports()) {
                return data.name;
            }
            return data.url.toString();
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Map) {
            Map map = (Map)parentElement;
            if (((List)map.values().iterator().next()).size() == 1) {
                Collection values = map.values();
                ArrayList all = new ArrayList();
                for (List list : values) {
                    all.addAll(list);
                }
                return all.toArray();
            }
            return map.entrySet().toArray();
        }
        if (parentElement instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)parentElement;
            return ((List)entry.getValue()).toArray();
        }
        if (parentElement instanceof ConnectionFailureState.Data) {
            return null;
        }
        return null;
    }

    public Object getParent(Object parentElement) {
        if (parentElement instanceof Map) {
            return null;
        }
        if (parentElement instanceof Map.Entry) {
            return this.getState().getReports();
        }
        if (parentElement instanceof ConnectionFailureState.Data) {
            Set<Map.Entry<String, List<ConnectionFailureState.Data>>> set = this.getState().getReports().entrySet();
            ConnectionFailureState.Data data = (ConnectionFailureState.Data)parentElement;
            for (Map.Entry<String, List<ConnectionFailureState.Data>> entry : set) {
                if (!entry.getKey().equals(data.id)) continue;
                if (entry.getValue().size() == 1) {
                    return this.getState().getReports();
                }
                return entry;
            }
        }
        return null;
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement instanceof Map) {
            return true;
        }
        if (parentElement instanceof Map.Entry) {
            return true;
        }
        if (parentElement instanceof ConnectionFailureState.Data) {
            return false;
        }
        return false;
    }

    public Object[] getElements(Object elements) {
        return this.getChildren(elements);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

